/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.List;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.type.StandardBasicTypes;

public class DerbyRpadFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    public DerbyRpadFunction() {
        super("rpad", StandardArgumentsValidators.exactly(2), StandardFunctionReturnTypeResolvers.invariant(StandardBasicTypes.STRING));
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        SqlAstNode string = arguments.get(0);
        SqlAstNode length = arguments.get(1);
        sqlAppender.appendSql("case when length(");
        walker.render(string, SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER);
        sqlAppender.appendSql(")<");
        walker.render(length, SqlAstNodeRenderingMode.DEFAULT);
        sqlAppender.appendSql(" then substr(");
        walker.render(string, SqlAstNodeRenderingMode.DEFAULT);
        sqlAppender.appendSql("||char('',");
        walker.render(length, SqlAstNodeRenderingMode.INLINE_PARAMETERS);
        sqlAppender.appendSql("),1,");
        walker.render(length, SqlAstNodeRenderingMode.DEFAULT);
        sqlAppender.appendSql(") else ");
        walker.render(string, SqlAstNodeRenderingMode.DEFAULT);
        sqlAppender.appendSql(" end");
    }

    @Override
    public String getArgumentListSignature() {
        return "(string, length)";
    }
}

