/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.query.Limit;

public class LegacyDB2LimitHandler
extends AbstractLimitHandler {
    public static final LegacyDB2LimitHandler INSTANCE = new LegacyDB2LimitHandler();

    @Override
    public String processSql(String sql, RowSelection selection) {
        if (LegacyDB2LimitHandler.hasFirstRow(selection)) {
            return "select * from ( select row_.*, rownumber() over(order by order of row_) as rownumber_ from ( " + sql + this.fetchFirstRows(selection) + " ) as row_ ) as query_ where rownumber_ > " + selection.getFirstRow() + " order by rownumber_";
        }
        return this.insertAtEnd(this.fetchFirstRows(selection), sql);
    }

    private String fetchFirstRows(RowSelection limit) {
        return " fetch first " + this.getMaxOrLimit(limit) + " rows only";
    }

    @Override
    public String processSql(String sql, Limit limit) {
        if (LegacyDB2LimitHandler.hasFirstRow(limit)) {
            return "select * from ( select row_.*, rownumber() over(order by order of row_) as rownumber_ from ( " + sql + this.fetchFirstRows(limit) + " ) as row_ ) as query_ where rownumber_ > " + limit.getFirstRow() + " order by rownumber_";
        }
        return this.insertAtEnd(this.fetchFirstRows(limit), sql);
    }

    private String fetchFirstRows(Limit limit) {
        return " fetch first " + this.getMaxOrLimit(limit) + " rows only";
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public final boolean useMaxForLimit() {
        return true;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return false;
    }
}

