/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.pagination;

import org.hibernate.dialect.pagination.AbstractLimitHandler;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.query.Limit;

public class SkipFirstLimitHandler
extends AbstractLimitHandler {
    public static final SkipFirstLimitHandler INSTANCE = new SkipFirstLimitHandler(true);
    private boolean variableLimit;

    public SkipFirstLimitHandler(boolean variableLimit) {
        this.variableLimit = variableLimit;
    }

    @Override
    public String processSql(String sql, RowSelection selection) {
        boolean hasFirstRow = SkipFirstLimitHandler.hasFirstRow(selection);
        boolean hasMaxRows = SkipFirstLimitHandler.hasMaxRows(selection);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        StringBuilder skipFirst = new StringBuilder();
        if (this.supportsVariableLimit()) {
            if (hasFirstRow) {
                skipFirst.append(" skip ?");
            }
            if (hasMaxRows) {
                skipFirst.append(" first ?");
            }
        } else {
            if (hasFirstRow) {
                skipFirst.append(" skip ").append(selection.getFirstRow());
            }
            if (hasMaxRows) {
                skipFirst.append(" first ").append(this.getMaxOrLimit(selection));
            }
        }
        return SkipFirstLimitHandler.insertAfterSelect(sql, skipFirst.toString());
    }

    @Override
    public String processSql(String sql, Limit limit) {
        boolean hasFirstRow = SkipFirstLimitHandler.hasFirstRow(limit);
        boolean hasMaxRows = SkipFirstLimitHandler.hasMaxRows(limit);
        if (!hasFirstRow && !hasMaxRows) {
            return sql;
        }
        StringBuilder skipFirst = new StringBuilder();
        if (this.supportsVariableLimit()) {
            if (hasFirstRow) {
                skipFirst.append(" skip ?");
            }
            if (hasMaxRows) {
                skipFirst.append(" first ?");
            }
        } else {
            if (hasFirstRow) {
                skipFirst.append(" skip ").append(limit.getFirstRow());
            }
            if (hasMaxRows) {
                skipFirst.append(" first ").append(this.getMaxOrLimit(limit));
            }
        }
        return SkipFirstLimitHandler.insertAfterSelect(sql, skipFirst.toString());
    }

    @Override
    public final boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsOffset() {
        return true;
    }

    @Override
    public final boolean bindLimitParametersFirst() {
        return true;
    }

    @Override
    public final boolean supportsVariableLimit() {
        return this.variableLimit;
    }
}

