/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.dialect.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.selector.spi.StrategySelectionException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.dialect.spi.DialectFactory;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfoSource;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolver;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class DialectFactoryImpl
implements DialectFactory,
ServiceRegistryAwareService {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger("SQL dialect");
    private StrategySelector strategySelector;
    private DialectResolver dialectResolver;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.strategySelector = serviceRegistry.getService(StrategySelector.class);
        this.dialectResolver = serviceRegistry.getService(DialectResolver.class);
    }

    public void setDialectResolver(DialectResolver dialectResolver) {
        this.dialectResolver = dialectResolver;
    }

    @Override
    public Dialect buildDialect(Map configValues, DialectResolutionInfoSource resolutionInfoSource) throws HibernateException {
        Object dialectReference = configValues.get("hibernate.dialect");
        Dialect dialect = !this.isEmpty(dialectReference) ? this.constructDialect(dialectReference, resolutionInfoSource) : this.determineDialect(resolutionInfoSource);
        DialectFactoryImpl.logSelectedDialect(dialect);
        return dialect;
    }

    private static void logSelectedDialect(Dialect dialect) {
        LOG.usingDialect(dialect);
        Class<?> dialectClass = dialect.getClass();
        if (dialectClass.isAnnotationPresent(Deprecated.class)) {
            Class<?> superDialectClass = dialectClass.getSuperclass();
            if (!superDialectClass.isAnnotationPresent(Deprecated.class) && !superDialectClass.equals(Dialect.class)) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedDialect(dialectClass.getSimpleName(), superDialectClass.getName());
            } else {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedDialect(dialectClass.getSimpleName());
            }
        }
    }

    private boolean isEmpty(Object dialectReference) {
        if (dialectReference != null) {
            if (dialectReference instanceof String) {
                return StringHelper.isEmpty((String)dialectReference);
            }
            return false;
        }
        return true;
    }

    private Dialect constructDialect(Object dialectReference, DialectResolutionInfoSource resolutionInfoSource) {
        try {
            Dialect dialect = this.strategySelector.resolveStrategy(Dialect.class, dialectReference, (Dialect)null, dialectClass -> {
                try {
                    try {
                        if (resolutionInfoSource != null) {
                            return (Dialect)dialectClass.getConstructor(DialectResolutionInfo.class).newInstance(resolutionInfoSource.getDialectResolutionInfo());
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    return (Dialect)dialectClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new StrategySelectionException(String.format("Could not instantiate named dialect class [%s]", dialectClass.getName()), e);
                }
            });
            if (dialect == null) {
                throw new HibernateException("Unable to construct requested dialect [" + dialectReference + "]");
            }
            return dialect;
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HibernateException("Unable to construct requested dialect [" + dialectReference + "]", e);
        }
    }

    private Dialect determineDialect(DialectResolutionInfoSource resolutionInfoSource) {
        if (resolutionInfoSource == null) {
            throw new HibernateException("Unable to determine Dialect without JDBC metadata (please set 'javax.persistence.jdbc.url', 'hibernate.connection.url', or 'hibernate.dialect')");
        }
        DialectResolutionInfo info = resolutionInfoSource.getDialectResolutionInfo();
        Dialect dialect = this.dialectResolver.resolveDialect(info);
        if (dialect == null) {
            throw new HibernateException("Unable to determine Dialect for " + info.getDatabaseName() + " " + info.getDatabaseMajorVersion() + "." + info.getDatabaseMinorVersion() + " (please set 'hibernate.dialect' or register a Dialect resolver)");
        }
        return dialect;
    }
}

