/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.LoadingEntityCollector;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.loader.ast.spi.MultiNaturalIdLoadOptions;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcSelectExecutorStandardImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.results.graph.entity.LoadingEntityEntry;
import org.hibernate.sql.results.internal.RowTransformerPassThruImpl;

public class MultiNaturalIdLoadingBatcher {
    private final EntityMappingType entityDescriptor;
    private final SelectStatement sqlSelect;
    private final List<JdbcParameter> jdbcParameters;
    private final KeyValueResolver keyValueResolver;
    private final JdbcSelect jdbcSelect;

    public MultiNaturalIdLoadingBatcher(EntityMappingType entityDescriptor, ModelPart restrictedPart, int batchSize, KeyValueResolver keyValueResolver, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.jdbcParameters = new ArrayList<JdbcParameter>(batchSize);
        this.sqlSelect = LoaderSelectBuilder.createSelect((Loadable)entityDescriptor, null, restrictedPart, null, batchSize, loadQueryInfluencers, lockOptions, this.jdbcParameters::add, sessionFactory);
        this.keyValueResolver = keyValueResolver;
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        this.jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, this.sqlSelect).translate(null, QueryOptions.NONE);
    }

    public <E> List<E> multiLoad(Object[] naturalIdValues, MultiNaturalIdLoadOptions options, SharedSessionContractImplementor session) {
        ArrayList multiLoadResults = CollectionHelper.arrayList(naturalIdValues.length);
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(this.jdbcParameters.size());
        int offset = 0;
        for (int i = 0; i < naturalIdValues.length; ++i) {
            Object bindValue = this.keyValueResolver.resolveKeyToLoad(naturalIdValues[i], session);
            if (bindValue != null) {
                offset += jdbcParamBindings.registerParametersForEachJdbcValue(bindValue, Clause.IRRELEVANT, offset, this.entityDescriptor.getNaturalIdMapping(), this.jdbcParameters, session);
            }
            if (offset != this.jdbcParameters.size()) continue;
            List<E> batchResults = this.performLoad(jdbcParamBindings, session);
            multiLoadResults.addAll(batchResults);
            jdbcParamBindings.clear();
            offset = 0;
        }
        if (offset != 0) {
            while (offset != this.jdbcParameters.size()) {
                offset += jdbcParamBindings.registerParametersForEachJdbcValue(null, Clause.IRRELEVANT, offset, this.entityDescriptor.getNaturalIdMapping(), this.jdbcParameters, session);
            }
            List<E> batchResults = this.performLoad(jdbcParamBindings, session);
            multiLoadResults.addAll(batchResults);
        }
        return multiLoadResults;
    }

    private <E> List<E> performLoad(JdbcParameterBindings jdbcParamBindings, final SharedSessionContractImplementor session) {
        final LoadingEntityCollector loadingEntityCollector = this.entityDescriptor.getEntityPersister().hasSubselectLoadableCollections() ? new LoadingEntityCollector(this.entityDescriptor, this.sqlSelect.getQuerySpec(), this.jdbcParameters, jdbcParamBindings, session.getPersistenceContext().getBatchFetchQueue()) : null;
        return JdbcSelectExecutorStandardImpl.INSTANCE.list(this.jdbcSelect, jdbcParamBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return null;
            }

            @Override
            public void registerLoadingEntityEntry(EntityKey entityKey, LoadingEntityEntry entry) {
                if (loadingEntityCollector != null) {
                    loadingEntityCollector.collectLoadingEntityKey(entityKey);
                }
            }
        }, RowTransformerPassThruImpl.instance(), true);
    }

    @FunctionalInterface
    static interface KeyValueResolver {
        public Object resolveKeyToLoad(Object var1, SharedSessionContractImplementor var2);
    }
}

