/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.AbstractNaturalIdLoader;
import org.hibernate.loader.ast.internal.LoaderSelectBuilder;
import org.hibernate.loader.ast.internal.LoaderSqlAstCreationState;
import org.hibernate.loader.ast.spi.Loadable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SimpleNaturalIdMapping;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcSelect;

public class SimpleNaturalIdLoader<T>
extends AbstractNaturalIdLoader<T> {
    public SimpleNaturalIdLoader(SimpleNaturalIdMapping naturalIdMapping, EntityMappingType entityDescriptor) {
        super(naturalIdMapping, entityDescriptor);
    }

    @Override
    protected SimpleNaturalIdMapping naturalIdMapping() {
        return (SimpleNaturalIdMapping)super.naturalIdMapping();
    }

    @Override
    protected void applyNaturalIdRestriction(Object bindValue, TableGroup rootTableGroup, Consumer<Predicate> predicateConsumer, BiConsumer<JdbcParameter, JdbcParameterBinding> jdbcParameterConsumer, LoaderSqlAstCreationState sqlAstCreationState, SharedSessionContractImplementor session) {
        if (bindValue == null) {
            this.naturalIdMapping().getAttribute().forEachSelection((selectionIndex, selectionMapping) -> {
                Expression columnReference = this.resolveColumnReference(rootTableGroup, selectionMapping, sqlAstCreationState.getSqlExpressionResolver(), session.getFactory());
                predicateConsumer.accept(new NullnessPredicate(columnReference));
            });
        } else {
            this.naturalIdMapping().getAttribute().breakDownJdbcValues(bindValue, (jdbcValue, jdbcValueMapping) -> {
                Expression columnReference = this.resolveColumnReference(rootTableGroup, jdbcValueMapping, sqlAstCreationState.getSqlExpressionResolver(), session.getFactory());
                if (jdbcValue == null) {
                    predicateConsumer.accept(new NullnessPredicate(columnReference));
                } else {
                    JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcValueMapping.getJdbcMapping());
                    ComparisonPredicate predicate = new ComparisonPredicate(columnReference, ComparisonOperator.EQUAL, jdbcParameter);
                    predicateConsumer.accept(predicate);
                    jdbcParameterConsumer.accept(jdbcParameter, new JdbcParameterBindingImpl(jdbcValueMapping.getJdbcMapping(), jdbcValue));
                }
            }, session);
        }
    }

    @Override
    public Object resolveIdToNaturalId(Object id, SharedSessionContractImplementor session) {
        Object rawValue = super.resolveIdToNaturalId(id, session);
        assert (rawValue instanceof Object[]);
        return ((Object[])rawValue)[0];
    }

    @Override
    public Object resolveNaturalIdToId(Object naturalIdValue, final SharedSessionContractImplementor session) {
        Object bindValue = this.naturalIdMapping().normalizeInput(naturalIdValue, session);
        SessionFactoryImplementor sessionFactory = session.getFactory();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        ArrayList<JdbcParameter> jdbcParameters = new ArrayList<JdbcParameter>();
        SelectStatement sqlSelect = LoaderSelectBuilder.createSelect((Loadable)this.entityDescriptor(), Collections.singletonList(this.entityDescriptor().getIdentifierMapping()), this.naturalIdMapping(), null, 1, session.getLoadQueryInfluencers(), LockOptions.READ, jdbcParameters::add, sessionFactory);
        JdbcParameterBindingsImpl jdbcParamBindings = new JdbcParameterBindingsImpl(jdbcParameters.size());
        SingularAttributeMapping attributeMapping = this.naturalIdMapping().getAttribute();
        jdbcParamBindings.registerParametersForEachJdbcValue(bindValue, Clause.WHERE, attributeMapping, jdbcParameters, session);
        JdbcSelect jdbcSelect = sqlAstTranslatorFactory.buildSelectTranslator(sessionFactory, sqlSelect).translate(jdbcParamBindings, QueryOptions.NONE);
        List<Object> results = session.getFactory().getJdbcServices().getJdbcSelectExecutor().list(jdbcSelect, jdbcParamBindings, new ExecutionContext(){

            @Override
            public SharedSessionContractImplementor getSession() {
                return session;
            }

            @Override
            public QueryOptions getQueryOptions() {
                return QueryOptions.NONE;
            }

            @Override
            public QueryParameterBindings getQueryParameterBindings() {
                return QueryParameterBindings.NO_PARAM_BINDINGS;
            }

            @Override
            public Callback getCallback() {
                return afterLoadAction -> {};
            }
        }, row -> row[0], true);
        if (results.size() > 1) {
            throw new HibernateException(String.format("Resolving natural-id to id returned more that one row : %s [%s]", this.entityDescriptor().getEntityName(), bindValue));
        }
        return results.get(0);
    }
}

