/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.FetchableContainer;

public interface EntityValuedModelPart
extends FetchableContainer {
    public EntityMappingType getEntityMappingType();

    default public ModelPart findSubPart(String name) {
        return this.getEntityMappingType().findSubPart(name, null);
    }

    @Override
    default public ModelPart findSubPart(String name, EntityMappingType targetType) {
        return this.getEntityMappingType().findSubPart(name, targetType);
    }

    @Override
    default public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType targetType) {
        this.getEntityMappingType().visitSubParts(consumer, targetType);
    }

    @Override
    default public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.getEntityMappingType().createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    default public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.getEntityMappingType().applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    default public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.getEntityMappingType().applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    default public int getJdbcTypeCount() {
        int span = 0;
        List<AttributeMapping> attributeMappings = this.getEntityMappingType().getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            span += attributeMappings.get(i).getJdbcTypeCount();
        }
        return span;
    }

    @Override
    default public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = 0;
        List<AttributeMapping> attributeMappings = this.getEntityMappingType().getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            span += attributeMappings.get(i).forEachJdbcType(span + offset, action);
        }
        return span;
    }

    @Override
    default public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.getEntityMappingType().disassemble(value, session);
    }

    @Override
    default public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.getEntityMappingType().forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    default public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer consumer, SharedSessionContractImplementor session) {
        int span = 0;
        List<AttributeMapping> attributeMappings = this.getEntityMappingType().getAttributeMappings();
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = attributeMappings.get(i);
            span += attributeMapping.forEachJdbcValue(value, clause, span + offset, consumer, session);
        }
        return span;
    }
}

