/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.ArrayList;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectionMapping;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;

public class MappingModelHelper {
    public static Expression buildColumnReferenceExpression(ModelPart modelPart, SqlExpressionResolver sqlExpressionResolver, SessionFactoryImplementor sessionFactory) {
        int jdbcTypeCount = modelPart.getJdbcTypeCount();
        if (modelPart instanceof EmbeddableValuedModelPart) {
            ArrayList columnReferences = new ArrayList(jdbcTypeCount);
            modelPart.forEachSelection((columnIndex, selection) -> {
                ColumnReference colRef = sqlExpressionResolver == null ? new ColumnReference(selection.getContainingTableExpression(), selection, sessionFactory) : (ColumnReference)sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(selection.getContainingTableExpression(), selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(selection.getContainingTableExpression(), selection, sessionFactory));
                columnReferences.add(colRef);
            });
            return new SqlTuple(columnReferences, modelPart);
        }
        assert (modelPart instanceof BasicValuedModelPart);
        BasicValuedModelPart basicPart = (BasicValuedModelPart)modelPart;
        if (sqlExpressionResolver == null) {
            return new ColumnReference(basicPart.getContainingTableExpression(), (SelectionMapping)basicPart, sessionFactory);
        }
        return sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(basicPart.getContainingTableExpression(), basicPart.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(basicPart.getContainingTableExpression(), (SelectionMapping)basicPart, sessionFactory));
    }

    private MappingModelHelper() {
    }
}

