/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.Property;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.type.AnyType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class DiscriminatedAssociationAttributeMapping
extends AbstractSingularAttributeMapping
implements DiscriminatedAssociationModelPart {
    private final NavigableRole navigableRole;
    private final DiscriminatedAssociationMapping discriminatorMapping;

    public DiscriminatedAssociationAttributeMapping(NavigableRole attributeRole, JavaTypeDescriptor<?> baseAssociationJtd, ManagedMappingType declaringType, int stateArrayPosition, StateArrayContributorMetadataAccess attributeMetadataAccess, FetchTiming fetchTiming, PropertyAccess propertyAccess, Property bootProperty, AnyType anyType, Any bootValueMapping, MappingModelCreationProcess creationProcess) {
        super(bootProperty.getName(), stateArrayPosition, attributeMetadataAccess, fetchTiming == FetchTiming.IMMEDIATE ? new FetchStrategy(FetchTiming.IMMEDIATE, FetchStyle.SELECT) : new FetchStrategy(FetchTiming.DELAYED, FetchStyle.SELECT), declaringType, propertyAccess);
        this.navigableRole = attributeRole;
        this.discriminatorMapping = DiscriminatedAssociationMapping.from(attributeRole, baseAssociationJtd, this, anyType, bootValueMapping, creationProcess);
    }

    @Override
    public BasicValuedModelPart getDiscriminatorPart() {
        return this.discriminatorMapping.getDiscriminatorPart();
    }

    @Override
    public BasicValuedModelPart getKeyPart() {
        return this.discriminatorMapping.getKeyPart();
    }

    @Override
    public EntityMappingType resolveDiscriminatorValue(Object discriminatorValue) {
        return this.discriminatorMapping.resolveDiscriminatorValueToEntityName(discriminatorValue);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return this.discriminatorMapping.generateFetch(fetchParent, fetchablePath, fetchTiming, selected, lockMode, resultVariable, creationState);
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public MappingType getMappedType() {
        return this.discriminatorMapping;
    }

    @Override
    public int getNumberOfFetchables() {
        return 2;
    }

    @Override
    public int getJdbcTypeCount() {
        return this.getDiscriminatorPart().getJdbcTypeCount() + this.getKeyPart().getJdbcTypeCount();
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.discriminatorMapping.getDiscriminatorPart().breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = this.getDiscriminatorPart().forEachJdbcType(offset, action);
        return span + this.getKeyPart().forEachJdbcType(offset + span, action);
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        fetchableConsumer.accept(this.getDiscriminatorPart());
        fetchableConsumer.accept(this.getKeyPart());
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        if ("{discriminator}".equals(name)) {
            return this.getDiscriminatorPart();
        }
        if ("{key}".equals(name)) {
            return this.getKeyPart();
        }
        return null;
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.getDiscriminatorPart());
        consumer.accept(this.getKeyPart());
    }
}

