/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectionConsumer;
import org.hibernate.metamodel.mapping.SelectionMappings;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableForeignKeyResultImpl;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EmbeddedForeignKeyDescriptor
implements ForeignKeyDescriptor,
ModelPart {
    private final EmbeddableValuedModelPart mappingType;
    private final String keyColumnContainingTable;
    private final SelectionMappings keySelectionMappings;
    private final String targetColumnContainingTable;
    private final SelectionMappings targetSelectionMappings;
    private AssociationKey associationKey;

    public EmbeddedForeignKeyDescriptor(EmbeddableValuedModelPart mappingType, String keyColumnContainingTable, SelectionMappings keySelectionMappings, String targetColumnContainingTable, SelectionMappings targetSelectionMappings, MappingModelCreationProcess creationProcess) {
        this.keyColumnContainingTable = keyColumnContainingTable;
        this.keySelectionMappings = keySelectionMappings;
        this.targetColumnContainingTable = targetColumnContainingTable;
        this.targetSelectionMappings = targetSelectionMappings;
        this.mappingType = mappingType;
        creationProcess.registerInitializationCallback("Embedded (composite) FK descriptor " + mappingType.getNavigableRole(), () -> {
            List<AttributeMapping> subAttributes = mappingType.getEmbeddableTypeDescriptor().getAttributeMappings();
            return !subAttributes.isEmpty();
        });
    }

    @Override
    public DomainResult createCollectionFetchDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        if (this.targetColumnContainingTable.equals(this.keyColumnContainingTable)) {
            return this.createDomainResult(collectionPath, tableGroup, this.targetColumnContainingTable, this.targetSelectionMappings, creationState);
        }
        return this.createDomainResult(collectionPath, tableGroup, this.keyColumnContainingTable, this.keySelectionMappings, creationState);
    }

    @Override
    public DomainResult createDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        return this.createDomainResult(collectionPath, tableGroup, this.keyColumnContainingTable, this.keySelectionMappings, creationState);
    }

    @Override
    public DomainResult createDomainResult(NavigablePath collectionPath, TableGroup tableGroup, boolean isKeyReferringSide, DomainResultCreationState creationState) {
        if (isKeyReferringSide) {
            return this.createDomainResult(collectionPath, tableGroup, this.keyColumnContainingTable, this.keySelectionMappings, creationState);
        }
        return this.createDomainResult(collectionPath, tableGroup, this.targetColumnContainingTable, this.targetSelectionMappings, creationState);
    }

    private DomainResult createDomainResult(NavigablePath collectionPath, TableGroup tableGroup, String columnContainingTable, SelectionMappings selectionMappings, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(columnContainingTable);
        String identificationVariable = tableReference.getIdentificationVariable();
        ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>(selectionMappings.getJdbcTypeCount());
        selectionMappings.forEachSelection((columnIndex, selection) -> {
            SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), s -> new ColumnReference(identificationVariable, selection, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), selection.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
            sqlSelections.add(sqlSelection);
        });
        return new EmbeddableForeignKeyResultImpl(sqlSelections, collectionPath, this.mappingType, null, creationState);
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup lhs, TableGroup tableGroup, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference rhsTableKeyReference;
        TableReference lhsTableReference;
        if (this.targetColumnContainingTable.equals(this.keyColumnContainingTable)) {
            lhsTableReference = this.getTableReferenceWhenTargetEqualsKey(lhs, tableGroup, this.keyColumnContainingTable);
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetColumnContainingTable);
        } else {
            lhsTableReference = this.getTableReference(lhs, tableGroup, this.keyColumnContainingTable);
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetColumnContainingTable);
        }
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, sqlAstJoinType, sqlExpressionResolver, creationContext);
    }

    @Override
    public Predicate generateJoinPredicate(TableReference lhs, TableReference rhs, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        String rhsTableExpression = rhs.getTableExpression();
        String lhsTableExpression = lhs.getTableExpression();
        if (lhsTableExpression.equals(this.keyColumnContainingTable)) {
            assert (rhsTableExpression.equals(this.targetColumnContainingTable));
            return this.getPredicate(lhs, rhs, creationContext, this.keySelectionMappings, this.targetSelectionMappings);
        }
        assert (rhsTableExpression.equals(this.keyColumnContainingTable));
        return this.getPredicate(lhs, rhs, creationContext, this.targetSelectionMappings, this.keySelectionMappings);
    }

    private Predicate getPredicate(TableReference lhs, TableReference rhs, SqlAstCreationContext creationContext, SelectionMappings lhsMappings, SelectionMappings rhsMappings) {
        Junction predicate = new Junction(Junction.Nature.CONJUNCTION);
        lhsMappings.forEachSelection((i, selection) -> {
            ComparisonPredicate comparisonPredicate = new ComparisonPredicate(new ColumnReference(lhs, selection, creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, rhsMappings.getSelectionMapping(i), creationContext.getSessionFactory()));
            predicate.add(comparisonPredicate);
        });
        return predicate;
    }

    protected TableReference getTableReferenceWhenTargetEqualsKey(TableGroup lhs, TableGroup tableGroup, String table) {
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        for (TableReferenceJoin tableJoin : lhs.getTableReferenceJoins()) {
            if (!tableJoin.getJoinedTableReference().getTableExpression().equals(table)) continue;
            return tableJoin.getJoinedTableReference();
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    protected TableReference getTableReference(TableGroup lhs, TableGroup tableGroup, String table) {
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        TableReference tableReference = lhs.resolveTableReference(table);
        if (tableReference != null) {
            return tableReference;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    @Override
    public int visitReferringColumns(int offset, SelectionConsumer consumer) {
        return this.keySelectionMappings.forEachSelection(offset, consumer);
    }

    @Override
    public int visitTargetColumns(int offset, SelectionConsumer consumer) {
        return this.targetSelectionMappings.forEachSelection(offset, consumer);
    }

    @Override
    public AssociationKey getAssociationKey() {
        if (this.associationKey == null) {
            ArrayList<String> columns = new ArrayList<String>();
            this.keySelectionMappings.forEachSelection((columnIndex, selection) -> columns.add(selection.getSelectionExpression()));
            this.associationKey = new AssociationKey(this.keyColumnContainingTable, columns);
        }
        return this.associationKey;
    }

    @Override
    public MappingType getPartMappingType() {
        throw new HibernateException("Unexpected call to SimpleForeignKeyDescriptor#getPartMappingType");
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.mappingType.getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(this.keyColumnContainingTable);
        String identificationVariable = tableReference.getIdentificationVariable();
        int size = this.keySelectionMappings.getJdbcTypeCount();
        ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>(size);
        this.keySelectionMappings.forEachSelection((columnIndex, selection) -> {
            SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), s -> new ColumnReference(identificationVariable, selection, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), selection.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
            sqlSelections.add(sqlSelection);
        });
        return new EmbeddableForeignKeyResultImpl(sqlSelections, navigablePath, this.mappingType, resultVariable, creationState);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        assert (domainValue instanceof Object[]);
        Object[] values = (Object[])domainValue;
        this.keySelectionMappings.forEachSelection((selectionIndex, selectionMapping) -> valueConsumer.consume(values[selectionIndex], selectionMapping));
    }

    @Override
    public Object getAssociationKeyFromTarget(Object targetObject, SharedSessionContractImplementor session) {
        if (this.mappingType instanceof SingleAttributeIdentifierMapping) {
            return ((SingleAttributeIdentifierMapping)((Object)this.mappingType)).getIdentifier(targetObject, session);
        }
        return targetObject;
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.mappingType.forEachJdbcType(offset, action);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.mappingType.forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.mappingType.disassemble(value, session);
    }
}

