/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectionConsumer;
import org.hibernate.metamodel.mapping.SelectionMapping;
import org.hibernate.metamodel.mapping.SelectionMappings;
import org.hibernate.metamodel.mapping.internal.SelectionMappingImpl;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class SelectionMappingsImpl
implements SelectionMappings {
    private final SelectionMapping[] selectionMappings;

    private SelectionMappingsImpl(SelectionMapping[] selectionMappings) {
        this.selectionMappings = selectionMappings;
    }

    private static void resolveJdbcMappings(List<JdbcMapping> jdbcMappings, Mapping mapping, Type valueType) {
        Type keyType = valueType instanceof EntityType ? ((EntityType)valueType).getIdentifierOrUniqueKeyType(mapping) : valueType;
        if (keyType instanceof CompositeType) {
            Type[] subtypes;
            for (Type subtype : subtypes = ((CompositeType)keyType).getSubtypes()) {
                SelectionMappingsImpl.resolveJdbcMappings(jdbcMappings, mapping, subtype);
            }
        } else {
            jdbcMappings.add((JdbcMapping)((Object)keyType));
        }
    }

    public static SelectionMappings from(String containingTableExpression, Value value, Mapping mapping, Dialect dialect, SqmFunctionRegistry sqmFunctionRegistry) {
        ArrayList<JdbcMapping> jdbcMappings = new ArrayList<JdbcMapping>();
        SelectionMappingsImpl.resolveJdbcMappings(jdbcMappings, mapping, value.getType());
        ArrayList<SelectionMapping> selectionMappings = new ArrayList<SelectionMapping>(jdbcMappings.size());
        Iterator<Selectable> columnIterator = value.getColumnIterator();
        while (columnIterator.hasNext()) {
            Selectable selectable = columnIterator.next();
            selectionMappings.add(SelectionMappingImpl.from(containingTableExpression, selectable, (JdbcMapping)jdbcMappings.get(selectionMappings.size()), dialect, sqmFunctionRegistry));
        }
        return new SelectionMappingsImpl(selectionMappings.toArray(new SelectionMapping[0]));
    }

    public static SelectionMappings from(EmbeddableMappingType embeddableMappingType) {
        int propertySpan = embeddableMappingType.getNumberOfAttributeMappings();
        ArrayList<SelectionMapping> selectionMappings = CollectionHelper.arrayList(propertySpan);
        embeddableMappingType.forEachAttributeMapping((index, attributeMapping) -> attributeMapping.forEachSelection((columnIndex, selection) -> selectionMappings.add(selection)));
        return new SelectionMappingsImpl(selectionMappings.toArray(new SelectionMapping[0]));
    }

    @Override
    public SelectionMapping getSelectionMapping(int columnIndex) {
        return this.selectionMappings[columnIndex];
    }

    @Override
    public int getJdbcTypeCount() {
        return this.selectionMappings.length;
    }

    @Override
    public int forEachSelection(int offset, SelectionConsumer consumer) {
        for (int i = 0; i < this.selectionMappings.length; ++i) {
            consumer.accept(offset + i, this.selectionMappings[i]);
        }
        return this.selectionMappings.length;
    }
}

