/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.SelectionConsumer;
import org.hibernate.metamodel.mapping.SelectionMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SimpleForeignKeyDescriptor
implements ForeignKeyDescriptor,
BasicValuedModelPart,
FetchOptions {
    private final SelectionMapping keySelectionMapping;
    private final SelectionMapping targetSelectionMapping;
    private final PropertyAccess propertyAccess;
    private final boolean refersToPrimaryKey;
    private AssociationKey associationKey;

    public SimpleForeignKeyDescriptor(SelectionMapping keySelectionMapping, SelectionMapping targetSelectionMapping, PropertyAccess propertyAccess, boolean refersToPrimaryKey) {
        this.keySelectionMapping = keySelectionMapping;
        this.targetSelectionMapping = targetSelectionMapping;
        this.propertyAccess = propertyAccess;
        this.refersToPrimaryKey = refersToPrimaryKey;
    }

    @Override
    public DomainResult<?> createCollectionFetchDomainResult(NavigablePath collectionPath, TableGroup tableGroup, DomainResultCreationState creationState) {
        if (this.targetSelectionMapping.getContainingTableExpression().equals(this.keySelectionMapping.getContainingTableExpression())) {
            return this.createDomainResult(tableGroup, this.targetSelectionMapping, creationState);
        }
        return this.createDomainResult(collectionPath, tableGroup, creationState);
    }

    @Override
    public DomainResult createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        return this.createDomainResult(tableGroup, this.keySelectionMapping, creationState);
    }

    @Override
    public DomainResult createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, boolean isKeyReferringSide, DomainResultCreationState creationState) {
        if (isKeyReferringSide) {
            return this.createDomainResult(tableGroup, this.keySelectionMapping, creationState);
        }
        return this.createDomainResult(tableGroup, this.targetSelectionMapping, creationState);
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return this.createDomainResult(tableGroup, this.keySelectionMapping, creationState);
    }

    private <T> DomainResult<T> createDomainResult(TableGroup tableGroup, SelectionMapping selectionMapping, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        TableReference tableReference = tableGroup.resolveTableReference(selectionMapping.getContainingTableExpression());
        String identificationVariable = tableReference.getIdentificationVariable();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selectionMapping.getSelectionExpression()), s -> new ColumnReference(identificationVariable, selectionMapping, creationState.getSqlAstCreationState().getCreationContext().getSessionFactory())), selectionMapping.getJdbcMapping().getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), null, selectionMapping.getJdbcMapping().getJavaTypeDescriptor());
    }

    @Override
    public Predicate generateJoinPredicate(TableReference lhs, TableReference rhs, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        if (lhs.getTableReference(this.keySelectionMapping.getContainingTableExpression()) != null) {
            return new ComparisonPredicate(new ColumnReference(lhs, this.keySelectionMapping, creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, this.targetSelectionMapping, creationContext.getSessionFactory()));
        }
        return new ComparisonPredicate(new ColumnReference(lhs, this.targetSelectionMapping, creationContext.getSessionFactory()), ComparisonOperator.EQUAL, new ColumnReference(rhs, this.keySelectionMapping, creationContext.getSessionFactory()));
    }

    @Override
    public Predicate generateJoinPredicate(TableGroup lhs, TableGroup tableGroup, SqlAstJoinType sqlAstJoinType, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableReference rhsTableKeyReference;
        TableReference lhsTableReference;
        if (this.targetSelectionMapping.getContainingTableExpression().equals(this.keySelectionMapping.getContainingTableExpression())) {
            lhsTableReference = this.getTableReferenceWhenTargetEqualsKey(lhs, tableGroup, this.keySelectionMapping.getContainingTableExpression());
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetSelectionMapping.getContainingTableExpression());
        } else {
            lhsTableReference = this.getTableReference(lhs, tableGroup, this.keySelectionMapping.getContainingTableExpression());
            rhsTableKeyReference = this.getTableReference(lhs, tableGroup, this.targetSelectionMapping.getContainingTableExpression());
        }
        return this.generateJoinPredicate(lhsTableReference, rhsTableKeyReference, sqlAstJoinType, sqlExpressionResolver, creationContext);
    }

    protected TableReference getTableReferenceWhenTargetEqualsKey(TableGroup lhs, TableGroup tableGroup, String table) {
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        for (TableReferenceJoin tableJoin : lhs.getTableReferenceJoins()) {
            if (!tableJoin.getJoinedTableReference().getTableExpression().equals(table)) continue;
            return tableJoin.getJoinedTableReference();
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    protected TableReference getTableReference(TableGroup lhs, TableGroup tableGroup, String table) {
        if (lhs.getPrimaryTableReference().getTableExpression().equals(table)) {
            return lhs.getPrimaryTableReference();
        }
        if (tableGroup.getPrimaryTableReference().getTableExpression().equals(table)) {
            return tableGroup.getPrimaryTableReference();
        }
        TableReference tableReference = lhs.resolveTableReference(table);
        if (tableReference != null) {
            return tableReference;
        }
        throw new IllegalStateException("Could not resolve binding for table `" + table + "`");
    }

    @Override
    public JavaTypeDescriptor<?> getJavaTypeDescriptor() {
        return this.targetSelectionMapping.getJdbcMapping().getJavaTypeDescriptor();
    }

    @Override
    public NavigableRole getNavigableRole() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        if (value == null) {
            return null;
        }
        if (this.refersToPrimaryKey && value instanceof HibernateProxy) {
            return ((HibernateProxy)value).getHibernateLazyInitializer().getIdentifier();
        }
        return this.propertyAccess.getGetter().get(value);
    }

    @Override
    public Object getAssociationKeyFromTarget(Object targetObject, SharedSessionContractImplementor session) {
        return this.disassemble(targetObject, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.getJdbcMapping());
        return 1;
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        valueConsumer.consume(domainValue, this.keySelectionMapping);
    }

    @Override
    public int visitReferringColumns(int offset, SelectionConsumer consumer) {
        consumer.accept(offset, this.keySelectionMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public int visitTargetColumns(int offset, SelectionConsumer consumer) {
        consumer.accept(offset, this.targetSelectionMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public AssociationKey getAssociationKey() {
        if (this.associationKey == null) {
            List<String> associationKeyColumns = Collections.singletonList(this.keySelectionMapping.getSelectionExpression());
            this.associationKey = new AssociationKey(this.keySelectionMapping.getContainingTableExpression(), associationKeyColumns);
        }
        return this.associationKey;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return Collections.singletonList(this.targetSelectionMapping.getJdbcMapping());
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.targetSelectionMapping.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.targetSelectionMapping.getJdbcMapping());
        return this.getJdbcTypeCount();
    }

    @Override
    public String getContainingTableExpression() {
        return this.keySelectionMapping.getContainingTableExpression();
    }

    @Override
    public String getSelectionExpression() {
        return this.keySelectionMapping.getSelectionExpression();
    }

    @Override
    public boolean isFormula() {
        return this.keySelectionMapping.isFormula();
    }

    @Override
    public String getCustomReadExpression() {
        return this.keySelectionMapping.getCustomReadExpression();
    }

    @Override
    public String getCustomWriteExpression() {
        return this.keySelectionMapping.getCustomWriteExpression();
    }

    @Override
    public String getFetchableName() {
        return "{fk}";
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return FetchStyle.JOIN;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.IMMEDIATE;
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        return null;
    }

    @Override
    public MappingType getMappedType() {
        return null;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.keySelectionMapping.getJdbcMapping();
    }

    public String toString() {
        return "SimpleForeignKeyDescriptor : " + this.keySelectionMapping.getContainingTableExpression() + "." + this.keySelectionMapping.getSelectionExpression() + " --> " + this.targetSelectionMapping.getContainingTableExpression() + "." + this.targetSelectionMapping.getSelectionExpression();
    }
}

