/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.LockMode;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.ToOne;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectionConsumer;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.EntityIdentifierNavigablePath;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.sql.results.graph.entity.EntityFetch;
import org.hibernate.sql.results.graph.entity.EntityValuedFetchable;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedResultImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchJoinedImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityFetchSelectImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityResultImpl;
import org.hibernate.sql.results.graph.entity.internal.EntityResultJoinedSubclassImpl;
import org.hibernate.sql.results.internal.domain.CircularBiDirectionalFetchImpl;
import org.hibernate.sql.results.internal.domain.CircularFetchImpl;

public class ToOneAttributeMapping
extends AbstractSingularAttributeMapping
implements EntityValuedFetchable,
EntityAssociationMapping,
TableGroupJoinProducer {
    private final NavigableRole navigableRole;
    private final String sqlAliasStem;
    private final boolean isNullable;
    private final boolean unwrapProxy;
    private final EntityMappingType entityMappingType;
    private final String referencedPropertyName;
    private final Cardinality cardinality;
    private String bidirectionalAttributeName;
    private ForeignKeyDescriptor foreignKeyDescriptor;
    private String identifyingColumnsTableExpression;
    private boolean isKeyReferringSide;

    public ToOneAttributeMapping(String name, NavigableRole navigableRole, int stateArrayPosition, ToOne bootValue, StateArrayContributorMetadataAccess attributeMetadataAccess, FetchStrategy mappedFetchStrategy, EntityMappingType entityMappingType, ManagedMappingType declaringType, PropertyAccess propertyAccess) {
        super(name, stateArrayPosition, attributeMetadataAccess, mappedFetchStrategy, declaringType, propertyAccess);
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(name);
        this.isNullable = bootValue.isNullable();
        this.referencedPropertyName = bootValue.getReferencedPropertyName();
        this.unwrapProxy = bootValue.isUnwrapProxy();
        this.entityMappingType = entityMappingType;
        if (bootValue instanceof ManyToOne) {
            ManyToOne manyToOne = (ManyToOne)bootValue;
            this.cardinality = manyToOne.isLogicalOneToOne() ? Cardinality.LOGICAL_ONE_TO_ONE : Cardinality.MANY_TO_ONE;
        } else {
            assert (bootValue instanceof OneToOne);
            this.cardinality = Cardinality.ONE_TO_ONE;
            this.bidirectionalAttributeName = StringHelper.subStringNullIfEmpty(((OneToOne)bootValue).getMappedByProperty(), Character.valueOf('.'));
            if (this.bidirectionalAttributeName == null) {
                this.bidirectionalAttributeName = StringHelper.subStringNullIfEmpty(bootValue.getReferencedPropertyName(), Character.valueOf('.'));
            }
        }
        this.navigableRole = navigableRole;
    }

    @Override
    public void setForeignKeyDescriptor(ForeignKeyDescriptor foreignKeyDescriptor) {
        this.isKeyReferringSide = foreignKeyDescriptor.getAssociationKey().getTable().equals(this.identifyingColumnsTableExpression);
        assert (this.identifyingColumnsTableExpression != null);
        this.foreignKeyDescriptor = foreignKeyDescriptor;
    }

    public void setIdentifyingColumnsTableExpression(String tableExpression) {
        this.identifyingColumnsTableExpression = tableExpression;
    }

    @Override
    public ForeignKeyDescriptor getForeignKeyDescriptor() {
        return this.foreignKeyDescriptor;
    }

    public String getReferencedPropertyName() {
        return this.referencedPropertyName;
    }

    @Override
    public EntityMappingType getMappedType() {
        return this.getEntityMappingType();
    }

    @Override
    public EntityMappingType getEntityMappingType() {
        return this.entityMappingType;
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.navigableRole;
    }

    @Override
    public Fetch resolveCircularFetch(NavigablePath fetchablePath, FetchParent fetchParent, DomainResultCreationState creationState) {
        AssociationKey associationKey = this.foreignKeyDescriptor.getAssociationKey();
        if (creationState.isAssociationKeyVisited(associationKey)) {
            NavigablePath parentNavigablePath = fetchablePath.getParent();
            assert (parentNavigablePath.equals(fetchParent.getNavigablePath()));
            ModelPart modelPart = creationState.resolveModelPart(parentNavigablePath);
            if (modelPart instanceof EmbeddedIdentifierMappingImpl) {
                while (parentNavigablePath instanceof EntityIdentifierNavigablePath) {
                    parentNavigablePath = parentNavigablePath.getParent();
                }
            }
            while (modelPart instanceof EmbeddableValuedFetchable) {
                parentNavigablePath = parentNavigablePath.getParent();
                assert (parentNavigablePath != null);
                modelPart = creationState.resolveModelPart(parentNavigablePath);
            }
            if (this.isBidirectionalAttributeName(parentNavigablePath)) {
                return this.createCircularBiDirectionalFetch(fetchablePath, fetchParent, parentNavigablePath, LockMode.READ);
            }
            boolean isBiDirectional = this.isBidirectional(modelPart, parentNavigablePath.getParent(), fetchablePath, creationState);
            if (isBiDirectional) {
                return this.createCircularBiDirectionalFetch(fetchablePath, fetchParent, parentNavigablePath, LockMode.READ);
            }
            if (this.isKeyReferringSide) {
                TableGroup parentTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath());
                return new CircularFetchImpl(this, this.getEntityMappingType(), this.getTiming(), fetchablePath, fetchParent, this, fetchablePath, this.foreignKeyDescriptor.createDomainResult(fetchablePath, parentTableGroup, creationState));
            }
        }
        return null;
    }

    private boolean isBidirectional(ModelPart modelPart, NavigablePath parentOfParent, NavigablePath fetchablePath, DomainResultCreationState creationState) {
        if (modelPart instanceof ToOneAttributeMapping) {
            return ((ToOneAttributeMapping)modelPart).isBidirectionalAttributeName(fetchablePath);
        }
        if (modelPart instanceof PluralAttributeMapping) {
            return ((PluralAttributeMapping)modelPart).isBidirectionalAttributeName(fetchablePath);
        }
        if (modelPart instanceof EntityCollectionPart) {
            if (parentOfParent instanceof EntityIdentifierNavigablePath) {
                parentOfParent = parentOfParent.getParent();
            }
            return ((PluralAttributeMapping)creationState.resolveModelPart(parentOfParent)).isBidirectionalAttributeName(fetchablePath);
        }
        return false;
    }

    protected boolean isBidirectionalAttributeName(NavigablePath fetchablePath) {
        if (this.bidirectionalAttributeName == null) {
            return false;
        }
        return fetchablePath.getFullPath().endsWith(this.bidirectionalAttributeName);
    }

    public String getBidirectionalAttributeName() {
        return this.bidirectionalAttributeName;
    }

    private Fetch createCircularBiDirectionalFetch(NavigablePath fetchablePath, FetchParent fetchParent, NavigablePath parentNavigablePath, LockMode lockMode) {
        NavigablePath referencedNavigablePath = parentNavigablePath.getParent() == null ? parentNavigablePath : parentNavigablePath.getParent();
        return new CircularBiDirectionalFetchImpl(FetchTiming.IMMEDIATE, fetchablePath, fetchParent, this, lockMode, referencedNavigablePath);
    }

    @Override
    public EntityFetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        boolean selectByUniqueKey;
        DomainResult keyResult;
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        TableGroup parentTableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath());
        if (fetchTiming == FetchTiming.IMMEDIATE && selected) {
            if (fetchParent instanceof EntityResultJoinedSubclassImpl && ((EntityPersister)fetchParent.getReferencedModePart()).findDeclaredAttributeMapping(this.getPartName()) == null) {
                TableGroup tableGroupJoin = this.createTableGroupJoin(fetchablePath, lockMode, creationState, parentTableGroup);
                fromClauseAccess.registerTableGroup(fetchablePath, tableGroupJoin);
            } else {
                fromClauseAccess.resolveTableGroup(fetchablePath, np -> this.createTableGroupJoin(fetchablePath, lockMode, creationState, parentTableGroup));
            }
            creationState.registerVisitedAssociationKey(this.foreignKeyDescriptor.getAssociationKey());
            return new EntityFetchJoinedImpl(fetchParent, this, lockMode, true, fetchablePath, creationState);
        }
        if (this.isKeyReferringSide) {
            keyResult = this.foreignKeyDescriptor.createDomainResult(fetchablePath, parentTableGroup, creationState);
            selectByUniqueKey = false;
        } else {
            keyResult = this.foreignKeyDescriptor.createDomainResult(fetchablePath, parentTableGroup, this.isKeyReferringSide, creationState);
            selectByUniqueKey = true;
        }
        assert (!selected);
        if (fetchTiming == FetchTiming.IMMEDIATE) {
            return new EntityFetchSelectImpl(fetchParent, this, this.isNullable, fetchablePath, keyResult, selectByUniqueKey, creationState);
        }
        return new EntityDelayedFetchImpl(fetchParent, this, fetchablePath, keyResult);
    }

    @Override
    public <T> DomainResult<T> createDelayedDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        if (!this.isKeyReferringSide || this.referencedPropertyName != null) {
            TableGroupJoin tableGroupJoin = this.createTableGroupJoin(navigablePath, tableGroup, null, tableGroup.isInnerJoinPossible() ? SqlAstJoinType.INNER : SqlAstJoinType.LEFT, null, creationState.getSqlAstCreationState());
            creationState.getSqlAstCreationState().getFromClauseAccess().registerTableGroup(navigablePath, tableGroupJoin.getJoinedGroup());
        }
        if (this.referencedPropertyName == null) {
            return new EntityDelayedResultImpl(navigablePath.append("{id}"), this, tableGroup, creationState);
        }
        return new EntityResultImpl(navigablePath, this, null, creationState);
    }

    private TableGroup createTableGroupJoin(NavigablePath fetchablePath, LockMode lockMode, DomainResultCreationState creationState, TableGroup parentTableGroup) {
        SqlAstJoinType sqlAstJoinType = this.isNullable ? SqlAstJoinType.LEFT : (parentTableGroup.getModelPart() instanceof EmbeddedCollectionPart ? SqlAstJoinType.LEFT : SqlAstJoinType.INNER);
        TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, parentTableGroup, null, sqlAstJoinType, lockMode, creationState.getSqlAstCreationState());
        return tableGroupJoin.getJoinedGroup();
    }

    @Override
    public int getNumberOfFetchables() {
        return this.getEntityMappingType().getNumberOfFetchables();
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, LockMode lockMode, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        String aliasRoot = explicitSourceAlias == null ? this.sqlAliasStem : explicitSourceAlias;
        SqlAliasBase sqlAliasBase = aliasBaseGenerator.createSqlAliasBase(aliasRoot);
        TableReference primaryTableReference = this.getEntityMappingType().createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
        StandardTableGroup tableGroup = new StandardTableGroup(navigablePath, this, lockMode, primaryTableReference, sqlAliasBase, tableExpression -> this.getEntityMappingType().containsTableReference((String)tableExpression), (tableExpression, tg) -> this.getEntityMappingType().createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, false, sqlExpressionResolver, creationContext), creationContext.getSessionFactory());
        TableReference lhsTableReference = lhs.resolveTableReference(this.identifyingColumnsTableExpression);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, sqlAstJoinType, tableGroup, this.foreignKeyDescriptor.generateJoinPredicate(lhsTableReference, primaryTableReference, sqlAstJoinType, sqlExpressionResolver, creationContext));
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public boolean isUnwrapProxy() {
        return this.unwrapProxy;
    }

    @Override
    public EntityMappingType getAssociatedEntityMappingType() {
        return this.getEntityMappingType();
    }

    @Override
    public ModelPart getKeyTargetMatchPart() {
        return this.foreignKeyDescriptor;
    }

    public String toString() {
        return "SingularAssociationAttributeMapping {" + this.navigableRole + "}";
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        this.foreignKeyDescriptor.breakDownJdbcValues(domainValue, valueConsumer, session);
    }

    @Override
    public int forEachSelection(int offset, SelectionConsumer consumer) {
        if (this.isKeyReferringSide) {
            return this.foreignKeyDescriptor.visitReferringColumns(offset, consumer);
        }
        return 0;
    }

    @Override
    public int getJdbcTypeCount() {
        return this.foreignKeyDescriptor.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.foreignKeyDescriptor.forEachJdbcType(offset, action);
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.disassemble(value, session);
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.forEachDisassembledJdbcValue(value, clause, offset, valuesConsumer, session);
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer consumer, SharedSessionContractImplementor session) {
        return this.foreignKeyDescriptor.forEachDisassembledJdbcValue(this.foreignKeyDescriptor.disassemble(value, session), clause, offset, consumer, session);
    }

    public static enum Cardinality {
        ONE_TO_ONE,
        MANY_TO_ONE,
        LOGICAL_ONE_TO_ONE;

    }
}

