/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.Type;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.internal.AbstractSqmPathSource;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.IllegalPathUsageException;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public class BasicSqmPathSource<J>
extends AbstractSqmPathSource<J>
implements AllowableParameterType<J>,
AllowableFunctionReturnType<J> {
    public BasicSqmPathSource(String localPathName, BasicDomainType<J> domainType, Bindable.BindableType jpaBindableType) {
        super(localPathName, domainType, jpaBindableType);
    }

    @Override
    public BasicDomainType<J> getSqmPathType() {
        return (BasicDomainType)super.getSqmPathType();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        throw new IllegalPathUsageException("Basic paths cannot be dereferenced");
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmCreationState creationState) {
        NavigablePath navigablePath = lhs.getNavigablePath().append(this.getPathName());
        return new SqmBasicValuedSimplePath(navigablePath, this, (SqmPath)lhs, creationState.getCreationContext().getNodeBuilder());
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.BASIC;
    }

    public Class<J> getJavaType() {
        return this.getExpressableJavaTypeDescriptor().getJavaTypeClass();
    }

    public String toString() {
        return "BasicSqmPathSource(" + this.getPathName() + " : " + this.getJavaType().getSimpleName() + ")";
    }
}

