/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.internal.SubGraphImpl;
import org.hibernate.graph.spi.SubGraphImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.model.domain.AbstractManagedType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.model.domain.internal.SingularAttributeImpl;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.ManagedTypeRepresentationStrategy;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.internal.PropertyAccessStrategyMixedImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.sql.ast.Clause;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class EmbeddableTypeImpl<J>
extends AbstractManagedType<J>
implements EmbeddableDomainType<J>,
Serializable,
MappingModelExpressable<J> {
    private final boolean isDynamic;
    private final EmbeddableRepresentationStrategy representationStrategy;

    public EmbeddableTypeImpl(JavaTypeDescriptor<J> javaTypeDescriptor, EmbeddableRepresentationStrategy representationStrategy, boolean isDynamic, JpaMetamodel domainMetamodel) {
        super(javaTypeDescriptor.getJavaType().getTypeName(), javaTypeDescriptor, null, domainMetamodel);
        this.representationStrategy = representationStrategy;
        this.isDynamic = isDynamic;
    }

    public EmbeddableTypeImpl(String name, JpaMetamodel domainMetamodel) {
        super(name, domainMetamodel.getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((java.lang.reflect.Type)((Object)Map.class)), null, domainMetamodel);
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public ManagedTypeRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    @Override
    public <S extends J> SubGraphImplementor<S> makeSubGraph(Class<S> subType) {
        return new SubGraphImpl(this, true, this.jpaMetamodel());
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        Object[] disassemble = (Object[])this.disassemble(value, session);
        return this.forEachJdbcType((i, jdbcMapping) -> valuesConsumer.consume(i + offset, disassemble[i], (JdbcMapping)jdbcMapping));
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        MetamodelImplementor metamodel = this.jpaMetamodel().getTypeConfiguration().getSessionFactory().getMetamodel();
        int i = 0;
        block5: for (Attribute attribute : this.getAttributes()) {
            if (!(attribute instanceof SingularAttribute)) continue;
            Type type = ((SingularAttribute)attribute).getType();
            switch (type.getPersistenceType()) {
                case BASIC: {
                    BasicType basicType = this.jpaMetamodel().getTypeConfiguration().getBasicTypeForJavaType(attribute.getJavaType());
                    action.accept(i + offset, basicType.getJdbcMapping());
                    ++i;
                    continue block5;
                }
                case ENTITY: {
                    EntityPersister entityDescriptor = metamodel.getEntityDescriptor(((EntityDomainType)type).getHibernateEntityName());
                    i += entityDescriptor.getEntityMappingType().getIdentifierMapping().forEachJdbcType(i + offset, action);
                    continue block5;
                }
                case EMBEDDABLE: {
                    i += ((Bindable)type).forEachJdbcType(i + offset, action);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
        return i;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        Set attributes = this.getAttributes();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Attribute attribute : attributes) {
            if (!(attribute instanceof SingularAttributeImpl)) continue;
            PropertyAccess propertyAccess = PropertyAccessStrategyMixedImpl.INSTANCE.buildPropertyAccess(this.getJavaType(), attribute.getName());
            Object attributeValue = propertyAccess.getGetter().get(value);
            if (attribute.isAssociation()) {
                EntityPersister entityDescriptor = session.getFactory().getMetamodel().findEntityDescriptor(attribute.getJavaType().getName());
                Object disassembled = entityDescriptor.getIdentifierMapping().disassemble(attributeValue, session);
                if (disassembled instanceof Object[]) {
                    for (Object o : (Object[])disassembled) {
                        result.add(o);
                    }
                    continue;
                }
                result.add(disassembled);
                continue;
            }
            result.add(attributeValue);
        }
        return result.toArray();
    }
}

