/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.function.Supplier;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Bindable;
import org.hibernate.graph.spi.GraphHelper;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.AnyMappingDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.AbstractAttribute;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SingularAttributeImpl<D, J>
extends AbstractAttribute<D, J, J>
implements SingularPersistentAttribute<D, J>,
Serializable {
    private final boolean isIdentifier;
    private final boolean isVersion;
    private final boolean isOptional;
    private final SqmPathSource<J> sqmPathSource;
    private final DelayedKeyTypeAccess graphKeyTypeAccess = new DelayedKeyTypeAccess();

    public SingularAttributeImpl(ManagedDomainType<D> declaringType, String name, AttributeClassification attributeClassification, SimpleDomainType<J> attributeType, Member member, boolean isIdentifier, boolean isVersion, boolean isOptional, MetadataContext metadataContext) {
        super(declaringType, name, attributeType.getExpressableJavaTypeDescriptor(), attributeClassification, attributeType, member, metadataContext);
        this.isIdentifier = isIdentifier;
        this.isVersion = isVersion;
        this.isOptional = isOptional;
        this.sqmPathSource = SqmMappingModelHelper.resolveSqmPathSource(name, attributeType, Bindable.BindableType.SINGULAR_ATTRIBUTE);
    }

    @Override
    public String getPathName() {
        return this.getName();
    }

    @Override
    public JavaTypeDescriptor<J> getExpressableJavaTypeDescriptor() {
        return this.sqmPathSource.getExpressableJavaTypeDescriptor();
    }

    @Override
    public SimpleDomainType<J> getSqmPathType() {
        return (SimpleDomainType)this.sqmPathSource.getSqmPathType();
    }

    @Override
    public SimpleDomainType<J> getValueGraphType() {
        return this.getSqmPathType();
    }

    @Override
    public SimpleDomainType<J> getKeyGraphType() {
        return this.graphKeyTypeAccess.get();
    }

    @Override
    public SimpleDomainType<J> getType() {
        return this.getSqmPathType();
    }

    public Class<J> getBindableJavaType() {
        return this.getExpressableJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return this.sqmPathSource.findSubPathSource(name);
    }

    @Override
    public SqmAttributeJoin<D, J> createSqmJoin(SqmFrom lhs, SqmJoinType joinType, String alias, boolean fetched, SqmCreationState creationState) {
        if (this.getType() instanceof AnyMappingDomainType) {
            throw new SemanticException("An @Any attribute cannot be join fetched");
        }
        return new SqmSingularJoin(lhs, this, alias, joinType, fetched, creationState.getCreationContext().getNodeBuilder());
    }

    public boolean isId() {
        return this.isIdentifier;
    }

    public boolean isVersion() {
        return this.isVersion;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isAssociation() {
        return this.getPersistentAttributeType() == Attribute.PersistentAttributeType.MANY_TO_ONE || this.getPersistentAttributeType() == Attribute.PersistentAttributeType.ONE_TO_ONE;
    }

    public boolean isCollection() {
        return false;
    }

    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath lhs, SqmCreationState creationState) {
        return this.sqmPathSource.createSqmPath(lhs, creationState);
    }

    private class DelayedKeyTypeAccess
    implements Supplier<SimpleDomainType<J>>,
    Serializable {
        private boolean resolved;
        private SimpleDomainType<J> type;

        private DelayedKeyTypeAccess() {
        }

        @Override
        public SimpleDomainType<J> get() {
            if (!this.resolved) {
                this.type = GraphHelper.resolveKeyTypeDescriptor(SingularAttributeImpl.this);
                this.resolved = true;
            }
            return this.type;
        }
    }

    public static class Version<X, Y>
    extends SingularAttributeImpl<X, Y> {
        public Version(ManagedDomainType<X> declaringType, String name, AttributeClassification attributeClassification, SimpleDomainType<Y> attributeType, Member member, MetadataContext metadataContext) {
            super(declaringType, name, attributeClassification, attributeType, member, false, true, false, metadataContext);
        }
    }

    public static class Identifier<D, J>
    extends SingularAttributeImpl<D, J> {
        public Identifier(ManagedDomainType<D> declaringType, String name, SimpleDomainType<J> attributeType, Member member, AttributeClassification attributeClassification, MetadataContext metadataContext) {
            super(declaringType, name, attributeClassification, attributeType, member, true, false, false, metadataContext);
        }
    }
}

