/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.query.SemanticException;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class DomainPathPart
implements SemanticPathPart {
    private SqmPath<?> currentPath;

    public DomainPathPart(SqmPath<?> basePath) {
        this.currentPath = basePath;
        assert (this.currentPath != null);
    }

    SqmExpression<?> getSqmExpression() {
        return this.currentPath;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        HqlLogging.QUERY_LOGGER.tracef("Resolving DomainPathPart(%s) sub-part : %s", this.currentPath, name);
        SqmPath<?> lhs = this.currentPath;
        SqmPathSource<?> subPathSource = lhs.getReferencedPathSource().findSubPathSource(name);
        if (subPathSource == null) {
            throw new SemanticException("Cannot resolve path (`" + name + "`) relative to `" + lhs.getNavigablePath() + "`");
        }
        SqmPath<?> existingImplicitJoinPath = lhs.getImplicitJoinPath(name);
        if (existingImplicitJoinPath != null) {
            this.currentPath = existingImplicitJoinPath;
            return this;
        }
        this.currentPath = subPathSource.createSqmPath(lhs, creationState);
        if (isTerminal) {
            return this.currentPath;
        }
        lhs.registerImplicitJoinPath(this.currentPath);
        return this;
    }

    @Override
    public SqmPath resolveIndexedAccess(SqmExpression selector, boolean isTerminal, SqmCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }
}

