/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.hibernate.FetchClauseType;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.NullPrecedence;
import org.hibernate.QueryException;
import org.hibernate.SetOperator;
import org.hibernate.SortOrder;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.grammars.hql.HqlParser;
import org.hibernate.grammars.hql.HqlParserBaseVisitor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.PathException;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.TrimSpec;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.internal.BasicDotIdentifierConsumer;
import org.hibernate.query.hql.internal.DomainPathPart;
import org.hibernate.query.hql.internal.QualifiedJoinPathConsumer;
import org.hibernate.query.hql.internal.QualifiedJoinPredicatePathConsumer;
import org.hibernate.query.hql.spi.DotIdentifierConsumer;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.LiteralNumberFormatException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.StrictJpaComplianceViolation;
import org.hibernate.query.sqm.UnknownEntityException;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.internal.ParameterCollector;
import org.hibernate.query.sqm.internal.SqmCreationProcessingStateImpl;
import org.hibernate.query.sqm.internal.SqmDmlCreationProcessingState;
import org.hibernate.query.sqm.internal.SqmQuerySpecCreationProcessingStateStandardImpl;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.spi.ParameterDeclarationContext;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmIndexedCollectionAccessPath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmMaxElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMaxIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmMinElementPath;
import org.hibernate.query.sqm.tree.domain.SqmMinIndexPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPolymorphicRootDescriptor;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCollate;
import org.hibernate.query.sqm.tree.expression.SqmCollectionSize;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameterizedEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPathEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.DowncastLocation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmQualifiedJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatablePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class SemanticQueryBuilder<R>
extends HqlParserBaseVisitor<Object>
implements SqmCreationState {
    private static final Logger log = Logger.getLogger(SemanticQueryBuilder.class);
    private final SqmCreationOptions creationOptions;
    private final SqmCreationContext creationContext;
    private final Stack<DotIdentifierConsumer> dotIdentifierConsumerStack;
    private final Stack<TreatHandler> treatHandlerStack = new StandardStack<TreatHandlerNormal>(new TreatHandlerNormal());
    private final Stack<ParameterDeclarationContext> parameterDeclarationContextStack = new StandardStack<ParameterDeclarationContext>();
    private final Stack<SqmCreationProcessingState> processingStateStack = new StandardStack<SqmCreationProcessingState>();
    private ParameterCollector parameterCollector;
    private JavaTypeDescriptor<List> listJavaTypeDescriptor;
    private JavaTypeDescriptor<Map> mapJavaTypeDescriptor;
    private boolean isExtractingJdbcTemporalType;
    private static final Pattern FORMAT = Pattern.compile("('[^']+'|[:;/,.!@#$^&?~`|()\\[\\]{}<>\\-+*=]|\\s|G{1,2}|[yY]{1,4}|M{1,4}|w{1,2}|W|E{3,4}|e{1,2}|d{1,2}|D{1,3}|a{1,2}|[Hhms]{1,2}|S{1,6}|[zZx]{1,3})*");

    public static <R> SqmStatement<R> buildSemanticModel(HqlParser.StatementContext hqlParseTree, SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        return new SemanticQueryBuilder<R>(creationOptions, creationContext).visitStatement(hqlParseTree);
    }

    @Override
    public Stack<SqmCreationProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    public SemanticQueryBuilder(SqmCreationOptions creationOptions, SqmCreationContext creationContext) {
        this.creationOptions = creationOptions;
        this.creationContext = creationContext;
        this.dotIdentifierConsumerStack = new StandardStack<BasicDotIdentifierConsumer>(new BasicDotIdentifierConsumer(this));
    }

    @Override
    public SqmCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqmCreationOptions getCreationOptions() {
        return this.creationOptions;
    }

    protected Stack<ParameterDeclarationContext> getParameterDeclarationContextStack() {
        return this.parameterDeclarationContextStack;
    }

    @Override
    public SqmStatement<R> visitStatement(HqlParser.StatementContext ctx) {
        this.parameterDeclarationContextStack.push(() -> false);
        try {
            if (ctx.selectStatement() != null) {
                Object object = this.visitSelectStatement(ctx.selectStatement());
                return object;
            }
            if (ctx.insertStatement() != null) {
                Object object = this.visitInsertStatement(ctx.insertStatement());
                return object;
            }
            if (ctx.updateStatement() != null) {
                Object object = this.visitUpdateStatement(ctx.updateStatement());
                return object;
            }
            if (ctx.deleteStatement() != null) {
                Object object = this.visitDeleteStatement(ctx.deleteStatement());
                return object;
            }
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
        throw new ParsingException("Unexpected statement type [not INSERT, UPDATE, DELETE or SELECT] : " + ctx.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSelectStatement<R> visitSelectStatement(HqlParser.SelectStatementContext ctx) {
        SqmSelectStatement selectStatement;
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        this.parameterCollector = selectStatement = new SqmSelectStatement(this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
        try {
            queryExpressionContext.accept(this);
        }
        finally {
            this.processingStateStack.pop();
        }
        return selectStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmInsertStatement<R> visitInsertStatement(HqlParser.InsertStatementContext ctx) {
        SqmInsertValuesStatement insertStatement;
        SqmRoot root = new SqmRoot(this.visitEntityName(ctx.dmlTarget().entityName()), this.applyJpaCompliance(this.visitIdentificationVariableDef(ctx.dmlTarget().identificationVariableDef())), this.creationContext.getNodeBuilder());
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        if (queryExpressionContext != null) {
            SqmInsertSelectStatement insertStatement2;
            this.parameterCollector = insertStatement2 = new SqmInsertSelectStatement(root, this.creationContext.getNodeBuilder());
            SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement2, this);
            this.processingStateStack.push(processingState);
            try {
                queryExpressionContext.accept(this);
                SqmCreationProcessingStateImpl stateFieldsProcessingState = new SqmCreationProcessingStateImpl(insertStatement2, this);
                stateFieldsProcessingState.getPathRegistry().register(root);
                this.processingStateStack.push(stateFieldsProcessingState);
                try {
                    for (HqlParser.DotIdentifierSequenceContext stateFieldCtx : ctx.targetFieldsSpec().dotIdentifierSequence()) {
                        SqmPath stateField = (SqmPath)this.visitDotIdentifierSequence(stateFieldCtx);
                        insertStatement2.addInsertTargetStateField(stateField);
                    }
                }
                finally {
                    this.processingStateStack.pop();
                }
                SqmInsertSelectStatement sqmInsertSelectStatement = insertStatement2;
                return sqmInsertSelectStatement;
            }
            finally {
                this.processingStateStack.pop();
            }
        }
        this.parameterCollector = insertStatement = new SqmInsertValuesStatement(root, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(insertStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register(root);
        try {
            for (HqlParser.ValuesContext values : ctx.valuesList().values()) {
                SqmValues sqmValues = new SqmValues();
                for (HqlParser.ExpressionContext expressionContext : values.expression()) {
                    sqmValues.getExpressions().add((SqmExpression)expressionContext.accept(this));
                }
                insertStatement.getValuesList().add(sqmValues);
            }
            for (HqlParser.DotIdentifierSequenceContext stateFieldCtx : ctx.targetFieldsSpec().dotIdentifierSequence()) {
                SqmPath stateField = (SqmPath)this.visitDotIdentifierSequence(stateFieldCtx);
                insertStatement.addInsertTargetStateField(stateField);
            }
            SqmInsertValuesStatement sqmInsertValuesStatement = insertStatement;
            return sqmInsertValuesStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmUpdateStatement<R> visitUpdateStatement(HqlParser.UpdateStatementContext ctx) {
        SqmUpdateStatement updateStatement;
        SqmRoot root = new SqmRoot(this.visitEntityName(ctx.dmlTarget().entityName()), this.visitIdentificationVariableDef(ctx.dmlTarget().identificationVariableDef()), this.creationContext.getNodeBuilder());
        this.parameterCollector = updateStatement = new SqmUpdateStatement(root, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState processingState = new SqmDmlCreationProcessingState(updateStatement, this);
        this.processingStateStack.push(processingState);
        processingState.getPathRegistry().register(root);
        try {
            for (HqlParser.AssignmentContext assignmentContext : ctx.setClause().assignment()) {
                updateStatement.applyAssignment(this.consumeDomainPath(assignmentContext.dotIdentifierSequence()), (SqmExpression)assignmentContext.expression().accept(this));
            }
            updateStatement.applyPredicate(this.visitWhereClause(ctx.whereClause()));
            SqmUpdateStatement sqmUpdateStatement = updateStatement;
            return sqmUpdateStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmDeleteStatement<R> visitDeleteStatement(HqlParser.DeleteStatementContext ctx) {
        SqmDeleteStatement deleteStatement;
        SqmRoot root = new SqmRoot(this.visitEntityName(ctx.dmlTarget().entityName()), this.visitIdentificationVariableDef(ctx.dmlTarget().identificationVariableDef()), this.creationContext.getNodeBuilder());
        this.parameterCollector = deleteStatement = new SqmDeleteStatement(root, SqmQuerySource.HQL, this.creationContext.getNodeBuilder());
        SqmDmlCreationProcessingState sqmDeleteCreationState = new SqmDmlCreationProcessingState(deleteStatement, this);
        sqmDeleteCreationState.getPathRegistry().register(root);
        this.processingStateStack.push(sqmDeleteCreationState);
        try {
            if (ctx.whereClause() != null && ctx.whereClause().predicate() != null) {
                deleteStatement.applyPredicate((SqmPredicate)ctx.whereClause().predicate().accept(this));
            }
            SqmDeleteStatement sqmDeleteStatement = deleteStatement;
            return sqmDeleteStatement;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    @Override
    public SqmQueryPart<Object> visitSimpleQueryGroup(HqlParser.SimpleQueryGroupContext ctx) {
        return (SqmQueryPart)ctx.simpleQueryExpression().accept(this);
    }

    @Override
    public SqmQueryPart<Object> visitQuerySpecExpression(HqlParser.QuerySpecExpressionContext ctx) {
        List children = ctx.children;
        Object queryPart = this.visitQuerySpec((HqlParser.QuerySpecContext)((Object)children.get(0)));
        if (children.size() > 1) {
            this.visitQueryOrder((SqmQueryPart<?>)queryPart, (HqlParser.QueryOrderContext)((Object)children.get(1)));
        }
        return queryPart;
    }

    @Override
    public SqmQueryPart<Object> visitNestedQueryExpression(HqlParser.NestedQueryExpressionContext ctx) {
        List children = ctx.children;
        SqmQueryPart queryPart = (SqmQueryPart)((ParseTree)children.get(1)).accept((ParseTreeVisitor)this);
        if (children.size() > 3) {
            this.visitQueryOrder(queryPart, (HqlParser.QueryOrderContext)((Object)children.get(3)));
        }
        return queryPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmQueryGroup<Object> visitSetQueryGroup(HqlParser.SetQueryGroupContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SET_OPERATIONS);
        }
        List children = ctx.children;
        SqmQueryPart firstQueryPart = (SqmQueryPart)((ParseTree)children.get(0)).accept((ParseTreeVisitor)this);
        SqmQueryGroup<Object> queryGroup = firstQueryPart instanceof SqmQueryGroup ? (SqmQueryGroup<Object>)firstQueryPart : new SqmQueryGroup<Object>(firstQueryPart);
        this.setCurrentQueryPart(queryGroup);
        List<SqmSelection> firstSelections = firstQueryPart.getFirstQuerySpec().getSelectClause().getSelections();
        int firstSelectionSize = firstSelections.size();
        int size = children.size();
        SqmCreationProcessingState firstProcessingState = this.processingStateStack.pop();
        for (int i = 1; i < size; i += 2) {
            Object queryPart;
            block13: {
                List queryParts;
                SetOperator operator = this.visitSetOperator((HqlParser.SetOperatorContext)((Object)children.get(i)));
                HqlParser.SimpleQueryExpressionContext simpleQueryCtx = (HqlParser.SimpleQueryExpressionContext)((Object)children.get(i + 1));
                if (queryGroup.getSetOperator() == null || queryGroup.getSetOperator() == operator) {
                    queryGroup.setSetOperator(operator);
                    queryParts = queryGroup.queryParts();
                } else {
                    queryParts = new ArrayList<SqmQueryPart<Object>>(size - (i >> 1));
                    queryParts.add(queryGroup);
                    queryGroup = new SqmQueryGroup(this.creationContext.getNodeBuilder(), operator, queryParts);
                    this.setCurrentQueryPart(queryGroup);
                }
                try {
                    this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), (SqmSelectQuery)firstProcessingState.getProcessingQuery(), this));
                    List subChildren = simpleQueryCtx.children;
                    if (subChildren.get(0) instanceof HqlParser.QuerySpecContext) {
                        SqmQuerySpec querySpec = new SqmQuerySpec(this.creationContext.getNodeBuilder());
                        queryParts.add(querySpec);
                        queryPart = this.visitQuerySpecExpression((HqlParser.QuerySpecExpressionContext)simpleQueryCtx);
                        break block13;
                    }
                    try {
                        SqmSelectStatement selectStatement = new SqmSelectStatement(this.creationContext.getNodeBuilder());
                        this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), selectStatement, this));
                        queryPart = this.visitNestedQueryExpression((HqlParser.NestedQueryExpressionContext)simpleQueryCtx);
                        queryParts.add(queryPart);
                    }
                    finally {
                        this.processingStateStack.pop();
                    }
                }
                finally {
                    this.processingStateStack.pop();
                }
            }
            List<SqmSelection> selections = ((SqmQueryPart)queryPart).getFirstQuerySpec().getSelectClause().getSelections();
            if (firstSelectionSize != selections.size()) {
                throw new SemanticException("All query parts must have the same arity!");
            }
            for (int j = 0; j < firstSelectionSize; ++j) {
                JavaTypeDescriptor firstJavaTypeDescriptor = firstSelections.get(j).getNodeJavaTypeDescriptor();
                if (firstJavaTypeDescriptor == selections.get(j).getNodeJavaTypeDescriptor()) continue;
                throw new SemanticException("Select items of the same index must have the same java type across all query parts!");
            }
        }
        this.processingStateStack.push(firstProcessingState);
        return queryGroup;
    }

    @Override
    public SetOperator visitSetOperator(HqlParser.SetOperatorContext ctx) {
        Token token = ((TerminalNode)ctx.getChild(0)).getSymbol();
        boolean all = ctx.getChildCount() == 2;
        switch (token.getType()) {
            case 185: {
                return all ? SetOperator.UNION_ALL : SetOperator.UNION;
            }
            case 104: {
                return all ? SetOperator.INTERSECT_ALL : SetOperator.INTERSECT;
            }
            case 82: {
                return all ? SetOperator.EXCEPT_ALL : SetOperator.EXCEPT;
            }
        }
        throw new SemanticException("Illegal set operator token: " + token.getText());
    }

    protected void visitQueryOrder(SqmQueryPart<?> sqmQueryPart, HqlParser.QueryOrderContext ctx) {
        SqmOrderByClause orderByClause;
        if (ctx == null) {
            return;
        }
        HqlParser.OrderByClauseContext orderByClauseContext = ctx.orderByClause();
        if (orderByClauseContext != null) {
            if (this.creationOptions.useStrictJpaCompliance() && this.processingStateStack.depth() > 1) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.SUBQUERY_ORDER_BY);
            }
            orderByClause = this.visitOrderByClause(orderByClauseContext);
            sqmQueryPart.setOrderByClause(orderByClause);
        } else {
            orderByClause = null;
        }
        HqlParser.LimitClauseContext limitClauseContext = ctx.limitClause();
        HqlParser.OffsetClauseContext offsetClauseContext = ctx.offsetClause();
        HqlParser.FetchClauseContext fetchClauseContext = ctx.fetchClause();
        if (limitClauseContext != null || offsetClauseContext != null || fetchClauseContext != null) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.LIMIT_OFFSET_CLAUSE);
            }
            if (this.processingStateStack.depth() > 1 && orderByClause == null) {
                throw new SemanticException("limit, offset and fetch clause require an order-by clause when used in sub-query");
            }
            sqmQueryPart.setOffsetExpression((SqmExpression<?>)this.visitOffsetClause(offsetClauseContext));
            if (limitClauseContext == null) {
                sqmQueryPart.setFetchExpression((SqmExpression<?>)this.visitFetchClause(fetchClauseContext), this.visitFetchClauseType(fetchClauseContext));
            } else if (fetchClauseContext == null) {
                sqmQueryPart.setFetchExpression((SqmExpression<?>)this.visitLimitClause(limitClauseContext));
            } else {
                throw new SemanticException("Can't use both, limit and fetch clause!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmQuerySpec<Object> visitQuerySpec(HqlParser.QuerySpecContext ctx) {
        HqlParser.HavingClauseContext havingClauseContext;
        SqmSelectClause selectClause;
        SqmQuerySpec<Object> sqmQuerySpec = this.currentQuerySpec();
        this.treatHandlerStack.push(new TreatHandlerFromClause());
        try {
            sqmQuerySpec.setFromClause(this.visitFromClause(ctx.fromClause()));
        }
        finally {
            this.treatHandlerStack.pop();
        }
        HqlParser.SelectClauseContext selectClauseContext = ctx.selectClause();
        if (selectClauseContext != null) {
            selectClause = this.visitSelectClause(selectClauseContext);
        } else {
            if (this.creationOptions.useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered implicit select-clause, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.IMPLICIT_SELECT);
            }
            log.debugf("Encountered implicit select clause : %s", (Object)ctx.getText());
            selectClause = this.buildInferredSelectClause(sqmQuerySpec.getFromClause());
        }
        sqmQuerySpec.setSelectClause(selectClause);
        SqmWhereClause whereClause = new SqmWhereClause(this.creationContext.getNodeBuilder());
        if (ctx.whereClause() != null) {
            this.treatHandlerStack.push(new TreatHandlerNormal(DowncastLocation.WHERE));
            try {
                whereClause.setPredicate((SqmPredicate)ctx.whereClause().accept(this));
            }
            finally {
                this.treatHandlerStack.pop();
            }
        }
        sqmQuerySpec.setWhereClause(whereClause);
        HqlParser.GroupByClauseContext groupByClauseContext = ctx.groupByClause();
        if (groupByClauseContext != null) {
            sqmQuerySpec.setGroupByClauseExpressions((List<SqmExpression<?>>)this.visitGroupByClause(groupByClauseContext));
        }
        if ((havingClauseContext = ctx.havingClause()) != null) {
            sqmQuerySpec.setHavingClausePredicate(this.visitHavingClause(havingClauseContext));
        }
        return sqmQuerySpec;
    }

    protected SqmSelectClause buildInferredSelectClause(SqmFromClause fromClause) {
        SqmSelectClause selectClause = new SqmSelectClause(false, fromClause.getNumberOfRoots(), this.creationContext.getNodeBuilder());
        fromClause.visitRoots(sqmRoot -> selectClause.addSelection(new SqmSelection(sqmRoot, sqmRoot.getExplicitAlias(), this.creationContext.getNodeBuilder())));
        return selectClause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSelectClause visitSelectClause(HqlParser.SelectClauseContext ctx) {
        this.treatHandlerStack.push(new TreatHandlerNormal(DowncastLocation.SELECT));
        try {
            SqmSelectClause selectClause = new SqmSelectClause(ctx.DISTINCT() != null, this.creationContext.getNodeBuilder());
            for (HqlParser.SelectionContext selectionContext : ctx.selectionList().selection()) {
                selectClause.addSelection(this.visitSelection(selectionContext));
            }
            SqmSelectClause sqmSelectClause = selectClause;
            return sqmSelectClause;
        }
        finally {
            this.treatHandlerStack.pop();
        }
    }

    @Override
    public SqmSelection visitSelection(HqlParser.SelectionContext ctx) {
        String resultIdentifier = this.applyJpaCompliance(this.visitResultIdentifier(ctx.resultIdentifier()));
        SqmSelectableNode selectableNode = this.visitSelectableNode(ctx);
        SqmSelection selection = new SqmSelection(selectableNode, resultIdentifier, this.creationContext.getNodeBuilder());
        this.getProcessingStateStack().getCurrent().getPathRegistry().register(selection);
        return selection;
    }

    private SqmSelectableNode visitSelectableNode(HqlParser.SelectionContext ctx) {
        if (ctx.selectExpression().dynamicInstantiation() != null) {
            return this.visitDynamicInstantiation(ctx.selectExpression().dynamicInstantiation());
        }
        if (ctx.selectExpression().jpaSelectObjectSyntax() != null) {
            return this.visitJpaSelectObjectSyntax(ctx.selectExpression().jpaSelectObjectSyntax());
        }
        if (ctx.selectExpression().mapEntrySelection() != null) {
            return this.visitMapEntrySelection(ctx.selectExpression().mapEntrySelection());
        }
        if (ctx.selectExpression().expression() != null) {
            return (SqmExpression)ctx.selectExpression().expression().accept(this);
        }
        throw new ParsingException("Unexpected selection rule type : " + ctx.getText());
    }

    @Override
    public String visitResultIdentifier(HqlParser.ResultIdentifierContext resultIdentifierContext) {
        if (resultIdentifierContext != null) {
            if (resultIdentifierContext.AS() != null) {
                Token aliasToken = resultIdentifierContext.identifier().getStart();
                String explicitAlias = aliasToken.getText();
                if (aliasToken.getType() != 205 && this.creationOptions.useStrictJpaCompliance()) {
                    throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), explicitAlias), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
                }
                return explicitAlias;
            }
            return resultIdentifierContext.getText();
        }
        return null;
    }

    @Override
    public SqmDynamicInstantiation visitDynamicInstantiation(HqlParser.DynamicInstantiationContext ctx) {
        SqmDynamicInstantiation<Object> dynamicInstantiation;
        if (ctx.dynamicInstantiationTarget().MAP() != null) {
            if (this.mapJavaTypeDescriptor == null) {
                this.mapJavaTypeDescriptor = this.creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)Map.class));
            }
            dynamicInstantiation = SqmDynamicInstantiation.forMapInstantiation(this.mapJavaTypeDescriptor, this.creationContext.getNodeBuilder());
        } else if (ctx.dynamicInstantiationTarget().LIST() != null) {
            if (this.listJavaTypeDescriptor == null) {
                this.listJavaTypeDescriptor = this.creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor((Type)((Object)List.class));
            }
            dynamicInstantiation = SqmDynamicInstantiation.forListInstantiation(this.listJavaTypeDescriptor, this.creationContext.getNodeBuilder());
        } else {
            String className = ctx.dynamicInstantiationTarget().dotIdentifierSequence().getText();
            try {
                JavaTypeDescriptor jtd = this.resolveInstantiationTargetJtd(className);
                dynamicInstantiation = SqmDynamicInstantiation.forClassInstantiation(jtd, this.creationContext.getNodeBuilder());
            }
            catch (ClassLoadingException e) {
                throw new SemanticException("Unable to resolve class named for dynamic instantiation : " + className);
            }
        }
        for (HqlParser.DynamicInstantiationArgContext arg : ctx.dynamicInstantiationArgs().dynamicInstantiationArg()) {
            dynamicInstantiation.addArgument(this.visitDynamicInstantiationArg(arg));
        }
        return dynamicInstantiation;
    }

    private JavaTypeDescriptor resolveInstantiationTargetJtd(String className) {
        Class targetJavaType = this.classForName(this.creationContext.getJpaMetamodel().qualifyImportableName(className));
        return this.creationContext.getJpaMetamodel().getTypeConfiguration().getJavaTypeDescriptorRegistry().resolveDescriptor(targetJavaType);
    }

    private Class classForName(String className) {
        return this.creationContext.getServiceRegistry().getService(ClassLoaderService.class).classForName(className);
    }

    @Override
    public SqmDynamicInstantiationArgument visitDynamicInstantiationArg(HqlParser.DynamicInstantiationArgContext ctx) {
        return new SqmDynamicInstantiationArgument(this.visitDynamicInstantiationArgExpression(ctx.dynamicInstantiationArgExpression()), ctx.identifier() == null ? null : ctx.identifier().getText(), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmSelectableNode visitDynamicInstantiationArgExpression(HqlParser.DynamicInstantiationArgExpressionContext ctx) {
        if (ctx.dynamicInstantiation() != null) {
            return this.visitDynamicInstantiation(ctx.dynamicInstantiation());
        }
        if (ctx.expression() != null) {
            return (SqmExpression)ctx.expression().accept(this);
        }
        throw new ParsingException("Unexpected dynamic-instantiation-argument rule type : " + ctx.getText());
    }

    @Override
    public SqmPath visitJpaSelectObjectSyntax(HqlParser.JpaSelectObjectSyntaxContext ctx) {
        String alias = ctx.identifier().getText();
        SqmFrom sqmFromByAlias = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias);
        if (sqmFromByAlias == null) {
            throw new SemanticException("Unable to resolve alias [" + alias + "] in selection [" + ctx.getText() + "]");
        }
        return sqmFromByAlias;
    }

    @Override
    public List<SqmExpression<?>> visitGroupByClause(HqlParser.GroupByClauseContext ctx) {
        return this.visitExpressions(ctx.groupByExpression());
    }

    @Override
    public SqmExpression<?> visitGroupByExpression(HqlParser.GroupByExpressionContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            if (ctx.collationSpecification() != null) {
                throw new ParsingException("COLLATE is not allowed for position based group by items!");
            }
            int position = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
            SqmSelection selection = this.getCurrentProcessingState().getPathRegistry().findSelectionByPosition(position);
            if (selection == null) {
                throw new ParsingException("Invalid select item position " + position + " used for order by item!");
            }
            return new SqmLiteral<Integer>(position, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
        }
        if (ctx.identifier() != null) {
            HqlParser.CollationSpecificationContext collationSpecificationContext = ctx.collationSpecification();
            SqmSelection selection = this.getCurrentProcessingState().getPathRegistry().findSelectionByAlias(ctx.identifier().getText());
            if (selection != null) {
                if (collationSpecificationContext != null) {
                    throw new ParsingException("COLLATE is not allowed for alias based group by items!");
                }
                return new SqmLiteral<Integer>(this.getSelectionPosition(selection), this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
            }
            SqmFrom sqmFrom = this.getCurrentProcessingState().getPathRegistry().findFromByAlias(ctx.identifier().getText());
            if (sqmFrom != null) {
                if (collationSpecificationContext != null) {
                    throw new ParsingException("COLLATE is not allowed for alias based group by items!");
                }
                return sqmFrom;
            }
            DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(ctx.getText(), true, true);
            return (SqmExpression)((Object)dotIdentifierConsumer.getConsumedPart());
        }
        return (SqmExpression)ctx.expression().accept(this);
    }

    @Override
    public SqmPredicate visitHavingClause(HqlParser.HavingClauseContext ctx) {
        return (SqmPredicate)ctx.predicate().accept(this);
    }

    @Override
    public SqmOrderByClause visitOrderByClause(HqlParser.OrderByClauseContext ctx) {
        SqmOrderByClause orderByClause = new SqmOrderByClause();
        for (HqlParser.SortSpecificationContext sortSpecificationContext : ctx.sortSpecification()) {
            orderByClause.addSortSpecification(this.visitSortSpecification(sortSpecificationContext));
        }
        return orderByClause;
    }

    @Override
    public SqmSortSpecification visitSortSpecification(HqlParser.SortSpecificationContext ctx) {
        SortOrder sortOrder;
        Object sortExpression = this.visitSortExpression(ctx.sortExpression());
        if (sortExpression == null) {
            throw new ParsingException("Could not resolve sort-expression : " + ctx.sortExpression().getText());
        }
        if (sortExpression instanceof SqmLiteral || sortExpression instanceof SqmParameter) {
            HqlLogging.QUERY_LOGGER.debugf("Questionable sorting by constant value : %s", sortExpression);
        }
        if (ctx.orderingSpecification() != null) {
            String ordering = ctx.orderingSpecification().getText();
            try {
                sortOrder = this.interpretSortOrder(ordering);
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException("Unrecognized sort ordering: " + ordering, e);
            }
        } else {
            sortOrder = null;
        }
        NullPrecedence nullPrecedence = ctx.nullsPrecedence() != null ? (ctx.nullsPrecedence().FIRST() != null ? NullPrecedence.FIRST : NullPrecedence.LAST) : null;
        return new SqmSortSpecification((SqmExpression)sortExpression, sortOrder, nullPrecedence);
    }

    @Override
    public SqmExpression<?> visitSortExpression(HqlParser.SortExpressionContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            if (ctx.collationSpecification() != null) {
                throw new ParsingException("COLLATE is not allowed for position based order by items!");
            }
            int position = Integer.parseInt(ctx.INTEGER_LITERAL().getText());
            SqmSelection selection = this.getCurrentProcessingState().getPathRegistry().findSelectionByPosition(position);
            if (selection == null) {
                selection = this.currentQuerySpec().getSelectClause().getSelections().get(position - 1);
            }
            if (selection == null) {
                throw new ParsingException("Invalid select item position " + position + " used for order by item!");
            }
            return new SqmLiteral<Integer>(position, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
        }
        if (ctx.identifier() != null) {
            HqlParser.CollationSpecificationContext collationSpecificationContext = ctx.collationSpecification();
            String alias = ctx.identifier().getText();
            SqmSelection selection = this.getCurrentProcessingState().getPathRegistry().findSelectionByAlias(alias);
            if (selection == null) {
                for (SqmSelection sqmSelection : this.currentQuerySpec().getSelectClause().getSelections()) {
                    if (!alias.equals(sqmSelection.getAlias())) continue;
                    selection = sqmSelection;
                    break;
                }
            }
            if (selection != null) {
                if (collationSpecificationContext != null) {
                    throw new ParsingException("COLLATE is not allowed for alias based order by items!");
                }
                return new SqmLiteral<Integer>(this.getSelectionPosition(selection), this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
            }
            SqmFrom sqmFrom = this.getCurrentProcessingState().getPathRegistry().findFromByAlias(ctx.identifier().getText());
            if (sqmFrom != null) {
                if (collationSpecificationContext != null) {
                    throw new ParsingException("COLLATE is not allowed for alias based order by items!");
                }
                return sqmFrom;
            }
            DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(ctx.getText(), true, true);
            return (SqmExpression)((Object)dotIdentifierConsumer.getConsumedPart());
        }
        return (SqmExpression)ctx.expression().accept(this);
    }

    private SqmQuerySpec<?> currentQuerySpec() {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            return ((SqmInsertSelectStatement)processingQuery).getSelectQueryPart().getLastQuerySpec();
        }
        return ((SqmQueryPart)((SqmSelectQuery)processingQuery).getQueryPart()).getLastQuerySpec();
    }

    private void setCurrentQueryPart(SqmQueryPart<?> queryPart) {
        SqmQuery<?> processingQuery = this.processingStateStack.getCurrent().getProcessingQuery();
        if (processingQuery instanceof SqmInsertSelectStatement) {
            ((SqmInsertSelectStatement)processingQuery).setSelectQueryPart(queryPart);
        } else {
            ((AbstractSqmSelectQuery)processingQuery).setQueryPart(queryPart);
        }
    }

    private int getSelectionPosition(SqmSelection<?> selection) {
        return this.currentQuerySpec().getSelectClause().getSelections().indexOf(selection) + 1;
    }

    @Override
    public SqmExpression<?> visitLimitClause(HqlParser.LimitClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitOffsetClause(HqlParser.OffsetClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.getChild(1).accept((ParseTreeVisitor)this);
    }

    @Override
    public SqmExpression<?> visitFetchClause(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return null;
        }
        return (SqmExpression)ctx.getChild(2).accept((ParseTreeVisitor)this);
    }

    private FetchClauseType visitFetchClauseType(HqlParser.FetchClauseContext ctx) {
        if (ctx == null) {
            return FetchClauseType.ROWS_ONLY;
        }
        if (ctx.TIES() == null) {
            return ctx.PERCENT() == null ? FetchClauseType.ROWS_ONLY : FetchClauseType.PERCENT_ONLY;
        }
        return ctx.PERCENT() == null ? FetchClauseType.ROWS_WITH_TIES : FetchClauseType.PERCENT_WITH_TIES;
    }

    @Override
    public SqmExpression<?> visitPathExpression(HqlParser.PathExpressionContext ctx) {
        HqlParser.PathContext path = ctx.path();
        Object accept = path.accept(this);
        if (accept instanceof DomainPathPart) {
            return ((DomainPathPart)accept).getSqmExpression();
        }
        return (SqmExpression)accept;
    }

    @Override
    public SqmExpression<?> visitFunctionExpression(HqlParser.FunctionExpressionContext ctx) {
        return (SqmExpression)ctx.function().accept(this);
    }

    @Override
    public SqmExpression<?> visitParameterOrIntegerLiteral(HqlParser.ParameterOrIntegerLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.parameter() != null) {
            return (SqmExpression)ctx.parameter().accept(this);
        }
        return null;
    }

    @Override
    public SqmExpression<?> visitParameterOrNumberLiteral(HqlParser.ParameterOrNumberLiteralContext ctx) {
        if (ctx.INTEGER_LITERAL() != null) {
            return this.integerLiteral(ctx.INTEGER_LITERAL().getText());
        }
        if (ctx.FLOAT_LITERAL() != null) {
            return this.floatLiteral(ctx.FLOAT_LITERAL().getText());
        }
        if (ctx.DOUBLE_LITERAL() != null) {
            return this.doubleLiteral(ctx.DOUBLE_LITERAL().getText());
        }
        if (ctx.parameter() != null) {
            return (SqmExpression)ctx.parameter().accept(this);
        }
        return null;
    }

    private SortOrder interpretSortOrder(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("ascending") || value.equalsIgnoreCase("asc")) {
            return SortOrder.ASCENDING;
        }
        if (value.equalsIgnoreCase("descending") || value.equalsIgnoreCase("desc")) {
            return SortOrder.DESCENDING;
        }
        throw new SemanticException("Unknown sort order : " + value);
    }

    @Override
    public EntityDomainType<?> visitEntityName(HqlParser.EntityNameContext parserEntityName) {
        String entityName = parserEntityName.fullNameText;
        EntityDomainType entityReference = this.resolveEntityReference(entityName);
        if (entityReference == null) {
            throw new UnknownEntityException("Could not resolve entity name [" + entityName + "] as DML target", entityName);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(entityName, entityReference);
        return entityReference;
    }

    private EntityDomainType resolveEntityReference(String entityName) {
        log.debugf("Attempting to resolve path [%s] as entity reference...", (Object)entityName);
        EntityDomainType reference = null;
        try {
            entityName = this.creationContext.getJpaMetamodel().qualifyImportableName(entityName);
            reference = this.creationContext.getJpaMetamodel().entity(entityName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmFromClause visitFromClause(HqlParser.FromClauseContext parserFromClause) {
        this.treatHandlerStack.push(new TreatHandlerFromClause());
        try {
            SqmFromClause fromClause;
            if (parserFromClause == null) {
                fromClause = new SqmFromClause();
            } else {
                List<HqlParser.FromClauseSpaceContext> fromClauseSpaceContexts = parserFromClause.fromClauseSpace();
                fromClause = new SqmFromClause(fromClauseSpaceContexts.size());
                for (int i = 0; i < fromClauseSpaceContexts.size(); ++i) {
                    SqmRoot sqmPathRoot = this.visitFromClauseSpace(fromClauseSpaceContexts.get(i));
                    fromClause.addRoot(sqmPathRoot);
                }
            }
            SqmFromClause sqmFromClause = fromClause;
            return sqmFromClause;
        }
        finally {
            this.treatHandlerStack.pop();
        }
    }

    @Override
    public SqmRoot visitFromClauseSpace(HqlParser.FromClauseSpaceContext parserSpace) {
        SqmRoot sqmRoot = this.visitPathRoot(parserSpace.pathRoot());
        for (HqlParser.CrossJoinContext crossJoinContext : parserSpace.crossJoin()) {
            this.consumeCrossJoin(crossJoinContext, sqmRoot);
        }
        for (HqlParser.QualifiedJoinContext qualifiedJoinContext : parserSpace.qualifiedJoin()) {
            this.consumeQualifiedJoin(qualifiedJoinContext, sqmRoot);
        }
        for (HqlParser.JpaCollectionJoinContext jpaCollectionJoinContext : parserSpace.jpaCollectionJoin()) {
            this.consumeJpaCollectionJoin(jpaCollectionJoinContext, sqmRoot);
        }
        return sqmRoot;
    }

    @Override
    public SqmRoot visitPathRoot(HqlParser.PathRootContext ctx) {
        HqlParser.EntityNameContext entityNameContext = ctx.entityName();
        List entityNameParseTreeChildren = entityNameContext.children;
        String name = entityNameContext.fullNameText;
        log.debugf("Handling root path - %s", (Object)name);
        EntityDomainType entityDescriptor = this.getCreationContext().getJpaMetamodel().getHqlEntityReference(name);
        String alias = this.applyJpaCompliance(this.visitIdentificationVariableDef(ctx.identificationVariableDef()));
        SqmCreationProcessingState processingState = this.processingStateStack.getCurrent();
        SqmPathRegistry pathRegistry = processingState.getPathRegistry();
        if (entityDescriptor == null) {
            int size = entityNameParseTreeChildren.size();
            if (this.processingStateStack.depth() > 1 && size > 2) {
                String parentAlias = ((ParseTree)entityNameParseTreeChildren.get(0)).getText();
                AbstractSqmFrom correlationBasis = (AbstractSqmFrom)processingState.getParentProcessingState().getPathRegistry().findFromByAlias(parentAlias);
                if (correlationBasis != null) {
                    SqmCorrelation correlation = correlationBasis.createCorrelation();
                    pathRegistry.register(correlation);
                    QualifiedJoinPathConsumer dotIdentifierConsumer = new QualifiedJoinPathConsumer(correlation, SqmJoinType.INNER, false, alias, (SqmCreationState)this);
                    int lastIdx = size - 1;
                    for (int i = 2; i != lastIdx; i += 2) {
                        dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(i)).getText(), false, false);
                    }
                    dotIdentifierConsumer.consumeIdentifier(((ParseTree)entityNameParseTreeChildren.get(lastIdx)).getText(), false, true);
                    return correlation.getCorrelatedRoot();
                }
                throw new IllegalArgumentException("Could not resolve entity reference or correlation path: " + name);
            }
            throw new IllegalArgumentException("Could not resolve entity reference: " + name);
        }
        this.checkFQNEntityNameJpaComplianceViolationIfNeeded(name, entityDescriptor);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            if (this.getCreationOptions().useStrictJpaCompliance()) {
                throw new StrictJpaComplianceViolation("Encountered unmapped polymorphic reference [" + entityDescriptor.getHibernateEntityName() + "], but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.UNMAPPED_POLYMORPHISM);
            }
            if (this.processingStateStack.depth() > 1) {
                throw new SemanticException("Illegal implicit-polymorphic domain path in sub-query : " + entityDescriptor.getName());
            }
        }
        SqmRoot sqmRoot = new SqmRoot(entityDescriptor, alias, this.creationContext.getNodeBuilder());
        pathRegistry.register(sqmRoot);
        return sqmRoot;
    }

    @Override
    public String visitIdentificationVariableDef(HqlParser.IdentificationVariableDefContext ctx) {
        if (ctx == null) {
            return null;
        }
        if (ctx.AS() != null && ctx.identifier() != null) {
            Token identificationVariableToken;
            if (this.getCreationOptions().useStrictJpaCompliance() && (identificationVariableToken = ctx.identifier().getStart()).getType() != 205) {
                throw new StrictJpaComplianceViolation(String.format(Locale.ROOT, "Strict JPQL compliance was violated : %s [%s]", StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS.description(), identificationVariableToken.getText()), StrictJpaComplianceViolation.Type.RESERVED_WORD_USED_AS_ALIAS);
            }
            return ctx.identifier().getText();
        }
        if (ctx.IDENTIFIER() != null) {
            return ctx.IDENTIFIER().getText();
        }
        return null;
    }

    private String applyJpaCompliance(String text) {
        if (text == null) {
            return null;
        }
        if (this.getCreationOptions().useStrictJpaCompliance()) {
            return text.toLowerCase(Locale.getDefault());
        }
        return text;
    }

    @Override
    public final SqmCrossJoin visitCrossJoin(HqlParser.CrossJoinContext ctx) {
        throw new UnsupportedOperationException("Unexpected call to #visitCrossJoin, see #consumeCrossJoin");
    }

    private void consumeCrossJoin(HqlParser.CrossJoinContext parserJoin, SqmRoot sqmRoot) {
        String name = parserJoin.pathRoot().entityName().fullNameText;
        SqmTreeCreationLogger.LOGGER.debugf("Handling root path - %s", (Object)name);
        EntityDomainType entityDescriptor = this.getCreationContext().getJpaMetamodel().resolveHqlEntityReference(name);
        if (entityDescriptor instanceof SqmPolymorphicRootDescriptor) {
            throw new SemanticException("Unmapped polymorphic reference cannot be used as a CROSS JOIN target");
        }
        SqmCrossJoin join = new SqmCrossJoin(entityDescriptor, this.visitIdentificationVariableDef(parserJoin.pathRoot().identificationVariableDef()), sqmRoot);
        this.processingStateStack.getCurrent().getPathRegistry().register(join);
        sqmRoot.addSqmJoin(join);
    }

    @Override
    public final SqmQualifiedJoin visitQualifiedJoin(HqlParser.QualifiedJoinContext parserJoin) {
        throw new UnsupportedOperationException("Unexpected call to #visitQualifiedJoin, see #consumeQualifiedJoin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeQualifiedJoin(HqlParser.QualifiedJoinContext parserJoin, SqmRoot<?> sqmRoot) {
        block11: {
            HqlParser.JoinTypeQualifierContext joinTypeQualifier = parserJoin.joinTypeQualifier();
            if (joinTypeQualifier.FULL() != null) {
                throw new SemanticException("FULL OUTER joins are not yet supported : " + parserJoin.getText());
            }
            if (joinTypeQualifier.RIGHT() != null) {
                throw new SemanticException("RIGHT OUTER joins are not yet supported : " + parserJoin.getText());
            }
            SqmJoinType joinType = joinTypeQualifier.OUTER() != null || joinTypeQualifier.LEFT() != null ? SqmJoinType.LEFT : SqmJoinType.INNER;
            String alias = this.visitIdentificationVariableDef(parserJoin.qualifiedJoinRhs().identificationVariableDef());
            this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, joinType, parserJoin.FETCH() != null, alias, (SqmCreationState)this));
            try {
                SqmQualifiedJoin join = (SqmQualifiedJoin)parserJoin.qualifiedJoinRhs().path().accept(this);
                join.setExplicitAlias(alias);
                if (join instanceof SqmEntityJoin) {
                    sqmRoot.addSqmJoin(join);
                } else if (this.getCreationOptions().useStrictJpaCompliance() && join.getExplicitAlias() != null && ((SqmAttributeJoin)join).isFetched()) {
                    throw new StrictJpaComplianceViolation("Encountered aliased fetch join, but strict JPQL compliance was requested", StrictJpaComplianceViolation.Type.ALIASED_FETCH_JOIN);
                }
                if (parserJoin.qualifiedJoinPredicate() == null) break block11;
                this.dotIdentifierConsumerStack.push(new QualifiedJoinPredicatePathConsumer(join, (SqmCreationState)this));
                try {
                    join.setJoinPredicate((SqmPredicate)parserJoin.qualifiedJoinPredicate().predicate().accept(this));
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
    }

    @Override
    public SqmJoin visitJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx) {
        throw new UnsupportedOperationException();
    }

    protected void consumeJpaCollectionJoin(HqlParser.JpaCollectionJoinContext ctx, SqmRoot sqmRoot) {
        this.dotIdentifierConsumerStack.push(new QualifiedJoinPathConsumer(sqmRoot, SqmJoinType.LEFT, false, null, (SqmCreationState)this));
        try {
            this.consumePluralAttributeReference(ctx.path());
        }
        finally {
            this.dotIdentifierConsumerStack.pop();
        }
    }

    @Override
    public SqmPredicate visitWhereClause(HqlParser.WhereClauseContext ctx) {
        if (ctx == null || ctx.predicate() == null) {
            return null;
        }
        return (SqmPredicate)ctx.predicate().accept(this);
    }

    @Override
    public SqmGroupedPredicate visitGroupedPredicate(HqlParser.GroupedPredicateContext ctx) {
        return new SqmGroupedPredicate((SqmPredicate)ctx.predicate().accept(this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitAndPredicate(HqlParser.AndPredicateContext ctx) {
        return new SqmAndPredicate((SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitOrPredicate(HqlParser.OrPredicateContext ctx) {
        return new SqmOrPredicate((SqmPredicate)ctx.predicate(0).accept(this), (SqmPredicate)ctx.predicate(1).accept(this), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitNegatedPredicate(HqlParser.NegatedPredicateContext ctx) {
        SqmPredicate predicate = (SqmPredicate)ctx.predicate().accept(this);
        if (predicate instanceof SqmNegatablePredicate) {
            ((SqmNegatablePredicate)predicate).negate();
            return predicate;
        }
        return new SqmNegatedPredicate(predicate, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmBetweenPredicate visitBetweenPredicate(HqlParser.BetweenPredicateContext ctx) {
        return new SqmBetweenPredicate((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), (SqmExpression)ctx.expression(2).accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmNullnessPredicate visitIsNullPredicate(HqlParser.IsNullPredicateContext ctx) {
        return new SqmNullnessPredicate((SqmExpression)ctx.expression().accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmEmptinessPredicate visitIsEmptyPredicate(HqlParser.IsEmptyPredicateContext ctx) {
        return new SqmEmptinessPredicate((SqmPluralValuedSimplePath)ctx.expression().accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitComparisonOperator(HqlParser.ComparisonOperatorContext ctx) {
        if (ctx.EQUAL() != null) {
            return ComparisonOperator.EQUAL;
        }
        if (ctx.NOT_EQUAL() != null) {
            return ComparisonOperator.NOT_EQUAL;
        }
        if (ctx.LESS() != null) {
            return ComparisonOperator.LESS_THAN;
        }
        if (ctx.LESS_EQUAL() != null) {
            return ComparisonOperator.LESS_THAN_OR_EQUAL;
        }
        if (ctx.GREATER() != null) {
            return ComparisonOperator.GREATER_THAN;
        }
        if (ctx.GREATER_EQUAL() != null) {
            return ComparisonOperator.GREATER_THAN_OR_EQUAL;
        }
        throw new QueryException("missing operator");
    }

    @Override
    public SqmPredicate visitComparisonPredicate(HqlParser.ComparisonPredicateContext ctx) {
        SqmExpression left;
        SqmExpression right;
        ComparisonOperator comparisonOperator = (ComparisonOperator)((Object)ctx.comparisonOperator().accept(this));
        List<HqlParser.ExpressionContext> expressionContexts = ctx.expression();
        HqlParser.ExpressionContext leftExpressionContext = expressionContexts.get(0);
        HqlParser.ExpressionContext rightExpressionContext = expressionContexts.get(1);
        switch (comparisonOperator) {
            case EQUAL: 
            case NOT_EQUAL: {
                Map<Class<?>, Enum<?>> possibleEnumValues = this.getPossibleEnumValues(leftExpressionContext);
                if (possibleEnumValues != null) {
                    right = (SqmExpression)rightExpressionContext.accept(this);
                    left = this.resolveEnumShorthandLiteral(leftExpressionContext, possibleEnumValues, right.getJavaType());
                    break;
                }
                possibleEnumValues = this.getPossibleEnumValues(rightExpressionContext);
                if (possibleEnumValues != null) {
                    left = (SqmExpression)leftExpressionContext.accept(this);
                    right = this.resolveEnumShorthandLiteral(rightExpressionContext, possibleEnumValues, left.getJavaType());
                    break;
                }
                left = (SqmExpression)leftExpressionContext.accept(this);
                right = (SqmExpression)rightExpressionContext.accept(this);
                if (left instanceof SqmLiteralNull) {
                    return new SqmNullnessPredicate(right, comparisonOperator == ComparisonOperator.NOT_EQUAL, this.creationContext.getNodeBuilder());
                }
                if (!(right instanceof SqmLiteralNull)) break;
                return new SqmNullnessPredicate(left, comparisonOperator == ComparisonOperator.NOT_EQUAL, this.creationContext.getNodeBuilder());
            }
            default: {
                left = (SqmExpression)leftExpressionContext.accept(this);
                right = (SqmExpression)rightExpressionContext.accept(this);
            }
        }
        return new SqmComparisonPredicate(left, comparisonOperator, right, this.creationContext.getNodeBuilder());
    }

    private SqmExpression resolveEnumShorthandLiteral(HqlParser.ExpressionContext expressionContext, Map<Class<?>, Enum<?>> possibleEnumValues, Class<?> enumType) {
        Enum<?> enumValue;
        if (possibleEnumValues != null && (enumValue = possibleEnumValues.get(enumType)) != null) {
            DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
            dotIdentifierConsumer.consumeIdentifier(enumValue.getClass().getCanonicalName(), true, false);
            dotIdentifierConsumer.consumeIdentifier(enumValue.name(), false, true);
            return (SqmExpression)((Object)this.dotIdentifierConsumerStack.getCurrent().getConsumedPart());
        }
        return (SqmExpression)expressionContext.accept(this);
    }

    private Map<Class<?>, Enum<?>> getPossibleEnumValues(HqlParser.ExpressionContext expressionContext) {
        ParseTree ctx;
        if (expressionContext instanceof HqlParser.CollateExpressionContext && expressionContext.getChildCount() == 1 && (ctx = expressionContext.getChild(0)) instanceof HqlParser.PrimaryExpressionContext && ctx.getChildCount() == 1 && (ctx = expressionContext.getChild(0)) instanceof HqlParser.PathContext && ctx.getChildCount() == 1 && (ctx = ctx.getChild(0)) instanceof HqlParser.GeneralPathFragmentContext && ctx.getChildCount() == 1 && (ctx = ctx.getChild(0)) instanceof HqlParser.DotIdentifierSequenceContext && (ctx.getChildCount() == 1 || ctx.getChildCount() == 2 && ctx.getChild(1) instanceof HqlParser.DotIdentifierSequenceContinuationContext) && ctx.getChild(0) instanceof HqlParser.IdentifierContext) {
            return this.creationContext.getJpaMetamodel().getAllowedEnumLiteralTexts().get(ctx.getText());
        }
        return null;
    }

    @Override
    public SqmPredicate visitLikePredicate(HqlParser.LikePredicateContext ctx) {
        List<HqlParser.ExpressionContext> expressionContexts = ctx.expression();
        if (ctx.likeEscape() != null) {
            return new SqmLikePredicate((SqmExpression)expressionContexts.get(0).accept(this), (SqmExpression)expressionContexts.get(1).accept(this), (SqmExpression)ctx.likeEscape().expression().accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
        }
        return new SqmLikePredicate((SqmExpression)expressionContexts.get(0).accept(this), (SqmExpression)expressionContexts.get(1).accept(this), ctx.NOT() != null, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPredicate visitMemberOfPredicate(HqlParser.MemberOfPredicateContext ctx) {
        SqmPath sqmPluralPath = this.consumeDomainPath(ctx.path());
        if (sqmPluralPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return new SqmMemberOfPredicate((SqmExpression)ctx.expression().accept(this), sqmPluralPath, ctx.NOT() != null, this.creationContext.getNodeBuilder());
        }
        throw new SemanticException("Path argument to MEMBER OF must be a plural attribute");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPredicate visitInPredicate(HqlParser.InPredicateContext ctx) {
        SqmExpression testExpression = (SqmExpression)ctx.expression().accept(this);
        HqlParser.InListContext inListContext = ctx.inList();
        if (inListContext instanceof HqlParser.ExplicitTupleInListContext) {
            HqlParser.ExplicitTupleInListContext tupleExpressionListContext = (HqlParser.ExplicitTupleInListContext)inListContext;
            List<HqlParser.ExpressionContext> expressionContexts = tupleExpressionListContext.expression();
            boolean isEnum = testExpression.getJavaType().isEnum();
            this.parameterDeclarationContextStack.push(() -> expressionContexts.size() == 1);
            try {
                ArrayList listExpressions = new ArrayList(expressionContexts.size());
                for (HqlParser.ExpressionContext expressionContext : expressionContexts) {
                    Map<Class<?>, Enum<?>> possibleEnumValues;
                    if (isEnum && (possibleEnumValues = this.getPossibleEnumValues(expressionContext)) != null) {
                        listExpressions.add(this.resolveEnumShorthandLiteral(expressionContext, possibleEnumValues, testExpression.getJavaType()));
                        continue;
                    }
                    listExpressions.add((SqmExpression)expressionContext.accept(this));
                }
                SqmInListPredicate sqmInListPredicate = new SqmInListPredicate(testExpression, listExpressions, ctx.NOT() != null, this.creationContext.getNodeBuilder());
                return sqmInListPredicate;
            }
            finally {
                this.parameterDeclarationContextStack.pop();
            }
        }
        if (inListContext instanceof HqlParser.SubQueryOrParamInListContext) {
            HqlParser.SubQueryOrParamInListContext subQueryOrParamInListContext = (HqlParser.SubQueryOrParamInListContext)inListContext;
            SqmExpression sqmExpression = (SqmExpression)subQueryOrParamInListContext.expression().accept(this);
            if (!(sqmExpression instanceof SqmSubQuery)) {
                if (sqmExpression instanceof SqmParameter) {
                    ArrayList listExpressions = new ArrayList(1);
                    listExpressions.add(sqmExpression);
                    return new SqmInListPredicate(testExpression, listExpressions, ctx.NOT() != null, this.creationContext.getNodeBuilder());
                }
                throw new ParsingException("Was expecting a SubQueryExpression or a SqmParameter, but found " + sqmExpression.getClass().getSimpleName() + " : " + subQueryOrParamInListContext.expression().toString());
            }
            return new SqmInSubQueryPredicate(testExpression, (SqmSubQuery)sqmExpression, ctx.NOT() != null, this.creationContext.getNodeBuilder());
        }
        throw new ParsingException("Unexpected IN predicate type [" + ((Object)((Object)ctx)).getClass().getSimpleName() + "] : " + ctx.getText());
    }

    @Override
    public SqmPredicate visitExistsPredicate(HqlParser.ExistsPredicateContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        return new SqmExistsPredicate(expression, this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitEntityTypeExpression(HqlParser.EntityTypeExpressionContext ctx) {
        HqlParser.ParameterContext parameterContext = ctx.entityTypeReference().parameter();
        HqlParser.PathContext pathContext = ctx.entityTypeReference().path();
        if (parameterContext != null) {
            return new SqmParameterizedEntityType((SqmParameter)parameterContext.accept(this), this.creationContext.getNodeBuilder());
        }
        if (pathContext != null) {
            return new SqmPathEntityType((SqmPath)pathContext.accept(this), this.creationContext.getNodeBuilder());
        }
        throw new ParsingException("Could not interpret grammar context as 'entity type' expression : " + ctx.getText());
    }

    @Override
    public SqmExpression<?> visitEntityIdExpression(HqlParser.EntityIdExpressionContext ctx) {
        return this.visitEntityIdReference(ctx.entityIdReference());
    }

    @Override
    public SqmPath visitEntityIdReference(HqlParser.EntityIdReferenceContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath(ctx.path());
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            SqmPath idPath = ((IdentifiableDomainType)sqmPathType).getIdentifierDescriptor().createSqmPath(sqmPath, this);
            if (ctx.pathContinuation() == null) {
                return idPath;
            }
            throw new NotYetImplementedFor6Exception("Path continuation from `id()` reference not yet implemented");
        }
        throw new SemanticException("Path does not reference an identifiable-type : " + sqmPath.getNavigablePath().getFullPath());
    }

    @Override
    public SqmExpression<?> visitEntityVersionExpression(HqlParser.EntityVersionExpressionContext ctx) {
        return this.visitEntityVersionReference(ctx.entityVersionReference());
    }

    @Override
    public SqmPath visitEntityVersionReference(HqlParser.EntityVersionReferenceContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath(ctx.path());
        DomainType<?> sqmPathType = sqmPath.getReferencedPathSource().getSqmPathType();
        if (sqmPathType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableType = (IdentifiableDomainType)sqmPathType;
            SingularPersistentAttribute versionAttribute = identifiableType.findVersionAttribute();
            if (versionAttribute == null) {
                throw new SemanticException("`" + sqmPath.getNavigablePath().getFullPath() + "` resolved to an identifiable-type (`" + identifiableType.getTypeName() + "`) which does not define a version");
            }
            return versionAttribute.createSqmPath(sqmPath, this);
        }
        throw new SemanticException("Path does not reference an identifiable-type : " + sqmPath.getNavigablePath().getFullPath());
    }

    @Override
    public SqmPath visitEntityNaturalIdExpression(HqlParser.EntityNaturalIdExpressionContext ctx) {
        return this.visitEntityNaturalIdReference(ctx.entityNaturalIdReference());
    }

    @Override
    public SqmPath visitEntityNaturalIdReference(HqlParser.EntityNaturalIdReferenceContext ctx) {
        throw new NotYetImplementedFor6Exception("Support for HQL natural-id references not yet implemented");
    }

    @Override
    public SqmMapEntryReference visitMapEntrySelection(HqlParser.MapEntrySelectionContext ctx) {
        return new SqmMapEntryReference(this.consumePluralAttributeReference(ctx.path()), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression visitConcatenationExpression(HqlParser.ConcatenationExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the concat operator");
        }
        return this.getFunctionDescriptor("concat").generateSqmExpression(Arrays.asList((SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this)), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitSignOperator(HqlParser.SignOperatorContext ctx) {
        if (ctx.PLUS() != null) {
            return UnaryArithmeticOperator.UNARY_PLUS;
        }
        if (ctx.MINUS() != null) {
            return UnaryArithmeticOperator.UNARY_MINUS;
        }
        throw new QueryException("missing operator");
    }

    @Override
    public Object visitAdditiveOperator(HqlParser.AdditiveOperatorContext ctx) {
        if (ctx.PLUS() != null) {
            return BinaryArithmeticOperator.ADD;
        }
        if (ctx.MINUS() != null) {
            return BinaryArithmeticOperator.SUBTRACT;
        }
        throw new QueryException("missing operator");
    }

    @Override
    public Object visitMultiplicativeOperator(HqlParser.MultiplicativeOperatorContext ctx) {
        if (ctx.ASTERISK() != null) {
            return BinaryArithmeticOperator.MULTIPLY;
        }
        if (ctx.SLASH() != null) {
            return BinaryArithmeticOperator.DIVIDE;
        }
        if (ctx.PERCENT_OP() != null) {
            return BinaryArithmeticOperator.MODULO;
        }
        throw new QueryException("missing operator");
    }

    @Override
    public Object visitAdditionExpression(HqlParser.AdditionExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the additive operator");
        }
        return new SqmBinaryArithmetic((BinaryArithmeticOperator)((Object)ctx.additiveOperator().accept(this)), (SqmExpression)ctx.expression(0).accept(this), (SqmExpression)ctx.expression(1).accept(this), this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitMultiplicationExpression(HqlParser.MultiplicationExpressionContext ctx) {
        if (ctx.expression().size() != 2) {
            throw new ParsingException("Expecting 2 operands to the multiplicative operator");
        }
        SqmExpression left = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression right = (SqmExpression)ctx.expression(1).accept(this);
        BinaryArithmeticOperator operator = (BinaryArithmeticOperator)((Object)ctx.multiplicativeOperator().accept(this));
        if (operator == BinaryArithmeticOperator.MODULO) {
            return this.getFunctionDescriptor("mod").generateSqmExpression(Arrays.asList(left, right), (AllowableFunctionReturnType)left.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
        }
        return new SqmBinaryArithmetic(operator, left, right, this.creationContext.getJpaMetamodel(), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitToDurationExpression(HqlParser.ToDurationExpressionContext ctx) {
        return new SqmToDuration<Duration>((SqmExpression)ctx.expression().accept(this), this.toDurationUnit((SqmExtractUnit)ctx.datetimeField().accept(this)), this.resolveExpressableTypeBasic(Duration.class), this.creationContext.getNodeBuilder());
    }

    private SqmDurationUnit<Long> toDurationUnit(SqmExtractUnit<?> extractUnit) {
        return new SqmDurationUnit<Long>(extractUnit.getUnit(), this.resolveExpressableTypeBasic(Long.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitFromDurationExpression(HqlParser.FromDurationExpressionContext ctx) {
        return new SqmByUnit(this.toDurationUnit((SqmExtractUnit)ctx.datetimeField().accept(this)), (SqmExpression)ctx.expression().accept(this), this.resolveExpressableTypeBasic(Long.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmUnaryOperation<?> visitUnaryExpression(HqlParser.UnaryExpressionContext ctx) {
        return new SqmUnaryOperation((UnaryArithmeticOperator)((Object)ctx.signOperator().accept(this)), (SqmExpression)ctx.expression().accept(this));
    }

    @Override
    public Object visitGroupedExpression(HqlParser.GroupedExpressionContext ctx) {
        return ctx.expression().accept(this);
    }

    @Override
    public Object visitCollateExpression(HqlParser.CollateExpressionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.primaryExpression().accept(this);
        HqlParser.CollationSpecificationContext collationSpecificationContext = ctx.collationSpecification();
        if (collationSpecificationContext == null) {
            return expression;
        }
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.COLLATIONS);
        }
        return new SqmCollate(expression, collationSpecificationContext.collateName().getText());
    }

    @Override
    public Object visitTupleExpression(HqlParser.TupleExpressionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.TUPLES);
        }
        List<SqmExpression<?>> expressions = this.visitExpressions(ctx.expression());
        return new SqmTuple(expressions, this.creationContext.getNodeBuilder());
    }

    private List<SqmExpression<?>> visitExpressions(List<? extends ParserRuleContext> expressionContexts) {
        int size = expressionContexts.size();
        ArrayList expressions = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            expressions.add((SqmExpression)expressionContexts.get(i).accept((ParseTreeVisitor)this));
        }
        return expressions;
    }

    @Override
    public Object visitCaseExpression(HqlParser.CaseExpressionContext ctx) {
        return ctx.caseList().accept(this);
    }

    @Override
    public SqmCaseSimple visitSimpleCaseList(HqlParser.SimpleCaseListContext ctx) {
        SqmCaseSimple caseExpression = new SqmCaseSimple((SqmExpression)ctx.expression().accept(this), this.creationContext.getNodeBuilder());
        for (HqlParser.SimpleCaseWhenContext simpleCaseWhen : ctx.simpleCaseWhen()) {
            caseExpression.when((SqmExpression)simpleCaseWhen.expression(0).accept(this), (SqmExpression)simpleCaseWhen.expression(1).accept(this));
        }
        if (ctx.caseOtherwise() != null) {
            caseExpression.otherwise((SqmExpression)ctx.caseOtherwise().expression().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmCaseSearched visitSearchedCaseList(HqlParser.SearchedCaseListContext ctx) {
        SqmCaseSearched caseExpression = new SqmCaseSearched(this.creationContext.getNodeBuilder());
        for (HqlParser.SearchedCaseWhenContext whenFragment : ctx.searchedCaseWhen()) {
            caseExpression.when((SqmPredicate)whenFragment.predicate().accept(this), (SqmExpression)whenFragment.expression().accept(this));
        }
        if (ctx.caseOtherwise() != null) {
            caseExpression.otherwise((SqmExpression)ctx.caseOtherwise().expression().accept(this));
        }
        return caseExpression;
    }

    @Override
    public SqmExpression visitCurrentDateFunction(HqlParser.CurrentDateFunctionContext ctx) {
        return this.getFunctionDescriptor("current_date").generateSqmExpression(this.resolveExpressableTypeBasic(Date.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitCurrentTimeFunction(HqlParser.CurrentTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("current_time").generateSqmExpression(this.resolveExpressableTypeBasic(Time.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitCurrentTimestampFunction(HqlParser.CurrentTimestampFunctionContext ctx) {
        return this.getFunctionDescriptor("current_timestamp").generateSqmExpression(this.resolveExpressableTypeBasic(Timestamp.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitInstantFunction(HqlParser.InstantFunctionContext ctx) {
        return this.getFunctionDescriptor("instant").generateSqmExpression(this.resolveExpressableTypeBasic(Instant.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitLocalDateFunction(HqlParser.LocalDateFunctionContext ctx) {
        return this.getFunctionDescriptor("local_date").generateSqmExpression(this.resolveExpressableTypeBasic(LocalDate.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitLocalTimeFunction(HqlParser.LocalTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_time").generateSqmExpression(this.resolveExpressableTypeBasic(LocalTime.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitLocalDateTimeFunction(HqlParser.LocalDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("local_datetime").generateSqmExpression(this.resolveExpressableTypeBasic(LocalDateTime.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitOffsetDateTimeFunction(HqlParser.OffsetDateTimeFunctionContext ctx) {
        return this.getFunctionDescriptor("offset_datetime").generateSqmExpression(this.resolveExpressableTypeBasic(OffsetDateTime.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitLeastFunction(HqlParser.LeastFunctionContext ctx) {
        ArrayList arguments = new ArrayList();
        SqmExpressable type = null;
        for (HqlParser.ExpressionContext argument : ctx.expression()) {
            SqmTypedNode arg = (SqmTypedNode)argument.accept(this);
            arguments.add(arg);
            type = arg.getNodeType();
        }
        return this.getFunctionDescriptor("least").generateSqmExpression(arguments, (AllowableFunctionReturnType)type, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitGreatestFunction(HqlParser.GreatestFunctionContext ctx) {
        ArrayList arguments = new ArrayList();
        SqmExpressable type = null;
        for (HqlParser.ExpressionContext argument : ctx.expression()) {
            SqmTypedNode arg = (SqmTypedNode)argument.accept(this);
            arguments.add(arg);
            type = arg.getNodeType();
        }
        return this.getFunctionDescriptor("greatest").generateSqmExpression(arguments, (AllowableFunctionReturnType)type, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitCoalesceFunction(HqlParser.CoalesceFunctionContext ctx) {
        ArrayList arguments = new ArrayList();
        SqmExpressable type = null;
        for (HqlParser.ExpressionContext argument : ctx.expression()) {
            SqmTypedNode arg = (SqmTypedNode)argument.accept(this);
            arguments.add(arg);
            type = arg.getNodeType();
        }
        return this.getFunctionDescriptor("coalesce").generateSqmExpression(arguments, (AllowableFunctionReturnType)type, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitNullifFunction(HqlParser.NullifFunctionContext ctx) {
        SqmExpression arg1 = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression arg2 = (SqmExpression)ctx.expression(1).accept(this);
        return this.getFunctionDescriptor("nullif").generateSqmExpression(Arrays.asList(arg1, arg2), (AllowableFunctionReturnType)arg1.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitIfnullFunction(HqlParser.IfnullFunctionContext ctx) {
        SqmExpression arg1 = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression arg2 = (SqmExpression)ctx.expression(1).accept(this);
        return this.getFunctionDescriptor("ifnull").generateSqmExpression(Arrays.asList(arg1, arg2), (AllowableFunctionReturnType)arg1.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLiteralExpression(HqlParser.LiteralExpressionContext ctx) {
        return (SqmExpression)ctx.literal().accept(this);
    }

    @Override
    public Object visitBinaryLiteral(HqlParser.BinaryLiteralContext ctx) {
        TerminalNode binaryLiteral = ctx.BINARY_LITERAL();
        if (binaryLiteral != null) {
            return this.binaryLiteral(binaryLiteral.getText());
        }
        StringBuilder text = new StringBuilder("x'");
        for (TerminalNode hex : ctx.HEX_LITERAL()) {
            String hexText = hex.getText();
            if (hexText.length() != 4) {
                throw new LiteralNumberFormatException("not a byte: " + hexText);
            }
            text.append(hexText.substring(2));
        }
        return this.binaryLiteral(text.append("'").toString());
    }

    @Override
    public Object visitGeneralizedLiteral(HqlParser.GeneralizedLiteralContext ctx) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    public SqmExpression<?> visitTerminal(TerminalNode node) {
        if (node.getSymbol().getType() == -1) {
            return null;
        }
        switch (node.getSymbol().getType()) {
            case 10: {
                return this.stringLiteral(node.getText());
            }
            case 3: {
                return this.integerLiteral(node.getText());
            }
            case 4: {
                return this.longLiteral(node.getText());
            }
            case 7: {
                return this.bigIntegerLiteral(node.getText());
            }
            case 9: {
                return this.hexLiteral(node.getText());
            }
            case 5: {
                return this.floatLiteral(node.getText());
            }
            case 6: {
                return this.doubleLiteral(node.getText());
            }
            case 8: {
                return this.bigDecimalLiteral(node.getText());
            }
            case 203: {
                return this.booleanLiteral(false);
            }
            case 202: {
                return this.booleanLiteral(true);
            }
            case 204: {
                return new SqmLiteralNull(this.creationContext.getQueryEngine().getCriteriaBuilder());
            }
            case 11: {
                return this.binaryLiteral(node.getText());
            }
        }
        throw new ParsingException("Unexpected terminal node [" + node.getText() + "]");
    }

    @Override
    public Object visitDateTimeLiteral(HqlParser.DateTimeLiteralContext dateTimeLiteralContext) {
        HqlParser.DateTimeContext dateTimeContext = dateTimeLiteralContext.dateTime();
        if (dateTimeContext.offset() == null) {
            return this.dateTimeLiteralFrom(dateTimeContext.date(), dateTimeContext.time(), dateTimeContext.zoneId());
        }
        return this.offsetDatetimeLiteralFrom(dateTimeContext.date(), dateTimeContext.time(), dateTimeContext.offset());
    }

    @Override
    public Object visitDateLiteral(HqlParser.DateLiteralContext ctx) {
        return ctx.date().accept(this);
    }

    @Override
    public Object visitTimeLiteral(HqlParser.TimeLiteralContext ctx) {
        return ctx.time().accept(this);
    }

    @Override
    public Object visitJdbcTimestampLiteral(HqlParser.JdbcTimestampLiteralContext ctx) {
        HqlParser.GenericTemporalLiteralTextContext genericTemporalLiteralTextContext = ctx.genericTemporalLiteralText();
        if (genericTemporalLiteralTextContext == null) {
            return ctx.dateTime().accept(this);
        }
        return this.sqlTimestampLiteralFrom(genericTemporalLiteralTextContext.getText());
    }

    @Override
    public Object visitJdbcDateLiteral(HqlParser.JdbcDateLiteralContext ctx) {
        HqlParser.GenericTemporalLiteralTextContext genericTemporalLiteralTextContext = ctx.genericTemporalLiteralText();
        if (genericTemporalLiteralTextContext == null) {
            return ctx.date().accept(this);
        }
        return this.sqlDateLiteralFrom(genericTemporalLiteralTextContext.getText());
    }

    @Override
    public Object visitJdbcTimeLiteral(HqlParser.JdbcTimeLiteralContext ctx) {
        HqlParser.GenericTemporalLiteralTextContext genericTemporalLiteralTextContext = ctx.genericTemporalLiteralText();
        if (genericTemporalLiteralTextContext == null) {
            return ctx.time().accept(this);
        }
        return this.sqlTimeLiteralFrom(genericTemporalLiteralTextContext.getText());
    }

    @Override
    public Object visitDateTime(HqlParser.DateTimeContext ctx) {
        return this.dateTimeLiteralFrom(ctx.date(), ctx.time(), ctx.zoneId());
    }

    private SqmLiteral<?> dateTimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.ZoneIdContext timezone) {
        if (timezone == null) {
            return new SqmLiteral<LocalDateTime>(LocalDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time)), this.resolveExpressableTypeBasic(LocalDateTime.class), this.creationContext.getNodeBuilder());
        }
        ZoneId zoneId = this.visitZoneId(timezone);
        return new SqmLiteral<ZonedDateTime>(ZonedDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), zoneId), this.resolveExpressableTypeBasic(ZonedDateTime.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public ZoneId visitZoneId(HqlParser.ZoneIdContext ctx) {
        String timezoneText = ctx.getText();
        String timezoneFullName = ZoneId.SHORT_IDS.get(timezoneText);
        if (timezoneFullName == null) {
            return ZoneId.of(timezoneText);
        }
        return ZoneId.of(timezoneFullName);
    }

    private SqmLiteral<?> offsetDatetimeLiteralFrom(HqlParser.DateContext date, HqlParser.TimeContext time, HqlParser.OffsetContext offset) {
        return new SqmLiteral<OffsetDateTime>(OffsetDateTime.of(SemanticQueryBuilder.localDate(date), SemanticQueryBuilder.localTime(time), SemanticQueryBuilder.zoneOffset(offset)), this.resolveExpressableTypeBasic(OffsetDateTime.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitDate(HqlParser.DateContext ctx) {
        return new SqmLiteral<LocalDate>(SemanticQueryBuilder.localDate(ctx), this.resolveExpressableTypeBasic(LocalDate.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public Object visitTime(HqlParser.TimeContext ctx) {
        return new SqmLiteral<LocalTime>(SemanticQueryBuilder.localTime(ctx), this.resolveExpressableTypeBasic(LocalTime.class), this.creationContext.getNodeBuilder());
    }

    private static LocalTime localTime(HqlParser.TimeContext ctx) {
        HqlParser.SecondContext second = ctx.second();
        if (second != null) {
            String secondText = second.getText();
            int index = secondText.indexOf(46);
            if (index < 0) {
                return LocalTime.of(Integer.parseInt(ctx.hour().getText()), Integer.parseInt(ctx.minute().getText()), Integer.parseInt(secondText));
            }
            return LocalTime.of(Integer.parseInt(ctx.hour().getText()), Integer.parseInt(ctx.minute().getText()), Integer.parseInt(secondText.substring(0, index)), Integer.parseInt(secondText.substring(index + 1)));
        }
        return LocalTime.of(Integer.parseInt(ctx.hour().getText()), Integer.parseInt(ctx.minute().getText()));
    }

    private static LocalDate localDate(HqlParser.DateContext ctx) {
        return LocalDate.of(Integer.parseInt(ctx.year().getText()), Integer.parseInt(ctx.month().getText()), Integer.parseInt(ctx.day().getText()));
    }

    private static ZoneOffset zoneOffset(HqlParser.OffsetContext offset) {
        HqlParser.MinuteContext minute = offset.minute();
        return minute == null ? ZoneOffset.ofHours(Integer.parseInt(offset.hour().getText())) : ZoneOffset.ofHoursMinutes(Integer.parseInt(offset.hour().getText()), Integer.parseInt(minute.getText()));
    }

    private SqmLiteral<?> sqlTimestampLiteralFrom(String literalText) {
        TemporalAccessor parsed = DateTimeUtils.DATE_TIME.parse(literalText);
        try {
            ZonedDateTime zonedDateTime = ZonedDateTime.from(parsed);
            GregorianCalendar literal = GregorianCalendar.from(zonedDateTime);
            return new SqmLiteral<Calendar>(literal, this.resolveExpressableTypeBasic(Calendar.class), this.creationContext.getNodeBuilder());
        }
        catch (DateTimeException dte) {
            LocalDateTime localDateTime = LocalDateTime.from(parsed);
            Timestamp literal = Timestamp.valueOf(localDateTime);
            return new SqmLiteral<Timestamp>(literal, this.resolveExpressableTypeBasic(Timestamp.class), this.creationContext.getNodeBuilder());
        }
    }

    private SqmLiteral<Date> sqlDateLiteralFrom(String literalText) {
        LocalDate localDate = LocalDate.from(DateTimeFormatter.ISO_LOCAL_DATE.parse(literalText));
        Date literal = Date.valueOf(localDate);
        return new SqmLiteral<Date>(literal, this.resolveExpressableTypeBasic(Date.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<Time> sqlTimeLiteralFrom(String literalText) {
        LocalTime localTime = LocalTime.from(DateTimeFormatter.ISO_LOCAL_TIME.parse(literalText));
        Time literal = Time.valueOf(localTime);
        return new SqmLiteral<Time>(literal, this.resolveExpressableTypeBasic(Time.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<Boolean> booleanLiteral(boolean value) {
        return new SqmLiteral<Boolean>(value, this.resolveExpressableTypeBasic(Boolean.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<String> stringLiteral(String text) {
        return new SqmLiteral<String>(text, this.resolveExpressableTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<byte[]> binaryLiteral(String text) {
        return new SqmLiteral<byte[]>((byte[])StandardBasicTypes.BINARY.fromStringValue(text.substring(2, text.length() - 1)), (SqmExpressable<byte[]>)this.resolveExpressableTypeBasic(byte[].class), this.creationContext.getNodeBuilder());
    }

    private SqmLiteral<Integer> integerLiteral(String text) {
        try {
            Integer value = Integer.valueOf(text);
            return new SqmLiteral<Integer>(value, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Integer", e);
        }
    }

    private SqmLiteral<Long> longLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("l") || text.endsWith("L")) {
                text = text.substring(0, text.length() - 1);
            }
            Long value = Long.valueOf(text);
            return new SqmLiteral<Long>(value, this.resolveExpressableTypeBasic(Long.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to Long", e);
        }
    }

    private SqmLiteral<? extends Number> hexLiteral(String text) {
        String originalText = text;
        text = text.substring(2);
        try {
            BasicDomainType<Number> type;
            Number value;
            if (text.endsWith("l") || text.endsWith("L")) {
                text = text.substring(0, text.length() - 1);
                value = Long.parseUnsignedLong(text, 16);
                type = this.resolveExpressableTypeBasic(Long.class);
            } else {
                value = Integer.parseUnsignedInt(text, 16);
                type = this.resolveExpressableTypeBasic(Integer.class);
            }
            return new SqmLiteral<Integer>((Integer)value, (SqmExpressable<Integer>)type, this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "]", e);
        }
    }

    private SqmLiteral<BigInteger> bigIntegerLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bi") || text.endsWith("BI")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigInteger>(new BigInteger(text), this.resolveExpressableTypeBasic(BigInteger.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigInteger", e);
        }
    }

    private SqmLiteral<Float> floatLiteral(String text) {
        try {
            return new SqmLiteral<Float>(Float.valueOf(text), this.resolveExpressableTypeBasic(Float.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Float", e);
        }
    }

    private SqmLiteral<Double> doubleLiteral(String text) {
        try {
            return new SqmLiteral<Double>(Double.valueOf(text), this.resolveExpressableTypeBasic(Double.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + text + "] to Double", e);
        }
    }

    private SqmLiteral<BigDecimal> bigDecimalLiteral(String text) {
        String originalText = text;
        try {
            if (text.endsWith("bd") || text.endsWith("BD")) {
                text = text.substring(0, text.length() - 2);
            }
            return new SqmLiteral<BigDecimal>(new BigDecimal(text), this.resolveExpressableTypeBasic(BigDecimal.class), this.creationContext.getNodeBuilder());
        }
        catch (NumberFormatException e) {
            throw new LiteralNumberFormatException("Unable to convert sqm literal [" + originalText + "] to BigDecimal", e);
        }
    }

    private <J> BasicDomainType<J> resolveExpressableTypeBasic(Class<J> javaType) {
        return this.creationContext.getJpaMetamodel().getTypeConfiguration().standardBasicTypeForJavaType(javaType);
    }

    @Override
    public Object visitParameterExpression(HqlParser.ParameterExpressionContext ctx) {
        return ctx.parameter().accept(this);
    }

    @Override
    public SqmNamedParameter<?> visitNamedParameter(HqlParser.NamedParameterContext ctx) {
        SqmNamedParameter param = new SqmNamedParameter(ctx.identifier().getText(), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), this.creationContext.getNodeBuilder());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmPositionalParameter<?> visitPositionalParameter(HqlParser.PositionalParameterContext ctx) {
        if (ctx.INTEGER_LITERAL() == null) {
            throw new SemanticException("Encountered positional parameter which did not declare position (? instead of, e.g., ?1)");
        }
        SqmPositionalParameter param = new SqmPositionalParameter(Integer.parseInt(ctx.INTEGER_LITERAL().getText()), this.parameterDeclarationContextStack.getCurrent().isMultiValuedBindingAllowed(), this.creationContext.getNodeBuilder());
        this.parameterCollector.addParameter(param);
        return param;
    }

    @Override
    public SqmExpression<?> visitJpaNonStandardFunction(HqlParser.JpaNonStandardFunctionContext ctx) {
        String functionName = ctx.jpaNonStandardFunctionName().STRING_LITERAL().getText().toLowerCase();
        List functionArguments = ctx.nonStandardFunctionArguments() == null ? Collections.emptyList() : (List)ctx.nonStandardFunctionArguments().accept(this);
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(StandardBasicTypes.OBJECT_TYPE));
        }
        return functionTemplate.generateSqmExpression(functionArguments, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitNonStandardFunction(HqlParser.NonStandardFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation("Encountered non-compliant non-standard function call [" + (Object)((Object)ctx.nonStandardFunctionName()) + "], but strict JPQL compliance was requested; use JPA's FUNCTION(functionName[,...]) syntax name instead", StrictJpaComplianceViolation.Type.FUNCTION_CALL);
        }
        String functionName = ctx.nonStandardFunctionName().getText().toLowerCase();
        List functionArguments = ctx.nonStandardFunctionArguments() == null ? Collections.emptyList() : (List)ctx.nonStandardFunctionArguments().accept(this);
        SqmFunctionDescriptor functionTemplate = this.getFunctionDescriptor(functionName);
        if (functionTemplate == null) {
            functionTemplate = new NamedSqmFunctionDescriptor(functionName, true, null, StandardFunctionReturnTypeResolvers.invariant(StandardBasicTypes.OBJECT_TYPE));
        }
        return functionTemplate.generateSqmExpression(functionArguments, null, this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public List<SqmTypedNode<?>> visitNonStandardFunctionArguments(HqlParser.NonStandardFunctionArgumentsContext ctx) {
        ArrayList arguments = new ArrayList();
        if (ctx.datetimeField() != null) {
            arguments.add(this.toDurationUnit((SqmExtractUnit)ctx.datetimeField().accept(this)));
        }
        int size = ctx.expression().size();
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                arguments.add(this.visitFinalFunctionArgument(ctx.expression(i)));
                continue;
            }
            arguments.add((SqmTypedNode)ctx.expression(i).accept(this));
        }
        return arguments;
    }

    private SqmExpression<?> visitFinalFunctionArgument(HqlParser.ExpressionContext expression) {
        this.parameterDeclarationContextStack.push(this.creationOptions::useStrictJpaCompliance);
        try {
            SqmExpression sqmExpression = (SqmExpression)expression.accept(this);
            return sqmExpression;
        }
        finally {
            this.parameterDeclarationContextStack.pop();
        }
    }

    @Override
    public SqmExpression<?> visitCeilingFunction(HqlParser.CeilingFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("ceiling").generateSqmExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitFloorFunction(HqlParser.FloorFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("floor").generateSqmExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    private SqmFunctionDescriptor getFunctionDescriptor(String name) {
        return this.creationContext.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor(name);
    }

    @Override
    public SqmExpression<?> visitAbsFunction(HqlParser.AbsFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("abs").generateSqmExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitSignFunction(HqlParser.SignFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("sign").generateSqmExpression(arg, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitModFunction(HqlParser.ModFunctionContext ctx) {
        SqmExpression dividend = (SqmExpression)ctx.modDividendArgument().accept(this);
        SqmExpression divisor = (SqmExpression)ctx.modDivisorArgument().accept(this);
        return this.getFunctionDescriptor("mod").generateSqmExpression(Arrays.asList(dividend, divisor), (AllowableFunctionReturnType)dividend.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitPowerFunction(HqlParser.PowerFunctionContext ctx) {
        SqmExpression base = (SqmExpression)ctx.powerBaseArgument().accept(this);
        SqmExpression power = (SqmExpression)ctx.powerPowerArgument().accept(this);
        return this.getFunctionDescriptor("power").generateSqmExpression(Arrays.asList(base, power), (AllowableFunctionReturnType)base.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitTrigFunction(HqlParser.TrigFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor(ctx.trigFunctionName().getText()).generateSqmExpression(arg, this.resolveExpressableTypeBasic(Double.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitSqrtFunction(HqlParser.SqrtFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("sqrt").generateSqmExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitRoundFunction(HqlParser.RoundFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        SqmExpression precision = (SqmExpression)ctx.roundFunctionPrecision().expression().accept(this);
        return this.getFunctionDescriptor("round").generateSqmExpression(Arrays.asList(arg, precision), (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitAtan2Function(HqlParser.Atan2FunctionContext ctx) {
        SqmExpression sin = (SqmExpression)ctx.expression().get(0).accept(this);
        SqmExpression cos = (SqmExpression)ctx.expression().get(1).accept(this);
        return this.getFunctionDescriptor("atan2").generateSqmExpression(Arrays.asList(sin, cos), (AllowableFunctionReturnType)sin.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLnFunction(HqlParser.LnFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("ln").generateSqmExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitExpFunction(HqlParser.ExpFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("exp").generateSqmExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitDatetimeField(HqlParser.DatetimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        if (ctx.DAY() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.DAY, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.MONTH() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.MONTH, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.YEAR() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.YEAR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.HOUR() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.HOUR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.MINUTE() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.MINUTE, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.SECOND() != null) {
            return new SqmExtractUnit<Float>(TemporalUnit.SECOND, this.resolveExpressableTypeBasic(Float.class), nodeBuilder);
        }
        if (ctx.NANOSECOND() != null) {
            return new SqmExtractUnit<Long>(TemporalUnit.NANOSECOND, this.resolveExpressableTypeBasic(Long.class), nodeBuilder);
        }
        if (ctx.WEEK() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.WEEK, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.QUARTER() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.QUARTER, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        return super.visitDatetimeField(ctx);
    }

    @Override
    public Object visitDayField(HqlParser.DayFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        if (ctx.WEEK() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_WEEK, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.MONTH() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_MONTH, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.YEAR() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.DAY_OF_YEAR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        return super.visitDayField(ctx);
    }

    @Override
    public Object visitWeekField(HqlParser.WeekFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        if (ctx.MONTH() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_MONTH, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.YEAR() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.WEEK_OF_YEAR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        return super.visitWeekField(ctx);
    }

    @Override
    public Object visitDateOrTimeField(HqlParser.DateOrTimeFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        if (ctx.DATE() != null) {
            return this.isExtractingJdbcTemporalType ? new SqmExtractUnit<Date>(TemporalUnit.DATE, this.resolveExpressableTypeBasic(Date.class), nodeBuilder) : new SqmExtractUnit<LocalDate>(TemporalUnit.DATE, this.resolveExpressableTypeBasic(LocalDate.class), nodeBuilder);
        }
        if (ctx.TIME() != null) {
            return this.isExtractingJdbcTemporalType ? new SqmExtractUnit<Time>(TemporalUnit.TIME, this.resolveExpressableTypeBasic(Time.class), nodeBuilder) : new SqmExtractUnit<LocalTime>(TemporalUnit.TIME, this.resolveExpressableTypeBasic(LocalTime.class), nodeBuilder);
        }
        return super.visitDateOrTimeField(ctx);
    }

    @Override
    public Object visitTimeZoneField(HqlParser.TimeZoneFieldContext ctx) {
        NodeBuilder nodeBuilder = this.creationContext.getNodeBuilder();
        if (ctx.HOUR() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_HOUR, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        if (ctx.MINUTE() != null) {
            return new SqmExtractUnit<Integer>(TemporalUnit.TIMEZONE_MINUTE, this.resolveExpressableTypeBasic(Integer.class), nodeBuilder);
        }
        return new SqmExtractUnit<ZoneOffset>(TemporalUnit.OFFSET, this.resolveExpressableTypeBasic(ZoneOffset.class), nodeBuilder);
    }

    @Override
    public Object visitExtractFunction(HqlParser.ExtractFunctionContext ctx) {
        SqmExtractUnit extractFieldExpression;
        SqmExpression expressionToExtract = (SqmExpression)ctx.expression().accept(this);
        this.isExtractingJdbcTemporalType = TypeConfiguration.isJdbcTemporalType(expressionToExtract.getNodeType());
        if (ctx.extractField() != null) {
            extractFieldExpression = (SqmExtractUnit)ctx.extractField().accept(this);
        } else if (ctx.datetimeField() != null) {
            extractFieldExpression = (SqmExtractUnit)ctx.datetimeField().accept(this);
        } else {
            return expressionToExtract;
        }
        return this.getFunctionDescriptor("extract").generateSqmExpression(Arrays.asList(extractFieldExpression, expressionToExtract), extractFieldExpression.getType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitFormat(HqlParser.FormatContext ctx) {
        String format = ctx.STRING_LITERAL().getText();
        if (!FORMAT.matcher(format).matches()) {
            throw new SemanticException("illegal format pattern: '" + format + "'");
        }
        return new SqmFormat(format, (SqmExpressable<String>)this.resolveExpressableTypeBasic(String.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitFormatFunction(HqlParser.FormatFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.expression().accept(this);
        SqmLiteral format = (SqmLiteral)ctx.format().accept(this);
        return this.getFunctionDescriptor("format").generateSqmExpression(Arrays.asList(expressionToCast, format), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitCastFunction(HqlParser.CastFunctionContext ctx) {
        SqmExpression expressionToCast = (SqmExpression)ctx.expression().accept(this);
        SqmCastTarget castTargetExpression = (SqmCastTarget)ctx.castTarget().accept(this);
        return this.getFunctionDescriptor("cast").generateSqmExpression(Arrays.asList(expressionToCast, castTargetExpression), castTargetExpression.getType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmCastTarget<?> visitCastTarget(HqlParser.CastTargetContext castTargetContext) {
        String targetName = castTargetContext.identifier().getText();
        List<TerminalNode> args = castTargetContext.INTEGER_LITERAL();
        Long length = args.size() == 1 ? Long.valueOf(args.get(0).getText()) : null;
        Integer precision = args.size() > 0 ? Integer.valueOf(args.get(0).getText()) : null;
        Integer scale = args.size() > 1 ? Integer.valueOf(args.get(1).getText()) : null;
        return new SqmCastTarget((AllowableFunctionReturnType)((Object)this.creationContext.getJpaMetamodel().getTypeConfiguration().resolveCastTargetType(targetName)), length, precision, scale, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitUpperFunction(HqlParser.UpperFunctionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("upper").generateSqmExpression(expression, (AllowableFunctionReturnType)expression.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLowerFunction(HqlParser.LowerFunctionContext ctx) {
        SqmExpression expression = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("lower").generateSqmExpression(expression, (AllowableFunctionReturnType)expression.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitConcatFunction(HqlParser.ConcatFunctionContext ctx) {
        ArrayList arguments = new ArrayList();
        for (HqlParser.ExpressionContext argument : ctx.expression()) {
            arguments.add((SqmTypedNode)argument.accept(this));
        }
        return this.getFunctionDescriptor("concat").generateSqmExpression(arguments, this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitLengthFunction(HqlParser.LengthFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("length").generateSqmExpression(arg, this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitPositionFunction(HqlParser.PositionFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.positionFunctionStringArgument().accept(this);
        SqmExpression pattern = (SqmExpression)ctx.positionFunctionPatternArgument().accept(this);
        return this.getFunctionDescriptor("position").generateSqmExpression(Arrays.asList(pattern, string), this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitLocateFunction(HqlParser.LocateFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.locateFunctionStringArgument().accept(this);
        SqmExpression pattern = (SqmExpression)ctx.locateFunctionPatternArgument().accept(this);
        SqmExpression start = ctx.locateFunctionStartArgument() == null ? null : (SqmExpression)ctx.locateFunctionStartArgument().accept(this);
        return this.getFunctionDescriptor("locate").generateSqmExpression(start == null ? Arrays.asList(pattern, string) : Arrays.asList(pattern, string, start), this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitOverlayFunction(HqlParser.OverlayFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.overlayFunctionStringArgument().accept(this);
        SqmExpression replacement = (SqmExpression)ctx.overlayFunctionReplacementArgument().accept(this);
        SqmExpression start = (SqmExpression)ctx.overlayFunctionStartArgument().accept(this);
        SqmExpression length = ctx.overlayFunctionLengthArgument() == null ? null : (SqmExpression)ctx.overlayFunctionLengthArgument().accept(this);
        return this.getFunctionDescriptor("overlay").generateSqmExpression(length == null ? Arrays.asList(string, replacement, start) : Arrays.asList(string, replacement, start, length), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitReplaceFunction(HqlParser.ReplaceFunctionContext ctx) {
        SqmExpression string = (SqmExpression)ctx.replaceFunctionStringArgument().accept(this);
        SqmExpression pattern = (SqmExpression)ctx.replaceFunctionPatternArgument().accept(this);
        SqmExpression replacement = (SqmExpression)ctx.replaceFunctionReplacementArgument().accept(this);
        return this.getFunctionDescriptor("replace").generateSqmExpression(Arrays.asList(string, pattern, replacement), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public Object visitStrFunction(HqlParser.StrFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("str").generateSqmExpression(Collections.singletonList(arg), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitMaxFunction(HqlParser.MaxFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("max").generateSqmExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitMinFunction(HqlParser.MinFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        return this.getFunctionDescriptor("min").generateSqmExpression(arg, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitSumFunction(HqlParser.SumFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        SqmTypedNode argument = ctx.DISTINCT() != null ? new SqmDistinct(arg, this.getCreationContext().getNodeBuilder()) : arg;
        return this.getFunctionDescriptor("sum").generateSqmExpression(argument, (AllowableFunctionReturnType)arg.getNodeType(), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitEveryFunction(HqlParser.EveryFunctionContext ctx) {
        if (ctx.subQuery() != null) {
            SqmSubQuery subquery = (SqmSubQuery)ctx.subQuery().accept(this);
            return new SqmEvery(subquery, this.creationContext.getNodeBuilder());
        }
        SqmExpression argument = (SqmExpression)ctx.predicate().accept(this);
        return this.getFunctionDescriptor("every").generateSqmExpression(argument, this.resolveExpressableTypeBasic(Boolean.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitAnyFunction(HqlParser.AnyFunctionContext ctx) {
        if (ctx.subQuery() != null) {
            SqmSubQuery subquery = (SqmSubQuery)ctx.subQuery().accept(this);
            return new SqmAny(subquery, this.creationContext.getNodeBuilder());
        }
        SqmExpression argument = (SqmExpression)ctx.predicate().accept(this);
        return this.getFunctionDescriptor("any").generateSqmExpression(argument, this.resolveExpressableTypeBasic(Boolean.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitAvgFunction(HqlParser.AvgFunctionContext ctx) {
        SqmExpression arg = (SqmExpression)ctx.expression().accept(this);
        SqmTypedNode argument = ctx.DISTINCT() != null ? new SqmDistinct(arg, this.getCreationContext().getNodeBuilder()) : arg;
        return this.getFunctionDescriptor("avg").generateSqmExpression(argument, this.resolveExpressableTypeBasic(Double.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitCountFunction(HqlParser.CountFunctionContext ctx) {
        SqmExpression<Object> arg = ctx.ASTERISK() != null ? new SqmStar(this.getCreationContext().getNodeBuilder()) : (SqmExpression)ctx.expression().accept(this);
        SqmTypedNode<Object> argument = ctx.DISTINCT() != null ? new SqmDistinct<Object>(arg, this.getCreationContext().getNodeBuilder()) : arg;
        return this.getFunctionDescriptor("count").generateSqmExpression(argument, this.resolveExpressableTypeBasic(Long.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitCube(HqlParser.CubeContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.CUBE, this.visitExpressions(ctx.expression()), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitRollup(HqlParser.RollupContext ctx) {
        return new SqmSummarization(SqmSummarization.Kind.ROLLUP, this.visitExpressions(ctx.expression()), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitSubstringFunction(HqlParser.SubstringFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmExpression start = (SqmExpression)ctx.substringFunctionStartArgument().accept(this);
        SqmExpression length = ctx.substringFunctionLengthArgument() == null ? null : (SqmExpression)ctx.substringFunctionLengthArgument().accept(this);
        return this.getFunctionDescriptor("substring").generateSqmExpression(length == null ? Arrays.asList(source, start) : Arrays.asList(source, start, length), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitLeftFunction(HqlParser.LeftFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression length = (SqmExpression)ctx.expression(1).accept(this);
        return this.getFunctionDescriptor("left").generateSqmExpression(Arrays.asList(source, length), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getNodeBuilder().getTypeConfiguration());
    }

    @Override
    public SqmExpression<?> visitRightFunction(HqlParser.RightFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression(0).accept(this);
        SqmExpression length = (SqmExpression)ctx.expression(1).accept(this);
        return this.getFunctionDescriptor("right").generateSqmExpression(Arrays.asList(source, length), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getNodeBuilder().getTypeConfiguration());
    }

    @Override
    public SqmExpression visitPadFunction(HqlParser.PadFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmExpression length = (SqmExpression)ctx.padLength().accept(this);
        SqmTrimSpecification padSpec = this.visitPadSpecification(ctx.padSpecification());
        Object padChar = ctx.padCharacter() == null ? null : this.visitPadCharacter(ctx.padCharacter());
        return this.getFunctionDescriptor("pad").generateSqmExpression(padChar != null ? Arrays.asList(source, length, padSpec, padChar) : Arrays.asList(source, length, padSpec), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmTrimSpecification visitPadSpecification(HqlParser.PadSpecificationContext ctx) {
        TrimSpec spec = ctx.LEADING() != null ? TrimSpec.LEADING : TrimSpec.TRAILING;
        return new SqmTrimSpecification(spec, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmLiteral<Character> visitPadCharacter(HqlParser.PadCharacterContext ctx) {
        String padCharText;
        String string = padCharText = ctx != null && ctx.STRING_LITERAL() != null ? ctx.STRING_LITERAL().getText() : " ";
        if (padCharText.length() != 1) {
            throw new SemanticException("Pad character for pad() function must be single character, found: " + padCharText);
        }
        return new SqmLiteral<Character>(Character.valueOf(padCharText.charAt(0)), this.resolveExpressableTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmExpression<?> visitTrimFunction(HqlParser.TrimFunctionContext ctx) {
        SqmExpression source = (SqmExpression)ctx.expression().accept(this);
        SqmTrimSpecification trimSpec = this.visitTrimSpecification(ctx.trimSpecification());
        Object trimChar = this.visitTrimCharacter(ctx.trimCharacter());
        return this.getFunctionDescriptor("trim").generateSqmExpression(Arrays.asList(trimSpec, trimChar, source), this.resolveExpressableTypeBasic(String.class), this.creationContext.getQueryEngine(), this.creationContext.getJpaMetamodel().getTypeConfiguration());
    }

    @Override
    public SqmTrimSpecification visitTrimSpecification(HqlParser.TrimSpecificationContext ctx) {
        TrimSpec spec = TrimSpec.BOTH;
        if (ctx != null) {
            if (ctx.LEADING() != null) {
                spec = TrimSpec.LEADING;
            } else if (ctx.TRAILING() != null) {
                spec = TrimSpec.TRAILING;
            }
        }
        return new SqmTrimSpecification(spec, this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmLiteral<Character> visitTrimCharacter(HqlParser.TrimCharacterContext ctx) {
        String trimCharText;
        String string = trimCharText = ctx != null && ctx.STRING_LITERAL() != null ? ctx.STRING_LITERAL().getText() : " ";
        if (trimCharText.length() != 1) {
            throw new SemanticException("Trim character for trim() function must be single character, found: " + trimCharText);
        }
        return new SqmLiteral<Character>(Character.valueOf(trimCharText.charAt(0)), this.resolveExpressableTypeBasic(Character.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmCollectionSize visitCollectionSizeFunction(HqlParser.CollectionSizeFunctionContext ctx) {
        return new SqmCollectionSize(this.consumeDomainPath(ctx.path()), this.resolveExpressableTypeBasic(Integer.class), this.creationContext.getNodeBuilder());
    }

    @Override
    public SqmPath<?> visitCollectionIndexFunction(HqlParser.CollectionIndexFunctionContext ctx) {
        String alias = ctx.identifier().getText();
        SqmFrom sqmFrom = this.processingStateStack.getCurrent().getPathRegistry().findFromByAlias(alias);
        if (sqmFrom == null) {
            throw new ParsingException("Could not resolve identification variable [" + alias + "] to SqmFrom");
        }
        SqmPathSource pluralAttribute = sqmFrom.getReferencedPathSource();
        if (!(pluralAttribute instanceof PluralPersistentAttribute)) {
            throw new ParsingException("Could not resolve identification variable [" + alias + "] as plural-attribute");
        }
        return ((PluralPersistentAttribute)pluralAttribute).getIndexPathSource().createSqmPath(sqmFrom, this);
    }

    private boolean isIndexedPluralAttribute(SqmPath<?> path) {
        return path.getReferencedPathSource() instanceof PluralPersistentAttribute;
    }

    @Override
    public SqmMaxElementPath visitMaxElementFunction(HqlParser.MaxElementFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmMaxElementPath(this.consumePluralAttributeReference(ctx.path()));
    }

    @Override
    public SqmMinElementPath visitMinElementFunction(HqlParser.MinElementFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        return new SqmMinElementPath(this.consumePluralAttributeReference(ctx.path()));
    }

    @Override
    public SqmMaxIndexPath visitMaxIndexFunction(HqlParser.MaxIndexFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (!this.isIndexedPluralAttribute(pluralPath)) {
            throw new SemanticException("maxindex() function can only be applied to path expressions which resolve to an indexed collection (list,map); specified path [" + ctx.path().getText() + "] resolved to " + pluralPath.getReferencedPathSource());
        }
        return new SqmMaxIndexPath(pluralPath);
    }

    @Override
    public SqmMinIndexPath visitMinIndexFunction(HqlParser.MinIndexFunctionContext ctx) {
        if (this.creationOptions.useStrictJpaCompliance()) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.HQL_COLLECTION_FUNCTION);
        }
        SqmPath pluralPath = this.consumePluralAttributeReference(ctx.path());
        if (!this.isIndexedPluralAttribute(pluralPath)) {
            throw new SemanticException("minindex() function can only be applied to path expressions which resolve to an indexed collection (list,map); specified path [" + ctx.path().getText() + "] resolved to " + pluralPath.getReferencedPathSource());
        }
        return new SqmMinIndexPath(pluralPath);
    }

    @Override
    public SqmSubQuery<?> visitSubQueryExpression(HqlParser.SubQueryExpressionContext ctx) {
        return this.visitSubQuery(ctx.subQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmSubQuery<?> visitSubQuery(HqlParser.SubQueryContext ctx) {
        HqlParser.QueryExpressionContext queryExpressionContext = ctx.queryExpression();
        SqmSubQuery subQuery = new SqmSubQuery(this.processingStateStack.getCurrent().getProcessingQuery(), this.creationContext.getNodeBuilder());
        this.processingStateStack.push(new SqmQuerySpecCreationProcessingStateStandardImpl(this.processingStateStack.getCurrent(), subQuery, this));
        try {
            queryExpressionContext.accept(this);
            SqmSubQuery sqmSubQuery = subQuery;
            return sqmSubQuery;
        }
        finally {
            this.processingStateStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SemanticPathPart visitPath(HqlParser.PathContext ctx) {
        if (ctx.syntacticDomainPath() != null) {
            SemanticPathPart syntacticNavigablePathResult = this.visitSyntacticDomainPath(ctx.syntacticDomainPath());
            if (ctx.pathContinuation() != null) {
                this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(syntacticNavigablePathResult, this){

                    @Override
                    protected void reset() {
                    }
                });
                try {
                    SemanticPathPart semanticPathPart = (SemanticPathPart)ctx.pathContinuation().accept(this);
                    return semanticPathPart;
                }
                finally {
                    this.dotIdentifierConsumerStack.pop();
                }
            }
            return syntacticNavigablePathResult;
        }
        if (ctx.generalPathFragment() != null) {
            return (SemanticPathPart)ctx.generalPathFragment().accept(this);
        }
        throw new ParsingException("Unrecognized `path` rule branch");
    }

    @Override
    public SemanticPathPart visitGeneralPathFragment(HqlParser.GeneralPathFragmentContext ctx) {
        return this.visitDotIdentifierSequence(ctx.dotIdentifierSequence());
    }

    @Override
    public SemanticPathPart visitSyntacticDomainPath(HqlParser.SyntacticDomainPathContext ctx) {
        if (ctx.treatedNavigablePath() != null) {
            return this.visitTreatedNavigablePath(ctx.treatedNavigablePath());
        }
        if (ctx.collectionElementNavigablePath() != null) {
            return this.visitCollectionElementNavigablePath(ctx.collectionElementNavigablePath());
        }
        if (ctx.mapKeyNavigablePath() != null) {
            return this.visitMapKeyNavigablePath(ctx.mapKeyNavigablePath());
        }
        if (ctx.dotIdentifierSequence() != null && ctx.indexedPathAccessFragment() != null) {
            SqmAttributeJoin indexedJoinPath = (SqmAttributeJoin)ctx.dotIdentifierSequence().accept(this);
            return new SqmIndexedCollectionAccessPath(indexedJoinPath, (SqmExpression)ctx.indexedPathAccessFragment().accept(this));
        }
        throw new ParsingException("Unsure how to process `syntacticDomainPath` over : " + ctx.getText());
    }

    @Override
    public SemanticPathPart visitDotIdentifierSequence(HqlParser.DotIdentifierSequenceContext ctx) {
        int numberOfContinuations = ctx.dotIdentifierSequenceContinuation().size();
        boolean hasContinuations = numberOfContinuations != 0;
        DotIdentifierConsumer dotIdentifierConsumer = this.dotIdentifierConsumerStack.getCurrent();
        assert (ctx.identifier().getChildCount() == 1);
        dotIdentifierConsumer.consumeIdentifier(ctx.identifier().getChild(0).getText(), true, !hasContinuations);
        if (hasContinuations) {
            int i = 1;
            for (HqlParser.DotIdentifierSequenceContinuationContext continuation : ctx.dotIdentifierSequenceContinuation()) {
                assert (continuation.identifier().getChildCount() == 1);
                dotIdentifierConsumer.consumeIdentifier(continuation.identifier().getChild(0).getText(), false, i++ >= numberOfContinuations);
            }
        }
        return dotIdentifierConsumer.getConsumedPart();
    }

    @Override
    public Object visitDotIdentifierSequenceContinuation(HqlParser.DotIdentifierSequenceContinuationContext ctx) {
        return super.visitDotIdentifierSequenceContinuation(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqmPath<?> visitTreatedNavigablePath(HqlParser.TreatedNavigablePathContext ctx) {
        SqmPath sqmPath = this.consumeManagedTypeReference(ctx.path());
        String treatTargetName = ctx.dotIdentifierSequence().getText();
        EntityDomainType treatTarget = this.getCreationContext().getJpaMetamodel().entity(treatTargetName);
        SqmPath result = this.resolveTreatedPath(sqmPath, treatTarget);
        if (ctx.pathContinuation() != null) {
            this.dotIdentifierConsumerStack.push(new BasicDotIdentifierConsumer(result, this){

                @Override
                protected void reset() {
                }
            });
            try {
                result = this.consumeDomainPath(ctx.pathContinuation().dotIdentifierSequence());
            }
            finally {
                this.dotIdentifierConsumerStack.pop();
            }
        }
        return result;
    }

    private SqmTreatedPath resolveTreatedPath(SqmPath<?> sqmPath, EntityDomainType<?> treatTarget) {
        return sqmPath.treatAs(treatTarget);
    }

    @Override
    public SqmPath<?> visitCollectionElementNavigablePath(HqlParser.CollectionElementNavigablePathContext ctx) {
        SqmPath pluralAttributePath = this.consumeDomainPath(ctx.path());
        SqmPathSource<?> referencedPathSource = pluralAttributePath.getReferencedPathSource();
        if (!(referencedPathSource instanceof PluralPersistentAttribute)) {
            throw new PathException("Illegal attempt to treat non-plural path as a plural path : " + pluralAttributePath.getNavigablePath());
        }
        PluralPersistentAttribute attribute = (PluralPersistentAttribute)referencedPathSource;
        if (this.getCreationOptions().useStrictJpaCompliance() && attribute.getCollectionClassification() != CollectionClassification.MAP) {
            throw new StrictJpaComplianceViolation(StrictJpaComplianceViolation.Type.VALUE_FUNCTION_ON_NON_MAP);
        }
        SqmPath result = attribute.getElementPathSource().createSqmPath(pluralAttributePath, this);
        if (ctx.pathContinuation() != null) {
            result = this.consumeDomainPath(ctx.path());
        }
        return result;
    }

    @Override
    public SqmPath visitMapKeyNavigablePath(HqlParser.MapKeyNavigablePathContext ctx) {
        SqmPath sqmPath = this.consumeDomainPath(ctx.path());
        SqmPathSource<?> referencedPathSource = sqmPath.getReferencedPathSource();
        if (!(referencedPathSource instanceof MapPersistentAttribute)) {
            throw new PathException("SqmPath#referencedPathSource [" + sqmPath + "] does not refer");
        }
        MapPersistentAttribute attribute = (MapPersistentAttribute)referencedPathSource;
        SqmPath result = attribute.getKeyPathSource().createSqmPath(sqmPath, this);
        if (ctx.pathContinuation() != null) {
            return this.consumeDomainPath(ctx.path());
        }
        return result;
    }

    private SqmPath consumeDomainPath(HqlParser.PathContext parserPath) {
        SemanticPathPart consumedPart = (SemanticPathPart)parserPath.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath consumeDomainPath(HqlParser.DotIdentifierSequenceContext sequence) {
        SemanticPathPart consumedPart = (SemanticPathPart)sequence.accept(this);
        if (consumedPart instanceof SqmPath) {
            return (SqmPath)consumedPart;
        }
        throw new SemanticException("Expecting domain-model path, but found : " + consumedPart);
    }

    private SqmPath consumeManagedTypeReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        SqmPathSource<?> pathSource = sqmPath.getReferencedPathSource();
        try {
            pathSource.sqmAs(ManagedDomainType.class);
            return sqmPath;
        }
        catch (Exception e) {
            throw new SemanticException("Expecting ManagedType valued path [" + sqmPath.getNavigablePath() + "], but found : " + pathSource.getSqmPathType());
        }
    }

    private SqmPath consumePluralAttributeReference(HqlParser.PathContext parserPath) {
        SqmPath sqmPath = this.consumeDomainPath(parserPath);
        if (sqmPath.getReferencedPathSource() instanceof PluralPersistentAttribute) {
            return sqmPath;
        }
        throw new SemanticException("Expecting plural attribute valued path [" + sqmPath.getNavigablePath() + "], but found : " + sqmPath.getReferencedPathSource().getSqmPathType());
    }

    private void checkFQNEntityNameJpaComplianceViolationIfNeeded(String name, EntityDomainType entityDescriptor) {
        if (this.getCreationOptions().useStrictJpaCompliance() && !name.equals(entityDescriptor.getName())) {
            throw new StrictJpaComplianceViolation("Encountered FQN entity name [" + name + "], but strict JPQL compliance was requested ( [" + entityDescriptor.getName() + "] should be used instead )", StrictJpaComplianceViolation.Type.FQN_ENTITY_NAME);
        }
    }

    private static class TreatHandlerFromClause
    implements TreatHandler {
        private TreatHandlerFromClause() {
        }

        @Override
        public void addDowncast(SqmFrom sqmFrom, IdentifiableDomainType downcastTarget) {
            throw new NotYetImplementedFor6Exception();
        }
    }

    private static class TreatHandlerNormal
    implements TreatHandler {
        private final DowncastLocation downcastLocation;

        public TreatHandlerNormal() {
            this(DowncastLocation.OTHER);
        }

        public TreatHandlerNormal(DowncastLocation downcastLocation) {
            this.downcastLocation = downcastLocation;
        }

        @Override
        public void addDowncast(SqmFrom sqmFrom, IdentifiableDomainType downcastTarget) {
            throw new NotYetImplementedFor6Exception();
        }
    }

    private static interface TreatHandler {
        public void addDowncast(SqmFrom var1, IdentifiableDomainType var2);
    }
}

