/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.persistence.CacheRetrieveMode;
import javax.persistence.CacheStoreMode;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NonUniqueResultException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.QueryParameterException;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.TypeMismatchException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.query.spi.EntityGraphQueryHint;
import org.hibernate.engine.spi.ExceptionConverter;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.EntityManagerMessageLogger;
import org.hibernate.internal.HEMLogging;
import org.hibernate.jpa.QueryHints;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.FlushModeTypeHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.Query;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.TypedParameterValue;
import org.hibernate.query.internal.QueryOptionsImpl;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.spi.MutableQueryOptions;
import org.hibernate.query.spi.QueryImplementor;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.query.spi.StreamDecorator;
import org.hibernate.transform.ResultTransformer;
import org.jboss.logging.Logger;

public abstract class AbstractProducedQuery<R>
implements QueryImplementor<R> {
    private static final EntityManagerMessageLogger MSG_LOGGER = HEMLogging.messageLogger(AbstractProducedQuery.class);
    private static final Logger LOGGER = Logger.getLogger(AbstractProducedQuery.class);
    private final SharedSessionContractImplementor producer;
    private final ParameterMetadata parameterMetadata;
    private ResultTransformer resultTransformer;
    private MutableQueryOptions queryOptions = new QueryOptionsImpl();
    private EntityGraphQueryHint entityGraphQueryHint;
    private Object optionalObject;
    private Serializable optionalId;
    private String optionalEntityName;
    private Boolean passDistinctThrough;
    private FlushMode sessionFlushMode;
    private CacheMode sessionCacheMode;

    public AbstractProducedQuery(SharedSessionContractImplementor producer, ParameterMetadata parameterMetadata) {
        this.producer = producer;
        this.parameterMetadata = parameterMetadata;
    }

    @Override
    public MutableQueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public FlushMode getHibernateFlushMode() {
        return this.getQueryOptions().getFlushMode();
    }

    @Override
    public QueryImplementor setHibernateFlushMode(FlushMode flushMode) {
        this.getQueryOptions().setFlushMode(flushMode);
        return this;
    }

    public FlushModeType getFlushMode() {
        this.getSession().checkOpen();
        return this.getHibernateFlushMode() == null ? this.getSession().getFlushMode() : FlushModeTypeHelper.getFlushModeType(this.getHibernateFlushMode());
    }

    @Override
    public QueryImplementor setFlushMode(FlushModeType flushModeType) {
        this.getSession().checkOpen();
        this.setHibernateFlushMode(FlushModeTypeHelper.getFlushMode(flushModeType));
        return this;
    }

    @Override
    public CacheMode getCacheMode() {
        return this.getQueryOptions().getCacheMode();
    }

    @Override
    public QueryImplementor setCacheMode(CacheMode cacheMode) {
        this.getQueryOptions().setCacheMode(cacheMode);
        return this;
    }

    @Override
    public boolean isCacheable() {
        return this.getQueryOptions().isResultCachingEnabled();
    }

    @Override
    public QueryImplementor setCacheable(boolean cacheable) {
        this.getQueryOptions().setResultCachingEnabled(cacheable);
        return this;
    }

    @Override
    public String getCacheRegion() {
        return this.getQueryOptions().getResultCacheRegionName();
    }

    @Override
    public QueryImplementor setCacheRegion(String cacheRegion) {
        this.getQueryOptions().setResultCacheRegionName(cacheRegion);
        return this;
    }

    @Override
    public Integer getTimeout() {
        return this.queryOptions.getTimeout();
    }

    @Override
    public QueryImplementor setTimeout(int timeout) {
        this.queryOptions.setTimeout(timeout);
        return this;
    }

    @Override
    public Integer getFetchSize() {
        return this.queryOptions.getFetchSize();
    }

    @Override
    public QueryImplementor setFetchSize(int fetchSize) {
        this.queryOptions.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.getQueryOptions().isReadOnly() == null ? this.getSession().isDefaultReadOnly() : this.getQueryOptions().isReadOnly().booleanValue();
    }

    @Override
    public QueryImplementor setReadOnly(boolean readOnly) {
        this.getQueryOptions().setReadOnly(readOnly);
        return this;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.getQueryOptions().getLockOptions();
    }

    public QueryImplementor setLockOptions(LockOptions lockOptions) {
        this.getQueryOptions().getLockOptions().setLockMode(lockOptions.getLockMode());
        this.getQueryOptions().getLockOptions().setScope(lockOptions.getScope());
        this.getQueryOptions().getLockOptions().setTimeOut(lockOptions.getTimeOut());
        this.getQueryOptions().getLockOptions().setFollowOnLocking(lockOptions.getFollowOnLocking());
        return this;
    }

    public QueryImplementor setLockMode(String alias, LockMode lockMode) {
        this.getQueryOptions().getLockOptions().setAliasSpecificLockMode(alias, lockMode);
        return this;
    }

    @Override
    public QueryImplementor setLockMode(LockModeType lockModeType) {
        this.getSession().checkOpen();
        if (!LockModeType.NONE.equals((Object)lockModeType) && !this.isSelect()) {
            throw new IllegalStateException("Illegal attempt to set lock mode on a non-SELECT query");
        }
        this.getQueryOptions().getLockOptions().setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        return this;
    }

    @Override
    public String getComment() {
        return this.getQueryOptions().getComment();
    }

    public QueryImplementor setComment(String comment) {
        this.getQueryOptions().setComment(comment);
        return this;
    }

    public QueryImplementor addQueryHint(String hint) {
        this.getQueryOptions().addDatabaseHint(hint);
        return this;
    }

    @Override
    public ParameterMetadata getParameterMetadata() {
        return this.parameterMetadata;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<Instant> param, Instant value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<LocalDateTime> param, LocalDateTime value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<ZonedDateTime> param, ZonedDateTime value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(Parameter<OffsetDateTime> param, OffsetDateTime value, TemporalType temporalType) {
        this.locateBinding(param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, Instant value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, LocalDateTime value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, ZonedDateTime value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(String name, OffsetDateTime value, TemporalType temporalType) {
        this.locateBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, Instant value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, LocalDateTime value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, ZonedDateTime value, TemporalType temporalType) {
        this.locateBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor<R> setParameter(int position, OffsetDateTime value, TemporalType temporalType) {
        QueryParameterBinding<?> binding = this.getQueryParameterBindings().getBinding(this.getParameterMetadata().getQueryParameter(position));
        binding.setBindValue(value, temporalType);
        return this;
    }

    public <P> QueryImplementor setParameter(QueryParameter<P> parameter, P value) {
        this.getQueryParameterBindings().getBinding(parameter).setBindValue(value);
        return this;
    }

    private <P> QueryParameterBinding<P> locateBinding(Parameter<P> parameter) {
        if (parameter instanceof QueryParameterImplementor) {
            return this.getQueryParameterBindings().getBinding((QueryParameterImplementor)parameter);
        }
        if (parameter.getName() != null) {
            return this.getQueryParameterBindings().getBinding(parameter.getName());
        }
        if (parameter.getPosition() != null) {
            return this.getQueryParameterBindings().getBinding(parameter.getPosition());
        }
        throw this.getExceptionConverter().convert(new IllegalArgumentException("Could not resolve binding for given parameter reference [" + parameter + "]"));
    }

    private <P> QueryParameterBinding<P> locateBinding(String name) {
        return this.getQueryParameterBindings().getBinding(name);
    }

    private <P> QueryParameterBinding<P> locateBinding(int position) {
        return this.getQueryParameterBindings().getBinding(position);
    }

    public <P> QueryImplementor setParameter(Parameter<P> parameter, P value) {
        this.getSession().checkOpen();
        if (value instanceof TypedParameterValue) {
            this.setParameter(parameter, ((TypedParameterValue)value).getValue(), ((TypedParameterValue)value).getType());
        } else {
            this.locateBinding(parameter).setBindValue(value);
        }
        return this;
    }

    private <P> void setParameter(Parameter<P> parameter, Object value, AllowableParameterType type) {
        if (parameter instanceof QueryParameter) {
            this.setParameter((QueryParameter)parameter, value, type);
        } else if (value == null) {
            this.locateBinding(parameter).setBindValue(null, type);
        } else {
            this.locateBinding(parameter).setBindValue(value, type);
        }
    }

    @Override
    public QueryImplementor setParameter(String name, Object value) {
        this.getSession().checkOpen();
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedValueWrapper = (TypedParameterValue)value;
            this.setParameter(name, typedValueWrapper.getValue(), typedValueWrapper.getType());
        } else if (value instanceof Collection && !this.isRegisteredAsBasicType(value.getClass())) {
            this.setParameterList(name, (Collection)value);
        } else {
            this.getQueryParameterBindings().getBinding(name).setBindValue(value);
        }
        return this;
    }

    @Override
    public QueryImplementor setParameter(int position, Object value) {
        this.getSession().checkOpen();
        if (value instanceof TypedParameterValue) {
            TypedParameterValue typedParameterValue = (TypedParameterValue)value;
            this.setParameter(position, typedParameterValue.getValue(), typedParameterValue.getType());
        } else if (value instanceof Collection && !this.isRegisteredAsBasicType(value.getClass())) {
            this.setParameterList(position, (Collection)value);
        } else {
            this.getQueryParameterBindings().getBinding(position).setBindValue(value);
        }
        return this;
    }

    public <P> QueryImplementor setParameter(QueryParameter<P> parameter, P value, AllowableParameterType type) {
        this.getQueryParameterBindings().getBinding(parameter).setBindValue(value, type);
        return this;
    }

    public QueryImplementor setParameter(String name, Object value, AllowableParameterType type) {
        this.getQueryParameterBindings().getBinding(name).setBindValue(value, type);
        return this;
    }

    public QueryImplementor setParameter(int position, Object value, AllowableParameterType type) {
        this.getQueryParameterBindings().getBinding(position).setBindValue(value, type);
        return this;
    }

    public <P> QueryImplementor setParameter(QueryParameter<P> parameter, P value, TemporalType temporalType) {
        this.getQueryParameterBindings().getBinding(parameter).setBindValue(value, temporalType);
        return this;
    }

    public QueryImplementor setParameter(String name, Object value, TemporalType temporalType) {
        this.getQueryParameterBindings().getBinding(name).setBindValue(value, temporalType);
        return this;
    }

    public QueryImplementor setParameter(int position, Object value, TemporalType temporalType) {
        this.getQueryParameterBindings().getBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public <P> QueryImplementor<R> setParameterList(QueryParameter<P> parameter, Collection<P> values) {
        this.getQueryParameterBindings().getBinding(parameter).setBindValues(values);
        return this;
    }

    public QueryImplementor setParameterList(String name, Collection values) {
        this.getQueryParameterBindings().getBinding(name).setBindValues(values);
        return this;
    }

    public QueryImplementor setParameterList(int position, Collection values) {
        this.getQueryParameterBindings().getBinding(position).setBindValues(values);
        return this;
    }

    public QueryImplementor setParameterList(String name, Collection values, AllowableParameterType type) {
        this.getQueryParameterBindings().getBinding(name).setBindValues(values, type);
        return this;
    }

    public QueryImplementor setParameterList(int position, Collection values, AllowableParameterType type) {
        this.getQueryParameterBindings().getBinding(position).setBindValues(values, type);
        return this;
    }

    public QueryImplementor setParameterList(String name, Object[] values, AllowableParameterType type) {
        this.getQueryParameterBindings().getBinding(name).setBindValues(Arrays.asList(values), type);
        return this;
    }

    public QueryImplementor setParameterList(int position, Object[] values, AllowableParameterType type) {
        this.getQueryParameterBindings().getBinding(position).setBindValues(Arrays.asList(values), type);
        return this;
    }

    public QueryImplementor setParameterList(String name, Object[] values) {
        this.getQueryParameterBindings().getBinding(name).setBindValues(Arrays.asList(values));
        return this;
    }

    public QueryImplementor setParameterList(int position, Object[] values) {
        this.getQueryParameterBindings().getBinding(position).setBindValues(Arrays.asList(values));
        return this;
    }

    public QueryImplementor setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.getSession().checkOpen();
        this.getQueryParameterBindings().getBinding((QueryParameter)param).setBindValue(value, temporalType);
        return this;
    }

    public QueryImplementor setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.getSession().checkOpen();
        this.getQueryParameterBindings().getBinding((QueryParameter)param).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor setParameter(String name, Calendar value, TemporalType temporalType) {
        this.getSession().checkOpen();
        this.getQueryParameterBindings().getBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor setParameter(String name, Date value, TemporalType temporalType) {
        this.getSession().checkOpen();
        this.getQueryParameterBindings().getBinding(name).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor setParameter(int position, Calendar value, TemporalType temporalType) {
        this.getSession().checkOpen();
        this.getQueryParameterBindings().getBinding(position).setBindValue(value, temporalType);
        return this;
    }

    @Override
    public QueryImplementor setParameter(int position, Date value, TemporalType temporalType) {
        this.getSession().checkOpen();
        this.getQueryParameterBindings().getBinding(position).setBindValue(value, temporalType);
        return this;
    }

    public Set<Parameter<?>> getParameters() {
        this.getSession().checkOpen(false);
        return this.getParameterMetadata().getRegistrations();
    }

    public QueryParameter<?> getParameter(String name) {
        this.getSession().checkOpen(false);
        try {
            return this.getParameterMetadata().getQueryParameter(name);
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public <T> QueryParameter<T> getParameter(String name, Class<T> type) {
        this.getSession().checkOpen(false);
        try {
            QueryParameter<?> parameter = this.getParameterMetadata().getQueryParameter(name);
            if (!parameter.getParameterType().isAssignableFrom(type)) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to name [" + name + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public QueryParameter<?> getParameter(int position) {
        this.getSession().checkOpen(false);
        try {
            return this.parameterMetadata.getQueryParameter(position);
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public <T> QueryParameter<T> getParameter(int position, Class<T> type) {
        this.getSession().checkOpen(false);
        try {
            QueryParameter<?> parameter = this.getParameterMetadata().getQueryParameter(position);
            if (!parameter.getParameterType().isAssignableFrom(type)) {
                throw new IllegalArgumentException("The type [" + parameter.getParameterType().getName() + "] associated with the parameter corresponding to position [" + position + "] is not assignable to requested Java type [" + type.getName() + "]");
            }
            return parameter;
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
    }

    public boolean isBound(Parameter<?> parameter) {
        this.getSession().checkOpen();
        return this.getQueryParameterBindings().getBinding((QueryParameterImplementor)parameter).isBound();
    }

    public <T> T getParameterValue(Parameter<T> parameter) {
        LOGGER.tracef("#getParameterValue(%s)", parameter);
        this.getSession().checkOpen(false);
        if (!this.getParameterMetadata().containsReference((QueryParameter)parameter)) {
            throw new IllegalArgumentException("Parameter reference [" + parameter + "] did not come from this query");
        }
        QueryParameterBinding binding = this.getQueryParameterBindings().getBinding((QueryParameter)parameter);
        LOGGER.debugf("Checking whether parameter reference [%s] is bound : %s", parameter, (Object)binding.isBound());
        if (!binding.isBound()) {
            throw new IllegalStateException("Parameter value not yet bound : " + parameter.toString());
        }
        return (T)binding.getBindValue();
    }

    public Object getParameterValue(String name) {
        QueryParameterBinding binding;
        this.getSession().checkOpen(false);
        try {
            binding = this.getQueryParameterBindings().getBinding(name);
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException("Could not resolve parameter by name - " + name, (Throwable)((Object)e));
        }
        LOGGER.debugf("Checking whether named parameter [%s] is bound : %s", (Object)name, (Object)binding.isBound());
        if (!binding.isBound()) {
            throw new IllegalStateException("Parameter value not yet bound : " + name);
        }
        return binding.getBindValue();
    }

    public Object getParameterValue(int position) {
        QueryParameterBinding binding;
        this.getSession().checkOpen(false);
        try {
            binding = this.getQueryParameterBindings().getBinding(position);
        }
        catch (QueryParameterException e) {
            throw new IllegalArgumentException("Could not resolve parameter by position - " + position, (Throwable)((Object)e));
        }
        LOGGER.debugf("Checking whether positional parameter [%s] is bound : %s", (Object)position, (Object)binding.isBound());
        if (!binding.isBound()) {
            throw new IllegalStateException("Parameter value not yet bound : " + position);
        }
        return binding.getBindValue();
    }

    public QueryImplementor setProperties(Object bean) {
        Class<?> clazz = bean.getClass();
        this.parameterMetadata.visitRegistrations(queryParameter -> {
            String parameterName = queryParameter.getName();
            if (parameterName != null) {
                try {
                    PropertyAccess propertyAccess = BuiltInPropertyAccessStrategies.BASIC.getStrategy().buildPropertyAccess(clazz, parameterName);
                    Getter getter = propertyAccess.getGetter();
                    Class<?> retType = getter.getReturnTypeClass();
                    Object object = getter.get(bean);
                    if (Collection.class.isAssignableFrom(retType)) {
                        this.setParameterList(parameterName, (Collection)object);
                    } else if (retType.isArray()) {
                        this.setParameterList(parameterName, (Object[])object);
                    } else {
                        this.setParameter(parameterName, object, this.determineType(parameterName, retType));
                    }
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    // empty catch block
                }
            }
        });
        return this;
    }

    protected AllowableParameterType determineType(String namedParam, Class retType) {
        AllowableParameterType type = this.getQueryParameterBindings().getBinding(namedParam).getBindType();
        if (type == null) {
            type = this.getParameterMetadata().getQueryParameter(namedParam).getHibernateType();
        }
        if (type == null) {
            type = this.getSession().getFactory().resolveParameterBindType(retType);
        }
        return type;
    }

    public QueryImplementor setProperties(Map map) {
        this.parameterMetadata.visitRegistrations(queryParameter -> {
            String parameterName = queryParameter.getName();
            if (parameterName != null) {
                Object value = map.get(parameterName);
                if (value == null) {
                    if (map.containsKey(parameterName)) {
                        this.setParameter(parameterName, null, this.determineType(parameterName, null));
                    }
                } else {
                    Class<?> retType = value.getClass();
                    if (Collection.class.isAssignableFrom(retType)) {
                        this.setParameterList(parameterName, (Collection)value);
                    } else if (retType.isArray()) {
                        this.setParameterList(parameterName, (Object[])value);
                    } else {
                        this.setParameter(parameterName, value, this.determineType(parameterName, retType));
                    }
                }
            }
        });
        return this;
    }

    public QueryImplementor setResultTransformer(ResultTransformer transformer) {
        this.resultTransformer = transformer;
        return this;
    }

    public int getMaxResults() {
        this.getSession().checkOpen();
        return this.queryOptions.getMaxRows() == null ? Integer.MAX_VALUE : this.queryOptions.getMaxRows();
    }

    @Override
    public QueryImplementor setMaxResults(int maxResult) {
        this.getSession().checkOpen();
        if (maxResult < 0) {
            throw new IllegalArgumentException("max-results cannot be negative");
        }
        this.queryOptions.getLimit().setMaxRows(maxResult);
        return this;
    }

    public int getFirstResult() {
        this.getSession().checkOpen();
        return this.queryOptions.getFirstRow() == null ? 0 : this.queryOptions.getFirstRow();
    }

    @Override
    public QueryImplementor setFirstResult(int startPosition) {
        this.getSession().checkOpen();
        if (startPosition < 0) {
            throw new IllegalArgumentException("first-result value cannot be negative : " + startPosition);
        }
        this.queryOptions.getLimit().setFirstRow(startPosition);
        return this;
    }

    public Set<String> getSupportedHints() {
        return QueryHints.getDefinedHints();
    }

    public Map<String, Object> getHints() {
        this.getSession().checkOpen(false);
        HashMap<String, Object> hints = new HashMap<String, Object>();
        this.collectBaselineHints(hints);
        this.collectHints(hints);
        return hints;
    }

    protected void collectBaselineHints(Map<String, Object> hints) {
    }

    protected void collectHints(Map<String, Object> hints) {
        LockOptions lockOptions;
        int lockOptionsTimeOut;
        MutableQueryOptions queryOptions = this.getQueryOptions();
        Integer queryTimeout = queryOptions.getTimeout();
        if (queryTimeout != null) {
            hints.put("org.hibernate.timeout", queryTimeout);
            hints.put("javax.persistence.query.timeout", queryTimeout * 1000);
        }
        if ((lockOptionsTimeOut = (lockOptions = this.getLockOptions()).getTimeOut()) != -1) {
            hints.put("javax.persistence.lock.timeout", lockOptionsTimeOut);
        }
        if (lockOptions.getScope()) {
            hints.put("javax.persistence.lock.scope", lockOptions.getScope());
        }
        if (lockOptions.hasAliasSpecificLockModes() && this.canApplyAliasSpecificLockModeHints()) {
            for (Map.Entry<String, LockMode> entry : lockOptions.getAliasSpecificLocks()) {
                hints.put("org.hibernate.lockMode." + entry.getKey(), entry.getValue().name());
            }
        }
        this.putIfNotNull(hints, "org.hibernate.comment", this.getComment());
        this.putIfNotNull(hints, "org.hibernate.fetchSize", queryOptions.getFetchSize());
        this.putIfNotNull(hints, "org.hibernate.flushMode", this.getHibernateFlushMode());
        CacheMode cacheMode = this.getQueryOptions().getCacheMode();
        if (cacheMode != null) {
            hints.put("org.hibernate.cacheMode", (Object)cacheMode);
            hints.put("javax.persistence.cache.retrieveMode", cacheMode.getJpaRetrieveMode());
            hints.put("javax.persistence.cache.storeMode", cacheMode.getJpaStoreMode());
        }
        if (this.isCacheable()) {
            hints.put("org.hibernate.cacheable", true);
            this.putIfNotNull(hints, "org.hibernate.cacheRegion", this.getCacheRegion());
        }
        if (this.isReadOnly()) {
            hints.put("org.hibernate.readOnly", true);
        }
        if (this.entityGraphQueryHint != null) {
            hints.put(this.entityGraphQueryHint.getSemantic().getJpaHintName(), this.entityGraphQueryHint.getGraph());
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Enum hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    protected void putIfNotNull(Map<String, Object> hints, String hintName, Object hintValue) {
        if (hintValue != null) {
            hints.put(hintName, hintValue);
        }
    }

    @Override
    public QueryImplementor setHint(String hintName, Object value) {
        this.getSession().checkOpen(true);
        boolean applied = false;
        try {
            if ("org.hibernate.timeout".equals(hintName)) {
                applied = this.applyTimeoutHint(ConfigurationHelper.getInteger(value));
            } else if ("javax.persistence.query.timeout".equals(hintName)) {
                int timeout = (int)Math.round(ConfigurationHelper.getInteger(value).doubleValue() / 1000.0);
                applied = this.applyTimeoutHint(timeout);
            } else if ("javax.persistence.lock.timeout".equals(hintName)) {
                applied = this.applyLockTimeoutHint(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.comment".equals(hintName)) {
                applied = this.applyCommentHint((String)value);
            } else if ("org.hibernate.fetchSize".equals(hintName)) {
                applied = this.applyFetchSizeHint(ConfigurationHelper.getInteger(value));
            } else if ("org.hibernate.cacheable".equals(hintName)) {
                applied = this.applyCacheableHint(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.cacheRegion".equals(hintName)) {
                applied = this.applyCacheRegionHint((String)value);
            } else if ("org.hibernate.readOnly".equals(hintName)) {
                applied = this.applyReadOnlyHint(ConfigurationHelper.getBoolean(value));
            } else if ("org.hibernate.flushMode".equals(hintName)) {
                applied = this.applyFlushModeHint(ConfigurationHelper.getFlushMode(value));
            } else if ("org.hibernate.cacheMode".equals(hintName)) {
                applied = this.applyCacheModeHint(ConfigurationHelper.getCacheMode(value));
            } else if ("javax.persistence.cache.retrieveMode".equals(hintName)) {
                CacheRetrieveMode retrieveMode = value != null ? CacheRetrieveMode.valueOf((String)value.toString()) : null;
                applied = this.applyJpaCacheRetrieveMode(retrieveMode);
            } else if ("javax.persistence.cache.storeMode".equals(hintName)) {
                CacheStoreMode storeMode = value != null ? CacheStoreMode.valueOf((String)value.toString()) : null;
                applied = this.applyJpaCacheStoreMode(storeMode);
            } else if ("org.hibernate.query.native.spaces".equals(hintName)) {
                applied = this.applyQuerySpaces(value);
            } else if ("org.hibernate.lockMode".equals(hintName)) {
                applied = this.applyNativeQueryLockMode(value);
            } else if (hintName.startsWith("org.hibernate.lockMode")) {
                if (this.canApplyAliasSpecificLockModeHints()) {
                    String alias = hintName.substring("org.hibernate.lockMode".length() + 1);
                    try {
                        LockMode lockMode = LockModeTypeHelper.interpretLockMode(value);
                        this.applyAliasSpecificLockModeHint(alias, lockMode);
                    }
                    catch (Exception e) {
                        MSG_LOGGER.unableToDetermineLockModeValue(hintName, value);
                        applied = false;
                    }
                } else {
                    applied = false;
                }
            } else if (QueryHints.HINT_FETCHGRAPH.equals(hintName) || QueryHints.HINT_LOADGRAPH.equals(hintName)) {
                if (value instanceof RootGraph) {
                    this.applyGraph((RootGraph)value, GraphSemantic.fromJpaHintName(hintName));
                } else {
                    MSG_LOGGER.warnf("The %s hint was set, but the value was not an EntityGraph!", hintName);
                }
                applied = true;
            } else if ("hibernate.query.followOnLocking".equals(hintName)) {
                applied = this.applyFollowOnLockingHint(ConfigurationHelper.getBoolean(value));
            } else if ("hibernate.query.passDistinctThrough".equals(hintName)) {
                applied = this.applyPassDistinctThrough(ConfigurationHelper.getBoolean(value));
            } else {
                MSG_LOGGER.ignoringUnrecognizedQueryHint(hintName);
            }
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Value for hint");
        }
        if (!applied) {
            this.handleUnrecognizedHint(hintName, value);
        }
        return this;
    }

    protected boolean applyQuerySpaces(Object value) {
        throw new IllegalStateException("Illegal attempt to apply native-query spaces to a non-native query");
    }

    protected void handleUnrecognizedHint(String hintName, Object value) {
        MSG_LOGGER.debugf("Skipping unsupported query hint [%s]", hintName);
    }

    protected boolean applyJpaCacheRetrieveMode(CacheRetrieveMode mode) {
        this.getQueryOptions().setCacheRetrieveMode(mode);
        return true;
    }

    protected boolean applyJpaCacheStoreMode(CacheStoreMode mode) {
        this.getQueryOptions().setCacheStoreMode(mode);
        return true;
    }

    protected boolean applyNativeQueryLockMode(Object value) {
        if (!this.isNativeQuery()) {
            throw new IllegalStateException("Illegal attempt to set lock mode on non-native query via hint; use Query#setLockMode instead");
        }
        return false;
    }

    protected boolean applyTimeoutHint(int timeout) {
        this.setTimeout(timeout);
        return true;
    }

    protected boolean applyLockTimeoutHint(int timeout) {
        this.getLockOptions().setTimeOut(timeout);
        return true;
    }

    protected boolean applyCommentHint(String comment) {
        this.setComment(comment);
        return true;
    }

    protected boolean applyFetchSizeHint(int fetchSize) {
        this.setFetchSize(fetchSize);
        return true;
    }

    protected boolean applyCacheableHint(boolean isCacheable) {
        this.setCacheable(isCacheable);
        return true;
    }

    protected boolean applyCacheRegionHint(String regionName) {
        this.setCacheRegion(regionName);
        return true;
    }

    protected boolean applyReadOnlyHint(boolean isReadOnly) {
        this.setReadOnly(isReadOnly);
        return true;
    }

    protected boolean applyCacheModeHint(CacheMode cacheMode) {
        this.setCacheMode(cacheMode);
        return true;
    }

    protected boolean applyFlushModeHint(FlushMode flushMode) {
        this.setHibernateFlushMode(flushMode);
        return true;
    }

    protected boolean canApplyAliasSpecificLockModeHints() {
        return true;
    }

    protected boolean applyLockModeTypeHint(LockModeType lockModeType) {
        this.getLockOptions().setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        return true;
    }

    protected boolean applyHibernateLockModeHint(LockMode lockMode) {
        this.getLockOptions().setLockMode(lockMode);
        return true;
    }

    protected void applyAliasSpecificLockModeHint(String alias, LockMode lockMode) {
        this.getLockOptions().setAliasSpecificLockMode(alias, lockMode);
    }

    @Override
    public Query<R> applyGraph(RootGraph graph, GraphSemantic semantic) {
        if (semantic == null) {
            this.entityGraphQueryHint = null;
        } else {
            if (graph == null) {
                throw new IllegalStateException("Semantic was non-null, but graph was null");
            }
            this.applyGraph((RootGraph)((RootGraphImplementor)graph), semantic);
        }
        return this;
    }

    @Deprecated
    protected void applyEntityGraphQueryHint(EntityGraphQueryHint hint) {
        this.entityGraphQueryHint = hint;
    }

    protected boolean applyFollowOnLockingHint(Boolean followOnLocking) {
        this.getLockOptions().setFollowOnLocking(followOnLocking);
        return true;
    }

    protected boolean applyPassDistinctThrough(boolean passDistinctThrough) {
        this.passDistinctThrough = passDistinctThrough;
        return true;
    }

    protected abstract boolean isNativeQuery();

    public LockModeType getLockMode() {
        this.getSession().checkOpen(false);
        if (!this.isSelect()) {
            throw new IllegalStateException("Illegal attempt to get lock mode on a non-SELECT query");
        }
        return LockModeTypeHelper.getLockModeType(this.getQueryOptions().getLockOptions().getLockMode());
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isInstance(this.getSession())) {
            return (T)this.getSession();
        }
        if (cls.isInstance(this.getParameterMetadata())) {
            return (T)this.getParameterMetadata();
        }
        if (cls.isInstance(this.getQueryParameterBindings())) {
            return (T)this.getQueryParameterBindings();
        }
        if (cls.isInstance(this)) {
            return (T)this;
        }
        throw new HibernateException("Could not unwrap this [" + this.toString() + "] as requested Java type [" + cls.getName() + "]");
    }

    public QueryParameters getQueryParameters() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    protected void beforeQuery() {
        CacheMode effectiveCacheMode;
        if (this.optionalId == null) {
            this.getQueryParameterBindings().validate();
        }
        assert (this.sessionFlushMode == null);
        assert (this.sessionCacheMode == null);
        FlushMode flushMode = this.getQueryOptions().getFlushMode();
        if (flushMode != null) {
            this.sessionFlushMode = this.getSession().getHibernateFlushMode();
            this.getSession().setHibernateFlushMode(flushMode);
        }
        if ((effectiveCacheMode = CacheMode.fromJpaModes(this.queryOptions.getCacheRetrieveMode(), this.queryOptions.getCacheStoreMode())) != null) {
            this.sessionCacheMode = this.getSession().getCacheMode();
            this.getSession().setCacheMode(effectiveCacheMode);
        }
        if (this.entityGraphQueryHint != null && this.entityGraphQueryHint.getSemantic() == GraphSemantic.FETCH) {
            this.getSession().setEnforcingFetchGraph(true);
        }
    }

    protected void afterQuery() {
        if (this.sessionFlushMode != null) {
            this.getSession().setHibernateFlushMode(this.sessionFlushMode);
            this.sessionFlushMode = null;
        }
        if (this.sessionCacheMode != null) {
            this.getSession().setCacheMode(this.sessionCacheMode);
            this.sessionCacheMode = null;
        }
        this.getSession().setEnforcingFetchGraph(false);
    }

    @Override
    public ScrollableResultsImplementor<R> scroll() {
        Dialect dialect = this.getSession().getJdbcServices().getJdbcEnvironment().getDialect();
        return this.scroll(dialect.defaultScrollMode());
    }

    @Override
    public Stream<R> stream() {
        if (this.getMaxResults() == 0) {
            Spliterator spliterator = Spliterators.emptySpliterator();
            return StreamSupport.stream(spliterator, false);
        }
        ScrollableResults scrollableResults = this.scroll(ScrollMode.FORWARD_ONLY);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator(scrollableResults);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return new StreamDecorator(StreamSupport.stream(spliterator, false), ((ScrollableResultsImplementor)scrollableResults)::close);
    }

    @Override
    public Optional<R> uniqueResultOptional() {
        return Optional.ofNullable(this.uniqueResult());
    }

    @Override
    public List<R> list() {
        this.beforeQuery();
        try {
            List<R> list = this.doList();
            return list;
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException he) {
            throw this.getExceptionConverter().convert(he, this.getLockOptions());
        }
        finally {
            this.afterQuery();
        }
    }

    protected boolean isCallable() {
        return false;
    }

    protected List<R> doList() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    protected abstract QueryParameterBindings getQueryParameterBindings();

    @Override
    public R uniqueResult() {
        return AbstractProducedQuery.uniqueElement(this.list());
    }

    @Override
    public R getSingleResult() {
        try {
            List<R> list = this.list();
            if (list.size() == 0) {
                throw new NoResultException("No entity found for query");
            }
            return AbstractProducedQuery.uniqueElement(list);
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e, this.getLockOptions());
        }
    }

    public static <R> R uniqueElement(List<R> list) throws NonUniqueResultException {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        R first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new NonUniqueResultException(list.size());
        }
        return first;
    }

    public int executeUpdate() throws HibernateException {
        this.getSession().checkTransactionNeededForUpdateOperation("Executing an update/delete query");
        this.beforeQuery();
        try {
            int n = this.doExecuteUpdate();
            return n;
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException((Throwable)((Object)e));
        }
        catch (HibernateException e) {
            throw this.getExceptionConverter().convert(e);
        }
        finally {
            this.afterQuery();
        }
    }

    protected int doExecuteUpdate() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    protected String resolveEntityName(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("entity for parameter binding cannot be null");
        }
        return this.getSession().bestGuessEntityName(val);
    }

    @Override
    public void setOptionalEntityName(String optionalEntityName) {
        this.optionalEntityName = optionalEntityName;
    }

    @Override
    public void setOptionalId(Serializable optionalId) {
        this.optionalId = optionalId;
    }

    @Override
    public void setOptionalObject(Object optionalObject) {
        this.optionalObject = optionalObject;
    }

    protected boolean isSelect() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    protected ExceptionConverter getExceptionConverter() {
        return this.producer.getExceptionConverter();
    }

    private boolean isRegisteredAsBasicType(Class cl) {
        return this.producer.getFactory().getTypeConfiguration().getBasicTypeRegistry().getRegisteredType(cl.getName()) != null;
    }
}

