/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.Arrays;
import java.util.Collection;
import javax.persistence.TemporalType;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.BindingTypeHelper;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindingTypeResolver;
import org.hibernate.query.spi.QueryParameterBindingValidator;
import org.hibernate.type.spi.TypeConfiguration;

public class QueryParameterBindingImpl<T>
implements QueryParameterBinding<T> {
    private final QueryParameter<T> queryParameter;
    private final QueryParameterBindingTypeResolver typeResolver;
    private final boolean isBindingValidationRequired;
    private boolean isBound;
    private boolean isMultiValued;
    private AllowableParameterType<T> bindType;
    private MappingModelExpressable<T> type;
    private TemporalType explicitTemporalPrecision;
    private T bindValue;
    private Collection<T> bindValues;

    public QueryParameterBindingImpl(QueryParameter<T> queryParameter, QueryParameterBindingTypeResolver typeResolver, boolean isBindingValidationRequired) {
        this.queryParameter = queryParameter;
        this.typeResolver = typeResolver;
        this.isBindingValidationRequired = isBindingValidationRequired;
        this.bindType = queryParameter.getHibernateType();
    }

    public QueryParameterBindingImpl(QueryParameter<T> queryParameter, QueryParameterBindingTypeResolver typeResolver, AllowableParameterType<T> bindType, boolean isBindingValidationRequired) {
        this.queryParameter = queryParameter;
        this.typeResolver = typeResolver;
        this.isBindingValidationRequired = isBindingValidationRequired;
        this.bindType = bindType;
    }

    @Override
    public AllowableParameterType<T> getBindType() {
        return this.bindType;
    }

    @Override
    public TemporalType getExplicitTemporalPrecision() {
        return this.explicitTemporalPrecision;
    }

    @Override
    public boolean isBound() {
        return this.isBound;
    }

    @Override
    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    @Override
    public T getBindValue() {
        if (this.isMultiValued) {
            throw new IllegalStateException("Binding is multi-valued; illegal call to #getBindValue");
        }
        return this.bindValue;
    }

    @Override
    public void setBindValue(T value) {
        if (this.handleAsMultiValue(value)) {
            return;
        }
        if (this.isBindingValidationRequired) {
            this.validate(value);
        }
        this.bindValue(value);
    }

    private boolean handleAsMultiValue(T value) {
        if (!this.queryParameter.allowsMultiValuedBinding()) {
            return false;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Collection) {
            this.setBindValues((Collection)value);
            return true;
        }
        if (value.getClass().isArray()) {
            this.setBindValues(Arrays.asList((Object[])value));
            return true;
        }
        return false;
    }

    private void bindValue(T value) {
        this.isBound = true;
        this.bindValue = value;
        if (this.bindType == null) {
            this.bindType = this.typeResolver.resolveParameterBindType(value);
        }
    }

    @Override
    public void setBindValue(T value, AllowableParameterType<T> clarifiedType) {
        if (this.handleAsMultiValue(value)) {
            return;
        }
        if (this.isBindingValidationRequired) {
            this.validate(value, clarifiedType);
        }
        this.bindValue(value);
        if (clarifiedType != null) {
            this.bindType = clarifiedType;
        }
    }

    @Override
    public void setBindValue(T value, TemporalType temporalTypePrecision) {
        if (this.handleAsMultiValue(value)) {
            return;
        }
        if (this.isBindingValidationRequired) {
            this.validate(value, temporalTypePrecision);
        }
        this.bindValue(value);
        this.bindType = BindingTypeHelper.INSTANCE.resolveDateTemporalTypeVariant(this.getBindType().getExpressableJavaTypeDescriptor().getJavaTypeClass(), this.getBindType());
        this.explicitTemporalPrecision = temporalTypePrecision;
    }

    @Override
    public Collection<T> getBindValues() {
        if (!this.isMultiValued) {
            throw new IllegalStateException("Binding is not multi-valued; illegal call to #getBindValues");
        }
        return this.bindValues;
    }

    @Override
    public void setBindValues(Collection<T> values) {
        this.isBound = true;
        this.isMultiValued = true;
        this.bindValue = null;
        this.bindValues = values;
        if (this.bindType == null && !values.isEmpty()) {
            this.bindType = this.typeResolver.resolveParameterBindType(values.iterator().next());
        }
    }

    @Override
    public void setBindValues(Collection<T> values, AllowableParameterType<T> clarifiedType) {
        this.setBindValues(values);
        if (clarifiedType != null) {
            this.bindType = clarifiedType;
        }
    }

    @Override
    public void setBindValues(Collection<T> values, TemporalType temporalTypePrecision, TypeConfiguration typeConfiguration) {
        this.setBindValues(values);
        this.bindType = BindingTypeHelper.INSTANCE.resolveTemporalPrecision(temporalTypePrecision, this.bindType, typeConfiguration);
        this.explicitTemporalPrecision = temporalTypePrecision;
    }

    @Override
    public MappingModelExpressable getType() {
        return this.type;
    }

    @Override
    public void setType(MappingModelExpressable type) {
        this.type = type;
    }

    private void validate(T value) {
        QueryParameterBindingValidator.INSTANCE.validate(this.getBindType(), value);
    }

    private void validate(T value, AllowableParameterType clarifiedType) {
        QueryParameterBindingValidator.INSTANCE.validate(clarifiedType, value);
    }

    private void validate(T value, TemporalType clarifiedTemporalType) {
        QueryParameterBindingValidator.INSTANCE.validate(this.getBindType(), value, clarifiedTemporalType);
    }
}

