/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.Objects;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.AbstractQueryParameter;
import org.hibernate.query.named.NamedQueryMemento;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public class QueryParameterNamedImpl<T>
extends AbstractQueryParameter<T> {
    private final String name;

    public static <T> QueryParameterNamedImpl<T> fromSqm(SqmParameter parameter) {
        assert (parameter.getName() != null);
        assert (parameter.getPosition() == null);
        return new QueryParameterNamedImpl<T>(parameter.getName(), parameter.allowMultiValuedBinding(), parameter.getAnticipatedType());
    }

    public static <T> QueryParameterNamedImpl<T> fromNativeQuery(String name) {
        return new QueryParameterNamedImpl<T>(name, false, null);
    }

    private QueryParameterNamedImpl(String name, boolean allowMultiValuedBinding, AllowableParameterType anticipatedType) {
        super(allowMultiValuedBinding, anticipatedType);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NamedQueryMemento.ParameterMemento toMemento() {
        return session -> new QueryParameterNamedImpl<T>(this.getName(), this.allowsMultiValuedBinding(), this.getHibernateType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryParameterNamedImpl that = (QueryParameterNamedImpl)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }
}

