/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.function.Consumer;
import javax.persistence.ColumnResult;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.ResultMementoBasic;
import org.hibernate.query.results.ResultBuilderBasicValued;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValuedStandard;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class ResultMementoBasicStandard
implements ResultMementoBasic {
    public final String explicitColumnName;
    private final BasicType<?> explicitType;
    private final JavaTypeDescriptor<?> explicitJavaTypeDescriptor;

    public ResultMementoBasicStandard(ColumnResult definition, ResultSetMappingResolutionContext context) {
        this.explicitColumnName = definition.name();
        Class definedType = definition.type();
        if (Void.TYPE == definedType) {
            this.explicitJavaTypeDescriptor = null;
        } else {
            SessionFactoryImplementor sessionFactory = context.getSessionFactory();
            TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
            JavaTypeDescriptorRegistry jtdRegistry = typeConfiguration.getJavaTypeDescriptorRegistry();
            this.explicitJavaTypeDescriptor = jtdRegistry.getDescriptor(definition.type());
        }
        this.explicitType = null;
    }

    public ResultMementoBasicStandard(String explicitColumnName, BasicType<?> explicitType, ResultSetMappingResolutionContext context) {
        this.explicitColumnName = explicitColumnName;
        this.explicitType = explicitType;
        this.explicitJavaTypeDescriptor = explicitType != null ? explicitType.getJavaTypeDescriptor() : null;
    }

    @Override
    public ResultBuilderBasicValued resolve(Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        return new CompleteResultBuilderBasicValuedStandard(this.explicitColumnName, this.explicitType, this.explicitJavaTypeDescriptor);
    }
}

