/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.named.NamedResultSetMappingMemento;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.JdbcValuesMappingImpl;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultSetMapping;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMapping;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;

@Incubating
@Internal
public class ResultSetMappingImpl
implements ResultSetMapping {
    private final String mappingIdentifier;
    private List<ResultBuilder> resultBuilders;
    private Map<String, Map<String, DynamicFetchBuilderLegacy>> legacyFetchBuilders;

    public ResultSetMappingImpl(String mappingIdentifier) {
        this.mappingIdentifier = mappingIdentifier;
    }

    @Override
    public int getNumberOfResultBuilders() {
        return this.resultBuilders == null ? 0 : this.resultBuilders.size();
    }

    public List<ResultBuilder> getResultBuilders() {
        return Collections.unmodifiableList(this.resultBuilders);
    }

    @Override
    public void visitResultBuilders(BiConsumer<Integer, ResultBuilder> resultBuilderConsumer) {
        if (this.resultBuilders == null) {
            return;
        }
        for (int i = 0; i < this.resultBuilders.size(); ++i) {
            resultBuilderConsumer.accept(i, this.resultBuilders.get(i));
        }
    }

    @Override
    public void addResultBuilder(ResultBuilder resultBuilder) {
        if (this.resultBuilders == null) {
            this.resultBuilders = new ArrayList<ResultBuilder>();
        }
        this.resultBuilders.add(resultBuilder);
    }

    @Override
    public void addLegacyFetchBuilder(DynamicFetchBuilderLegacy fetchBuilder) {
        Map<String, DynamicFetchBuilderLegacy> fetchBuildersByOwner;
        Map<String, DynamicFetchBuilderLegacy> existingFetchBuildersByOwner;
        if (this.legacyFetchBuilders == null) {
            this.legacyFetchBuilders = new HashMap<String, Map<String, DynamicFetchBuilderLegacy>>();
            existingFetchBuildersByOwner = null;
        } else {
            existingFetchBuildersByOwner = this.legacyFetchBuilders.get(fetchBuilder.getOwnerAlias());
        }
        if (existingFetchBuildersByOwner == null) {
            fetchBuildersByOwner = new HashMap<String, DynamicFetchBuilderLegacy>();
            this.legacyFetchBuilders.put(fetchBuilder.getOwnerAlias(), fetchBuildersByOwner);
        } else {
            fetchBuildersByOwner = existingFetchBuildersByOwner;
        }
        DynamicFetchBuilderLegacy previousBuilder = fetchBuildersByOwner.put(fetchBuilder.getFetchableName(), fetchBuilder);
        if (previousBuilder != null) {
            // empty if block
        }
    }

    @Override
    public void addAffectedTableNames(Set<String> affectedTableNames, SessionFactoryImplementor sessionFactory) {
        if (StringHelper.isEmpty(this.mappingIdentifier)) {
            return;
        }
        EntityPersister entityDescriptor = sessionFactory.getMetamodel().findEntityDescriptor(this.mappingIdentifier);
        if (entityDescriptor == null) {
            return;
        }
        Collections.addAll(affectedTableNames, (String[])entityDescriptor.getQuerySpaces());
    }

    @Override
    public JdbcValuesMapping resolve(JdbcValuesMetadata jdbcResultsMetadata, SessionFactoryImplementor sessionFactory) {
        int numberOfResults = this.resultBuilders == null ? jdbcResultsMetadata.getColumnCount() : this.resultBuilders.size();
        ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>(jdbcResultsMetadata.getColumnCount());
        ArrayList domainResults = new ArrayList(numberOfResults);
        DomainResultCreationStateImpl creationState = new DomainResultCreationStateImpl(this.mappingIdentifier, jdbcResultsMetadata, this.legacyFetchBuilders, sqlSelections::add, sessionFactory);
        for (int i = 0; i < numberOfResults; ++i) {
            ResultBuilder resultBuilder;
            ResultBuilder resultBuilder2 = resultBuilder = this.resultBuilders != null ? this.resultBuilders.get(i) : null;
            DomainResult<?> domainResult = resultBuilder == null ? this.makeImplicitDomainResult(i, sqlSelections::add, jdbcResultsMetadata, sessionFactory) : resultBuilder.buildResult(jdbcResultsMetadata, domainResults.size(), creationState.getLegacyFetchResolver()::resolve, creationState);
            if (domainResult.containsAnyNonScalarResults()) {
                creationState.disallowPositionalSelections();
            }
            domainResults.add(domainResult);
        }
        return new JdbcValuesMappingImpl(sqlSelections, domainResults);
    }

    private DomainResult<?> makeImplicitDomainResult(int valuesArrayPosition, Consumer<SqlSelection> sqlSelectionConsumer, JdbcValuesMetadata jdbcResultsMetadata, SessionFactoryImplementor sessionFactory) {
        int jdbcPosition = valuesArrayPosition + 1;
        BasicType jdbcMapping = jdbcResultsMetadata.resolveType(jdbcPosition, null);
        String name = jdbcResultsMetadata.resolveColumnName(jdbcPosition);
        SqlSelectionImpl sqlSelection = new SqlSelectionImpl(valuesArrayPosition, jdbcMapping);
        sqlSelectionConsumer.accept(sqlSelection);
        return new BasicResult(valuesArrayPosition, name, jdbcMapping.getJavaTypeDescriptor());
    }

    @Override
    public NamedResultSetMappingMemento toMemento(String name) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }
}

