/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.Internal;
import org.hibernate.query.results.FromClauseAccessImpl;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

@Internal
public class SqlAstProcessingStateImpl
implements SqlAstProcessingState,
SqlExpressionResolver {
    private final FromClauseAccessImpl fromClauseAccess;
    private final Map<String, SqlSelectionImpl> sqlSelectionMap = new HashMap<String, SqlSelectionImpl>();
    private final Consumer<SqlSelection> sqlSelectionConsumer;
    private final SqlAstCreationState sqlAstCreationState;

    public SqlAstProcessingStateImpl(FromClauseAccessImpl fromClauseAccess, Consumer<SqlSelection> sqlSelectionConsumer, SqlAstCreationState sqlAstCreationState) {
        this.fromClauseAccess = fromClauseAccess;
        this.sqlSelectionConsumer = sqlSelectionConsumer;
        this.sqlAstCreationState = sqlAstCreationState;
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return null;
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this.sqlAstCreationState;
    }

    public int getNumberOfProcessedSelections() {
        return this.sqlSelectionMap.size();
    }

    @Override
    public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
        SqlSelectionImpl existing = this.sqlSelectionMap.get(key);
        if (existing != null) {
            return existing;
        }
        Expression created = creator.apply(this);
        if (created instanceof SqlSelectionImpl) {
            this.sqlSelectionMap.put(key, (SqlSelectionImpl)created);
            this.sqlSelectionConsumer.accept((SqlSelectionImpl)created);
        } else if (created instanceof ColumnReference) {
            ColumnReference columnReference = (ColumnReference)created;
            SqlSelectionImpl sqlSelection = new SqlSelectionImpl(this.sqlSelectionMap.size() + 1, columnReference.getJdbcMapping());
            this.sqlSelectionMap.put(key, sqlSelection);
            this.sqlSelectionConsumer.accept(sqlSelection);
        }
        return created;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        assert (expression instanceof SqlSelectionImpl);
        return (SqlSelection)((Object)expression);
    }

    public FromClauseAccess getFromClauseAccess() {
        return this.fromClauseAccess;
    }
}

