/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValued;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class CompleteResultBuilderBasicValuedStandard
implements CompleteResultBuilderBasicValued {
    private final String explicitColumnName;
    private final BasicValuedMapping explicitType;
    private final JavaTypeDescriptor<?> explicitJavaTypeDescriptor;

    public CompleteResultBuilderBasicValuedStandard(String explicitColumnName, BasicValuedMapping explicitType, JavaTypeDescriptor<?> explicitJavaTypeDescriptor) {
        this.explicitColumnName = explicitColumnName;
        this.explicitType = explicitType;
        this.explicitJavaTypeDescriptor = explicitJavaTypeDescriptor;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        String columnName;
        int jdbcPosition;
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        SessionFactoryImplementor sessionFactory = creationStateImpl.getSessionFactory();
        if (this.explicitColumnName != null) {
            jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(this.explicitColumnName);
            columnName = this.explicitColumnName;
        } else {
            jdbcPosition = resultPosition + 1;
            columnName = jdbcResultsMetadata.resolveColumnName(jdbcPosition);
        }
        int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
        BasicType<?> basicType = this.explicitType != null ? this.explicitType : jdbcResultsMetadata.resolveType(jdbcPosition, this.explicitJavaTypeDescriptor);
        creationStateImpl.resolveSqlSelection(creationStateImpl.resolveSqlExpression(columnName, processingState -> new SqlSelectionImpl(valuesArrayPosition, basicType)), this.explicitJavaTypeDescriptor, sessionFactory.getTypeConfiguration());
        return new BasicResult(valuesArrayPosition, columnName, basicType.getMappedType().getMappedJavaTypeDescriptor());
    }
}

