/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.dynamic;

import java.util.function.BiFunction;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.TableGroupImpl;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.dynamic.DynamicResultBuilderEntity;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.entity.EntityResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class DynamicResultBuilderEntityCalculated
implements DynamicResultBuilderEntity {
    private final NavigablePath navigablePath;
    private final EntityMappingType entityMapping;
    private final String tableAlias;
    private final LockMode explicitLockMode;
    private final SessionFactoryImplementor sessionFactory;

    public DynamicResultBuilderEntityCalculated(EntityMappingType entityMapping, String tableAlias, LockMode explicitLockMode, SessionFactoryImplementor sessionFactory) {
        this.entityMapping = entityMapping;
        this.navigablePath = new NavigablePath(entityMapping.getEntityName());
        this.tableAlias = tableAlias;
        this.explicitLockMode = explicitLockMode;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public EntityResult buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroupImpl.TableReferenceImpl tableReference = new TableGroupImpl.TableReferenceImpl(this.entityMapping.getEntityName(), this.tableAlias, false, this.sessionFactory);
        TableGroupImpl tableGroup = new TableGroupImpl(this.navigablePath, this.tableAlias, tableReference, this.entityMapping, this.explicitLockMode);
        creationStateImpl.getFromClauseAccess().registerTableGroup(this.navigablePath, tableGroup);
        return (EntityResult)this.entityMapping.createDomainResult(this.navigablePath, tableGroup, this.tableAlias, domainResultCreationState);
    }
}

