/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.function;

import java.util.AbstractMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.hibernate.query.sqm.function.JdbcEscapeFunctionDescriptor;
import org.hibernate.query.sqm.function.MultipatternSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.NamedFunctionDescriptorBuilder;
import org.hibernate.query.sqm.produce.function.PatternFunctionDescriptorBuilder;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.type.BasicType;
import org.jboss.logging.Logger;

public class SqmFunctionRegistry {
    private static final Logger log = Logger.getLogger(SqmFunctionRegistry.class);
    private final Map<String, SqmFunctionDescriptor> functionMap = new TreeMap<String, SqmFunctionDescriptor>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String> alternateKeyMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

    public SqmFunctionRegistry() {
        log.trace((Object)"SqmFunctionRegistry created");
    }

    public Map<String, SqmFunctionDescriptor> getFunctions() {
        return this.functionMap;
    }

    public Stream<Map.Entry<String, SqmFunctionDescriptor>> getFunctionsByName() {
        return Stream.concat(this.functionMap.entrySet().stream(), this.alternateKeyMap.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), this.functionMap.get(entry.getValue()))));
    }

    public SqmFunctionDescriptor findFunctionDescriptor(String functionName) {
        SqmFunctionDescriptor found = null;
        String alternateKeyResolution = this.alternateKeyMap.get(functionName);
        if (alternateKeyResolution != null) {
            found = this.functionMap.get(alternateKeyResolution);
        }
        if (found == null) {
            found = this.functionMap.get(functionName);
        }
        return found;
    }

    public SqmFunctionDescriptor register(String registrationKey, SqmFunctionDescriptor function) {
        SqmFunctionDescriptor priorRegistration = this.functionMap.put(registrationKey, function);
        log.debugf("Registered SqmFunctionTemplate [%s] under %s; prior registration was %s", (Object)function, (Object)registrationKey, (Object)priorRegistration);
        this.alternateKeyMap.remove(registrationKey);
        return function;
    }

    public SqmFunctionDescriptor registerPattern(String name, String pattern) {
        return this.patternDescriptorBuilder(name, pattern).register();
    }

    public SqmFunctionDescriptor registerPattern(String name, String pattern, BasicType returnType) {
        return this.patternDescriptorBuilder(name, pattern).setInvariantType(returnType).register();
    }

    public PatternFunctionDescriptorBuilder patternDescriptorBuilder(String registrationKey, String pattern) {
        return new PatternFunctionDescriptorBuilder(this, registrationKey, pattern);
    }

    public SqmFunctionDescriptor registerNamed(String name) {
        return this.namedDescriptorBuilder(name).register();
    }

    public SqmFunctionDescriptor registerNamed(String name, BasicType returnType) {
        return this.namedDescriptorBuilder(name, name).setInvariantType(returnType).register();
    }

    public NamedFunctionDescriptorBuilder namedDescriptorBuilder(String name) {
        return this.namedDescriptorBuilder(name, name);
    }

    public NamedFunctionDescriptorBuilder namedDescriptorBuilder(String registrationKey, String name) {
        return new NamedFunctionDescriptorBuilder(this, registrationKey, name);
    }

    public NamedFunctionDescriptorBuilder noArgsBuilder(String name) {
        return this.noArgsBuilder(name, name);
    }

    public NamedFunctionDescriptorBuilder noArgsBuilder(String registrationKey, String name) {
        return this.namedDescriptorBuilder(registrationKey, name).setExactArgumentCount(0);
    }

    public SqmFunctionDescriptor registerNoArgs(String name) {
        return this.registerNoArgs(name, name);
    }

    public SqmFunctionDescriptor registerNoArgs(String registrationKey, String name) {
        return this.noArgsBuilder(registrationKey, name).register();
    }

    public SqmFunctionDescriptor registerNoArgs(String name, BasicType returnType) {
        return this.registerNoArgs(name, name, returnType);
    }

    public SqmFunctionDescriptor registerNoArgs(String registrationKey, String name, BasicType returnType) {
        return this.noArgsBuilder(registrationKey, name).setInvariantType(returnType).register();
    }

    public SqmFunctionDescriptor wrapInJdbcEscape(String name, SqmFunctionDescriptor wrapped) {
        JdbcEscapeFunctionDescriptor wrapperTemplate = new JdbcEscapeFunctionDescriptor(name, wrapped);
        this.register(name, wrapperTemplate);
        return wrapperTemplate;
    }

    public void registerAlternateKey(String alternateKey, String mappedKey) {
        log.debugf("Registering alternate key : %s -> %s", (Object)alternateKey, (Object)mappedKey);
        this.alternateKeyMap.put(alternateKey, mappedKey);
    }

    public MultipatternSqmFunctionDescriptor registerNullaryUnaryPattern(String name, BasicType type, String pattern0, String pattern1) {
        return this.registerPatterns(name, type, pattern0, pattern1);
    }

    public MultipatternSqmFunctionDescriptor registerUnaryBinaryPattern(String name, BasicType type, String pattern1, String pattern2) {
        return this.registerPatterns(name, type, null, pattern1, pattern2);
    }

    public MultipatternSqmFunctionDescriptor registerBinaryTernaryPattern(String name, BasicType type, String pattern2, String pattern3) {
        return this.registerPatterns(name, type, null, null, pattern2, pattern3);
    }

    public MultipatternSqmFunctionDescriptor registerTernaryQuaternaryPattern(String name, BasicType type, String pattern3, String pattern4) {
        return this.registerPatterns(name, type, null, null, null, pattern3, pattern4);
    }

    private MultipatternSqmFunctionDescriptor registerPatterns(String name, BasicType type, String ... patterns) {
        SqmFunctionDescriptor[] descriptors = new SqmFunctionDescriptor[patterns.length];
        for (int i = 0; i < patterns.length; ++i) {
            String pattern = patterns[i];
            if (pattern == null) continue;
            descriptors[i] = this.patternDescriptorBuilder(name, pattern).setExactArgumentCount(i).setInvariantType(type).descriptor();
        }
        MultipatternSqmFunctionDescriptor function = new MultipatternSqmFunctionDescriptor(name, descriptors, StandardFunctionReturnTypeResolvers.invariant(type));
        this.register(name, function);
        return function;
    }

    public void overlay(SqmFunctionRegistry registryToOverly) {
        this.functionMap.forEach(registryToOverly::register);
        this.alternateKeyMap.forEach(registryToOverly::registerAlternateKey);
    }

    public void close() {
        this.functionMap.clear();
        this.alternateKeyMap.clear();
    }
}

