/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.spi.JdbcParameterBySqmParameterAccess;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public class SqmUtil {
    private SqmUtil() {
    }

    public static void verifyIsSelectStatement(SqmStatement sqm) {
        if (!(sqm instanceof SqmSelectStatement)) {
            throw new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a SELECT Query [%s], but found %s", SqmSelectStatement.class.getName(), sqm.getClass().getName()));
        }
    }

    public static void verifyIsNonSelectStatement(SqmStatement sqm) {
        if (!(sqm instanceof SqmDmlStatement)) {
            throw new IllegalQueryOperationException(String.format(Locale.ROOT, "Expecting a non-SELECT Query [%s], but found %s", SqmDmlStatement.class.getName(), sqm.getClass().getName()));
        }
    }

    public static Map<QueryParameterImplementor<?>, Map<SqmParameter, List<List<JdbcParameter>>>> generateJdbcParamsXref(DomainParameterXref domainParameterXref, JdbcParameterBySqmParameterAccess jdbcParameterBySqmParameterAccess) {
        if (domainParameterXref == null || !domainParameterXref.hasParameters()) {
            return Collections.emptyMap();
        }
        int queryParameterCount = domainParameterXref.getQueryParameterCount();
        IdentityHashMap result = new IdentityHashMap(queryParameterCount);
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter>> entry : domainParameterXref.getSqmParamByQueryParam().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter> sqmParams = entry.getValue();
            Map sqmParamMap = result.computeIfAbsent(queryParam, qp -> new IdentityHashMap(sqmParams.size()));
            for (SqmParameter sqmParam : sqmParams) {
                sqmParamMap.put(sqmParam, jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(sqmParam));
                List<SqmParameter> expansions = domainParameterXref.getExpansions(sqmParam);
                if (expansions.isEmpty()) continue;
                for (SqmParameter expansion : expansions) {
                    sqmParamMap.put(expansion, jdbcParameterBySqmParameterAccess.getJdbcParamsBySqmParam().get(expansion));
                    result.put(queryParam, sqmParamMap);
                }
            }
        }
        return result;
    }

    public static JdbcParameterBindings createJdbcParameterBindings(QueryParameterBindings domainParamBindings, DomainParameterXref domainParameterXref, Map<QueryParameterImplementor<?>, Map<SqmParameter, List<List<JdbcParameter>>>> jdbcParamXref, MappingMetamodel domainModel, Function<NavigablePath, TableGroup> tableGroupLocator, SharedSessionContractImplementor session) {
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(domainParameterXref.getSqmParameterCount());
        for (Map.Entry<QueryParameterImplementor<?>, List<SqmParameter>> entry : domainParameterXref.getSqmParamByQueryParam().entrySet()) {
            QueryParameterImplementor<?> queryParam = entry.getKey();
            List<SqmParameter> sqmParameters = entry.getValue();
            QueryParameterBinding<?> domainParamBinding = domainParamBindings.getBinding(queryParam);
            AllowableParameterType parameterType = SqmUtil.determineParameterType(domainParamBinding, queryParam, session.getFactory());
            Map<SqmParameter, List<List<JdbcParameter>>> jdbcParamMap = jdbcParamXref.get(queryParam);
            for (SqmParameter sqmParameter : sqmParameters) {
                List<JdbcParameter> jdbcParams;
                int i;
                List<List<JdbcParameter>> jdbcParamsBinds = jdbcParamMap.get(sqmParameter);
                if (!domainParamBinding.isBound()) {
                    MappingModelExpressable mappingExpressable = SqmMappingModelHelper.resolveMappingModelExpressable(sqmParameter, domainModel, tableGroupLocator);
                    for (i = 0; i < jdbcParamsBinds.size(); ++i) {
                        jdbcParams = jdbcParamsBinds.get(i);
                        mappingExpressable.forEachJdbcType((position, jdbcType) -> jdbcParameterBindings.addBinding((JdbcParameter)jdbcParams.get(position), new JdbcParameterBindingImpl((JdbcMapping)jdbcType, null)));
                    }
                    continue;
                }
                if (domainParamBinding.isMultiValued()) {
                    Collection<?> bindValues = domainParamBinding.getBindValues();
                    Iterator<?> valueItr = bindValues.iterator();
                    for (int i2 = 0; i2 < jdbcParamsBinds.size(); ++i2) {
                        List<JdbcParameter> jdbcParams2 = jdbcParamsBinds.get(i2);
                        SqmUtil.createValueBindings(jdbcParameterBindings, domainParamBinding, parameterType, jdbcParams2, valueItr.next(), session);
                    }
                    List<SqmParameter> expansions = domainParameterXref.getExpansions(sqmParameter);
                    assert (expansions.size() == bindValues.size() - 1);
                    int expansionPosition = 0;
                    while (valueItr.hasNext()) {
                        SqmParameter expansionSqmParam = expansions.get(expansionPosition++);
                        List<List<JdbcParameter>> jdbcParamBinds = jdbcParamMap.get(expansionSqmParam);
                        for (int i3 = 0; i3 < jdbcParamBinds.size(); ++i3) {
                            List<JdbcParameter> expansionJdbcParams = jdbcParamBinds.get(i3);
                            SqmUtil.createValueBindings(jdbcParameterBindings, domainParamBinding, parameterType, expansionJdbcParams, valueItr.next(), session);
                        }
                    }
                    continue;
                }
                if (domainParamBinding.getBindValue() == null) {
                    for (int i4 = 0; i4 < jdbcParamsBinds.size(); ++i4) {
                        List<JdbcParameter> jdbcParams3 = jdbcParamsBinds.get(i4);
                        for (int j = 0; j < jdbcParams3.size(); ++j) {
                            JdbcParameter jdbcParameter = jdbcParams3.get(j);
                            jdbcParameterBindings.addBinding(jdbcParameter, new JdbcParameterBindingImpl(null, null));
                        }
                    }
                    continue;
                }
                Object bindValue = domainParamBinding.getBindValue();
                for (i = 0; i < jdbcParamsBinds.size(); ++i) {
                    jdbcParams = jdbcParamsBinds.get(i);
                    SqmUtil.createValueBindings(jdbcParameterBindings, domainParamBinding, parameterType, jdbcParams, bindValue, session);
                }
            }
        }
        return jdbcParameterBindings;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void createValueBindings(JdbcParameterBindings jdbcParameterBindings, QueryParameterBinding<?> domainParamBinding, AllowableParameterType<?> parameterType, List<JdbcParameter> jdbcParams, Object bindValue, SharedSessionContractImplementor session) {
        ForeignKeyDescriptor mappingExpressable;
        MappingMetamodel domainModel = session.getFactory().getDomainModel();
        if (parameterType == null) {
            if (domainParamBinding.getType() == null) throw new IllegalStateException("Parameter has no type by which it can be bound: " + jdbcParameterBindings);
            ForeignKeyDescriptor type = domainParamBinding.getType();
            if (type instanceof EntityIdentifierMapping) {
                mappingExpressable = type;
                EntityIdentifierMapping identifierMapping = (EntityIdentifierMapping)((Object)type);
                if (!identifierMapping.getJavaTypeDescriptor().getJavaTypeClass().isInstance(bindValue)) {
                    bindValue = identifierMapping.getIdentifier(bindValue, session);
                }
            } else if (type instanceof ToOneAttributeMapping) {
                ToOneAttributeMapping association = (ToOneAttributeMapping)((Object)type);
                bindValue = association.getForeignKeyDescriptor().getAssociationKeyFromTarget(bindValue, session);
                mappingExpressable = association.getForeignKeyDescriptor();
            } else {
                mappingExpressable = type;
            }
        } else {
            mappingExpressable = domainModel.resolveMappingExpressable(parameterType);
        }
        int offset = jdbcParameterBindings.registerParametersForEachJdbcValue(bindValue, Clause.IRRELEVANT, mappingExpressable, jdbcParams, session);
        assert (offset == jdbcParams.size());
        return;
    }

    public static AllowableParameterType determineParameterType(QueryParameterBinding<?> binding, QueryParameterImplementor<?> parameter, SessionFactoryImplementor sessionFactory) {
        if (binding.getBindType() != null) {
            return binding.getBindType();
        }
        if (parameter.getHibernateType() != null) {
            return parameter.getHibernateType();
        }
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        BasicType basicType = typeConfiguration.standardBasicTypeForJavaType(parameter.getParameterType());
        return basicType;
    }
}

