/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.MutableInteger;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.mutation.internal.idtable.TableBasedDeleteHandler;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class UnrestrictedDeleteExecutionDelegate
implements TableBasedDeleteHandler.ExecutionDelegate {
    private final EntityMappingType entityDescriptor;

    public UnrestrictedDeleteExecutionDelegate(EntityMappingType entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        MutableInteger result = new MutableInteger();
        SqmMutationStrategyHelper.cleanUpCollectionTables(this.entityDescriptor, (tableReference, attributeMapping) -> null, JdbcParameterBindings.NO_BINDINGS, executionContext);
        this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnsVisitationSupplier) -> {
            int rows = this.deleteFrom(tableExpression, executionContext);
            result.set(rows);
        });
        return result.get();
    }

    private int deleteFrom(String tableExpression, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        FilterPredicate predicate = null;
        if (!(this.entityDescriptor instanceof JoinedSubclassEntityPersister) || tableExpression.equals(((JoinedSubclassEntityPersister)this.entityDescriptor).getTableName())) {
            predicate = FilterHelper.createFilterPredicate(executionContext.getLoadQueryInfluencers(), (Joinable)((Object)this.entityDescriptor));
        }
        DeleteStatement deleteStatement = new DeleteStatement(new TableReference(tableExpression, null, true, factory), predicate);
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(1);
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        JdbcDelete jdbcDelete = sqlAstTranslatorFactory.buildDeleteTranslator(factory, deleteStatement).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        return jdbcServices.getJdbcMutationExecutor().execute(jdbcDelete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, SqlOmittingQueryOptions.omitSqlQueryOptions(executionContext));
    }
}

