/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import java.sql.PreparedStatement;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectionConsumer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.SqlOmittingQueryOptions;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MatchingIdSelectionHelper;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.StatementCreatorHelper;

public class InlineDeleteHandler
implements DeleteHandler {
    private final MatchingIdRestrictionProducer matchingIdsPredicateProducer;
    private final SqmDeleteStatement sqmDeleteStatement;
    private final DomainParameterXref domainParameterXref;
    private final ExecutionContext executionContext;
    private final SessionFactoryImplementor sessionFactory;
    private final SqlAstTranslatorFactory sqlAstTranslatorFactory;
    private final JdbcMutationExecutor jdbcMutationExecutor;

    protected InlineDeleteHandler(MatchingIdRestrictionProducer matchingIdsPredicateProducer, SqmDeleteStatement sqmDeleteStatement, DomainParameterXref domainParameterXref, ExecutionContext context) {
        this.sqmDeleteStatement = sqmDeleteStatement;
        this.domainParameterXref = domainParameterXref;
        this.matchingIdsPredicateProducer = matchingIdsPredicateProducer;
        this.executionContext = context;
        this.sessionFactory = this.executionContext.getSession().getFactory();
        this.sqlAstTranslatorFactory = this.sessionFactory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory();
        this.jdbcMutationExecutor = this.sessionFactory.getJdbcServices().getJdbcMutationExecutor();
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        List<Object> ids = MatchingIdSelectionHelper.selectMatchingIds(this.sqmDeleteStatement, this.domainParameterXref, executionContext);
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        String mutatingEntityName = ((SqmRoot)this.sqmDeleteStatement.getTarget()).getModel().getHibernateEntityName();
        EntityPersister entityDescriptor = factory.getDomainModel().getEntityDescriptor(mutatingEntityName);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.domainParameterXref.getQueryParameterCount());
        entityDescriptor.visitAttributeMappings(attribute -> {
            PluralAttributeMapping pluralAttribute;
            if (!(attribute instanceof PluralAttributeMapping) || (pluralAttribute = (PluralAttributeMapping)attribute).getSeparateCollectionTable() != null) {
                // empty if block
            }
        });
        entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnsVisitationSupplier) -> this.executeDelete(tableExpression, entityDescriptor, tableKeyColumnsVisitationSupplier, ids, jdbcParameterBindings, executionContext));
        return ids.size();
    }

    private void executeDelete(String targetTableExpression, EntityMappingType entityDescriptor, Supplier<Consumer<SelectionConsumer>> tableKeyColumnsVisitationSupplier, List<Object> ids, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        TableReference targetTableReference = new TableReference(targetTableExpression, null, false, this.sessionFactory);
        Predicate matchingIdsPredicate = this.matchingIdsPredicateProducer.produceRestriction(ids, entityDescriptor, targetTableReference, tableKeyColumnsVisitationSupplier, executionContext);
        DeleteStatement deleteStatement = new DeleteStatement(targetTableReference, matchingIdsPredicate);
        JdbcDelete jdbcOperation = this.sqlAstTranslatorFactory.buildDeleteTranslator(this.sessionFactory, deleteStatement).translate(jdbcParameterBindings, executionContext.getQueryOptions());
        this.jdbcMutationExecutor.execute(jdbcOperation, jdbcParameterBindings, this::prepareQueryStatement, (integer, preparedStatement) -> {}, SqlOmittingQueryOptions.omitSqlQueryOptions(executionContext));
    }

    private PreparedStatement prepareQueryStatement(String sql) {
        return StatementCreatorHelper.prepareQueryStatement(sql, this.executionContext.getSession());
    }
}

