/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.TemporalType;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.boot.model.process.internal.InferredBasicValueResolver;
import org.hibernate.dialect.function.TimestampaddFunction;
import org.hibernate.dialect.function.TimestampdiffFunction;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.graph.spi.AppliedGraph;
import org.hibernate.internal.FilterHelper;
import org.hibernate.internal.util.NullnessHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.loader.MultipleBagFetchException;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.Association;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityAssociationMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.CompositeSqmPathSource;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.DynamicInstantiationNature;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.QueryLogging;
import org.hibernate.query.SemanticException;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.InterpretationException;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmMappingModelHelper;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.sql.ConversionException;
import org.hibernate.query.sqm.sql.FromClauseIndex;
import org.hibernate.query.sqm.sql.SqmTranslation;
import org.hibernate.query.sqm.sql.SqmTranslator;
import org.hibernate.query.sqm.sql.StandardSqmTranslation;
import org.hibernate.query.sqm.sql.internal.BasicValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.sql.internal.EmbeddableValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.EntityValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.NonAggregatedCompositeValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.PluralValuedSimplePathInterpretation;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqlAstQueryPartProcessingStateImpl;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteTable;
import org.hibernate.query.sqm.tree.cte.SqmCteTableColumn;
import org.hibernate.query.sqm.tree.cte.SqmSearchClauseSpecification;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.domain.AbstractSqmFrom;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.NonAggregatedCompositeSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmAny;
import org.hibernate.query.sqm.tree.expression.SqmBinaryArithmetic;
import org.hibernate.query.sqm.tree.expression.SqmByUnit;
import org.hibernate.query.sqm.tree.expression.SqmCaseSearched;
import org.hibernate.query.sqm.tree.expression.SqmCaseSimple;
import org.hibernate.query.sqm.tree.expression.SqmCastTarget;
import org.hibernate.query.sqm.tree.expression.SqmCollate;
import org.hibernate.query.sqm.tree.expression.SqmDistinct;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.query.sqm.tree.expression.SqmEnumLiteral;
import org.hibernate.query.sqm.tree.expression.SqmEvery;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExtractUnit;
import org.hibernate.query.sqm.tree.expression.SqmFieldLiteral;
import org.hibernate.query.sqm.tree.expression.SqmFormat;
import org.hibernate.query.sqm.tree.expression.SqmFunction;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmLiteral;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmPathEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.query.sqm.tree.expression.SqmStar;
import org.hibernate.query.sqm.tree.expression.SqmSummarization;
import org.hibernate.query.sqm.tree.expression.SqmToDuration;
import org.hibernate.query.sqm.tree.expression.SqmTrimSpecification;
import org.hibernate.query.sqm.tree.expression.SqmTuple;
import org.hibernate.query.sqm.tree.expression.SqmUnaryOperation;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.query.sqm.tree.insert.SqmInsertValuesStatement;
import org.hibernate.query.sqm.tree.insert.SqmValues;
import org.hibernate.query.sqm.tree.predicate.SqmAndPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBetweenPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmBooleanExpressionPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmComparisonPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmEmptinessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmExistsPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmGroupedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInListPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmInSubQueryPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmLikePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmMemberOfPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNullnessPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmOrPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmWhereClause;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQueryPartProcessingState;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.cte.SearchClauseSpecification;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Collate;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.NullnessLiteral;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignable;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.spi.JdbcParameters;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.EntityGraphTraversalState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.instantiation.internal.DynamicInstantiation;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.StandardEntityGraphTraversalStateImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public abstract class BaseSqmToSqlAstConverter<T extends Statement>
extends BaseSemanticQueryWalker
implements SqmTranslator<T>,
DomainResultCreationState,
SqlTypeDescriptorIndicators {
    private static final Logger log = Logger.getLogger(BaseSqmToSqlAstConverter.class);
    private final SqlAstCreationContext creationContext;
    private final SqmStatement<?> statement;
    private final QueryOptions queryOptions;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final DomainParameterXref domainParameterXref;
    private final QueryParameterBindings domainParameterBindings;
    private final Map<JpaCriteriaParameter<?>, Supplier<SqmJpaCriteriaParameterWrapper<?>>> jpaCriteriaParamResolutions;
    private final List<DomainResult> domainResults;
    private final EntityGraphTraversalState entityGraphTraversalState;
    private int fetchDepth;
    private Map<String, FilterPredicate> collectionFilterPredicates;
    private OrderByFragmentConsumer orderByFragmentConsumer;
    private Map<String, NavigablePath> joinPathBySqmJoinFullPath = new HashMap<String, NavigablePath>();
    private final SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
    private final Stack<SqlAstProcessingState> processingStateStack = new StandardStack<SqlAstProcessingState>();
    private final Stack<FromClauseIndex> fromClauseIndexStack = new StandardStack<FromClauseIndex>();
    private SqlAstProcessingState lastPoppedProcessingState;
    private FromClauseIndex lastPoppedFromClauseIndex;
    private final Stack<Clause> currentClauseStack = new StandardStack<Clause>();
    private SqmByUnit appliedByUnit;
    private Expression adjustedTimestamp;
    private SqmExpressable<?> adjustedTimestampType;
    private Expression adjustmentScale;
    private boolean negativeAdjustment;
    protected Predicate additionalRestrictions;
    private final Map<SqmParameter, List<List<JdbcParameter>>> jdbcParamsBySqmParam = new IdentityHashMap<SqmParameter, List<List<JdbcParameter>>>();
    private final JdbcParameters jdbcParameters = new JdbcParametersImpl();
    protected final Stack<Supplier<MappingModelExpressable>> inferableTypeAccessStack = new StandardStack<Supplier<MappingModelExpressable>>(() -> null);

    public BaseSqmToSqlAstConverter(SqlAstCreationContext creationContext, SqmStatement<?> statement, QueryOptions queryOptions, LoadQueryInfluencers loadQueryInfluencers, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings) {
        super(creationContext.getServiceRegistry());
        this.creationContext = creationContext;
        this.statement = statement;
        if (statement instanceof SqmSelectStatement) {
            this.domainResults = new ArrayList<DomainResult>(((SqmQueryPart)((SqmSelectStatement)statement).getQueryPart()).getFirstQuerySpec().getSelectClause().getSelectionItems().size());
            AppliedGraph appliedGraph = queryOptions.getAppliedGraph();
            this.entityGraphTraversalState = appliedGraph != null && appliedGraph.getSemantic() != null && appliedGraph.getGraph() != null ? new StandardEntityGraphTraversalStateImpl(appliedGraph.getSemantic(), appliedGraph.getGraph()) : null;
        } else if (statement instanceof SqmInsertSelectStatement) {
            this.domainResults = new ArrayList<DomainResult>(((SqmInsertSelectStatement)statement).getSelectQueryPart().getFirstQuerySpec().getSelectClause().getSelectionItems().size());
            this.entityGraphTraversalState = null;
        } else {
            this.domainResults = null;
            this.entityGraphTraversalState = null;
        }
        this.queryOptions = queryOptions;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.domainParameterXref = domainParameterXref;
        this.domainParameterBindings = domainParameterBindings;
        this.jpaCriteriaParamResolutions = domainParameterXref.getParameterResolutions().getJpaCriteriaParamResolutions();
    }

    protected Stack<SqlAstProcessingState> getProcessingStateStack() {
        return this.processingStateStack;
    }

    protected void pushProcessingState(SqlAstProcessingState processingState) {
        this.pushProcessingState(processingState, new FromClauseIndex(this.getFromClauseIndex()));
    }

    protected void pushProcessingState(SqlAstProcessingState processingState, FromClauseIndex fromClauseIndex) {
        this.fromClauseIndexStack.push(fromClauseIndex);
        this.processingStateStack.push(processingState);
    }

    protected void popProcessingStateStack() {
        this.lastPoppedFromClauseIndex = this.fromClauseIndexStack.pop();
        this.lastPoppedProcessingState = this.processingStateStack.pop();
    }

    protected SqmStatement<?> getStatement() {
        return this.statement;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.creationContext.getSessionFactory().getTypeConfiguration();
    }

    @Override
    public int getPreferredSqlTypeCodeForBoolean() {
        return this.creationContext.getSessionFactory().getSessionFactoryOptions().getPreferredSqlTypeCodeForBoolean();
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroup(navigablePath);
    }

    @Override
    public ModelPart resolveModelPart(NavigablePath navigablePath) {
        return this.getFromClauseAccess().findTableGroup(navigablePath).getModelPart();
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this.processingStateStack.getCurrent();
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.getCurrentProcessingState().getSqlExpressionResolver();
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        LockOptions lockOptions = this.getQueryOptions().getLockOptions();
        return lockOptions.getScope() || identificationVariable == null ? lockOptions.getLockMode() : lockOptions.getEffectiveLockMode(identificationVariable);
    }

    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.loadQueryInfluencers;
    }

    public FromClauseIndex getFromClauseIndex() {
        return (FromClauseIndex)this.getFromClauseAccess();
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        FromClauseIndex fromClauseIndex = this.fromClauseIndexStack.getCurrent();
        if (fromClauseIndex == null) {
            return this.lastPoppedFromClauseIndex;
        }
        return fromClauseIndex;
    }

    @Override
    public Stack<Clause> getCurrentClauseStack() {
        return this.currentClauseStack;
    }

    @Override
    public SqmTranslation<T> translate() {
        SqmStatement<?> sqmStatement = this.getStatement();
        Statement statement = (Statement)sqmStatement.accept(this);
        return new StandardSqmTranslation<Statement>(statement, this.getJdbcParamsBySqmParam(), this.lastPoppedProcessingState.getSqlExpressionResolver(), this.getFromClauseAccess());
    }

    @Override
    public Statement visitStatement(SqmStatement<?> sqmStatement) {
        return (Statement)sqmStatement.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStatement visitUpdateStatement(SqmUpdateStatement sqmStatement) {
        Object cteStatements = this.visitCteContainer(sqmStatement);
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, sqmStatement.getRoot().getAlias(), false, LockMode.WRITE, () -> predicate -> {
                this.additionalRestrictions = predicate;
            }, this, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM DELETE");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            Object assignments = this.visitSetClause(sqmStatement.getSetClause());
            FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), (Joinable)((Object)entityDescriptor));
            if (filterPredicate != null) {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, filterPredicate);
            }
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = sqmStatement.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.getCurrentClauseStack().push(Clause.WHERE);
                try {
                    suppliedPredicate = (Predicate)whereClause.getPredicate().accept(this);
                }
                finally {
                    this.getCurrentClauseStack().pop();
                }
            }
            UpdateStatement updateStatement = new UpdateStatement(sqmStatement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, rootTableGroup.getPrimaryTableReference(), (List<Assignment>)assignments, SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions), Collections.emptyList());
            return updateStatement;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Assignment> visitSetClause(SqmSetClause setClause) {
        ArrayList<Assignment> assignments = new ArrayList<Assignment>(setClause.getAssignments().size());
        for (SqmAssignment sqmAssignment : setClause.getAssignments()) {
            SqmPathInterpretation assignedPathInterpretation;
            final ArrayList targetColumnReferences = new ArrayList();
            this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent){

                @Override
                public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                    Expression expression = this.getParentState().getSqlExpressionResolver().resolveSqlExpression(key, creator);
                    assert (expression instanceof ColumnReference);
                    targetColumnReferences.add((ColumnReference)expression);
                    return expression;
                }
            }, this.getFromClauseIndex());
            try {
                assignedPathInterpretation = (SqmPathInterpretation)sqmAssignment.getTargetPath().accept(this);
            }
            finally {
                this.popProcessingStateStack();
            }
            this.inferableTypeAccessStack.push(assignedPathInterpretation::getExpressionType);
            final ArrayList valueColumnReferences = new ArrayList();
            this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent){

                @Override
                public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
                    Expression expression = this.getParentState().getSqlExpressionResolver().resolveSqlExpression(key, creator);
                    assert (expression instanceof ColumnReference);
                    valueColumnReferences.add((ColumnReference)expression);
                    return expression;
                }
            }, this.getFromClauseIndex());
            try {
                int assignedPathJdbcCount;
                if (sqmAssignment.getValue() instanceof SqmParameter) {
                    SqmParameter sqmParameter = (SqmParameter)sqmAssignment.getValue();
                    ArrayList jdbcParametersForSqm = new ArrayList();
                    assignedPathInterpretation.getExpressionType().forEachSelection((columnIndex, selection) -> {
                        JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(selection.getJdbcMapping());
                        jdbcParametersForSqm.add(jdbcParameter);
                        assignments.add(new Assignment(new ColumnReference((String)null, selection, this.getCreationContext().getSessionFactory()), jdbcParameter));
                    });
                    this.getJdbcParamsBySqmParam().computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParametersForSqm);
                    continue;
                }
                Expression valueExpression = (Expression)sqmAssignment.getValue().accept(this);
                int valueExprJdbcCount = this.getKeyExpressable(valueExpression.getExpressionType()).getJdbcTypeCount();
                if (valueExprJdbcCount != (assignedPathJdbcCount = this.getKeyExpressable(assignedPathInterpretation.getExpressionType()).getJdbcTypeCount())) {
                    SqlTreeCreationLogger.LOGGER.debugf("JDBC type count does not match in UPDATE assignment between the assigned-path and the assigned-value; this will likely lead to problems executing the query", new Object[0]);
                }
                assert (assignedPathJdbcCount == valueExprJdbcCount);
                for (ColumnReference columnReference : targetColumnReferences) {
                    assignments.add(new Assignment(columnReference, valueExpression));
                }
            }
            finally {
                this.popProcessingStateStack();
                this.inferableTypeAccessStack.pop();
            }
        }
        return assignments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteStatement visitDeleteStatement(SqmDeleteStatement<?> statement) {
        Object cteStatements = this.visitCteContainer(statement);
        String entityName = ((SqmRoot)statement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)statement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, statement.getRoot().getAlias(), false, LockMode.WRITE, () -> predicate -> {
                this.additionalRestrictions = predicate;
            }, this, this.getCreationContext());
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            if (!rootTableGroup.getTableReferenceJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM DELETE");
            }
            FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), (Joinable)((Object)entityDescriptor));
            if (filterPredicate != null) {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, filterPredicate);
            }
            Predicate suppliedPredicate = null;
            SqmWhereClause whereClause = statement.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.getCurrentClauseStack().push(Clause.WHERE);
                try {
                    suppliedPredicate = (Predicate)whereClause.getPredicate().accept(this);
                }
                finally {
                    this.getCurrentClauseStack().pop();
                }
            }
            DeleteStatement deleteStatement = new DeleteStatement(statement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, rootTableGroup.getPrimaryTableReference(), SqlAstTreeHelper.combinePredicates(suppliedPredicate, this.additionalRestrictions), Collections.emptyList());
            return deleteStatement;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertSelectStatement(SqmInsertSelectStatement<?> sqmStatement) {
        InsertStatement insertStatement;
        Object cteStatements = this.visitCteContainer(sqmStatement);
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        SqmQueryPart<?> selectQueryPart = sqmStatement.getSelectQueryPart();
        this.pushProcessingState(new SqlAstProcessingStateImpl(null, this, r -> new SqlSelectionForSqmSelectionResolver((SqlExpressionResolver)r, selectQueryPart.getFirstQuerySpec().getSelectClause().getSelectionItems().size()), this.getCurrentClauseStack()::getCurrent));
        this.currentClauseStack.push(Clause.INSERT);
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), false, LockMode.WRITE, () -> predicate -> {
                this.additionalRestrictions = predicate;
            }, this, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            insertStatement = new InsertStatement(sqmStatement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, rootTableGroup.getPrimaryTableReference(), Collections.emptyList());
            List<SqmPath> targetPaths = sqmStatement.getInsertionTargetPaths();
            for (SqmPath target : targetPaths) {
                Assignable assignable = (Assignable)target.accept(this);
                insertStatement.addTargetColumnReferences(assignable.getColumnReferences());
            }
        }
        finally {
            this.popProcessingStateStack();
            this.currentClauseStack.pop();
        }
        insertStatement.setSourceSelectStatement((QueryPart)this.visitQueryPart((SqmQueryPart)selectQueryPart));
        return insertStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertStatement visitInsertValuesStatement(SqmInsertValuesStatement<?> sqmStatement) {
        Object cteStatements = this.visitCteContainer(sqmStatement);
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.pushProcessingState(new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = ((AbstractSqmPath)((Object)sqmStatement.getTarget())).getNavigablePath();
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, ((AbstractSqmFrom)((Object)sqmStatement.getTarget())).getExplicitAlias(), false, LockMode.WRITE, () -> predicate -> {
                this.additionalRestrictions = predicate;
            }, this, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || !rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            this.getFromClauseAccess().registerTableGroup(rootPath, rootTableGroup);
            InsertStatement insertValuesStatement = new InsertStatement(sqmStatement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, rootTableGroup.getPrimaryTableReference(), Collections.emptyList());
            List<SqmPath> targetPaths = sqmStatement.getInsertionTargetPaths();
            for (SqmPath target : targetPaths) {
                Assignable assignable = (Assignable)target.accept(this);
                insertValuesStatement.addTargetColumnReferences(assignable.getColumnReferences());
            }
            List<SqmValues> valuesList = sqmStatement.getValuesList();
            for (SqmValues sqmValues : valuesList) {
                insertValuesStatement.getValuesList().add(this.visitValues(sqmValues));
            }
            InsertStatement insertStatement = insertValuesStatement;
            return insertStatement;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    @Override
    public Values visitValues(SqmValues sqmValues) {
        Values values = new Values();
        for (SqmExpression<?> expression : sqmValues.getExpressions()) {
            values.getExpressions().add((Expression)expression.accept(this));
        }
        return values;
    }

    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement<?> statement) {
        Object cteStatements = this.visitCteContainer(statement);
        Object queryPart = this.visitQueryPart((SqmQueryPart)statement.getQueryPart());
        return new SelectStatement(statement.isWithRecursive(), (Map<String, CteStatement>)cteStatements, (QueryPart)queryPart, this.domainResults);
    }

    @Override
    public DynamicInstantiation<?> visitDynamicInstantiation(SqmDynamicInstantiation<?> sqmDynamicInstantiation) {
        SqmDynamicInstantiationTarget<?> instantiationTarget = sqmDynamicInstantiation.getInstantiationTarget();
        DynamicInstantiationNature instantiationNature = instantiationTarget.getNature();
        JavaTypeDescriptor<T> targetTypeDescriptor = this.interpretInstantiationTarget(instantiationTarget);
        DynamicInstantiation<T> dynamicInstantiation = new DynamicInstantiation<T>(instantiationNature, targetTypeDescriptor);
        for (SqmDynamicInstantiationArgument<?> sqmArgument : sqmDynamicInstantiation.getArguments()) {
            DomainResultProducer argumentResultProducer = (DomainResultProducer)sqmArgument.getSelectableNode().accept(this);
            dynamicInstantiation.addArgument(sqmArgument.getAlias(), argumentResultProducer);
        }
        dynamicInstantiation.complete();
        return dynamicInstantiation;
    }

    private <T> JavaTypeDescriptor<T> interpretInstantiationTarget(SqmDynamicInstantiationTarget<?> instantiationTarget) {
        Class targetJavaType = instantiationTarget.getNature() == DynamicInstantiationNature.LIST ? List.class : (instantiationTarget.getNature() == DynamicInstantiationNature.MAP ? Map.class : instantiationTarget.getJavaType());
        return this.getCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(targetJavaType);
    }

    @Override
    public CteStatement visitCteStatement(SqmCteStatement<?> sqmCteStatement) {
        CteTable cteTable = BaseSqmToSqlAstConverter.createCteTable(sqmCteStatement.getCteTable(), this.getCreationContext().getSessionFactory());
        return new CteStatement(cteTable, (Statement)this.visitStatement((SqmStatement)sqmCteStatement.getCteDefinition()), sqmCteStatement.getSearchClauseKind(), this.visitSearchBySpecifications(cteTable, sqmCteStatement.getSearchBySpecifications()), this.visitCycleColumns(cteTable, sqmCteStatement.getCycleColumns()), this.findCteColumn(cteTable, sqmCteStatement.getCycleMarkColumn()), sqmCteStatement.getCycleValue(), sqmCteStatement.getNoCycleValue());
    }

    protected List<SearchClauseSpecification> visitSearchBySpecifications(CteTable cteTable, List<SqmSearchClauseSpecification> searchBySpecifications) {
        if (searchBySpecifications == null || searchBySpecifications.isEmpty()) {
            return null;
        }
        int size = searchBySpecifications.size();
        ArrayList<SearchClauseSpecification> searchClauseSpecifications = new ArrayList<SearchClauseSpecification>(size);
        for (int i = 0; i < size; ++i) {
            SqmSearchClauseSpecification specification = searchBySpecifications.get(i);
            this.forEachCteColumn(cteTable, specification.getCteColumn(), cteColumn -> searchClauseSpecifications.add(new SearchClauseSpecification((CteColumn)cteColumn, specification.getSortOrder(), specification.getNullPrecedence())));
        }
        return searchClauseSpecifications;
    }

    protected CteColumn findCteColumn(CteTable cteTable, SqmCteTableColumn cteColumn) {
        if (cteColumn == null) {
            return null;
        }
        List<CteColumn> cteColumns = cteTable.getCteColumns();
        int size = cteColumns.size();
        for (int i = 0; i < size; ++i) {
            CteColumn column = cteColumns.get(i);
            if (!cteColumn.getColumnName().equals(column.getColumnExpression())) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Couldn't find cte column %s in cte %s!", cteColumn.getColumnName(), cteTable.getTableExpression()));
    }

    protected void forEachCteColumn(CteTable cteTable, SqmCteTableColumn cteColumn, Consumer<CteColumn> consumer) {
        List<CteColumn> cteColumns = cteTable.getCteColumns();
        int size = cteColumns.size();
        for (int i = 0; i < size; ++i) {
            CteColumn column = cteColumns.get(i);
            if (!cteColumn.getColumnName().equals(column.getColumnExpression())) continue;
            consumer.accept(column);
        }
    }

    protected List<CteColumn> visitCycleColumns(CteTable cteTable, List<SqmCteTableColumn> cycleColumns) {
        if (cycleColumns == null || cycleColumns.isEmpty()) {
            return null;
        }
        int size = cycleColumns.size();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(size);
        for (int i = 0; i < size; ++i) {
            this.forEachCteColumn(cteTable, cycleColumns.get(i), columns::add);
        }
        return columns;
    }

    public static CteTable createCteTable(SqmCteTable sqmCteTable, SessionFactoryImplementor factory) {
        List<SqmCteTableColumn> sqmCteColumns = sqmCteTable.getColumns();
        ArrayList<CteColumn> sqlCteColumns = new ArrayList<CteColumn>(sqmCteColumns.size());
        for (int i = 0; i < sqmCteColumns.size(); ++i) {
            SqmCteTableColumn sqmCteTableColumn = sqmCteColumns.get(i);
            ModelPart modelPart = sqmCteTableColumn.getType();
            if (modelPart instanceof Association) {
                modelPart = ((Association)modelPart).getForeignKeyDescriptor();
            }
            if (modelPart instanceof EmbeddableValuedModelPart) {
                modelPart.forEachJdbcType((index, jdbcMapping) -> sqlCteColumns.add(new CteColumn(sqmCteTableColumn.getColumnName() + "_" + index, (JdbcMapping)jdbcMapping)));
                continue;
            }
            sqlCteColumns.add(new CteColumn(sqmCteTableColumn.getColumnName(), ((BasicValuedMapping)((Object)modelPart)).getJdbcMapping()));
        }
        return new CteTable(sqmCteTable.getCteName(), sqlCteColumns, factory);
    }

    @Override
    public Map<String, CteStatement> visitCteContainer(SqmCteContainer consumer) {
        Collection<SqmCteStatement<?>> sqmCteStatements = consumer.getCteStatements();
        LinkedHashMap<String, CteStatement> cteStatements = new LinkedHashMap<String, CteStatement>(sqmCteStatements.size());
        for (SqmCteStatement<?> sqmCteStatement : sqmCteStatements) {
            Object cteStatement = this.visitCteStatement((SqmCteStatement)sqmCteStatement);
            cteStatements.put(((CteStatement)cteStatement).getCteTable().getTableExpression(), (CteStatement)cteStatement);
        }
        return cteStatements;
    }

    @Override
    public QueryPart visitQueryPart(SqmQueryPart<?> queryPart) {
        return (QueryPart)super.visitQueryPart(queryPart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryGroup visitQueryGroup(SqmQueryGroup<?> queryGroup) {
        List<SqmQueryPart<?>> queryParts = queryGroup.getQueryParts();
        int size = queryParts.size();
        ArrayList<QueryPart> newQueryParts = new ArrayList<QueryPart>(size);
        QueryGroup group = new QueryGroup(this.getProcessingStateStack().isEmpty(), queryGroup.getSetOperator(), newQueryParts);
        SqlAstQueryPartProcessingStateImpl processingState = new SqlAstQueryPartProcessingStateImpl(group, this.getCurrentProcessingState(), this, DelegatingSqlSelectionForSqmSelectionCollector::new, this.currentClauseStack::getCurrent);
        DelegatingSqlSelectionForSqmSelectionCollector collector = (DelegatingSqlSelectionForSqmSelectionCollector)processingState.getSqlExpressionResolver();
        this.pushProcessingState(processingState);
        try {
            newQueryParts.add((QueryPart)this.visitQueryPart((SqmQueryPart)queryParts.get(0)));
            collector.setSqlSelectionForSqmSelectionCollector((SqlSelectionForSqmSelectionCollector)((Object)this.lastPoppedProcessingState.getSqlExpressionResolver()));
            for (int i = 1; i < size; ++i) {
                newQueryParts.add((QueryPart)this.visitQueryPart((SqmQueryPart)queryParts.get(i)));
            }
            this.visitOrderByOffsetAndFetch(queryGroup, group);
            QueryGroup queryGroup2 = group;
            return queryGroup2;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QuerySpec visitQuerySpec(SqmQuerySpec<?> sqmQuerySpec) {
        QuerySpec sqlQuerySpec = new QuerySpec(this.getProcessingStateStack().isEmpty(), sqmQuerySpec.getFromClause().getNumberOfRoots());
        SqmSelectClause selectClause = sqmQuerySpec.getSelectClause();
        Predicate originalAdditionalRestrictions = this.additionalRestrictions;
        this.additionalRestrictions = null;
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(sqlQuerySpec, this.getCurrentProcessingState(), this, r -> new SqlSelectionForSqmSelectionResolver((SqlExpressionResolver)r, selectClause.getSelectionItems().size()), this.currentClauseStack::getCurrent));
        try {
            boolean topLevel = sqlQuerySpec.isRoot();
            if (topLevel) {
                this.orderByFragmentConsumer = new StandardOrderByFragmentConsumer();
            }
            this.visitFromClause(sqmQuerySpec.getFromClause());
            this.visitSelectClause(selectClause);
            SqmWhereClause whereClause = sqmQuerySpec.getWhereClause();
            if (whereClause != null && whereClause.getPredicate() != null) {
                this.currentClauseStack.push(Clause.WHERE);
                try {
                    sqlQuerySpec.applyPredicate((Predicate)whereClause.getPredicate().accept(this));
                }
                finally {
                    this.currentClauseStack.pop();
                }
            }
            sqlQuerySpec.setGroupByClauseExpressions((List<Expression>)this.visitGroupByClause((List)sqmQuerySpec.getGroupByClauseExpressions()));
            if (sqmQuerySpec.getHavingClausePredicate() != null) {
                sqlQuerySpec.setHavingClauseRestrictions(this.visitHavingClause(sqmQuerySpec.getHavingClausePredicate()));
            }
            this.visitOrderByOffsetAndFetch(sqmQuerySpec, sqlQuerySpec);
            if (topLevel && this.statement instanceof SqmSelectStatement) {
                this.orderByFragmentConsumer.visitFragments((orderByFragment, tableGroup) -> orderByFragment.apply(sqlQuerySpec, (TableGroup)tableGroup, this));
                this.orderByFragmentConsumer = null;
                this.applyCollectionFilterPredicates(sqlQuerySpec);
            }
            this.joinPathBySqmJoinFullPath.clear();
            QuerySpec querySpec = sqlQuerySpec;
            return querySpec;
        }
        finally {
            if (this.additionalRestrictions != null) {
                sqlQuerySpec.applyPredicate(this.additionalRestrictions);
            }
            this.additionalRestrictions = originalAdditionalRestrictions;
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitOrderByOffsetAndFetch(SqmQueryPart<?> sqmQueryPart, QueryPart sqlQueryPart) {
        if (sqmQueryPart.getOrderByClause() != null) {
            this.currentClauseStack.push(Clause.ORDER);
            try {
                for (SqmSortSpecification sortSpecification : sqmQueryPart.getOrderByClause().getSortSpecifications()) {
                    sqlQueryPart.addSortSpecification(this.visitSortSpecification(sortSpecification));
                }
            }
            finally {
                this.currentClauseStack.pop();
            }
        }
        sqlQueryPart.setOffsetClauseExpression((Expression)this.visitOffsetExpression((SqmExpression)sqmQueryPart.getOffsetExpression()));
        sqlQueryPart.setFetchClauseExpression((Expression)this.visitFetchExpression((SqmExpression)sqmQueryPart.getFetchExpression()), sqmQueryPart.getFetchClauseType());
    }

    protected void applyCollectionFilterPredicates(QuerySpec sqlQuerySpec) {
        List<TableGroup> roots = sqlQuerySpec.getFromClause().getRoots();
        if (roots != null && roots.size() == 1) {
            TableGroup root = roots.get(0);
            ModelPartContainer modelPartContainer = root.getModelPart();
            EntityPersister entityPersister = modelPartContainer.findContainingEntityMapping().getEntityPersister();
            assert (entityPersister instanceof Joinable);
            FilterPredicate filterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), (Joinable)((Object)entityPersister), root);
            if (filterPredicate != null) {
                sqlQuerySpec.applyPredicate(filterPredicate);
            }
            if (CollectionHelper.isNotEmpty(this.collectionFilterPredicates)) {
                root.getTableGroupJoins().forEach(tableGroupJoin -> this.collectionFilterPredicates.forEach((alias, predicate) -> {
                    if (tableGroupJoin.getJoinedGroup().getGroupAlias().equals(alias)) {
                        tableGroupJoin.applyPredicate((Predicate)predicate);
                    }
                }));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SelectClause visitSelectClause(SqmSelectClause selectClause) {
        this.currentClauseStack.push(Clause.SELECT);
        try {
            super.visitSelectClause(selectClause);
            SelectClause sqlSelectClause = this.currentQuerySpec().getSelectClause();
            sqlSelectClause.makeDistinct(selectClause.isDistinct());
            SelectClause selectClause2 = sqlSelectClause;
            return selectClause2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitSelection(SqmSelection sqmSelection) {
        this.currentSqlSelectionCollector().next();
        DomainResultProducer resultProducer = this.resolveDomainResultProducer(sqmSelection);
        if (this.domainResults != null) {
            boolean collectDomainResults;
            Stack<SqlAstProcessingState> processingStateStack = this.getProcessingStateStack();
            if (processingStateStack.depth() == 1) {
                collectDomainResults = true;
            } else {
                SqlAstProcessingState current = processingStateStack.getCurrent();
                boolean bl = collectDomainResults = processingStateStack.findCurrentFirst(processingState -> {
                    if (!(processingState instanceof SqlAstQueryPartProcessingState)) {
                        return Boolean.FALSE;
                    }
                    if (processingState == current) {
                        return null;
                    }
                    QueryPart part = ((SqlAstQueryPartProcessingState)processingState).getInflightQueryPart();
                    if (part instanceof QueryGroup && ((QueryGroup)part).getQueryParts().isEmpty()) {
                        return null;
                    }
                    return Boolean.FALSE;
                }) == null;
            }
            if (collectDomainResults) {
                DomainResult domainResult = resultProducer.createDomainResult(sqmSelection.getAlias(), this);
                this.domainResults.add(domainResult);
            } else {
                resultProducer.applySqlSelections(this);
            }
        }
        return null;
    }

    private DomainResultProducer resolveDomainResultProducer(SqmSelection sqmSelection) {
        return (DomainResultProducer)sqmSelection.getSelectableNode().accept(this);
    }

    protected Expression resolveGroupOrOrderByExpression(SqmExpression<?> groupByClauseExpression) {
        Object literal;
        if (groupByClauseExpression instanceof SqmLiteral && (literal = ((SqmLiteral)groupByClauseExpression).getLiteralValue()) instanceof Integer) {
            int sqmPosition = (Integer)literal;
            List<SqlSelection> selections = this.currentSqlSelectionCollector().getSelections(sqmPosition);
            ArrayList<SqlSelectionExpression> expressions = new ArrayList<SqlSelectionExpression>(selections.size());
            block0: for (int i = 0; i < selections.size(); ++i) {
                SqlSelection selection = selections.get(i);
                for (int j = 0; j < i; ++j) {
                    if (selections.get(j) == selection) continue block0;
                }
                expressions.add(new SqlSelectionExpression(selection));
            }
            if (expressions.size() == 1) {
                return (Expression)expressions.get(0);
            }
            return new SqlTuple(expressions, null);
        }
        return (Expression)groupByClauseExpression.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Expression> visitGroupByClause(List<SqmExpression<?>> groupByClauseExpressions) {
        if (!groupByClauseExpressions.isEmpty()) {
            this.currentClauseStack.push(Clause.GROUP);
            try {
                ArrayList<Expression> expressions = new ArrayList<Expression>(groupByClauseExpressions.size());
                for (SqmExpression<?> groupByClauseExpression : groupByClauseExpressions) {
                    expressions.add(this.resolveGroupOrOrderByExpression(groupByClauseExpression));
                }
                ArrayList<Expression> arrayList = expressions;
                return arrayList;
            }
            finally {
                this.currentClauseStack.pop();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Predicate visitHavingClause(SqmPredicate sqmPredicate) {
        if (sqmPredicate == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.HAVING);
        try {
            Predicate predicate = (Predicate)sqmPredicate.accept(this);
            return predicate;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitOrderByClause(SqmOrderByClause orderByClause) {
        super.visitOrderByClause(orderByClause);
        return null;
    }

    @Override
    public SortSpecification visitSortSpecification(SqmSortSpecification sortSpecification) {
        return new SortSpecification(this.resolveGroupOrOrderByExpression(sortSpecification.getSortExpression()), null, sortSpecification.getSortOrder(), sortSpecification.getNullPrecedence());
    }

    public QuerySpec visitOffsetAndFetchExpressions(QuerySpec sqlQuerySpec, SqmQuerySpec<?> sqmQuerySpec) {
        Object offsetExpression = this.visitOffsetExpression((SqmExpression)sqmQuerySpec.getOffsetExpression());
        Object fetchExpression = this.visitFetchExpression((SqmExpression)sqmQuerySpec.getFetchExpression());
        sqlQuerySpec.setOffsetClauseExpression((Expression)offsetExpression);
        sqlQuerySpec.setFetchClauseExpression((Expression)fetchExpression, sqmQuerySpec.getFetchClauseType());
        return sqlQuerySpec;
    }

    @Override
    public Expression visitOffsetExpression(SqmExpression<?> expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.OFFSET);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Expression visitFetchExpression(SqmExpression<?> expression) {
        if (expression == null) {
            return null;
        }
        this.currentClauseStack.push(Clause.FETCH);
        try {
            Expression expression2 = (Expression)expression.accept(this);
            return expression2;
        }
        finally {
            this.currentClauseStack.pop();
        }
    }

    @Override
    public Void visitFromClause(SqmFromClause sqmFromClause) {
        this.currentClauseStack.push(Clause.FROM);
        try {
            sqmFromClause.visitRoots(this::consumeFromClauseRoot);
        }
        finally {
            this.currentClauseStack.pop();
        }
        return null;
    }

    protected void consumeFromClauseRoot(SqmRoot<?> sqmRoot) {
        TableGroup tableGroup;
        log.tracef("Resolving SqmRoot [%s] to TableGroup", sqmRoot);
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        if (fromClauseIndex.isResolved(sqmRoot)) {
            log.tracef("Already resolved SqmRoot [%s] to TableGroup", sqmRoot);
        }
        SqlExpressionResolver sqlExpressionResolver = this.getSqlExpressionResolver();
        if (sqmRoot.isCorrelated()) {
            SessionFactoryImplementor sessionFactory = this.creationContext.getSessionFactory();
            TableGroup parentTableGroup = fromClauseIndex.findTableGroup(sqmRoot.getCorrelationParent().getNavigablePath());
            EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmRoot.getReferencedPathSource());
            if (sqmRoot.containsOnlyInnerJoins()) {
                SqlAliasBase sqlAliasBase = this.sqlAliasBaseManager.createSqlAliasBase(parentTableGroup.getGroupAlias());
                CorrelatedTableGroup tableGroup2 = new CorrelatedTableGroup(parentTableGroup, sqlAliasBase, this.currentQuerySpec(), predicate -> {
                    this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
                }, sessionFactory);
                log.tracef("Resolved SqmRoot [%s] to correlated TableGroup [%s]", sqmRoot, (Object)tableGroup2);
                this.consumeExplicitJoins(sqmRoot, tableGroup2);
                this.consumeImplicitJoins(sqmRoot, tableGroup2);
                return;
            }
            tableGroup = entityDescriptor.createRootTableGroup(sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), true, LockMode.NONE, () -> predicate -> {}, this, this.creationContext);
            EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
            int jdbcTypeCount = identifierMapping.getJdbcTypeCount();
            if (jdbcTypeCount == 1) {
                identifierMapping.forEachSelection((selectionIndex, selectionMapping) -> {
                    this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, new ComparisonPredicate(new ColumnReference(parentTableGroup.getTableReference(selectionMapping.getContainingTableExpression()), selectionMapping, sessionFactory), ComparisonOperator.EQUAL, new ColumnReference(tableGroup.getTableReference(selectionMapping.getContainingTableExpression()), selectionMapping, sessionFactory)));
                });
            } else {
                ArrayList lhs = new ArrayList(jdbcTypeCount);
                ArrayList rhs = new ArrayList(jdbcTypeCount);
                identifierMapping.forEachSelection((selectionIndex, selectionMapping) -> {
                    lhs.add(new ColumnReference(parentTableGroup.getTableReference(selectionMapping.getContainingTableExpression()), selectionMapping, sessionFactory));
                    rhs.add(new ColumnReference(tableGroup.getTableReference(selectionMapping.getContainingTableExpression()), selectionMapping, sessionFactory));
                });
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, new ComparisonPredicate(new SqlTuple(lhs, identifierMapping), ComparisonOperator.EQUAL, new SqlTuple(rhs, identifierMapping)));
            }
        } else {
            EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmRoot.getReferencedPathSource());
            tableGroup = entityDescriptor.createRootTableGroup(sqmRoot.getNavigablePath(), sqmRoot.getExplicitAlias(), true, LockMode.NONE, () -> predicate -> {
                this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
            }, this, this.creationContext);
        }
        log.tracef("Resolved SqmRoot [%s] to new TableGroup [%s]", sqmRoot, (Object)tableGroup);
        fromClauseIndex.register(sqmRoot, tableGroup);
        this.currentQuerySpec().getFromClause().addRoot(tableGroup);
        this.consumeExplicitJoins(sqmRoot, tableGroup);
        this.consumeImplicitJoins(sqmRoot, tableGroup);
    }

    private EntityPersister resolveEntityPersister(EntityDomainType<?> entityDomainType) {
        return this.creationContext.getDomainModel().getEntityDescriptor(entityDomainType.getHibernateEntityName());
    }

    protected void consumeExplicitJoins(SqmFrom<?, ?> sqmFrom, TableGroup lhsTableGroup) {
        if (log.isTraceEnabled()) {
            log.tracef("Visiting explicit joins for `%s`", (Object)sqmFrom.getNavigablePath());
        }
        sqmFrom.visitSqmJoins(sqmJoin -> this.consumeExplicitJoin((SqmJoin<?, ?>)sqmJoin, lhsTableGroup));
    }

    protected void consumeExplicitJoin(SqmJoin<?, ?> sqmJoin, TableGroup lhsTableGroup) {
        if (sqmJoin instanceof SqmAttributeJoin) {
            this.consumeAttributeJoin((SqmAttributeJoin)sqmJoin, lhsTableGroup);
        } else if (sqmJoin instanceof SqmCrossJoin) {
            this.consumeCrossJoin((SqmCrossJoin)sqmJoin, lhsTableGroup);
        } else if (sqmJoin instanceof SqmEntityJoin) {
            this.consumeEntityJoin((SqmEntityJoin)sqmJoin, lhsTableGroup);
        } else {
            throw new InterpretationException("Could not resolve SqmJoin [" + sqmJoin.getNavigablePath() + "] to TableGroupJoin");
        }
    }

    private void consumeAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin, TableGroup lhsTableGroup) {
        TableGroupJoin joinedTableGroupJoin;
        NavigablePath joinPath;
        SqmPathSource<?> pathSource = sqmJoin.getReferencedPathSource();
        NavigablePath sqmJoinNavigablePath = sqmJoin.getNavigablePath();
        NavigablePath parentNavigablePath = sqmJoinNavigablePath.getParent();
        ModelPart modelPart = lhsTableGroup.getModelPart().findSubPart(pathSource.getPathName(), SqmMappingModelHelper.resolveExplicitTreatTarget(sqmJoin, this));
        if (pathSource instanceof PluralPersistentAttribute) {
            assert (modelPart instanceof PluralAttributeMapping);
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)modelPart;
            joinPath = this.getJoinNavigablePath(sqmJoinNavigablePath, parentNavigablePath, pluralAttributeMapping.getPartName());
            this.joinPathBySqmJoinFullPath.put(sqmJoin.getNavigablePath().getFullPath(), joinPath.append(CollectionPart.Nature.ELEMENT.getName()));
            joinedTableGroupJoin = pluralAttributeMapping.createTableGroupJoin(joinPath, lhsTableGroup, sqmJoin.getExplicitAlias(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), this.determineLockMode(sqmJoin.getExplicitAlias()), this);
        } else {
            assert (modelPart instanceof TableGroupJoinProducer);
            joinPath = this.getJoinNavigablePath(sqmJoinNavigablePath, parentNavigablePath, modelPart.getPartName());
            joinedTableGroupJoin = ((TableGroupJoinProducer)modelPart).createTableGroupJoin(joinPath, lhsTableGroup, sqmJoin.getExplicitAlias(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), this.determineLockMode(sqmJoin.getExplicitAlias()), this);
        }
        TableGroup joinedTableGroup = joinedTableGroupJoin.getJoinedGroup();
        lhsTableGroup.addTableGroupJoin(joinedTableGroupJoin);
        this.getFromClauseIndex().register(sqmJoin, joinedTableGroup, joinPath);
        if (sqmJoin.getJoinPredicate() != null) {
            if (sqmJoin.isFetched()) {
                QueryLogging.QUERY_MESSAGE_LOGGER.debugf("Join fetch [" + sqmJoinNavigablePath + "] is restricted", new Object[0]);
            }
            if (joinedTableGroupJoin == null) {
                throw new IllegalStateException();
            }
            joinedTableGroupJoin.applyPredicate((Predicate)sqmJoin.getJoinPredicate().accept(this));
        }
        this.consumeExplicitJoins(sqmJoin, joinedTableGroup);
        this.consumeImplicitJoins(sqmJoin, joinedTableGroup);
    }

    private NavigablePath getJoinNavigablePath(NavigablePath sqmJoinNavigablePath, NavigablePath parentNavigablePath, String partName) {
        if (parentNavigablePath == null) {
            return sqmJoinNavigablePath;
        }
        NavigablePath elementNavigablePath = this.joinPathBySqmJoinFullPath.get(parentNavigablePath.getFullPath());
        if (elementNavigablePath == null) {
            return sqmJoinNavigablePath;
        }
        return elementNavigablePath.append(partName);
    }

    private void consumeCrossJoin(SqmCrossJoin sqmJoin, TableGroup lhsTableGroup) {
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), true, this.determineLockMode(sqmJoin.getExplicitAlias()), () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this, this.getCreationContext());
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), SqlAstJoinType.CROSS, tableGroup);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        this.getFromClauseIndex().register(sqmJoin, tableGroup);
        this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        this.consumeImplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
    }

    private void consumeEntityJoin(SqmEntityJoin sqmJoin, TableGroup lhsTableGroup) {
        EntityPersister entityDescriptor = this.resolveEntityPersister((EntityDomainType<?>)sqmJoin.getReferencedPathSource());
        TableGroup tableGroup = entityDescriptor.createRootTableGroup(sqmJoin.getNavigablePath(), sqmJoin.getExplicitAlias(), true, this.determineLockMode(sqmJoin.getExplicitAlias()), () -> predicate -> {
            this.additionalRestrictions = SqlAstTreeHelper.combinePredicates(this.additionalRestrictions, predicate);
        }, this, this.getCreationContext());
        this.getFromClauseIndex().register(sqmJoin, tableGroup);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(sqmJoin.getNavigablePath(), sqmJoin.getSqmJoinType().getCorrespondingSqlJoinType(), tableGroup, null);
        lhsTableGroup.addTableGroupJoin(tableGroupJoin);
        this.consumeExplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        this.consumeImplicitJoins(sqmJoin, tableGroupJoin.getJoinedGroup());
        if (sqmJoin.getJoinPredicate() != null) {
            tableGroupJoin.applyPredicate((Predicate)sqmJoin.getJoinPredicate().accept(this));
        }
    }

    private void consumeImplicitJoins(SqmPath<?> sqmPath, TableGroup tableGroup) {
        if (log.isTraceEnabled()) {
            log.tracef("Visiting implicit joins for `%s`", (Object)sqmPath.getNavigablePath());
        }
        sqmPath.visitImplicitJoinPaths(joinedPath -> {
            if (log.isTraceEnabled()) {
                log.tracef("Starting implicit join handling for `%s`", (Object)joinedPath.getNavigablePath());
            }
            FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
            assert (fromClauseIndex.findTableGroup(joinedPath.getLhs().getNavigablePath()) == tableGroup);
            ModelPart subPart = tableGroup.getModelPart().findSubPart(joinedPath.getReferencedPathSource().getPathName(), sqmPath instanceof SqmTreatedPath ? this.resolveEntityPersister(((SqmTreatedPath)sqmPath).getTreatTarget()) : null);
            assert (subPart instanceof TableGroupJoinProducer);
            TableGroupJoinProducer joinProducer = (TableGroupJoinProducer)subPart;
            TableGroupJoin tableGroupJoin = joinProducer.createTableGroupJoin(joinedPath.getNavigablePath(), tableGroup, null, tableGroup.isInnerJoinPossible() ? SqlAstJoinType.INNER : SqlAstJoinType.LEFT, null, this);
            fromClauseIndex.register((SqmPath<?>)joinedPath, tableGroupJoin.getJoinedGroup());
            this.consumeImplicitJoins((SqmPath<?>)joinedPath, tableGroupJoin.getJoinedGroup());
        });
    }

    @Override
    public TableGroup visitRootPath(SqmRoot<?> sqmRoot) {
        TableGroup resolved = this.getFromClauseAccess().findTableGroup(sqmRoot.getNavigablePath());
        if (resolved != null) {
            log.tracef("SqmRoot [%s] resolved to existing TableGroup [%s]", sqmRoot, (Object)resolved);
            return resolved;
        }
        throw new InterpretationException("SqmRoot not yet resolved to TableGroup");
    }

    @Override
    public TableGroup visitQualifiedAttributeJoin(SqmAttributeJoin<?, ?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmAttributeJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return existing;
        }
        throw new InterpretationException("SqmAttributeJoin not yet resolved to TableGroup");
    }

    private QuerySpec currentQuerySpec() {
        return this.currentQueryPart().getLastQuerySpec();
    }

    private QueryPart currentQueryPart() {
        SqlAstQueryPartProcessingState processingState = (SqlAstQueryPartProcessingState)this.getProcessingStateStack().getCurrent();
        return processingState.getInflightQueryPart();
    }

    protected SqlSelectionForSqmSelectionCollector currentSqlSelectionCollector() {
        return (SqlSelectionForSqmSelectionCollector)((Object)this.getCurrentProcessingState().getSqlExpressionResolver());
    }

    @Override
    public TableGroup visitCrossJoin(SqmCrossJoin<?> sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmCrossJoin [%s] resolved to existing TableGroup [%s]", sqmJoin, (Object)existing);
            return existing;
        }
        throw new InterpretationException("SqmCrossJoin not yet resolved to TableGroup");
    }

    @Override
    public TableGroup visitQualifiedEntityJoin(SqmEntityJoin sqmJoin) {
        TableGroup existing = this.getFromClauseAccess().findTableGroup(sqmJoin.getNavigablePath());
        if (existing != null) {
            log.tracef("SqmEntityJoin [%s] resolved to existing TableGroup [%s]", (Object)sqmJoin, (Object)existing);
            return existing;
        }
        throw new InterpretationException("SqmEntityJoin not yet resolved to TableGroup");
    }

    @Override
    public Expression visitBasicValuedPath(SqmBasicValuedSimplePath<?> sqmPath) {
        BasicValuedPathInterpretation<?> path = BasicValuedPathInterpretation.from(sqmPath, this, this);
        if (TypeConfiguration.isDuration(sqmPath.getNodeType())) {
            Expression scaledExpression = this.applyScale(this.toSqlExpression(path));
            if (this.adjustedTimestamp != null) {
                if (this.appliedByUnit != null) {
                    throw new IllegalStateException();
                }
                return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, new DurationUnit(TemporalUnit.NANOSECOND, this.basicType(Long.class)), scaledExpression, this.adjustedTimestamp);
            }
            if (this.appliedByUnit != null) {
                MappingModelExpressable durationType = scaledExpression.getExpressionType();
                Duration duration = new Duration(scaledExpression, TemporalUnit.NANOSECOND, (BasicValuedMapping)durationType);
                TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
                BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
                return new Conversion(duration, appliedUnit, scalarType);
            }
            return scaledExpression;
        }
        return path;
    }

    @Override
    public SqmPathInterpretation<?> visitEmbeddableValuedPath(SqmEmbeddedValuedSimplePath<?> sqmPath) {
        return EmbeddableValuedPathInterpretation.from(sqmPath, this, this);
    }

    @Override
    public Object visitNonAggregatedCompositeValuedPath(NonAggregatedCompositeSimplePath sqmPath) {
        return NonAggregatedCompositeValuedPathInterpretation.from(sqmPath, this, this);
    }

    @Override
    public SqmPathInterpretation<?> visitEntityValuedPath(SqmEntityValuedSimplePath sqmPath) {
        return EntityValuedPathInterpretation.from(sqmPath, this);
    }

    @Override
    public SqmPathInterpretation<?> visitPluralValuedPath(SqmPluralValuedSimplePath sqmPath) {
        return PluralValuedSimplePathInterpretation.from(sqmPath, this);
    }

    @Override
    public Expression visitLiteral(SqmLiteral<?> literal) {
        if (literal instanceof SqmLiteralNull) {
            MappingModelExpressable mappingModelExpressable = this.inferableTypeAccessStack.getCurrent().get();
            if (mappingModelExpressable instanceof BasicValuedMapping) {
                return new NullnessLiteral(mappingModelExpressable);
            }
            MappingModelExpressable<?> keyExpressable = this.getKeyExpressable(mappingModelExpressable);
            ArrayList expressions = new ArrayList(keyExpressable.getJdbcTypeCount());
            keyExpressable.forEachJdbcType((index, jdbcMapping) -> expressions.add(new QueryLiteral<Object>(null, (BasicValuedMapping)((Object)jdbcMapping))));
            return new SqlTuple(expressions, mappingModelExpressable);
        }
        BasicType<?> expressable = SqmMappingModelHelper.resolveMappingModelExpressable(literal, this.getCreationContext().getDomainModel(), this.getFromClauseAccess()::findTableGroup);
        if (expressable instanceof BasicType) {
            expressable = InferredBasicValueResolver.resolveSqlTypeIndicators(this, expressable);
        }
        return new QueryLiteral(literal.getLiteralValue(), expressable);
    }

    private MappingModelExpressable<?> getKeyExpressable(MappingModelExpressable<?> mappingModelExpressable) {
        if (mappingModelExpressable instanceof EntityAssociationMapping) {
            return ((EntityAssociationMapping)mappingModelExpressable).getKeyTargetMatchPart();
        }
        return mappingModelExpressable;
    }

    @Override
    public Map<SqmParameter, List<List<JdbcParameter>>> getJdbcParamsBySqmParam() {
        return this.jdbcParamsBySqmParam;
    }

    @Override
    public Expression visitNamedParameterExpression(SqmNamedParameter expression) {
        return this.consumeSqmParameter(expression);
    }

    protected Expression consumeSqmParameter(SqmParameter sqmParameter) {
        MappingModelExpressable<?> valueMapping = this.determineValueMapping(sqmParameter);
        ArrayList<JdbcParameter> jdbcParametersForSqm = new ArrayList<JdbcParameter>();
        this.resolveSqmParameter(sqmParameter, valueMapping, jdbcParametersForSqm::add);
        this.jdbcParameters.addParameters(jdbcParametersForSqm);
        this.jdbcParamsBySqmParam.computeIfAbsent(sqmParameter, k -> new ArrayList(1)).add(jdbcParametersForSqm);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        binding.setType(valueMapping);
        return new SqmParameterInterpretation(sqmParameter, queryParameter, jdbcParametersForSqm, valueMapping, qp -> binding);
    }

    protected MappingModelExpressable<?> resolveMappingExpressable(SqmExpressable<?> nodeType) {
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        MappingModelExpressable valueMapping = this.getCreationContext().getDomainModel().resolveMappingExpressable(nodeType);
        if (valueMapping == null && (currentExpressableSupplier = this.inferableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier.get();
        }
        if (valueMapping == null) {
            throw new ConversionException("Could not determine ValueMapping for SqmExpressable: " + nodeType);
        }
        return valueMapping;
    }

    protected MappingModelExpressable<?> determineValueMapping(SqmExpression<?> sqmExpression) {
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        Supplier<MappingModelExpressable> currentExpressableSupplier2;
        if (sqmExpression instanceof SqmParameter) {
            return this.determineValueMapping((SqmParameter)sqmExpression);
        }
        if (sqmExpression instanceof SqmPath) {
            log.debugf("Determining mapping-model type for SqmPath : %s ", sqmExpression);
            return SqmMappingModelHelper.resolveMappingModelExpressable(sqmExpression, this.getCreationContext().getDomainModel(), this.getFromClauseAccess()::findTableGroup);
        }
        if (sqmExpression instanceof SqmEnumLiteral && (currentExpressableSupplier2 = this.inferableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier2.get();
        }
        log.debugf("Determining mapping-model type for generalized SqmExpression : %s", sqmExpression);
        SqmExpressable<?> nodeType = sqmExpression.getNodeType();
        MappingModelExpressable valueMapping = this.getCreationContext().getDomainModel().resolveMappingExpressable(nodeType);
        if (valueMapping == null && (currentExpressableSupplier = this.inferableTypeAccessStack.getCurrent()) != null) {
            return currentExpressableSupplier.get();
        }
        if (valueMapping == null) {
            throw new ConversionException("Could not determine ValueMapping for SqmExpression: " + sqmExpression);
        }
        return valueMapping;
    }

    protected MappingModelExpressable<?> determineValueMapping(SqmParameter<?> sqmParameter) {
        MappingModelExpressable inferredMapping;
        Supplier<MappingModelExpressable> currentExpressableSupplier;
        log.debugf("Determining mapping-model type for SqmParameter : %s", sqmParameter);
        QueryParameterImplementor<?> queryParameter = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> binding = this.domainParameterBindings.getBinding(queryParameter);
        if (sqmParameter.getAnticipatedType() == null && (currentExpressableSupplier = this.inferableTypeAccessStack.getCurrent()) != null && (inferredMapping = currentExpressableSupplier.get()) != null) {
            return inferredMapping;
        }
        AllowableParameterType<Object> parameterSqmType = binding.getBindType();
        if (parameterSqmType == null && (parameterSqmType = queryParameter.getHibernateType()) == null) {
            parameterSqmType = sqmParameter.getAnticipatedType();
        }
        assert (parameterSqmType != null);
        if (parameterSqmType instanceof BasicValuedMapping) {
            return (BasicValuedMapping)((Object)parameterSqmType);
        }
        if (parameterSqmType instanceof CompositeSqmPathSource) {
            throw new NotYetImplementedFor6Exception("Support for embedded-valued parameters not yet implemented");
        }
        throw new ConversionException("Could not determine ValueMapping for SqmParameter: " + sqmParameter);
    }

    private void resolveSqmParameter(SqmParameter expression, MappingModelExpressable valueMapping, Consumer<JdbcParameter> jdbcParameterConsumer) {
        if (valueMapping instanceof Association) {
            ((Association)valueMapping).getForeignKeyDescriptor().forEachJdbcType((index, jdbcMapping) -> jdbcParameterConsumer.accept(new JdbcParameterImpl((JdbcMapping)jdbcMapping)));
        } else {
            valueMapping.forEachJdbcType((index, jdbcMapping) -> jdbcParameterConsumer.accept(new JdbcParameterImpl((JdbcMapping)jdbcMapping)));
        }
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter expression) {
        return this.consumeSqmParameter(expression);
    }

    @Override
    public Object visitJpaCriteriaParameter(JpaCriteriaParameter<?> expression) {
        if (this.jpaCriteriaParamResolutions == null) {
            throw new IllegalStateException("No JpaCriteriaParameter resolutions registered");
        }
        Supplier<SqmJpaCriteriaParameterWrapper<?>> supplier = this.jpaCriteriaParamResolutions.get(expression);
        if (supplier == null) {
            throw new IllegalStateException("Criteria parameter [" + expression + "] not known to be a parameter of the processing tree");
        }
        return this.consumeSqmParameter(supplier.get());
    }

    @Override
    public Object visitTuple(SqmTuple<?> sqmTuple) {
        List<SqmExpression<?>> groupedExpressions = sqmTuple.getGroupedExpressions();
        int size = groupedExpressions.size();
        ArrayList<Expression> expressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            expressions.add((Expression)groupedExpressions.get(i).accept(this));
        }
        return new SqlTuple(expressions, null);
    }

    @Override
    public Object visitCollate(SqmCollate<?> sqmCollate) {
        return new Collate((Expression)sqmCollate.getExpression().accept(this), sqmCollate.getCollation());
    }

    @Override
    public Expression visitFunction(SqmFunction sqmFunction) {
        this.inferableTypeAccessStack.push(() -> null);
        try {
            Expression expression = sqmFunction.convertToSqlAst(this);
            return expression;
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
    }

    @Override
    public Star visitStar(SqmStar sqmStar) {
        return new Star();
    }

    @Override
    public Object visitDistinct(SqmDistinct sqmDistinct) {
        return new Distinct((Expression)sqmDistinct.getExpression().accept(this));
    }

    @Override
    public Object visitTrimSpecification(SqmTrimSpecification specification) {
        return new TrimSpecification(specification.getSpecification());
    }

    @Override
    public Object visitCastTarget(SqmCastTarget target) {
        BasicType<?> targetType = (BasicType<?>)target.getType();
        if (targetType instanceof BasicType) {
            targetType = InferredBasicValueResolver.resolveSqlTypeIndicators(this, targetType);
        }
        return new CastTarget(targetType, target.getLength(), target.getPrecision(), target.getScale());
    }

    @Override
    public Object visitExtractUnit(SqmExtractUnit unit) {
        return new ExtractUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
    }

    @Override
    public Object visitDurationUnit(SqmDurationUnit unit) {
        return new DurationUnit(unit.getUnit(), (BasicValuedMapping)((Object)unit.getType()));
    }

    @Override
    public Object visitFormat(SqmFormat sqmFormat) {
        return new Format((String)sqmFormat.getLiteralValue(), (BasicValuedMapping)((Object)sqmFormat.getNodeType()));
    }

    @Override
    public Object visitUnaryOperationExpression(SqmUnaryOperation expression) {
        return new UnaryOperation(this.interpret(expression.getOperation()), this.toSqlExpression(expression.getOperand().accept(this)), (BasicValuedMapping)this.determineValueMapping(expression.getOperand()));
    }

    private UnaryArithmeticOperator interpret(UnaryArithmeticOperator operator) {
        return operator;
    }

    @Override
    public Object visitBinaryArithmeticExpression(SqmBinaryArithmetic expression) {
        boolean temporalTypeSomewhereToLeft;
        SqmExpression leftOperand = expression.getLeftHandOperand();
        SqmExpression rightOperand = expression.getRightHandOperand();
        boolean durationToRight = TypeConfiguration.isDuration(rightOperand.getNodeType());
        TypeConfiguration typeConfiguration = this.getCreationContext().getDomainModel().getTypeConfiguration();
        TemporalType temporalTypeToLeft = typeConfiguration.getSqlTemporalType(leftOperand.getNodeType());
        TemporalType temporalTypeToRight = typeConfiguration.getSqlTemporalType(rightOperand.getNodeType());
        boolean bl = temporalTypeSomewhereToLeft = this.adjustedTimestamp != null || temporalTypeToLeft != null;
        if (temporalTypeToLeft != null && durationToRight && (this.adjustmentScale != null || this.negativeAdjustment)) {
            throw new SemanticException("scalar multiplication of temporal value");
        }
        if (durationToRight && temporalTypeSomewhereToLeft) {
            return this.transformDurationArithmetic(expression);
        }
        if (temporalTypeToLeft != null && temporalTypeToRight != null) {
            return this.transformDatetimeArithmetic(expression);
        }
        if (durationToRight && this.appliedByUnit != null) {
            return new BinaryArithmeticExpression(this.toSqlExpression(leftOperand.accept(this)), expression.getOperator(), this.toSqlExpression(rightOperand.accept(this)), (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType()));
        }
        return new BinaryArithmeticExpression(this.toSqlExpression(leftOperand.accept(this)), expression.getOperator(), this.toSqlExpression(rightOperand.accept(this)), this.getExpressionType(expression));
    }

    private BasicValuedMapping getExpressionType(SqmBinaryArithmetic expression) {
        SqmExpressable leftHandOperandType = expression.getLeftHandOperand().getNodeType();
        if (leftHandOperandType instanceof BasicValuedMapping) {
            return (BasicValuedMapping)((Object)leftHandOperandType);
        }
        return (BasicValuedMapping)((Object)expression.getRightHandOperand().getNodeType());
    }

    private Expression toSqlExpression(Object value) {
        return (Expression)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Object transformDurationArithmetic(SqmBinaryArithmetic<?> expression) {
        operator = expression.getOperator();
        switch (3.$SwitchMap$org$hibernate$query$BinaryArithmeticOperator[operator.ordinal()]) {
            case 1: 
            case 2: {
                timestamp = this.adjustedTimestamp;
                timestampType = this.adjustedTimestampType;
                this.adjustedTimestamp = this.toSqlExpression(expression.getLeftHandOperand().accept(this));
                type = this.adjustedTimestamp.getExpressionType();
                this.adjustedTimestampType = type instanceof SqmExpressable != false ? (SqmExpressable<Object>)type : (type instanceof AttributeMapping != false ? (SqmExpressable<Object>)((AttributeMapping)type).getMappedType() : expression.getLeftHandOperand().getNodeType());
                if (operator == BinaryArithmeticOperator.SUBTRACT) {
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                try {
                    var6_6 = expression.getRightHandOperand().accept(this);
                    if (operator != BinaryArithmeticOperator.SUBTRACT) ** GOTO lbl21
                    this.negativeAdjustment = this.negativeAdjustment == false;
                }
                catch (Throwable var7_8) {
                    if (operator == BinaryArithmeticOperator.SUBTRACT) {
                        this.negativeAdjustment = this.negativeAdjustment == false;
                    }
                    this.adjustedTimestamp = timestamp;
                    this.adjustedTimestampType = timestampType;
                    throw var7_8;
                }
lbl21:
                // 2 sources

                this.adjustedTimestamp = timestamp;
                this.adjustedTimestampType = timestampType;
                return var6_6;
            }
            case 3: {
                duration = this.toSqlExpression(expression.getLeftHandOperand().accept(this));
                scale = this.adjustmentScale;
                negate = this.negativeAdjustment;
                this.adjustmentScale = this.applyScale(duration);
                this.negativeAdjustment = false;
                try {
                    var9_11 = expression.getRightHandOperand().accept(this);
                    return var9_11;
                }
                finally {
                    this.adjustmentScale = scale;
                    this.negativeAdjustment = negate;
                }
            }
        }
        throw new SemanticException("illegal operator for a duration " + (Object)operator);
    }

    private Object transformDatetimeArithmetic(SqmBinaryArithmetic expression) {
        TemporalUnit baseUnit;
        BinaryArithmeticOperator operator = expression.getOperator();
        if (operator != BinaryArithmeticOperator.SUBTRACT) {
            throw new SemanticException("illegal operator for temporal type: " + (Object)((Object)operator));
        }
        Expression left = this.cleanly(() -> this.toSqlExpression(expression.getLeftHandOperand().accept(this)));
        Expression right = this.cleanly(() -> this.toSqlExpression(expression.getRightHandOperand().accept(this)));
        TypeConfiguration typeConfiguration = this.getCreationContext().getDomainModel().getTypeConfiguration();
        TemporalType leftTimestamp = typeConfiguration.getSqlTemporalType(expression.getLeftHandOperand().getNodeType());
        TemporalType rightTimestamp = typeConfiguration.getSqlTemporalType(expression.getRightHandOperand().getNodeType());
        TemporalUnit temporalUnit = baseUnit = rightTimestamp == TemporalType.TIMESTAMP || leftTimestamp == TemporalType.TIMESTAMP ? TemporalUnit.NATIVE : TemporalUnit.DAY;
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            DurationUnit unit = new DurationUnit(baseUnit, this.basicType(Integer.class));
            Expression scaledMagnitude = this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
            return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, unit, scaledMagnitude, this.adjustedTimestamp);
        }
        if (this.appliedByUnit != null) {
            DurationUnit unit = (DurationUnit)this.appliedByUnit.getUnit().accept((SemanticQueryWalker<?>)this);
            return this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
        }
        DurationUnit unit = new DurationUnit(baseUnit, this.basicType(Integer.class));
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)expression.getNodeType());
        Expression scaledMagnitude = this.applyScale(this.timestampdiff().expression((AllowableFunctionReturnType)expression.getNodeType(), unit, right, left));
        return new Duration(scaledMagnitude, baseUnit, durationType);
    }

    private <J> BasicValuedMapping basicType(Class<J> javaType) {
        return this.creationContext.getDomainModel().getTypeConfiguration().getBasicTypeForJavaType(javaType);
    }

    private TimestampaddFunction timestampadd() {
        return (TimestampaddFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampadd");
    }

    private TimestampdiffFunction timestampdiff() {
        return (TimestampdiffFunction)this.getCreationContext().getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("timestampdiff");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T cleanly(Supplier<T> supplier) {
        SqmByUnit byUnit = this.appliedByUnit;
        Expression timestamp = this.adjustedTimestamp;
        SqmExpressable<?> timestampType = this.adjustedTimestampType;
        Expression scale = this.adjustmentScale;
        boolean negate = this.negativeAdjustment;
        this.adjustmentScale = null;
        this.negativeAdjustment = false;
        this.appliedByUnit = null;
        this.adjustedTimestamp = null;
        this.adjustedTimestampType = null;
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            this.appliedByUnit = byUnit;
            this.adjustedTimestamp = timestamp;
            this.adjustedTimestampType = timestampType;
            this.adjustmentScale = scale;
            this.negativeAdjustment = negate;
        }
    }

    Expression applyScale(Expression magnitude) {
        boolean negate = this.negativeAdjustment;
        if (magnitude instanceof UnaryOperation) {
            UnaryOperation unary = (UnaryOperation)magnitude;
            if (unary.getOperator() == UnaryArithmeticOperator.UNARY_MINUS) {
                negate = !negate;
            }
            magnitude = unary.getOperand();
        }
        if (this.adjustmentScale != null && !BaseSqmToSqlAstConverter.isOne(this.adjustmentScale)) {
            magnitude = BaseSqmToSqlAstConverter.isOne(magnitude) ? this.adjustmentScale : new BinaryArithmeticExpression(this.adjustmentScale, BinaryArithmeticOperator.MULTIPLY, magnitude, (BasicValuedMapping)magnitude.getExpressionType());
        }
        if (negate) {
            magnitude = new UnaryOperation(UnaryArithmeticOperator.UNARY_MINUS, magnitude, (BasicValuedMapping)magnitude.getExpressionType());
        }
        return magnitude;
    }

    static boolean isOne(Expression scale) {
        return scale instanceof QueryLiteral && ((Number)((QueryLiteral)scale).getLiteralValue()).longValue() == 1L;
    }

    @Override
    public Object visitToDuration(SqmToDuration toDuration) {
        Expression magnitude = this.toSqlExpression(toDuration.getMagnitude().accept(this));
        DurationUnit unit = (DurationUnit)toDuration.getUnit().accept((SemanticQueryWalker<?>)this);
        Expression scaledMagnitude = this.applyScale(magnitude);
        if (this.adjustedTimestamp != null) {
            if (this.appliedByUnit != null) {
                throw new IllegalStateException();
            }
            return this.timestampadd().expression((AllowableFunctionReturnType)this.adjustedTimestampType, unit, scaledMagnitude, this.adjustedTimestamp);
        }
        BasicValuedMapping durationType = (BasicValuedMapping)((Object)toDuration.getNodeType());
        Duration duration = new Duration(scaledMagnitude, unit.getUnit(), durationType);
        if (this.appliedByUnit != null) {
            TemporalUnit appliedUnit = this.appliedByUnit.getUnit().getUnit();
            BasicValuedMapping scalarType = (BasicValuedMapping)((Object)this.appliedByUnit.getNodeType());
            return new Conversion(duration, appliedUnit, scalarType);
        }
        return duration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitByUnit(SqmByUnit byUnit) {
        SqmByUnit outer = this.appliedByUnit;
        this.appliedByUnit = byUnit;
        try {
            Object object = byUnit.getDuration().accept(this);
            return object;
        }
        finally {
            this.appliedByUnit = outer;
        }
    }

    @Override
    public QueryPart visitSubQueryExpression(SqmSubQuery sqmSubQuery) {
        return this.visitQueryPart((SqmQueryPart)sqmSubQuery.getQueryPart());
    }

    @Override
    public CaseSimpleExpression visitSimpleCaseExpression(SqmCaseSimple<?, ?> expression) {
        SqmExpressable resultType = expression.getNodeType();
        ArrayList<CaseSimpleExpression.WhenFragment> whenFragments = new ArrayList<CaseSimpleExpression.WhenFragment>(expression.getWhenFragments().size());
        for (SqmCaseSimple.WhenFragment<?, ?> whenFragment : expression.getWhenFragments()) {
            resultType = QueryHelper.highestPrecedenceType2(resultType, whenFragment.getResult().getNodeType());
            whenFragments.add(new CaseSimpleExpression.WhenFragment((Expression)whenFragment.getCheckValue().accept(this), (Expression)whenFragment.getResult().accept(this)));
        }
        Expression otherwise = null;
        if (expression.getOtherwise() != null) {
            resultType = QueryHelper.highestPrecedenceType2(resultType, expression.getOtherwise().getNodeType());
            otherwise = (Expression)expression.getOtherwise().accept(this);
        }
        CaseSimpleExpression result = new CaseSimpleExpression(this.resolveMappingExpressable(resultType), (Expression)expression.getFixture().accept(this), whenFragments, otherwise);
        return result;
    }

    @Override
    public CaseSearchedExpression visitSearchedCaseExpression(SqmCaseSearched<?> expression) {
        SqmExpressable resultType = expression.getNodeType();
        ArrayList<CaseSearchedExpression.WhenFragment> whenFragments = new ArrayList<CaseSearchedExpression.WhenFragment>(expression.getWhenFragments().size());
        for (SqmCaseSearched.WhenFragment<?> whenFragment : expression.getWhenFragments()) {
            resultType = QueryHelper.highestPrecedenceType2(resultType, whenFragment.getResult().getNodeType());
            whenFragments.add(new CaseSearchedExpression.WhenFragment((Predicate)whenFragment.getPredicate().accept(this), (Expression)whenFragment.getResult().accept(this)));
        }
        Expression otherwise = null;
        if (expression.getOtherwise() != null) {
            resultType = QueryHelper.highestPrecedenceType2(resultType, expression.getOtherwise().getNodeType());
            otherwise = (Expression)expression.getOtherwise().accept(this);
        }
        CaseSearchedExpression result = new CaseSearchedExpression(this.resolveMappingExpressable(resultType), whenFragments, otherwise);
        return result;
    }

    @Override
    public Object visitAny(SqmAny<?> sqmAny) {
        return new Any(this.visitSubQueryExpression((SqmSubQuery)sqmAny.getSubquery()), null);
    }

    @Override
    public Object visitEvery(SqmEvery<?> sqmEvery) {
        return new Every(this.visitSubQueryExpression((SqmSubQuery)sqmEvery.getSubquery()), null);
    }

    @Override
    public Object visitSummarization(SqmSummarization<?> sqmSummarization) {
        List<SqmExpression<?>> groupingExpressions = sqmSummarization.getGroupings();
        int size = groupingExpressions.size();
        ArrayList<Expression> expressions = new ArrayList<Expression>(size);
        for (int i = 0; i < size; ++i) {
            expressions.add((Expression)groupingExpressions.get(i).accept(this));
        }
        return new Summarization(this.getSummarizationKind(sqmSummarization.getKind()), expressions);
    }

    private Summarization.Kind getSummarizationKind(SqmSummarization.Kind kind) {
        switch (kind) {
            case CUBE: {
                return Summarization.Kind.CUBE;
            }
            case ROLLUP: {
                return Summarization.Kind.ROLLUP;
            }
        }
        throw new UnsupportedOperationException("Unsupported summarization: " + (Object)((Object)kind));
    }

    @Override
    public Expression visitEntityTypeLiteralExpression(SqmLiteralEntityType sqmExpression) {
        SqmExpressable nodeType = sqmExpression.getNodeType();
        EntityPersister mappingDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(nodeType.getHibernateEntityName());
        return new EntityTypeLiteral(mappingDescriptor);
    }

    @Override
    public Expression visitSqmPathEntityTypeExpression(SqmPathEntityType<?> sqmExpression) {
        return BasicValuedPathInterpretation.from(sqmExpression, this, this);
    }

    @Override
    public Object visitEnumLiteral(SqmEnumLiteral sqmEnumLiteral) {
        return new QueryLiteral<Enum>(sqmEnumLiteral.getEnumValue(), (BasicValuedMapping)this.determineValueMapping(sqmEnumLiteral));
    }

    @Override
    public Object visitFieldLiteral(SqmFieldLiteral sqmFieldLiteral) {
        return new QueryLiteral(sqmFieldLiteral.getValue(), (BasicValuedMapping)this.determineValueMapping(sqmFieldLiteral));
    }

    @Override
    public GroupedPredicate visitGroupedPredicate(SqmGroupedPredicate predicate) {
        return new GroupedPredicate((Predicate)predicate.getSubPredicate().accept(this));
    }

    @Override
    public Junction visitAndPredicate(SqmAndPredicate predicate) {
        Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
        conjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        conjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return conjunction;
    }

    @Override
    public Junction visitOrPredicate(SqmOrPredicate predicate) {
        Junction disjunction = new Junction(Junction.Nature.DISJUNCTION);
        disjunction.add((Predicate)predicate.getLeftHandPredicate().accept(this));
        disjunction.add((Predicate)predicate.getRightHandPredicate().accept(this));
        return disjunction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InSubQueryPredicate visitMemberOfPredicate(SqmMemberOfPredicate predicate) {
        Expression lhs;
        SqmPath<?> pluralPath = predicate.getPluralPath();
        PluralAttributeMapping mappingModelExpressable = (PluralAttributeMapping)this.determineValueMapping(pluralPath);
        if (mappingModelExpressable.getElementDescriptor() instanceof EntityCollectionPart) {
            this.inferableTypeAccessStack.push(() -> ((EntityCollectionPart)mappingModelExpressable.getElementDescriptor()).getKeyTargetMatchPart());
        } else if (mappingModelExpressable.getElementDescriptor() instanceof EmbeddedCollectionPart) {
            this.inferableTypeAccessStack.push(() -> mappingModelExpressable.getElementDescriptor());
        } else {
            this.inferableTypeAccessStack.push(() -> mappingModelExpressable);
        }
        try {
            lhs = (Expression)predicate.getLeftHandExpression().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return new InSubQueryPredicate(lhs, this.createMemberOfSubQuery(pluralPath, mappingModelExpressable), predicate.isNegated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryPart createMemberOfSubQuery(SqmPath<?> pluralPath, PluralAttributeMapping mappingModelExpressable) {
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        QuerySpec querySpec = new QuerySpec(false);
        this.pushProcessingState(new SqlAstQueryPartProcessingStateImpl(querySpec, this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent));
        try {
            TableGroup rootTableGroup = mappingModelExpressable.createRootTableGroup(pluralPath.getNavigablePath(), null, true, LockOptions.NONE.getLockMode(), () -> querySpec::applyPredicate, this, this.creationContext);
            this.getFromClauseAccess().registerTableGroup(pluralPath.getNavigablePath(), rootTableGroup);
            querySpec.getFromClause().addRoot(rootTableGroup);
            CollectionPart elementDescriptor = mappingModelExpressable.getElementDescriptor();
            elementDescriptor.createDomainResult(pluralPath.getNavigablePath(), rootTableGroup, null, this);
            Predicate predicate = mappingModelExpressable.getKeyDescriptor().generateJoinPredicate(parentFromClauseAccess.findTableGroup(pluralPath.getNavigablePath().getParent()), rootTableGroup, null, this.getSqlExpressionResolver(), this.creationContext);
            querySpec.applyPredicate(predicate);
        }
        finally {
            this.popProcessingStateStack();
        }
        return querySpec;
    }

    @Override
    public NegatedPredicate visitNegatedPredicate(SqmNegatedPredicate predicate) {
        return new NegatedPredicate((Predicate)predicate.getWrappedPredicate().accept(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComparisonPredicate visitComparisonPredicate(SqmComparisonPredicate predicate) {
        Expression rhs;
        Expression lhs;
        this.inferableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getRightHandExpression()));
        try {
            lhs = (Expression)predicate.getLeftHandExpression().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        this.inferableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getLeftHandExpression()));
        try {
            rhs = (Expression)predicate.getRightHandExpression().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return new ComparisonPredicate(lhs, predicate.getSqmOperator(), rhs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitIsEmptyPredicate(SqmEmptinessPredicate predicate) {
        QuerySpec subQuerySpec = new QuerySpec(false, 1);
        FromClauseAccess parentFromClauseAccess = this.getFromClauseAccess();
        SqlAstProcessingStateImpl subQueryState = new SqlAstProcessingStateImpl(this.getCurrentProcessingState(), this, this.currentClauseStack::getCurrent);
        this.pushProcessingState(subQueryState);
        try {
            SqmPluralValuedSimplePath<?> sqmPluralPath = predicate.getPluralPath();
            NavigablePath pluralPathNavPath = sqmPluralPath.getNavigablePath();
            NavigablePath parentNavPath = pluralPathNavPath.getParent();
            assert (parentNavPath != null);
            TableGroup parentTableGroup = parentFromClauseAccess.getTableGroup(parentNavPath);
            subQueryState.getSqlAstCreationState().getFromClauseAccess().registerTableGroup(parentNavPath, parentTableGroup);
            Object sqmPathInterpretation = this.visitPluralValuedPath((SqmPluralValuedSimplePath)sqmPluralPath);
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)sqmPathInterpretation.getExpressionType();
            TableGroupJoin tableGroupJoin = pluralAttributeMapping.createTableGroupJoin(pluralPathNavPath, parentTableGroup, sqmPluralPath.getExplicitAlias(), SqlAstJoinType.LEFT, LockMode.NONE, this.sqlAliasBaseManager, subQueryState, this.creationContext);
            TableGroup collectionTableGroup = tableGroupJoin.getJoinedGroup();
            subQuerySpec.getFromClause().addRoot(collectionTableGroup);
            subQuerySpec.applyPredicate(tableGroupJoin.getPredicate());
            ForeignKeyDescriptor collectionKeyDescriptor = pluralAttributeMapping.getKeyDescriptor();
            int jdbcTypeCount = collectionKeyDescriptor.getJdbcTypeCount();
            assert (jdbcTypeCount > 0);
            JdbcLiteral<Integer> jdbcLiteral = new JdbcLiteral<Integer>(1, StandardBasicTypes.INTEGER);
            subQuerySpec.getSelectClause().addSqlSelection(new SqlSelectionImpl(1, 0, jdbcLiteral));
            ExistsPredicate existsPredicate = new ExistsPredicate(subQuerySpec);
            return existsPredicate;
        }
        finally {
            this.popProcessingStateStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BetweenPredicate visitBetweenPredicate(SqmBetweenPredicate predicate) {
        Expression upperBound;
        Expression lowerBound;
        Expression expression;
        this.inferableTypeAccessStack.push(() -> (MappingModelExpressable)NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getLowerBound()), () -> this.determineValueMapping(predicate.getUpperBound())));
        try {
            expression = (Expression)predicate.getExpression().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        this.inferableTypeAccessStack.push(() -> (MappingModelExpressable)NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getExpression()), () -> this.determineValueMapping(predicate.getUpperBound())));
        try {
            lowerBound = (Expression)predicate.getLowerBound().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        this.inferableTypeAccessStack.push(() -> (MappingModelExpressable)NullnessHelper.coalesceSuppliedValues(() -> this.determineValueMapping(predicate.getExpression()), () -> this.determineValueMapping(predicate.getLowerBound())));
        try {
            upperBound = (Expression)predicate.getUpperBound().accept(this);
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return new BetweenPredicate(expression, lowerBound, upperBound, predicate.isNegated());
    }

    @Override
    public LikePredicate visitLikePredicate(SqmLikePredicate predicate) {
        Expression escapeExpression = predicate.getEscapeCharacter() == null ? null : (Expression)predicate.getEscapeCharacter().accept(this);
        return new LikePredicate((Expression)predicate.getMatchExpression().accept(this), (Expression)predicate.getPattern().accept(this), escapeExpression, predicate.isNegated());
    }

    @Override
    public NullnessPredicate visitIsNullPredicate(SqmNullnessPredicate predicate) {
        return new NullnessPredicate((Expression)predicate.getExpression().accept(this), predicate.isNegated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InListPredicate visitInListPredicate(SqmInListPredicate<?> predicate) {
        InListPredicate specialCase;
        SqmParameter sqmParameter;
        SqmExpression<?> sqmExpression;
        if (predicate.getListExpressions().size() == 1 && (sqmExpression = predicate.getListExpressions().get(0)) instanceof SqmParameter && (sqmParameter = (SqmParameter)sqmExpression).allowMultiValuedBinding() && (specialCase = this.processInListWithSingleParameter(predicate, sqmParameter)) != null) {
            return specialCase;
        }
        InListPredicate inPredicate = new InListPredicate((Expression)predicate.getTestExpression().accept(this), predicate.isNegated());
        this.inferableTypeAccessStack.push(() -> this.determineValueMapping(predicate.getTestExpression()));
        try {
            for (SqmExpression<?> expression : predicate.getListExpressions()) {
                inPredicate.addExpression((Expression)expression.accept(this));
            }
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return inPredicate;
    }

    private InListPredicate processInListWithSingleParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter sqmParameter) {
        assert (sqmParameter.allowMultiValuedBinding());
        if (sqmParameter instanceof JpaCriteriaParameter) {
            return this.processInSingleCriteriaParameter(sqmPredicate, (JpaCriteriaParameter)sqmParameter);
        }
        return this.processInSingleHqlParameter(sqmPredicate, sqmParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InListPredicate processInSingleHqlParameter(SqmInListPredicate<?> sqmPredicate, SqmParameter sqmParameter) {
        QueryParameterImplementor<?> domainParam = this.domainParameterXref.getQueryParameter(sqmParameter);
        QueryParameterBinding<?> domainParamBinding = this.domainParameterBindings.getBinding(domainParam);
        if (!domainParamBinding.isMultiValued()) {
            return null;
        }
        InListPredicate inListPredicate = new InListPredicate((Expression)sqmPredicate.getTestExpression().accept(this));
        this.inferableTypeAccessStack.push(() -> this.determineValueMapping(sqmPredicate.getTestExpression()));
        try {
            boolean first = true;
            for (Object bindValue : domainParamBinding.getBindValues()) {
                SqmParameter sqmParamToConsume;
                if (first) {
                    sqmParamToConsume = sqmParameter;
                    first = false;
                } else {
                    sqmParamToConsume = sqmParameter.copy();
                    this.domainParameterXref.addExpansion(domainParam, sqmParameter, sqmParamToConsume);
                }
                inListPredicate.addExpression(this.consumeSqmParameter(sqmParamToConsume));
            }
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return inListPredicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InListPredicate processInSingleCriteriaParameter(SqmInListPredicate<?> sqmPredicate, JpaCriteriaParameter jpaCriteriaParameter) {
        assert (jpaCriteriaParameter.allowsMultiValuedBinding());
        QueryParameterBinding domainParamBinding = this.domainParameterBindings.getBinding(jpaCriteriaParameter);
        if (!domainParamBinding.isMultiValued()) {
            return null;
        }
        InListPredicate inListPredicate = new InListPredicate((Expression)sqmPredicate.getTestExpression().accept(this));
        this.inferableTypeAccessStack.push(() -> this.determineValueMapping(sqmPredicate.getTestExpression()));
        SqmJpaCriteriaParameterWrapper<?> sqmWrapper = this.jpaCriteriaParamResolutions.get(jpaCriteriaParameter).get();
        try {
            boolean first = true;
            for (Object bindValue : domainParamBinding.getBindValues()) {
                SqmParameter<Object> sqmParamToConsume;
                if (first) {
                    sqmParamToConsume = sqmWrapper;
                    first = false;
                } else {
                    sqmParamToConsume = sqmWrapper.copy();
                    this.domainParameterXref.addExpansion(jpaCriteriaParameter, sqmWrapper, sqmParamToConsume);
                }
                inListPredicate.addExpression(this.consumeSqmParameter(sqmParamToConsume));
            }
        }
        finally {
            this.inferableTypeAccessStack.pop();
        }
        return inListPredicate;
    }

    @Override
    public InSubQueryPredicate visitInSubQueryPredicate(SqmInSubQueryPredicate predicate) {
        return new InSubQueryPredicate((Expression)predicate.getTestExpression().accept(this), (QueryPart)predicate.getSubQueryExpression().accept(this), predicate.isNegated());
    }

    @Override
    public Object visitBooleanExpressionPredicate(SqmBooleanExpressionPredicate predicate) {
        Object booleanExpression = predicate.getBooleanExpression().accept(this);
        if (booleanExpression instanceof SelfRenderingExpression) {
            return new SelfRenderingPredicate((SelfRenderingExpression)booleanExpression);
        }
        return new ComparisonPredicate((Expression)booleanExpression, ComparisonOperator.EQUAL, new QueryLiteral<Boolean>(true, this.basicType(Boolean.class)));
    }

    @Override
    public Object visitExistsPredicate(SqmExistsPredicate predicate) {
        return new ExistsPredicate((QueryPart)predicate.getExpression().accept(this));
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public Object visitFullyQualifiedClass(Class namedClass) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        ArrayList<Fetch> fetches = CollectionHelper.arrayList(fetchParent.getReferencedMappingType().getNumberOfFetchables());
        ArrayList bagRoles = new ArrayList();
        BiConsumer<Fetchable, Boolean> fetchableBiConsumer = (fetchable, isKeyFetchable) -> {
            NavigablePath fetchablePath = fetchParent.getNavigablePath().append(fetchable.getFetchableName());
            Fetch biDirectionalFetch = fetchable.resolveCircularFetch(fetchablePath, fetchParent, this);
            if (biDirectionalFetch != null) {
                fetches.add(biDirectionalFetch);
                return;
            }
            boolean incrementFetchDepth = fetchable.incrementFetchDepth();
            try {
                Fetch fetch;
                if (incrementFetchDepth) {
                    ++this.fetchDepth;
                }
                if ((fetch = this.buildFetch(fetchablePath, fetchParent, (Fetchable)fetchable, (boolean)isKeyFetchable)) != null) {
                    PluralAttributeMapping pluralAttributeMapping;
                    CollectionClassification collectionClassification;
                    if (fetch.getTiming() == FetchTiming.IMMEDIATE && fetchable instanceof PluralAttributeMapping && (collectionClassification = (pluralAttributeMapping = (PluralAttributeMapping)fetchable).getMappedType().getCollectionSemantics().getCollectionClassification()) == CollectionClassification.BAG) {
                        bagRoles.add(fetchable.getNavigableRole().getNavigableName());
                    }
                    fetches.add(fetch);
                }
            }
            finally {
                if (incrementFetchDepth) {
                    --this.fetchDepth;
                }
            }
        };
        fetchParent.getReferencedMappingContainer().visitKeyFetchables(fetchable -> fetchableBiConsumer.accept((Fetchable)fetchable, true), null);
        fetchParent.getReferencedMappingContainer().visitFetchables(fetchable -> fetchableBiConsumer.accept((Fetchable)fetchable, false), null);
        if (bagRoles.size() > 1) {
            throw new MultipleBagFetchException(bagRoles);
        }
        return fetches;
    }

    private Fetch buildFetch(NavigablePath fetchablePath, FetchParent fetchParent, Fetchable fetchable, boolean isKeyFetchable) {
        String alias;
        LockMode lockMode = LockMode.READ;
        FetchTiming fetchTiming = fetchable.getMappedFetchOptions().getTiming();
        boolean joined = false;
        EntityGraphTraversalState.TraversalResult traversalResult = null;
        FromClauseIndex fromClauseIndex = this.getFromClauseIndex();
        SqmAttributeJoin fetchedJoin = fromClauseIndex.findFetchedJoinByPath(fetchablePath);
        if (fetchedJoin != null) {
            assert (fromClauseIndex.getTableGroup(fetchablePath) != null);
            if (fetchedJoin.isFetched()) {
                fetchTiming = FetchTiming.IMMEDIATE;
            }
            joined = true;
            alias = fetchedJoin.getExplicitAlias();
            lockMode = this.determineLockMode(alias);
        } else {
            Integer maxDepth;
            TableGroup existingJoinedGroup;
            alias = null;
            if (!(fetchable instanceof CollectionPart)) {
                if (this.entityGraphTraversalState != null) {
                    traversalResult = this.entityGraphTraversalState.traverse(fetchParent, fetchable, isKeyFetchable);
                    fetchTiming = traversalResult.getFetchStrategy();
                    joined = traversalResult.isJoined();
                } else if (this.getLoadQueryInfluencers().hasEnabledFetchProfiles() && fetchParent instanceof EntityResultGraphNode) {
                    EntityResultGraphNode entityFetchParent = (EntityResultGraphNode)fetchParent;
                    EntityMappingType entityMappingType = entityFetchParent.getEntityValuedModelPart().getEntityMappingType();
                    String fetchParentEntityName = entityMappingType.getEntityName();
                    String fetchableRole = fetchParentEntityName + "." + fetchable.getFetchableName();
                    for (String enabledFetchProfileName : this.getLoadQueryInfluencers().getEnabledFetchProfileNames()) {
                        FetchProfile enabledFetchProfile = this.getCreationContext().getSessionFactory().getFetchProfile(enabledFetchProfileName);
                        org.hibernate.engine.profile.Fetch profileFetch = enabledFetchProfile.getFetchByRole(fetchableRole);
                        fetchTiming = FetchTiming.IMMEDIATE;
                        joined = joined || profileFetch.getStyle() == Fetch.Style.JOIN;
                    }
                }
            }
            if ((existingJoinedGroup = fromClauseIndex.findTableGroup(fetchablePath)) != null) {
                // empty if block
            }
            if ((maxDepth = this.getCreationContext().getMaximumFetchDepth()) != null && this.fetchDepth >= maxDepth) {
                joined = false;
            }
            if (joined && fetchable instanceof TableGroupJoinProducer) {
                fromClauseIndex.resolveTableGroup(fetchablePath, np -> {
                    TableGroup lhs = fromClauseIndex.getTableGroup(fetchParent.getNavigablePath());
                    TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)fetchable)).createTableGroupJoin(fetchablePath, lhs, alias, SqlAstJoinType.LEFT, LockMode.NONE, this);
                    return tableGroupJoin.getJoinedGroup();
                });
            }
        }
        try {
            Fetch fetch = fetchable.generateFetch(fetchParent, fetchablePath, fetchTiming, joined, lockMode, alias, this);
            if (fetchable instanceof PluralAttributeMapping && fetch.getTiming() == FetchTiming.IMMEDIATE && joined) {
                PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
                Joinable joinable = pluralAttributeMapping.getCollectionDescriptor().getCollectionType().getAssociatedJoinable(this.getCreationContext().getSessionFactory());
                TableGroup tableGroup = fromClauseIndex.getTableGroup(fetchablePath);
                FilterPredicate collectionFieldFilterPredicate = FilterHelper.createFilterPredicate(this.getLoadQueryInfluencers(), joinable, tableGroup);
                if (collectionFieldFilterPredicate != null) {
                    if (this.collectionFilterPredicates == null) {
                        this.collectionFilterPredicates = new HashMap<String, FilterPredicate>();
                    }
                    this.collectionFilterPredicates.put(tableGroup.getGroupAlias(), collectionFieldFilterPredicate);
                }
                if (pluralAttributeMapping.getCollectionDescriptor().isManyToMany()) {
                    assert (joinable instanceof CollectionPersister);
                    FilterPredicate manyToManyFilterPredicate = FilterHelper.createManyToManyFilterPredicate(this.getLoadQueryInfluencers(), (CollectionPersister)((Object)joinable), tableGroup);
                    if (manyToManyFilterPredicate != null) {
                        assert (tableGroup.getTableReferenceJoins() != null && tableGroup.getTableReferenceJoins().size() == 1);
                        tableGroup.getTableReferenceJoins().get(0).applyPredicate(manyToManyFilterPredicate);
                    }
                }
                if (this.orderByFragmentConsumer != null) {
                    assert (tableGroup.getModelPart() == pluralAttributeMapping);
                    if (pluralAttributeMapping.getOrderByFragment() != null) {
                        this.orderByFragmentConsumer.accept(pluralAttributeMapping.getOrderByFragment(), tableGroup);
                    }
                    if (pluralAttributeMapping.getManyToManyOrderByFragment() != null) {
                        this.orderByFragmentConsumer.accept(pluralAttributeMapping.getManyToManyOrderByFragment(), tableGroup);
                    }
                }
            }
            Fetch fetch2 = fetch;
            return fetch2;
        }
        catch (RuntimeException e) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not generate fetch : %s -> %s", fetchParent.getNavigablePath(), fetchable.getFetchableName()), e);
        }
        finally {
            if (this.entityGraphTraversalState != null && traversalResult != null) {
                this.entityGraphTraversalState.backtrack(traversalResult.getPreviousContext());
            }
        }
    }

    protected static class SqlSelectionForSqmSelectionResolver
    implements SqlExpressionResolver,
    SqlSelectionForSqmSelectionCollector {
        private final SqlExpressionResolver delegate;
        private final List<SqlSelection>[] sqlSelectionsForSqmSelection;
        private int index = -1;

        public SqlSelectionForSqmSelectionResolver(SqlExpressionResolver delegate, int sqmSelectionCount) {
            this.delegate = delegate;
            this.sqlSelectionsForSqmSelection = new List[sqmSelectionCount];
        }

        @Override
        public void next() {
            ++this.index;
        }

        @Override
        public List<SqlSelection> getSelections(int position) {
            return this.sqlSelectionsForSqmSelection[position - 1];
        }

        @Override
        public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
            return this.delegate.resolveSqlExpression(key, creator);
        }

        @Override
        public SqlSelection resolveSqlSelection(Expression expression, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            SqlSelection selection = this.delegate.resolveSqlSelection(expression, javaTypeDescriptor, typeConfiguration);
            List<SqlSelection> sqlSelectionList = this.sqlSelectionsForSqmSelection[this.index];
            if (sqlSelectionList == null) {
                this.sqlSelectionsForSqmSelection[this.index] = sqlSelectionList = new ArrayList<SqlSelection>();
            }
            sqlSelectionList.add(selection);
            return selection;
        }
    }

    protected static class DelegatingSqlSelectionForSqmSelectionCollector
    implements SqlExpressionResolver,
    SqlSelectionForSqmSelectionCollector {
        private final SqlExpressionResolver delegate;
        private SqlSelectionForSqmSelectionCollector sqlSelectionForSqmSelectionCollector;

        public DelegatingSqlSelectionForSqmSelectionCollector(SqlExpressionResolver delegate) {
            this.delegate = delegate;
        }

        @Override
        public void next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SqlSelection> getSelections(int position) {
            return this.sqlSelectionForSqmSelectionCollector.getSelections(position);
        }

        @Override
        public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
            return this.delegate.resolveSqlExpression(key, creator);
        }

        @Override
        public SqlSelection resolveSqlSelection(Expression expression, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return this.delegate.resolveSqlSelection(expression, javaTypeDescriptor, typeConfiguration);
        }

        public SqlSelectionForSqmSelectionCollector getSqlSelectionForSqmSelectionCollector() {
            return this.sqlSelectionForSqmSelectionCollector;
        }

        public void setSqlSelectionForSqmSelectionCollector(SqlSelectionForSqmSelectionCollector sqlSelectionForSqmSelectionCollector) {
            this.sqlSelectionForSqmSelectionCollector = sqlSelectionForSqmSelectionCollector;
        }
    }

    protected static interface SqlSelectionForSqmSelectionCollector {
        public void next();

        public List<SqlSelection> getSelections(int var1);
    }

    private static class StandardOrderByFragmentConsumer
    implements OrderByFragmentConsumer {
        private Map<OrderByFragment, TableGroup> fragments;

        private StandardOrderByFragmentConsumer() {
        }

        @Override
        public void accept(OrderByFragment orderByFragment, TableGroup tableGroup) {
            if (this.fragments == null) {
                this.fragments = new LinkedHashMap<OrderByFragment, TableGroup>();
            }
            this.fragments.put(orderByFragment, tableGroup);
        }

        @Override
        public void visitFragments(BiConsumer<OrderByFragment, TableGroup> consumer) {
            if (this.fragments == null || this.fragments.isEmpty()) {
                return;
            }
            this.fragments.forEach(consumer);
        }
    }

    private static interface OrderByFragmentConsumer {
        public void accept(OrderByFragment var1, TableGroup var2);

        public void visitFragments(BiConsumer<OrderByFragment, TableGroup> var1);
    }
}

