/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.internal.SqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public abstract class AbstractSqmPathInterpretation<T>
implements SqmPathInterpretation<T> {
    private final SqmPath<T> sqmPath;
    private final ModelPart mapping;
    private final TableGroup tableGroup;

    public AbstractSqmPathInterpretation(SqmPath<T> sqmPath, ModelPart mapping, TableGroup tableGroup) {
        assert (sqmPath != null);
        assert (mapping != null);
        assert (tableGroup != null);
        this.sqmPath = sqmPath;
        this.mapping = mapping;
        this.tableGroup = tableGroup;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.sqmPath.getNavigablePath();
    }

    @Override
    public ModelPart getExpressionType() {
        return this.mapping;
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.mapping.createDomainResult(this.getNavigablePath(), this.tableGroup, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.mapping.applySqlSelections(this.getNavigablePath(), this.tableGroup, creationState);
    }
}

