/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;

public class EntityValuedPathInterpretation<T>
extends AbstractSqmPathInterpretation<T> {
    private final Expression sqlExpression;

    public static <T> EntityValuedPathInterpretation<T> from(SqmEntityValuedSimplePath<T> sqmPath, SqmToSqlAstConverter sqlAstCreationState) {
        TableGroup tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        EntityValuedModelPart mapping = (EntityValuedModelPart)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        SqlTuple sqlExpression = EntityValuedPathInterpretation.resolveSqlExpression(sqmPath, sqlAstCreationState, tableGroup, mapping);
        return new EntityValuedPathInterpretation<T>(sqlExpression, sqmPath, tableGroup, mapping);
    }

    private EntityValuedPathInterpretation(Expression sqlExpression, SqmEntityValuedSimplePath sqmPath, TableGroup tableGroup, EntityValuedModelPart mapping) {
        super(sqmPath, mapping, tableGroup);
        this.sqlExpression = sqlExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlExpression.accept(sqlTreeWalker);
    }

    private static <T> SqlTuple resolveSqlExpression(SqmEntityValuedSimplePath<T> sqmPath, SqmToSqlAstConverter sqlAstCreationState, TableGroup tableGroup, EntityValuedModelPart mapping) {
        ArrayList columnReferences = new ArrayList();
        assert (mapping instanceof ToOneAttributeMapping);
        ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)mapping;
        ModelPart modelPart = EntityValuedPathInterpretation.getModelPart(sqlAstCreationState, toOneAttributeMapping);
        modelPart.forEachSelection((columnIndex, selection) -> {
            TableReference tableReference = EntityValuedPathInterpretation.getTableReference(sqmPath, sqlAstCreationState, tableGroup, toOneAttributeMapping, selection.getContainingTableExpression());
            Expression columnReference = sqlAstCreationState.getSqlExpressionResolver().resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, selection.getSelectionExpression()), sqlAstProcessingState -> new ColumnReference(tableReference.getIdentificationVariable(), selection, sqlAstCreationState.getCreationContext().getSessionFactory()));
            columnReferences.add((ColumnReference)columnReference);
        });
        SqlTuple sqlExpression = new SqlTuple(columnReferences, mapping);
        return sqlExpression;
    }

    private static ModelPart getModelPart(SqmToSqlAstConverter sqlAstCreationState, ToOneAttributeMapping toOneAttributeMapping) {
        Clause current = sqlAstCreationState.getCurrentClauseStack().getCurrent();
        ModelPart modelPart = current == Clause.SELECT ? toOneAttributeMapping.getAssociatedEntityMappingType().getIdentifierMapping() : toOneAttributeMapping.getForeignKeyDescriptor();
        return modelPart;
    }

    private static <T> TableReference getTableReference(SqmEntityValuedSimplePath<T> sqmPath, SqlAstCreationState sqlAstCreationState, TableGroup tableGroup, ToOneAttributeMapping toOneAttributeMapping, String containingTableExpression) {
        TableReference tableReference = tableGroup.getTableReference(containingTableExpression);
        if (tableReference == null) {
            TableGroupJoin tableGroupJoin = toOneAttributeMapping.createTableGroupJoin(sqmPath.getNavigablePath(), tableGroup, null, toOneAttributeMapping.isNullable() ? SqlAstJoinType.INNER : SqlAstJoinType.LEFT, LockMode.NONE, sqlAstCreationState);
            sqlAstCreationState.getFromClauseAccess().registerTableGroup(sqmPath.getNavigablePath(), tableGroupJoin.getJoinedGroup());
            return tableGroupJoin.getJoinedGroup().getTableReference(containingTableExpression);
        }
        return tableReference;
    }
}

