/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaSimpleCase;
import org.hibernate.query.internal.QueryHelper;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmCaseSimple<T, R>
extends AbstractSqmExpression<R>
implements JpaSimpleCase<T, R>,
DomainResultProducer<R> {
    private final SqmExpression<T> fixture;
    private List<WhenFragment<T, R>> whenFragments = new ArrayList<WhenFragment<T, R>>();
    private SqmExpression<R> otherwise;

    public SqmCaseSimple(SqmExpression<T> fixture, NodeBuilder nodeBuilder) {
        this(fixture, null, nodeBuilder);
    }

    public SqmCaseSimple(SqmExpression<T> fixture, SqmExpressable<R> inherentType, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
        this.fixture = fixture;
    }

    public SqmExpression<T> getFixture() {
        return this.fixture;
    }

    public List<WhenFragment<T, R>> getWhenFragments() {
        return this.whenFragments;
    }

    public SqmExpression<R> getOtherwise() {
        return this.otherwise;
    }

    public void otherwise(SqmExpression<R> otherwiseExpression) {
        this.otherwise = otherwiseExpression;
        this.applyInferableResultType(otherwiseExpression.getNodeType());
    }

    public void when(SqmExpression<T> test, SqmExpression<R> result) {
        this.whenFragments.add(new WhenFragment<T, R>(test, result));
        this.applyInferableResultType(result.getNodeType());
    }

    private void applyInferableResultType(SqmExpressable<?> type) {
        if (type == null) {
            return;
        }
        SqmExpressable oldType = this.getNodeType();
        SqmExpressable newType = QueryHelper.highestPrecedenceType2(oldType, type);
        if (newType != null && newType != oldType) {
            this.internalApplyInferableType(newType);
        }
    }

    @Override
    protected void internalApplyInferableType(SqmExpressable newType) {
        super.internalApplyInferableType(newType);
        if (this.otherwise != null) {
            this.otherwise.applyInferableType(newType);
        }
        if (this.whenFragments != null) {
            this.whenFragments.forEach(whenFragment -> whenFragment.getResult().applyInferableType(newType));
        }
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitSimpleCaseExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "<simple-case>";
    }

    @Override
    public JpaExpression<T> getExpression() {
        return this.getFixture();
    }

    @Override
    public JpaSimpleCase<T, R> when(T condition, R result) {
        this.when(this.nodeBuilder().value(condition), this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> when(T condition, Expression<? extends R> result) {
        this.when(this.nodeBuilder().value(condition), (SqmExpression)result);
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> otherwise(R result) {
        this.otherwise(this.nodeBuilder().value(result));
        return this;
    }

    @Override
    public JpaSimpleCase<T, R> otherwise(Expression<? extends R> result) {
        this.otherwise((SqmExpression)result);
        return this;
    }

    public static class WhenFragment<T, R> {
        private final SqmExpression<T> checkValue;
        private final SqmExpression<R> result;

        public WhenFragment(SqmExpression<T> checkValue, SqmExpression<R> result) {
            this.checkValue = checkValue;
            this.result = result;
        }

        public SqmExpression<T> getCheckValue() {
            return this.checkValue;
        }

        public SqmExpression<R> getResult() {
            return this.result;
        }
    }
}

