/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.query.criteria.JpaCoalesce;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmCoalesce<T>
extends AbstractSqmExpression<T>
implements JpaCoalesce<T> {
    private final SqmFunctionDescriptor functionDescriptor;
    private final List<SqmExpression<? extends T>> arguments;

    public SqmCoalesce(NodeBuilder nodeBuilder) {
        this((SqmExpressable<T>)null, nodeBuilder);
    }

    public SqmCoalesce(SqmExpressable<T> type, NodeBuilder nodeBuilder) {
        super(type, nodeBuilder);
        this.functionDescriptor = nodeBuilder.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("coalesce");
        this.arguments = new ArrayList<SqmExpression<? extends T>>();
    }

    public SqmCoalesce(SqmExpressable<T> type, int numberOfArguments, NodeBuilder nodeBuilder) {
        super(type, nodeBuilder);
        this.functionDescriptor = nodeBuilder.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("coalesce");
        this.arguments = new ArrayList<SqmExpression<? extends T>>(numberOfArguments);
    }

    public SqmFunctionDescriptor getFunctionDescriptor() {
        return this.functionDescriptor;
    }

    public void value(SqmExpression<? extends T> expression) {
        this.arguments.add(expression);
    }

    public List<SqmExpression<? extends T>> getArguments() {
        return this.arguments;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitCoalesce(this);
    }

    @Override
    public String asLoggableText() {
        return "coalesce(...)";
    }

    @Override
    public SqmCoalesce<T> value(T value) {
        this.value(this.nodeBuilder().value(value));
        return this;
    }

    @Override
    public SqmCoalesce<T> value(Expression<? extends T> value) {
        this.value((SqmExpression)value);
        return this;
    }

    @Override
    public SqmCoalesce<T> value(JpaExpression<? extends T> value) {
        this.value((SqmExpression)value);
        return this;
    }

    @Override
    public SqmCoalesce<T> values(T ... values) {
        for (T value : values) {
            this.value(this.nodeBuilder().value(value));
        }
        return this;
    }
}

