/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.jpa;

import org.hibernate.query.criteria.JpaTupleElement;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.type.StandardBasicTypes;

public abstract class AbstractJpaTupleElement<T>
extends AbstractSqmNode
implements SqmVisitableNode,
JpaTupleElement<T> {
    private SqmExpressable<T> expressableType;
    private String alias;

    protected AbstractJpaTupleElement(SqmExpressable<T> expressableType, NodeBuilder criteriaBuilder) {
        super(criteriaBuilder);
        this.setExpressableType(expressableType);
    }

    protected AbstractJpaTupleElement(Class<T> javaType, NodeBuilder criteriaBuilder) {
        super(criteriaBuilder);
        if (javaType != null) {
            this.setJavaType(javaType);
        } else {
            this.setExpressableType(StandardBasicTypes.OBJECT_TYPE);
        }
    }

    public String getAlias() {
        return this.alias;
    }

    protected void setAlias(String alias) {
        this.alias = alias;
    }

    public SqmExpressable<T> getNodeType() {
        return this.expressableType;
    }

    protected final void setExpressableType(SqmExpressable<?> expressableType) {
        this.expressableType = expressableType;
    }

    protected void setJavaType(Class<T> targetType) {
        if (targetType != null) {
            this.setExpressableType(this.nodeBuilder().getDomainModel().getTypeConfiguration().standardBasicTypeForJavaType(targetType));
        } else {
            this.setExpressableType(StandardBasicTypes.OBJECT_TYPE);
        }
    }
}

