/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.jpa;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.query.sqm.spi.BaseSemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.expression.JpaCriteriaParameter;
import org.hibernate.query.sqm.tree.expression.SqmJpaCriteriaParameterWrapper;
import org.hibernate.query.sqm.tree.expression.SqmNamedParameter;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.expression.SqmPositionalParameter;
import org.hibernate.service.ServiceRegistry;

public class ParameterCollector
extends BaseSemanticQueryWalker {
    private Set<SqmParameter<?>> parameterExpressions;
    private final Consumer<SqmParameter<?>> consumer;

    public static Set<SqmParameter<?>> collectParameters(SqmStatement<?> statement, Consumer<SqmParameter<?>> consumer, ServiceRegistry serviceRegistry) {
        ParameterCollector collector = new ParameterCollector(serviceRegistry, consumer);
        statement.accept(collector);
        return collector.parameterExpressions == null ? Collections.emptySet() : collector.parameterExpressions;
    }

    private ParameterCollector(ServiceRegistry serviceRegistry, Consumer<SqmParameter<?>> consumer) {
        super(serviceRegistry);
        this.consumer = consumer;
    }

    @Override
    public Object visitPositionalParameterExpression(SqmPositionalParameter expression) {
        return this.visitParameter(expression);
    }

    @Override
    public Object visitNamedParameterExpression(SqmNamedParameter expression) {
        return this.visitParameter(expression);
    }

    @Override
    public SqmJpaCriteriaParameterWrapper<?> visitJpaCriteriaParameter(JpaCriteriaParameter<?> expression) {
        return (SqmJpaCriteriaParameterWrapper)this.visitParameter(new SqmJpaCriteriaParameterWrapper(expression.getHibernateType(), expression, expression.nodeBuilder()));
    }

    private SqmParameter<?> visitParameter(SqmParameter<?> param) {
        if (this.parameterExpressions == null) {
            this.parameterExpressions = new HashSet();
        }
        this.parameterExpressions.add(param);
        this.consumer.accept(param);
        return param;
    }
}

