/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.predicate;

import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.predicate.AbstractSqmPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmJunctivePredicate;
import org.hibernate.query.sqm.tree.predicate.SqmNegatedPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public class SqmAndPredicate
extends AbstractSqmPredicate
implements SqmJunctivePredicate {
    private final SqmPredicate leftHandPredicate;
    private final SqmPredicate rightHandPredicate;

    public SqmAndPredicate(SqmPredicate leftHandPredicate, SqmPredicate rightHandPredicate, NodeBuilder nodeBuilder) {
        super(nodeBuilder);
        this.leftHandPredicate = leftHandPredicate;
        this.rightHandPredicate = rightHandPredicate;
    }

    @Override
    public SqmPredicate getLeftHandPredicate() {
        return this.leftHandPredicate;
    }

    @Override
    public SqmPredicate getRightHandPredicate() {
        return this.rightHandPredicate;
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitAndPredicate(this);
    }

    @Override
    public Predicate.BooleanOperator getOperator() {
        return Predicate.BooleanOperator.AND;
    }

    public boolean isNegated() {
        return false;
    }

    @Override
    public List<Expression<Boolean>> getExpressions() {
        return Arrays.asList(this.leftHandPredicate, this.rightHandPredicate);
    }

    @Override
    public SqmPredicate not() {
        return new SqmNegatedPredicate(this, this.nodeBuilder());
    }
}

