/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.EntityType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.tree.AbstractSqmNode;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;

public abstract class AbstractSqmSelectQuery<T>
extends AbstractSqmNode
implements SqmSelectQuery<T>,
SqmCteContainer {
    private final Map<String, SqmCteStatement<?>> cteStatements = new LinkedHashMap();
    private boolean withRecursive;
    private SqmQueryPart<T> sqmQueryPart;
    private Class<T> resultType;

    public AbstractSqmSelectQuery(Class<T> resultType, NodeBuilder builder) {
        super(builder);
        this.sqmQueryPart = new SqmQuerySpec(builder);
        this.resultType = resultType;
    }

    public AbstractSqmSelectQuery(SqmQueryPart<T> queryPart, Class<T> resultType, NodeBuilder builder) {
        super(builder);
        this.resultType = resultType;
        this.setQueryPart(queryPart);
    }

    @Override
    public boolean isWithRecursive() {
        return this.withRecursive;
    }

    @Override
    public void setWithRecursive(boolean withRecursive) {
        this.withRecursive = withRecursive;
    }

    @Override
    public Collection<SqmCteStatement<?>> getCteStatements() {
        return this.cteStatements.values();
    }

    @Override
    public SqmCteStatement<?> getCteStatement(String cteLabel) {
        return this.cteStatements.get(cteLabel);
    }

    @Override
    public void addCteStatement(SqmCteStatement<?> cteStatement) {
        if (this.cteStatements.putIfAbsent(cteStatement.getCteTable().getCteName(), cteStatement) != null) {
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getCteName() + " already exists!");
        }
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    protected void setResultType(Class<T> resultType) {
        this.resultType = resultType;
    }

    @Override
    public SqmQuerySpec<T> getQuerySpec() {
        return this.sqmQueryPart.getFirstQuerySpec();
    }

    @Override
    public SqmQueryPart<T> getQueryPart() {
        return this.sqmQueryPart;
    }

    public void setQueryPart(SqmQueryPart<T> sqmQueryPart) {
        this.sqmQueryPart = sqmQueryPart;
    }

    public Set<Root<?>> getRoots() {
        return ((SqmQuerySpec)this.getQuerySpec()).getRoots();
    }

    @Override
    public <X> SqmRoot<X> from(Class<X> entityClass) {
        return this.addRoot(new SqmRoot(this.nodeBuilder().getDomainModel().entity((Class)entityClass), null, this.nodeBuilder()));
    }

    private <X> SqmRoot<X> addRoot(SqmRoot<X> root) {
        ((SqmQuerySpec)this.getQuerySpec()).addRoot(root);
        return root;
    }

    @Override
    public <X> SqmRoot<X> from(EntityType<X> entityType) {
        return this.addRoot(new SqmRoot((EntityDomainType)entityType, null, this.nodeBuilder()));
    }

    public boolean isDistinct() {
        return ((SqmQuerySpec)this.getQuerySpec()).isDistinct();
    }

    @Override
    public SqmSelectQuery<T> distinct(boolean distinct) {
        ((SqmQuerySpec)this.getQuerySpec()).setDistinct(distinct);
        return this;
    }

    @Override
    public JpaSelection<T> getSelection() {
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection();
    }

    @Override
    public SqmPredicate getRestriction() {
        return ((SqmQuerySpec)this.getQuerySpec()).getRestriction();
    }

    @Override
    public SqmSelectQuery<T> where(Expression<Boolean> restriction) {
        ((SqmQuerySpec)this.getQuerySpec()).setRestriction((Expression)restriction);
        return this;
    }

    @Override
    public SqmSelectQuery<T> where(Predicate ... restrictions) {
        ((SqmQuerySpec)this.getQuerySpec()).setRestriction(restrictions);
        return this;
    }

    public List<Expression<?>> getGroupList() {
        return ((SqmQuerySpec)this.getQuerySpec()).getGroupingExpressions();
    }

    @Override
    public SqmSelectQuery<T> groupBy(Expression<?> ... expressions) {
        return this.groupBy((List)Arrays.asList(expressions));
    }

    @Override
    public SqmSelectQuery<T> groupBy(List<Expression<?>> grouping) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupingExpressions(grouping);
        return this;
    }

    @Override
    public SqmPredicate getGroupRestriction() {
        return ((SqmQuerySpec)this.getQuerySpec()).getGroupRestriction();
    }

    @Override
    public SqmSelectQuery<T> having(Expression<Boolean> booleanExpression) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupRestriction(this.nodeBuilder().wrap((Expression)booleanExpression));
        return this;
    }

    @Override
    public SqmSelectQuery<T> having(Predicate ... predicates) {
        ((SqmQuerySpec)this.getQuerySpec()).setGroupRestriction(this.nodeBuilder().wrap((Expression[])predicates));
        return this;
    }
}

