/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.util.Collections;
import java.util.List;
import org.hibernate.FetchClauseType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.type.StandardBasicTypes;

public abstract class SqmQueryPart<T>
implements SqmVisitableNode,
JpaQueryPart<T> {
    private final NodeBuilder nodeBuilder;
    private SqmOrderByClause orderByClause;
    private SqmExpression<?> offsetExpression;
    private SqmExpression<?> fetchExpression;
    private FetchClauseType fetchClauseType = FetchClauseType.ROWS_ONLY;

    public SqmQueryPart(NodeBuilder nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
    }

    public abstract SqmQuerySpec<T> getFirstQuerySpec();

    public abstract SqmQuerySpec<T> getLastQuerySpec();

    public abstract boolean isSimpleQueryPart();

    @Override
    public NodeBuilder nodeBuilder() {
        return this.nodeBuilder;
    }

    public SqmOrderByClause getOrderByClause() {
        return this.orderByClause;
    }

    public void setOrderByClause(SqmOrderByClause orderByClause) {
        this.orderByClause = orderByClause;
    }

    public SqmExpression<?> getFetchExpression() {
        return this.fetchExpression;
    }

    public SqmExpression<?> getOffsetExpression() {
        return this.offsetExpression;
    }

    public void setOffsetExpression(SqmExpression<?> offsetExpression) {
        if (offsetExpression != null) {
            offsetExpression.applyInferableType(StandardBasicTypes.INTEGER);
        }
        this.offsetExpression = offsetExpression;
    }

    public void setFetchExpression(SqmExpression<?> fetchExpression) {
        this.setFetchExpression(fetchExpression, FetchClauseType.ROWS_ONLY);
    }

    public void setFetchExpression(SqmExpression<?> fetchExpression, FetchClauseType fetchClauseType) {
        if (fetchExpression == null) {
            this.fetchExpression = null;
            this.fetchClauseType = null;
        } else {
            if (fetchClauseType == null) {
                throw new IllegalArgumentException("Fetch clause may not be null!");
            }
            fetchExpression.applyInferableType(StandardBasicTypes.INTEGER);
            this.fetchExpression = fetchExpression;
            this.fetchClauseType = fetchClauseType;
        }
    }

    @Override
    public FetchClauseType getFetchClauseType() {
        return this.fetchClauseType;
    }

    @Override
    public List<SqmSortSpecification> getSortSpecifications() {
        if (this.getOrderByClause() == null) {
            return Collections.emptyList();
        }
        return this.getOrderByClause().getSortSpecifications();
    }

    @Override
    public SqmQueryPart<T> setSortSpecifications(List<? extends JpaOrder> sortSpecifications) {
        if (this.getOrderByClause() == null) {
            this.setOrderByClause(new SqmOrderByClause());
        }
        this.getOrderByClause().setSortSpecifications(sortSpecifications);
        return this;
    }

    @Override
    public SqmExpression<?> getOffset() {
        return this.getOffsetExpression();
    }

    @Override
    public SqmQueryPart<T> setOffset(JpaExpression<?> offset) {
        this.setOffsetExpression((SqmExpression)offset);
        return this;
    }

    @Override
    public SqmExpression<?> getFetch() {
        return this.getFetchExpression();
    }

    @Override
    public SqmQueryPart<T> setFetch(JpaExpression<?> fetch) {
        this.setFetchExpression((SqmExpression)fetch);
        return this;
    }

    @Override
    public JpaQueryPart<T> setFetch(JpaExpression<?> fetch, FetchClauseType fetchClauseType) {
        this.setFetchExpression((SqmExpression)fetch, fetchClauseType);
        return this;
    }
}

