/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import org.hibernate.NullPrecedence;
import org.hibernate.SortOrder;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaOrder;
import org.hibernate.query.sqm.tree.expression.SqmExpression;

public class SqmSortSpecification
implements JpaOrder {
    private final SqmExpression sortExpression;
    private final SortOrder sortOrder;
    private NullPrecedence nullPrecedence;

    public SqmSortSpecification(SqmExpression sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        this.sortExpression = sortExpression;
        this.sortOrder = sortOrder;
        this.nullPrecedence = nullPrecedence;
    }

    public SqmSortSpecification(SqmExpression sortExpression) {
        this(sortExpression, SortOrder.ASCENDING, null);
    }

    public SqmSortSpecification(SqmExpression sortExpression, SortOrder sortOrder) {
        this(sortExpression, sortOrder, null);
    }

    public SqmExpression getSortExpression() {
        return this.sortExpression;
    }

    @Override
    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public JpaOrder nullPrecedence(NullPrecedence nullPrecedence) {
        this.nullPrecedence = nullPrecedence;
        return this;
    }

    @Override
    public NullPrecedence getNullPrecedence() {
        return this.nullPrecedence;
    }

    @Override
    public JpaOrder reverse() {
        SortOrder newSortOrder = this.sortOrder == null ? SortOrder.DESCENDING : this.sortOrder.reverse();
        return new SqmSortSpecification(this.sortExpression, newSortOrder, this.nullPrecedence);
    }

    @Override
    public JpaExpression<?> getExpression() {
        return this.getSortExpression();
    }

    public boolean isAscending() {
        return this.sortOrder == SortOrder.ASCENDING;
    }
}

