/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.hibernate.CteSearchClauseKind;
import org.hibernate.FetchClauseType;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.NullPrecedence;
import org.hibernate.SortOrder;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.AbstractDelegatingWrapperOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.FilterJdbcParameter;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicValuedCollectionPart;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.Limit;
import org.hibernate.query.TemporalUnit;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.sql.internal.EmbeddableValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.NonAggregatedCompositeValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.SqmParameterInterpretation;
import org.hibernate.query.sqm.tree.expression.Conversion;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlTreeCreationException;
import org.hibernate.sql.ast.SqlTreePrinter;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteContainer;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.SearchClauseSpecification;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.Collate;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Distinct;
import org.hibernate.sql.ast.tree.expression.Duration;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractUnit;
import org.hibernate.sql.ast.tree.expression.Format;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.LiteralAsParameter;
import org.hibernate.sql.ast.tree.expression.NullnessLiteral;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Star;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.expression.TrimSpecification;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.ExistsPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.exec.spi.JdbcUpdate;
import org.hibernate.sql.results.graph.DomainResultGraphPrinter;
import org.hibernate.sql.results.jdbc.internal.JdbcValuesMappingProducerStandard;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.sql.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;

public abstract class AbstractSqlAstTranslator<T extends JdbcOperation>
implements SqlAstTranslator<T>,
SqlAppender {
    private static final QueryLiteral<Integer> ONE_LITERAL = new QueryLiteral<Integer>(1, IntegerType.INSTANCE);
    private final SessionFactoryImplementor sessionFactory;
    private final StringBuilder sqlBuffer = new StringBuilder();
    private final List<JdbcParameterBinder> parameterBinders = new ArrayList<JdbcParameterBinder>();
    private final JdbcParametersImpl jdbcParameters = new JdbcParametersImpl();
    private final Set<FilterJdbcParameter> filterJdbcParameters = new HashSet<FilterJdbcParameter>();
    private final Stack<Clause> clauseStack = new StandardStack<Clause>();
    private final Stack<QueryPart> queryPartStack = new StandardStack<QueryPart>();
    private final Dialect dialect;
    private final Statement statement;
    private final Set<String> affectedTableNames = new HashSet<String>();
    private String dmlTargetTableAlias;
    private boolean needsSelectAliases;
    private QueryPart queryPartForRowNumbering;
    private int queryPartForRowNumberingAliasCounter;
    private int queryGroupAliasCounter;
    private transient AbstractSqmSelfRenderingFunctionDescriptor castFunction;
    private transient LazySessionWrapperOptions lazySessionWrapperOptions;
    private boolean inlineParameters;
    private Map<JdbcParameter, JdbcParameterBinding> appliedParameterBindings = Collections.emptyMap();
    private JdbcParameterBindings jdbcParameterBindings;
    private LockOptions lockOptions;
    private Limit limit;
    private JdbcParameter offsetParameter;
    private JdbcParameter limitParameter;

    public Dialect getDialect() {
        return this.dialect;
    }

    protected AbstractSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        this.sessionFactory = sessionFactory;
        this.statement = statement;
        this.dialect = sessionFactory.getJdbcServices().getDialect();
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    protected AbstractSqmSelfRenderingFunctionDescriptor castFunction() {
        if (this.castFunction == null) {
            this.castFunction = (AbstractSqmSelfRenderingFunctionDescriptor)this.sessionFactory.getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("cast");
        }
        return this.castFunction;
    }

    protected WrapperOptions getWrapperOptions() {
        if (this.lazySessionWrapperOptions == null) {
            this.lazySessionWrapperOptions = new LazySessionWrapperOptions(this.sessionFactory);
        }
        return this.lazySessionWrapperOptions;
    }

    public String getSql() {
        return this.sqlBuffer.toString();
    }

    protected void cleanup() {
        if (this.lazySessionWrapperOptions != null) {
            this.lazySessionWrapperOptions.cleanup();
            this.lazySessionWrapperOptions = null;
        }
        this.jdbcParameterBindings = null;
        this.lockOptions = null;
        this.limit = null;
        this.setOffsetParameter(null);
        this.setLimitParameter(null);
    }

    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    public Set<FilterJdbcParameter> getFilterJdbcParameters() {
        return this.filterJdbcParameters;
    }

    protected SqlAppender getSqlAppender() {
        return this;
    }

    @Override
    public Set<String> getAffectedTableNames() {
        return this.affectedTableNames;
    }

    @Override
    public void appendSql(String fragment) {
        this.sqlBuffer.append(fragment);
    }

    @Override
    public void appendSql(char fragment) {
        this.sqlBuffer.append(fragment);
    }

    protected JdbcServices getJdbcServices() {
        return this.getSessionFactory().getJdbcServices();
    }

    protected void addAppliedParameterBinding(JdbcParameter parameter, JdbcParameterBinding binding) {
        if (this.appliedParameterBindings.isEmpty()) {
            this.appliedParameterBindings = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>();
        }
        if (binding == null) {
            this.appliedParameterBindings.put(parameter, null);
        } else {
            JdbcMapping bindType = binding.getBindType();
            Object value = bindType.getJavaTypeDescriptor().getMutabilityPlan().deepCopy(binding.getBindValue());
            this.appliedParameterBindings.put(parameter, new JdbcParameterBindingImpl(bindType, value));
        }
    }

    protected Map<JdbcParameter, JdbcParameterBinding> getAppliedParameterBindings() {
        return this.appliedParameterBindings;
    }

    protected JdbcParameterBindings getJdbcParameterBindings() {
        return this.jdbcParameterBindings;
    }

    protected LockOptions getLockOptions() {
        return this.lockOptions;
    }

    protected Limit getLimit() {
        return this.limit;
    }

    protected boolean hasLimit() {
        return this.limit != null && !this.limit.isEmpty();
    }

    protected boolean hasOffset(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit()) {
            return this.limit.getFirstRowJpa() != 0;
        }
        return queryPart.getOffsetClauseExpression() != null;
    }

    protected boolean useOffsetFetchClause(QueryPart queryPart) {
        return !queryPart.isRoot() || this.limit == null || this.limit.isEmpty();
    }

    protected boolean isRowsOnlyFetchClauseType(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit() || queryPart.getFetchClauseType() == null) {
            return true;
        }
        return queryPart.getFetchClauseType() == FetchClauseType.ROWS_ONLY;
    }

    protected JdbcParameter getOffsetParameter() {
        return this.offsetParameter;
    }

    protected void setOffsetParameter(JdbcParameter offsetParameter) {
        this.offsetParameter = offsetParameter;
    }

    protected JdbcParameter getLimitParameter() {
        return this.limitParameter;
    }

    protected void setLimitParameter(JdbcParameter limitParameter) {
        this.limitParameter = limitParameter;
    }

    protected <R> R interpretExpression(Expression expression, JdbcParameterBindings jdbcParameterBindings) {
        if (expression instanceof Literal) {
            return (R)((Literal)expression).getLiteralValue();
        }
        if (expression instanceof JdbcParameter) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available!");
            }
            return (R)this.getParameterBindValue((JdbcParameter)expression);
        }
        throw new UnsupportedOperationException("Can't interpret expression: " + expression);
    }

    protected void renderExpressionAsLiteral(Expression expression, JdbcParameterBindings jdbcParameterBindings) {
        if (expression instanceof Literal) {
            expression.accept(this);
            return;
        }
        if (expression instanceof JdbcParameter) {
            if (jdbcParameterBindings == null) {
                throw new IllegalArgumentException("Can't interpret expression because no parameter bindings are available!");
            }
            JdbcParameter parameter = (JdbcParameter)expression;
            this.renderAsLiteral(parameter, this.getParameterBindValue(parameter));
            return;
        }
        throw new UnsupportedOperationException("Can't render expression as literal: " + expression);
    }

    protected Object getParameterBindValue(JdbcParameter parameter) {
        JdbcParameterBinding binding = parameter == this.getOffsetParameter() ? new JdbcParameterBindingImpl(IntegerType.INSTANCE, this.getLimit().getFirstRow()) : (parameter == this.getLimitParameter() ? new JdbcParameterBindingImpl(IntegerType.INSTANCE, this.getLimit().getMaxRows()) : this.jdbcParameterBindings.getBinding(parameter));
        this.addAppliedParameterBinding(parameter, binding);
        return binding.getBindValue();
    }

    protected boolean isCurrentlyInPredicate() {
        return this.clauseStack.getCurrent() == Clause.WHERE || this.clauseStack.getCurrent() == Clause.HAVING;
    }

    protected boolean inOverClause() {
        return this.clauseStack.findCurrentFirst(clause -> {
            if (clause == Clause.OVER) {
                return true;
            }
            return null;
        }) != null;
    }

    protected Stack<Clause> getClauseStack() {
        return this.clauseStack;
    }

    protected Stack<QueryPart> getQueryPartStack() {
        return this.queryPartStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T translate(JdbcParameterBindings jdbcParameterBindings, QueryOptions queryOptions) {
        try {
            JdbcOperation jdbcOperation;
            this.jdbcParameterBindings = jdbcParameterBindings;
            this.lockOptions = queryOptions.getLockOptions().makeCopy();
            Limit limit = this.limit = queryOptions.getLimit() == null ? null : queryOptions.getLimit().makeCopy();
            if (this.statement instanceof DeleteStatement) {
                jdbcOperation = this.translateDelete((DeleteStatement)this.statement);
            } else if (this.statement instanceof UpdateStatement) {
                jdbcOperation = this.translateUpdate((UpdateStatement)this.statement);
            } else if (this.statement instanceof InsertStatement) {
                jdbcOperation = this.translateInsert((InsertStatement)this.statement);
            } else if (this.statement instanceof SelectStatement) {
                jdbcOperation = this.translateSelect((SelectStatement)this.statement);
            } else {
                throw new IllegalArgumentException("Unexpected statement!");
            }
            if (jdbcParameterBindings != null && CollectionHelper.isNotEmpty(this.getFilterJdbcParameters())) {
                for (FilterJdbcParameter filterJdbcParameter : this.getFilterJdbcParameters()) {
                    jdbcParameterBindings.addBinding(filterJdbcParameter.getParameter(), filterJdbcParameter.getBinding());
                }
            }
            JdbcDelete jdbcDelete = jdbcOperation;
            return (T)jdbcDelete;
        }
        finally {
            this.cleanup();
        }
    }

    protected JdbcDelete translateDelete(DeleteStatement sqlAst) {
        this.visitDeleteStatement(sqlAst);
        return new JdbcDelete(){

            @Override
            public String getSql() {
                return AbstractSqlAstTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return AbstractSqlAstTranslator.this.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return AbstractSqlAstTranslator.this.getAffectedTableNames();
            }

            @Override
            public Set<FilterJdbcParameter> getFilterJdbcParameters() {
                return AbstractSqlAstTranslator.this.getFilterJdbcParameters();
            }
        };
    }

    protected JdbcUpdate translateUpdate(UpdateStatement sqlAst) {
        this.visitUpdateStatement(sqlAst);
        return new JdbcUpdate(){

            @Override
            public String getSql() {
                return AbstractSqlAstTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return AbstractSqlAstTranslator.this.getParameterBinders();
            }

            @Override
            public Set<FilterJdbcParameter> getFilterJdbcParameters() {
                return AbstractSqlAstTranslator.this.getFilterJdbcParameters();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return AbstractSqlAstTranslator.this.getAffectedTableNames();
            }
        };
    }

    protected JdbcInsert translateInsert(InsertStatement sqlAst) {
        this.visitInsertStatement(sqlAst);
        return new JdbcInsert(){

            @Override
            public String getSql() {
                return AbstractSqlAstTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return AbstractSqlAstTranslator.this.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return AbstractSqlAstTranslator.this.getAffectedTableNames();
            }

            @Override
            public Set<FilterJdbcParameter> getFilterJdbcParameters() {
                return AbstractSqlAstTranslator.this.getFilterJdbcParameters();
            }
        };
    }

    protected JdbcSelect translateSelect(SelectStatement sqlAstSelect) {
        DomainResultGraphPrinter.logDomainResultGraph(sqlAstSelect.getDomainResultDescriptors());
        SqlTreePrinter.logSqlAst(sqlAstSelect);
        this.visitSelectStatement(sqlAstSelect);
        int rowsToSkip = this.getRowsToSkip(sqlAstSelect, this.getJdbcParameterBindings());
        return new JdbcSelect(this.getSql(), this.getParameterBinders(), new JdbcValuesMappingProducerStandard(sqlAstSelect.getQuerySpec().getSelectClause().getSqlSelections(), sqlAstSelect.getDomainResultDescriptors()), this.getAffectedTableNames(), this.getFilterJdbcParameters(), rowsToSkip, this.getMaxRows(sqlAstSelect, this.getJdbcParameterBindings(), rowsToSkip), this.getAppliedParameterBindings(), this.getLockOptions(), this.getOffsetParameter(), this.getLimitParameter());
    }

    protected int getRowsToSkip(SelectStatement sqlAstSelect, JdbcParameterBindings jdbcParameterBindings) {
        if (this.hasLimit()) {
            if (this.offsetParameter != null && this.needsRowsToSkip()) {
                return (Integer)this.interpretExpression(this.offsetParameter, jdbcParameterBindings);
            }
        } else {
            Expression offsetClauseExpression = sqlAstSelect.getQueryPart().getOffsetClauseExpression();
            if (offsetClauseExpression != null && this.needsRowsToSkip()) {
                return (Integer)this.interpretExpression(offsetClauseExpression, jdbcParameterBindings);
            }
        }
        return 0;
    }

    protected int getMaxRows(SelectStatement sqlAstSelect, JdbcParameterBindings jdbcParameterBindings, int rowsToSkip) {
        if (this.hasLimit()) {
            if (this.limitParameter != null && this.needsMaxRows()) {
                Number fetchCount = (Number)this.interpretExpression(this.limitParameter, jdbcParameterBindings);
                return rowsToSkip + fetchCount.intValue();
            }
        } else {
            Expression fetchClauseExpression = sqlAstSelect.getQueryPart().getFetchClauseExpression();
            if (fetchClauseExpression != null && this.needsMaxRows()) {
                Number fetchCount = (Number)this.interpretExpression(fetchClauseExpression, jdbcParameterBindings);
                return rowsToSkip + fetchCount.intValue();
            }
        }
        return Integer.MAX_VALUE;
    }

    protected boolean needsRowsToSkip() {
        return false;
    }

    protected boolean needsMaxRows() {
        return false;
    }

    protected void prepareLimitOffsetParameters() {
        Limit limit = this.getLimit();
        if (limit.getFirstRow() != null) {
            this.setOffsetParameter(new JdbcParameterImpl(IntegerType.INSTANCE){

                @Override
                public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
                    IntegerType.INSTANCE.getJdbcValueBinder().bind(statement, executionContext.getQueryOptions().getLimit().getFirstRow(), startPosition, (WrapperOptions)executionContext.getSession());
                }
            });
        }
        if (limit.getMaxRows() != null) {
            this.setLimitParameter(new JdbcParameterImpl(IntegerType.INSTANCE){

                @Override
                public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
                    IntegerType.INSTANCE.getJdbcValueBinder().bind(statement, executionContext.getQueryOptions().getLimit().getMaxRows(), startPosition, (WrapperOptions)executionContext.getSession());
                }
            });
        }
    }

    @Override
    public void visitSelectStatement(SelectStatement statement) {
        String oldDmlTargetTableAlias = this.dmlTargetTableAlias;
        this.dmlTargetTableAlias = null;
        try {
            this.visitCteContainer(statement);
            statement.getQueryPart().accept(this);
        }
        finally {
            this.dmlTargetTableAlias = oldDmlTargetTableAlias;
        }
    }

    @Override
    public void visitDeleteStatement(DeleteStatement statement) {
        String oldDmlTargetTableAlias = this.dmlTargetTableAlias;
        this.dmlTargetTableAlias = null;
        try {
            this.visitCteContainer(statement);
            this.dmlTargetTableAlias = statement.getTargetTable().getIdentificationVariable();
            this.visitDeleteStatementOnly(statement);
        }
        finally {
            this.dmlTargetTableAlias = oldDmlTargetTableAlias;
        }
    }

    @Override
    public void visitUpdateStatement(UpdateStatement statement) {
        String oldDmlTargetTableAlias = this.dmlTargetTableAlias;
        this.dmlTargetTableAlias = null;
        try {
            this.visitCteContainer(statement);
            this.dmlTargetTableAlias = statement.getTargetTable().getIdentificationVariable();
            this.visitUpdateStatementOnly(statement);
        }
        finally {
            this.dmlTargetTableAlias = oldDmlTargetTableAlias;
        }
    }

    @Override
    public void visitAssignment(Assignment assignment) {
        throw new SqlTreeCreationException("Encountered unexpected assignment clause");
    }

    @Override
    public void visitInsertStatement(InsertStatement statement) {
        String oldDmlTargetTableAlias = this.dmlTargetTableAlias;
        this.dmlTargetTableAlias = null;
        try {
            this.visitCteContainer(statement);
            this.visitInsertStatementOnly(statement);
        }
        finally {
            this.dmlTargetTableAlias = oldDmlTargetTableAlias;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitDeleteStatementOnly(DeleteStatement statement) {
        this.appendSql("delete from ");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.DELETE);
            this.renderTableReference(statement.getTargetTable());
        }
        finally {
            clauseStack.pop();
        }
        if (statement.getRestriction() != null) {
            try {
                clauseStack.push(Clause.WHERE);
                this.appendSql(" where ");
                statement.getRestriction().accept(this);
            }
            finally {
                clauseStack.pop();
            }
        }
        this.visitReturningColumns(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitUpdateStatementOnly(UpdateStatement statement) {
        this.appendSql("update ");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.UPDATE);
            this.renderTableReference(statement.getTargetTable());
        }
        finally {
            clauseStack.pop();
        }
        this.appendSql(" set ");
        boolean firstPass = true;
        try {
            clauseStack.push(Clause.SET);
            for (Assignment assignment : statement.getAssignments()) {
                if (firstPass) {
                    firstPass = false;
                } else {
                    this.appendSql(", ");
                }
                List<ColumnReference> columnReferences = assignment.getAssignable().getColumnReferences();
                if (columnReferences.size() == 1) {
                    columnReferences.get(0).accept(this);
                } else {
                    this.appendSql(" (");
                    for (ColumnReference columnReference : columnReferences) {
                        columnReference.accept(this);
                    }
                    this.appendSql(") ");
                }
                this.appendSql(" = ");
                assignment.getAssignedValue().accept(this);
            }
        }
        finally {
            clauseStack.pop();
        }
        if (statement.getRestriction() != null) {
            this.appendSql(" where ");
            try {
                clauseStack.push(Clause.WHERE);
                statement.getRestriction().accept(this);
            }
            finally {
                clauseStack.pop();
            }
        }
        this.visitReturningColumns(statement);
    }

    protected void visitInsertStatementOnly(InsertStatement statement) {
        this.appendSql("insert into ");
        this.appendSql(statement.getTargetTable().getTableExpression());
        this.appendSql(" (");
        boolean firstPass = true;
        List<ColumnReference> targetColumnReferences = statement.getTargetColumnReferences();
        if (targetColumnReferences == null) {
            this.renderImplicitTargetColumnSpec();
        } else {
            for (ColumnReference targetColumnReference : targetColumnReferences) {
                if (firstPass) {
                    firstPass = false;
                } else {
                    this.appendSql(", ");
                }
                this.appendSql(targetColumnReference.getColumnExpression());
            }
        }
        this.appendSql(") ");
        if (statement.getSourceSelectStatement() != null) {
            statement.getSourceSelectStatement().accept(this);
        } else {
            this.visitValuesList(statement.getValuesList());
        }
        this.visitReturningColumns(statement);
    }

    private void renderImplicitTargetColumnSpec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void visitValuesList(List<Values> valuesList) {
        this.appendSql("values");
        boolean firstTuple = true;
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.VALUES);
            for (Values values : valuesList) {
                if (firstTuple) {
                    firstTuple = false;
                } else {
                    this.appendSql(", ");
                }
                this.appendSql(" (");
                boolean firstExpr = true;
                for (Expression expression : values.getExpressions()) {
                    if (firstExpr) {
                        firstExpr = false;
                    } else {
                        this.appendSql(", ");
                    }
                    expression.accept(this);
                }
                this.appendSql(")");
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void visitReturningColumns(MutationStatement mutationStatement) {
        List<ColumnReference> returningColumns = mutationStatement.getReturningColumns();
        int size = returningColumns.size();
        if (size == 0) {
            return;
        }
        this.appendSql(" returning ");
        String separator = "";
        for (int i = 0; i < size; ++i) {
            this.appendSql(separator);
            this.appendSql(returningColumns.get(i).getColumnExpression());
            separator = ", ";
        }
    }

    public void visitCteContainer(CteContainer cteContainer) {
        Collection<CteStatement> cteStatements = cteContainer.getCteStatements();
        if (cteStatements.isEmpty()) {
            return;
        }
        this.appendSql("with ");
        if (cteContainer.isWithRecursive()) {
            this.appendSql("recursive ");
        }
        String mainSeparator = "";
        for (CteStatement cte : cteStatements) {
            this.appendSql(mainSeparator);
            this.appendSql(cte.getCteTable().getTableExpression());
            this.appendSql(" (");
            String separator = "";
            for (CteColumn cteColumn : cte.getCteTable().getCteColumns()) {
                this.appendSql(separator);
                this.appendSql(cteColumn.getColumnExpression());
                separator = ", ";
            }
            this.appendSql(") as (");
            cte.getCteDefinition().accept(this);
            this.appendSql(')');
            this.renderSearchClause(cte);
            this.renderCycleClause(cte);
            mainSeparator = ", ";
        }
        this.appendSql(' ');
    }

    protected void renderSearchClause(CteStatement cte) {
        if (cte.getSearchClauseKind() != null) {
            this.appendSql(" search ");
            if (cte.getSearchClauseKind() == CteSearchClauseKind.DEPTH_FIRST) {
                this.appendSql(" depth ");
            } else {
                this.appendSql(" breadth ");
            }
            this.appendSql(" first by ");
            String separator = "";
            for (SearchClauseSpecification searchBySpecification : cte.getSearchBySpecifications()) {
                this.appendSql(separator);
                this.appendSql(searchBySpecification.getCteColumn().getColumnExpression());
                if (searchBySpecification.getSortOrder() != null) {
                    if (searchBySpecification.getSortOrder() == SortOrder.ASCENDING) {
                        this.appendSql(" asc");
                    } else {
                        this.appendSql(" desc");
                    }
                    if (searchBySpecification.getNullPrecedence() != null) {
                        if (searchBySpecification.getNullPrecedence() == NullPrecedence.FIRST) {
                            this.appendSql(" nulls first");
                        } else {
                            this.appendSql(" nulls last");
                        }
                    }
                }
                separator = ", ";
            }
        }
    }

    protected void renderCycleClause(CteStatement cte) {
        if (cte.getCycleMarkColumn() != null) {
            this.appendSql(" cycle ");
            String separator = "";
            for (CteColumn cycleColumn : cte.getCycleColumns()) {
                this.appendSql(separator);
                this.appendSql(cycleColumn.getColumnExpression());
                separator = ", ";
            }
            this.appendSql(" set ");
            this.appendSql(cte.getCycleMarkColumn().getColumnExpression());
            this.appendSql(" to '");
            this.appendSql(cte.getCycleValue());
            this.appendSql("' default '");
            this.appendSql(cte.getNoCycleValue());
            this.appendSql("'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        boolean needsSelectAliases = this.needsSelectAliases;
        try {
            String queryGroupAlias = null;
            QueryPart currentQueryPart = this.queryPartStack.getCurrent();
            if (currentQueryPart != null && queryPartForRowNumbering != currentQueryPart) {
                this.queryPartForRowNumbering = null;
                this.needsSelectAliases = false;
            }
            if (queryPartForRowNumbering != queryGroup && !queryGroup.isRoot()) {
                this.needsSelectAliases = true;
                queryGroupAlias = "grp_" + this.queryGroupAliasCounter + "_";
                ++this.queryGroupAliasCounter;
                this.appendSql("select ");
                this.appendSql(queryGroupAlias);
                this.appendSql(".* from (");
            }
            this.queryPartStack.push(queryGroup);
            List<QueryPart> queryParts = queryGroup.getQueryParts();
            String setOperatorString = " " + queryGroup.getSetOperator().sqlString() + " ";
            String separator = "";
            for (int i = 0; i < queryParts.size(); ++i) {
                this.appendSql(separator);
                queryParts.get(i).accept(this);
                separator = setOperatorString;
            }
            this.visitOrderBy(queryGroup.getSortSpecifications());
            this.visitOffsetFetchClause(queryGroup);
            if (queryGroupAlias != null) {
                this.appendSql(") ");
                this.appendSql(queryGroupAlias);
            }
        }
        finally {
            this.queryPartStack.pop();
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.needsSelectAliases = needsSelectAliases;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        boolean needsSelectAliases = this.needsSelectAliases;
        try {
            boolean needsParenthesis;
            QueryPart currentQueryPart = this.queryPartStack.getCurrent();
            if (currentQueryPart != null && queryPartForRowNumbering != currentQueryPart) {
                this.queryPartForRowNumbering = null;
            }
            String queryGroupAlias = "";
            if (currentQueryPart instanceof QueryGroup) {
                needsParenthesis = querySpec.hasOffsetOrFetchClause();
                if (needsParenthesis && (!this.supportsSimpleQueryGrouping() || currentQueryPart.hasOffsetOrFetchClause())) {
                    this.needsSelectAliases = true;
                    queryGroupAlias = " grp_" + this.queryGroupAliasCounter + "_";
                    ++this.queryGroupAliasCounter;
                    this.appendSql("select");
                    this.appendSql(queryGroupAlias);
                    this.appendSql(".* from ");
                }
            } else {
                needsParenthesis = !querySpec.isRoot();
            }
            this.queryPartStack.push(querySpec);
            if (needsParenthesis) {
                this.appendSql("(");
            }
            this.visitSelectClause(querySpec.getSelectClause());
            this.visitFromClause(querySpec.getFromClause());
            this.visitWhereClause(querySpec);
            this.visitGroupByClause(querySpec, this.dialect.supportsSelectAliasInGroupByClause());
            this.visitHavingClause(querySpec);
            this.visitOrderBy(querySpec.getSortSpecifications());
            this.visitOffsetFetchClause(querySpec);
            if (needsParenthesis) {
                this.appendSql(")");
                this.appendSql(queryGroupAlias);
            }
        }
        finally {
            this.queryPartStack.pop();
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.needsSelectAliases = needsSelectAliases;
        }
    }

    protected boolean supportsSimpleQueryGrouping() {
        return true;
    }

    protected final void visitWhereClause(QuerySpec querySpec) {
        Predicate whereClauseRestrictions = querySpec.getWhereClauseRestrictions();
        if (whereClauseRestrictions != null && !whereClauseRestrictions.isEmpty()) {
            this.appendSql(" where ");
            this.clauseStack.push(Clause.WHERE);
            try {
                whereClauseRestrictions.accept(this);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected Expression resolveAliasedExpression(Expression expression) {
        return this.resolveAliasedExpression(this.queryPartStack.getCurrent().getFirstQuerySpec().getSelectClause().getSqlSelections(), expression);
    }

    protected Expression resolveAliasedExpression(List<SqlSelection> sqlSelections, Expression expression) {
        if (expression instanceof Literal) {
            Object literalValue = ((Literal)expression).getLiteralValue();
            if (literalValue instanceof Integer) {
                return sqlSelections.get((Integer)literalValue).getExpression();
            }
        } else if (expression instanceof SqlSelectionExpression) {
            return ((SqlSelectionExpression)expression).getSelection().getExpression();
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void visitGroupByClause(QuerySpec querySpec, boolean supportsSelectAliases) {
        List<Expression> partitionExpressions = querySpec.getGroupByClauseExpressions();
        if (!partitionExpressions.isEmpty()) {
            try {
                this.clauseStack.push(Clause.GROUP);
                this.appendSql(" group by ");
                this.visitPartitionExpressions(partitionExpressions, supportsSelectAliases);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected final void visitPartitionByClause(List<Expression> partitionExpressions) {
        if (!partitionExpressions.isEmpty()) {
            try {
                this.clauseStack.push(Clause.PARTITION);
                this.appendSql("partition by ");
                this.visitPartitionExpressions(partitionExpressions, false);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected final void visitPartitionExpressions(List<Expression> partitionExpressions, boolean supportsSelectAliases) {
        String separator = "";
        if (supportsSelectAliases) {
            for (Expression partitionExpression : partitionExpressions) {
                if (partitionExpression instanceof SqlTuple) {
                    for (Expression expression : ((SqlTuple)partitionExpression).getExpressions()) {
                        this.appendSql(separator);
                        this.renderPartitionItem(expression);
                        separator = ", ";
                    }
                } else {
                    this.appendSql(separator);
                    this.renderPartitionItem(partitionExpression);
                }
                separator = ", ";
            }
        } else {
            for (Expression partitionExpression : partitionExpressions) {
                if (partitionExpression instanceof SqlTuple) {
                    for (Expression expression : ((SqlTuple)partitionExpression).getExpressions()) {
                        this.appendSql(separator);
                        this.renderPartitionItem(this.resolveAliasedExpression(expression));
                        separator = ", ";
                    }
                } else {
                    this.appendSql(separator);
                    this.renderPartitionItem(this.resolveAliasedExpression(partitionExpression));
                }
                separator = ", ";
            }
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            switch (this.dialect.getGroupByConstantRenderingStrategy()) {
                case CONSTANT: {
                    this.appendSql("'0'");
                    break;
                }
                case CONSTANT_EXPRESSION: {
                    this.appendSql("'0' || '0'");
                    break;
                }
                case EMPTY_GROUPING: {
                    this.appendSql("()");
                    break;
                }
                case SUBQUERY: {
                    this.appendSql("(select 1");
                    String fromDual = this.dialect.getFromDual();
                    if (!fromDual.isEmpty()) {
                        this.appendSql(" ");
                        this.appendSql(fromDual);
                    }
                    this.appendSql(')');
                    break;
                }
                case COLUMN_REFERENCE: {
                    throw new UnsupportedOperationException("Column reference strategy is not yet implemented!");
                }
            }
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            switch (this.dialect.getGroupBySummarizationRenderingStrategy()) {
                case FUNCTION: {
                    this.appendSql(summarization.getKind().name().toLowerCase());
                    this.appendSql("(");
                    this.renderCommaSeparated(summarization.getGroupings());
                    this.appendSql(")");
                    break;
                }
                case CLAUSE: {
                    this.renderCommaSeparated(summarization.getGroupings());
                    this.appendSql(" with ");
                    this.appendSql(summarization.getKind().name().toLowerCase());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
                }
            }
        } else {
            expression.accept(this);
        }
    }

    protected final void visitHavingClause(QuerySpec querySpec) {
        Predicate havingClauseRestrictions = querySpec.getHavingClauseRestrictions();
        if (havingClauseRestrictions != null && !havingClauseRestrictions.isEmpty()) {
            this.appendSql(" having ");
            this.clauseStack.push(Clause.HAVING);
            try {
                havingClauseRestrictions.accept(this);
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected void visitOrderBy(List<SortSpecification> sortSpecifications) {
        if (this.queryPartForRowNumbering == null) {
            this.renderOrderBy(true, sortSpecifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderOrderBy(boolean addWhitespace, List<SortSpecification> sortSpecifications) {
        if (sortSpecifications != null && !sortSpecifications.isEmpty()) {
            if (addWhitespace) {
                this.appendSql(' ');
            }
            this.appendSql("order by ");
            this.clauseStack.push(Clause.ORDER);
            try {
                String separator = "";
                for (SortSpecification sortSpecification : sortSpecifications) {
                    this.appendSql(separator);
                    this.visitSortSpecification(sortSpecification);
                    separator = ", ";
                }
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected void emulateTupleComparison(List<? extends Expression> lhsExpressions, List<? extends Expression> rhsExpressions, ComparisonOperator operator, boolean indexOptimized) {
        boolean isCurrentWhereClause;
        boolean bl = isCurrentWhereClause = this.clauseStack.getCurrent() == Clause.WHERE;
        if (isCurrentWhereClause) {
            this.appendSql("(");
        }
        int size = lhsExpressions.size();
        assert (size == rhsExpressions.size());
        switch (operator) {
            case EQUAL: 
            case NOT_EQUAL: {
                String operatorText = operator.sqlText();
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    this.appendSql(separator);
                    lhsExpressions.get(i).accept(this);
                    this.appendSql(operatorText);
                    rhsExpressions.get(i).accept(this);
                    separator = " and ";
                }
                break;
            }
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case GREATER_THAN: {
                if (indexOptimized) {
                    lhsExpressions.get(0).accept(this);
                    this.appendSql(operator.broader().sqlText());
                    rhsExpressions.get(0).accept(this);
                    this.appendSql(" and not ");
                    String negatedOperatorText = operator.negated().sqlText();
                    this.emulateTupleComparisonSimple(lhsExpressions, rhsExpressions, negatedOperatorText, negatedOperatorText, true);
                    break;
                }
                this.emulateTupleComparisonSimple(lhsExpressions, rhsExpressions, operator.sharper().sqlText(), operator.sqlText(), false);
            }
        }
        if (isCurrentWhereClause) {
            this.appendSql(")");
        }
    }

    protected void renderExpressionsAsSubquery(List<? extends Expression> expressions) {
        this.clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            this.renderCommaSeparated(expressions);
            String fromDual = this.dialect.getFromDual();
            if (!fromDual.isEmpty()) {
                this.appendSql(" ");
                this.appendSql(fromDual);
            }
        }
        finally {
            this.clauseStack.pop();
        }
    }

    private void emulateTupleComparisonSimple(List<? extends Expression> lhsExpressions, List<? extends Expression> rhsExpressions, String operatorText, String finalOperatorText, boolean optimized) {
        int i;
        int size = lhsExpressions.size();
        int lastIndex = size - 1;
        this.appendSql("(");
        String separator = "";
        if (optimized) {
            i = 1;
        } else {
            lhsExpressions.get(0).accept(this);
            this.appendSql(operatorText);
            rhsExpressions.get(0).accept(this);
            separator = " or ";
            i = 1;
        }
        while (i < lastIndex) {
            this.appendSql(separator);
            lhsExpressions.get(i - 1).accept(this);
            this.appendSql('=');
            rhsExpressions.get(i - 1).accept(this);
            this.appendSql(" and (");
            lhsExpressions.get(i).accept(this);
            this.appendSql(operatorText);
            rhsExpressions.get(i).accept(this);
            separator = " or ";
            ++i;
        }
        this.appendSql(separator);
        lhsExpressions.get(lastIndex - 1).accept(this);
        this.appendSql('=');
        rhsExpressions.get(lastIndex - 1).accept(this);
        this.appendSql(" and ");
        lhsExpressions.get(lastIndex).accept(this);
        this.appendSql(finalOperatorText);
        rhsExpressions.get(lastIndex).accept(this);
        int n = i = optimized ? 1 : 0;
        while (i < lastIndex) {
            this.appendSql(")");
            ++i;
        }
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        if (this.dialect.supportsRowValueConstructorSyntax()) {
            this.appendSql("(");
            String separator = "";
            for (SqlSelection lhsExpression : lhsExpressions) {
                this.appendSql(separator);
                lhsExpression.getExpression().accept(this);
                separator = ", ";
            }
            this.appendSql(")");
            this.appendSql(" ");
            this.appendSql(operator.sqlText());
            this.appendSql(" ");
            tuple.accept(this);
        } else {
            ArrayList<Expression> lhs = new ArrayList<Expression>(lhsExpressions.size());
            for (SqlSelection lhsExpression : lhsExpressions) {
                lhs.add(lhsExpression.getExpression());
            }
            this.emulateTupleComparison(lhs, tuple.getExpressions(), operator, true);
        }
    }

    @Override
    public void visitSortSpecification(SortSpecification sortSpecification) {
        Expression sortExpression = sortSpecification.getSortExpression();
        NullPrecedence nullPrecedence = sortSpecification.getNullPrecedence();
        SortOrder sortOrder = sortSpecification.getSortOrder();
        if (sortExpression instanceof SqlTuple) {
            String separator = "";
            for (Expression expression : ((SqlTuple)sortExpression).getExpressions()) {
                this.appendSql(separator);
                this.visitSortSpecification(expression, sortOrder, nullPrecedence);
                separator = ", ";
            }
        } else {
            this.visitSortSpecification(sortExpression, sortOrder, nullPrecedence);
        }
    }

    public void visitSortSpecification(Expression sortExpression, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        boolean renderNullPrecedence;
        boolean bl = renderNullPrecedence = nullPrecedence != null && !nullPrecedence.isDefaultOrdering(sortOrder, this.dialect.getNullOrdering());
        if (renderNullPrecedence && !this.dialect.supportsNullPrecedence()) {
            this.emulateSortSpecificationNullPrecedence(sortExpression, nullPrecedence);
        }
        if (this.inOverClause()) {
            this.resolveAliasedExpression(sortExpression).accept(this);
        } else {
            sortExpression.accept(this);
        }
        if (sortOrder == SortOrder.ASCENDING) {
            this.appendSql(" asc");
        } else if (sortOrder == SortOrder.DESCENDING) {
            this.appendSql(" desc");
        }
        if (renderNullPrecedence && this.dialect.supportsNullPrecedence()) {
            this.appendSql(" nulls ");
            this.appendSql(nullPrecedence.name().toLowerCase(Locale.ROOT));
        }
    }

    protected void emulateSortSpecificationNullPrecedence(Expression sortExpression, NullPrecedence nullPrecedence) {
        this.appendSql("case when (");
        this.resolveAliasedExpression(sortExpression).accept(this);
        this.appendSql(") is null then ");
        if (nullPrecedence == NullPrecedence.FIRST) {
            this.appendSql("0 else 1");
        } else {
            this.appendSql("1 else 0");
        }
        this.appendSql(" end");
        this.appendSql(", ");
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderOffsetFetchClause(queryPart, true);
        }
    }

    protected void renderOffsetFetchClause(QueryPart queryPart, boolean renderOffsetRowsKeyword) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderOffsetFetchClause(this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY, renderOffsetRowsKeyword);
        } else {
            this.renderOffsetFetchClause(queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression(), queryPart.getFetchClauseType(), renderOffsetRowsKeyword);
        }
    }

    protected void renderOffsetFetchClause(Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean renderOffsetRowsKeyword) {
        if (offsetExpression != null) {
            this.renderOffset(offsetExpression, renderOffsetRowsKeyword);
        }
        if (fetchExpression != null) {
            this.renderFetch(fetchExpression, null, fetchClauseType);
        }
    }

    protected void renderOffset(Expression offsetExpression, boolean renderOffsetRowsKeyword) {
        this.appendSql(" offset ");
        this.clauseStack.push(Clause.OFFSET);
        try {
            this.renderOffsetExpression(offsetExpression);
        }
        finally {
            this.clauseStack.pop();
        }
        if (renderOffsetRowsKeyword) {
            this.appendSql(" rows");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFetch(Expression fetchExpression, Expression offsetExpressionToAdd, FetchClauseType fetchClauseType) {
        this.appendSql(" fetch first ");
        this.clauseStack.push(Clause.FETCH);
        try {
            if (offsetExpressionToAdd == null) {
                this.renderFetchExpression(fetchExpression);
            } else {
                this.renderFetchPlusOffsetExpression(fetchExpression, offsetExpressionToAdd, 0);
            }
        }
        finally {
            this.clauseStack.pop();
        }
        switch (fetchClauseType) {
            case ROWS_ONLY: {
                this.appendSql(" rows only");
                break;
            }
            case ROWS_WITH_TIES: {
                this.appendSql(" rows with ties");
                break;
            }
            case PERCENT_ONLY: {
                this.appendSql(" percent rows only");
                break;
            }
            case PERCENT_WITH_TIES: {
                this.appendSql(" percent rows with ties");
            }
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        offsetExpression.accept(this);
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        fetchExpression.accept(this);
    }

    protected void renderTopClause(QuerySpec querySpec, boolean addOffset) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderTopClause(this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY, addOffset);
        } else {
            this.renderTopClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression(), querySpec.getFetchClauseType(), addOffset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTopClause(Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean addOffset) {
        if (fetchExpression != null) {
            this.appendSql("top (");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.FETCH);
            try {
                if (addOffset && offsetExpression != null) {
                    this.renderFetchPlusOffsetExpression(fetchExpression, offsetExpression, 0);
                } else {
                    this.renderFetchExpression(fetchExpression);
                }
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(") ");
            switch (fetchClauseType) {
                case ROWS_WITH_TIES: {
                    this.appendSql("with ties ");
                    break;
                }
                case PERCENT_ONLY: {
                    this.appendSql("percent ");
                    break;
                }
                case PERCENT_WITH_TIES: {
                    this.appendSql("percent with ties ");
                }
            }
        }
    }

    protected void renderTopStartAtClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderTopStartAtClause(this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY);
        } else {
            this.renderTopStartAtClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression(), querySpec.getFetchClauseType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderTopStartAtClause(Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType) {
        if (fetchExpression != null) {
            this.appendSql("top ");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
            if (offsetExpression != null) {
                clauseStack.push(Clause.OFFSET);
                try {
                    this.appendSql(" start at ");
                    this.renderOffsetExpression(offsetExpression);
                }
                finally {
                    clauseStack.pop();
                }
            }
            this.appendSql(' ');
            switch (fetchClauseType) {
                case ROWS_WITH_TIES: {
                    this.appendSql("with ties ");
                    break;
                }
                case PERCENT_ONLY: {
                    this.appendSql("percent ");
                    break;
                }
                case PERCENT_WITH_TIES: {
                    this.appendSql("percent with ties ");
                }
            }
        }
    }

    protected void renderRowsToClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderRowsToClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderRowsToClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderRowsToClause(Expression offsetClauseExpression, Expression fetchClauseExpression) {
        if (fetchClauseExpression != null) {
            this.appendSql("rows ");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchClauseExpression);
            }
            finally {
                clauseStack.pop();
            }
            if (offsetClauseExpression != null) {
                clauseStack.push(Clause.OFFSET);
                try {
                    this.appendSql(" to ");
                    this.renderFetchPlusOffsetExpression(fetchClauseExpression, offsetClauseExpression, 1);
                }
                finally {
                    clauseStack.pop();
                }
            }
            this.appendSql(' ');
        }
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchExpression(fetchClauseExpression);
        this.appendSql('+');
        this.renderOffsetExpression(offsetClauseExpression);
        if (offset != 0) {
            this.appendSql('+');
            this.appendSql(Integer.toString(offset));
        }
    }

    protected void renderFetchPlusOffsetExpressionAsSingleParameter(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        if (fetchClauseExpression instanceof Literal) {
            Number fetchCount = (Number)((Literal)fetchClauseExpression).getLiteralValue();
            if (offsetClauseExpression instanceof Literal) {
                Number offsetCount = (Number)((Literal)offsetClauseExpression).getLiteralValue();
                this.appendSql(Integer.toString(fetchCount.intValue() + offsetCount.intValue() + offset));
            } else {
                this.appendSql("?");
                JdbcParameter offsetParameter = (JdbcParameter)offsetClauseExpression;
                int offsetValue = offset + fetchCount.intValue();
                this.jdbcParameters.addParameter(offsetParameter);
                this.parameterBinders.add((statement, startPosition, jdbcParameterBindings, executionContext) -> {
                    JdbcParameterBinding binding = jdbcParameterBindings.getBinding(offsetParameter);
                    if (binding == null) {
                        throw new ExecutionException("JDBC parameter value not bound - " + offsetParameter);
                    }
                    Number bindValue = (Number)binding.getBindValue();
                    offsetParameter.getExpressionType().getJdbcMappings().get(0).getJdbcValueBinder().bind(statement, Integer.valueOf(bindValue.intValue() + offsetValue), startPosition, (WrapperOptions)executionContext.getSession());
                });
            }
        } else {
            this.appendSql("?");
            JdbcParameter offsetParameter = (JdbcParameter)offsetClauseExpression;
            JdbcParameter fetchParameter = (JdbcParameter)fetchClauseExpression;
            OffsetReceivingParameterBinder fetchBinder = new OffsetReceivingParameterBinder(fetchParameter, offset);
            this.jdbcParameters.addParameter(fetchParameter);
            this.parameterBinders.add(fetchBinder);
            this.jdbcParameters.addParameter(offsetParameter);
            this.parameterBinders.add((statement, startPosition, jdbcParameterBindings, executionContext) -> {
                JdbcParameterBinding binding = jdbcParameterBindings.getBinding(offsetParameter);
                if (binding == null) {
                    throw new ExecutionException("JDBC parameter value not bound - " + offsetParameter);
                }
                fetchBinder.dynamicOffset = (Number)binding.getBindValue();
            });
        }
    }

    protected void renderFirstSkipClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderFirstSkipClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderFirstSkipClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFirstSkipClause(Expression offsetExpression, Expression fetchExpression) {
        Stack<Clause> clauseStack = this.getClauseStack();
        if (fetchExpression != null) {
            this.appendSql("first ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
        if (offsetExpression != null) {
            this.appendSql("skip ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
    }

    protected void renderSkipFirstClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderSkipFirstClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderSkipFirstClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderSkipFirstClause(Expression offsetExpression, Expression fetchExpression) {
        Stack<Clause> clauseStack = this.getClauseStack();
        if (offsetExpression != null) {
            this.appendSql("skip ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
        if (fetchExpression != null) {
            this.appendSql("first ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
    }

    protected void renderFirstClause(QuerySpec querySpec) {
        if (querySpec.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderFirstClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(querySpec);
            this.renderFirstClause(querySpec.getOffsetClauseExpression(), querySpec.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderFirstClause(Expression offsetExpression, Expression fetchExpression) {
        Stack<Clause> clauseStack = this.getClauseStack();
        if (fetchExpression != null) {
            this.appendSql("first ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchPlusOffsetExpression(fetchExpression, offsetExpression, 0);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(' ');
        }
    }

    protected void renderCombinedLimitClause(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderCombinedLimitClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(queryPart);
            this.renderCombinedLimitClause(queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderCombinedLimitClause(Expression offsetExpression, Expression fetchExpression) {
        if (offsetExpression != null) {
            Stack<Clause> clauseStack = this.getClauseStack();
            this.appendSql(" limit ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
            this.appendSql(", ");
            if (fetchExpression != null) {
                clauseStack.push(Clause.FETCH);
                try {
                    this.renderFetchExpression(fetchExpression);
                }
                finally {
                    clauseStack.pop();
                }
            } else {
                this.appendSql(Integer.toString(Integer.MAX_VALUE));
            }
        } else if (fetchExpression != null) {
            Stack<Clause> clauseStack = this.getClauseStack();
            this.appendSql(" limit ");
            clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    protected void renderLimitOffsetClause(QueryPart queryPart) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.renderLimitOffsetClause(this.getOffsetParameter(), this.getLimitParameter());
        } else {
            this.assertRowsOnlyFetchClauseType(queryPart);
            this.renderLimitOffsetClause(queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderLimitOffsetClause(Expression offsetExpression, Expression fetchExpression) {
        if (fetchExpression != null) {
            this.appendSql(" limit ");
            this.clauseStack.push(Clause.FETCH);
            try {
                this.renderFetchExpression(fetchExpression);
            }
            finally {
                this.clauseStack.pop();
            }
        } else if (offsetExpression != null) {
            this.appendSql(" limit ");
            this.appendSql(Integer.toString(Integer.MAX_VALUE));
        }
        if (offsetExpression != null) {
            Stack<Clause> clauseStack = this.getClauseStack();
            this.appendSql(" offset ");
            clauseStack.push(Clause.OFFSET);
            try {
                this.renderOffsetExpression(offsetExpression);
            }
            finally {
                clauseStack.pop();
            }
        }
    }

    protected void assertRowsOnlyFetchClauseType(QueryPart queryPart) {
        FetchClauseType fetchClauseType;
        if (!(queryPart.isRoot() && this.hasLimit() || (fetchClauseType = queryPart.getFetchClauseType()) == null || fetchClauseType == FetchClauseType.ROWS_ONLY)) {
            throw new IllegalArgumentException("Can't emulate fetch clause type: " + (Object)((Object)fetchClauseType));
        }
    }

    protected QueryPart getQueryPartForRowNumbering() {
        return this.queryPartForRowNumbering;
    }

    protected boolean isRowNumberingCurrentQueryPart() {
        return this.queryPartForRowNumbering != null;
    }

    protected void emulateFetchOffsetWithWindowFunctions(QueryPart queryPart, boolean emulateFetchClause) {
        if (queryPart.isRoot() && this.hasLimit()) {
            this.prepareLimitOffsetParameters();
            this.emulateFetchOffsetWithWindowFunctions(queryPart, this.getOffsetParameter(), this.getLimitParameter(), FetchClauseType.ROWS_ONLY, emulateFetchClause);
        } else {
            this.emulateFetchOffsetWithWindowFunctions(queryPart, queryPart.getOffsetClauseExpression(), queryPart.getFetchClauseExpression(), queryPart.getFetchClauseType(), emulateFetchClause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emulateFetchOffsetWithWindowFunctions(QueryPart queryPart, Expression offsetExpression, Expression fetchExpression, FetchClauseType fetchClauseType, boolean emulateFetchClause) {
        QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
        boolean needsSelectAliases = this.needsSelectAliases;
        try {
            this.queryPartForRowNumbering = queryPart;
            this.needsSelectAliases = true;
            String alias = "r_" + this.queryPartForRowNumberingAliasCounter + "_";
            ++this.queryPartForRowNumberingAliasCounter;
            this.appendSql("select ");
            if (this.getClauseStack().isEmpty()) {
                this.appendSql("*");
            } else {
                int size = queryPart.getFirstQuerySpec().getSelectClause().getSqlSelections().size();
                String separator = "";
                for (int i = 0; i < size; ++i) {
                    this.appendSql(separator);
                    this.appendSql(alias);
                    this.appendSql(".c");
                    this.appendSql(Integer.toString(i));
                    separator = ", ";
                }
            }
            this.appendSql(" from (");
            queryPart.accept(this);
            this.appendSql(" ) ");
            this.appendSql(alias);
            this.appendSql(" where ");
            Stack<Clause> clauseStack = this.getClauseStack();
            clauseStack.push(Clause.WHERE);
            try {
                if (emulateFetchClause) {
                    switch (fetchClauseType) {
                        case PERCENT_ONLY: {
                            this.appendSql(alias);
                            this.appendSql(".rn <= ");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql(" + ");
                            }
                            this.appendSql("ceil(");
                            this.appendSql(alias);
                            this.appendSql(".cnt * ");
                            fetchExpression.accept(this);
                            this.appendSql(" / 100 )");
                            break;
                        }
                        case ROWS_ONLY: {
                            this.appendSql(alias);
                            this.appendSql(".rn <= ");
                            fetchExpression.accept(this);
                            break;
                        }
                        case PERCENT_WITH_TIES: {
                            this.appendSql(alias);
                            this.appendSql(".rnk <= ");
                            if (offsetExpression != null) {
                                offsetExpression.accept(this);
                                this.appendSql(" + ");
                            }
                            this.appendSql("ceil(");
                            this.appendSql(alias);
                            this.appendSql(".cnt * ");
                            fetchExpression.accept(this);
                            this.appendSql(" / 100 )");
                            break;
                        }
                        case ROWS_WITH_TIES: {
                            this.appendSql(alias);
                            this.appendSql(".rnk <= ");
                            fetchExpression.accept(this);
                        }
                    }
                }
                if (offsetExpression == null) {
                    switch (fetchClauseType) {
                        case ROWS_ONLY: 
                        case PERCENT_ONLY: {
                            this.appendSql(" order by ");
                            this.appendSql(alias);
                            this.appendSql(".rn");
                            break;
                        }
                        case ROWS_WITH_TIES: 
                        case PERCENT_WITH_TIES: {
                            this.appendSql(" order by ");
                            this.appendSql(alias);
                            this.appendSql(".rnk");
                        }
                    }
                } else {
                    if (emulateFetchClause) {
                        this.appendSql(" and ");
                    }
                    this.appendSql(alias);
                    this.appendSql(".rn > ");
                    offsetExpression.accept(this);
                    this.appendSql(" order by ");
                    this.appendSql(alias);
                    this.appendSql(".rn");
                }
            }
            finally {
                clauseStack.pop();
            }
        }
        finally {
            this.queryPartForRowNumbering = queryPartForRowNumbering;
            this.needsSelectAliases = needsSelectAliases;
        }
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        this.clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            if (selectClause.isDistinct()) {
                this.appendSql("distinct ");
            }
            this.visitSqlSelections(selectClause);
        }
        finally {
            this.clauseStack.pop();
        }
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        List<SqlSelection> sqlSelections = selectClause.getSqlSelections();
        int size = sqlSelections.size();
        if (this.needsSelectAliases) {
            FetchClauseType fetchClauseType;
            String separator = "";
            for (int i = 0; i < size; ++i) {
                SqlSelection sqlSelection = sqlSelections.get(i);
                this.appendSql(separator);
                this.visitSqlSelection(sqlSelection);
                this.appendSql(" c");
                this.appendSql(Integer.toString(i));
                separator = ", ";
            }
            if (this.queryPartForRowNumbering != null && (fetchClauseType = this.getFetchClauseTypeForRowNumbering(this.queryPartForRowNumbering)) != null) {
                this.appendSql(separator);
                switch (fetchClauseType) {
                    case PERCENT_ONLY: {
                        this.appendSql("count(*) over () cnt,");
                    }
                    case ROWS_ONLY: {
                        this.renderRowNumber(selectClause, this.queryPartForRowNumbering);
                        this.appendSql(" rn ");
                        break;
                    }
                    case PERCENT_WITH_TIES: {
                        this.appendSql("count(*) over () cnt,");
                    }
                    case ROWS_WITH_TIES: {
                        if (this.queryPartForRowNumbering.getOffsetClauseExpression() != null) {
                            this.renderRowNumber(selectClause, this.queryPartForRowNumbering);
                            this.appendSql(" rn, ");
                        }
                        if (selectClause.isDistinct()) {
                            this.appendSql("dense_rank()");
                        } else {
                            this.appendSql("rank()");
                        }
                        this.visitOverClause(Collections.emptyList(), this.getSortSpecificationsRowNumbering(selectClause, this.queryPartForRowNumbering));
                        this.appendSql(" rnk");
                    }
                }
            }
        } else {
            String separator = "";
            for (int i = 0; i < size; ++i) {
                SqlSelection sqlSelection = sqlSelections.get(i);
                this.appendSql(separator);
                this.visitSqlSelection(sqlSelection);
                separator = ", ";
            }
        }
    }

    protected FetchClauseType getFetchClauseTypeForRowNumbering(QueryPart queryPartForRowNumbering) {
        if (queryPartForRowNumbering.isRoot() && this.hasLimit()) {
            return FetchClauseType.ROWS_ONLY;
        }
        return queryPartForRowNumbering.getFetchClauseType();
    }

    protected void visitOverClause(List<Expression> partitionExpressions, List<SortSpecification> sortSpecifications) {
        try {
            this.clauseStack.push(Clause.OVER);
            this.appendSql(" over (");
            this.visitPartitionByClause(partitionExpressions);
            this.renderOrderBy(!partitionExpressions.isEmpty(), sortSpecifications);
            this.appendSql(')');
        }
        finally {
            this.clauseStack.pop();
        }
    }

    protected void renderRowNumber(SelectClause selectClause, QueryPart queryPart) {
        if (selectClause.isDistinct()) {
            this.appendSql("dense_rank()");
        } else {
            this.appendSql("row_number()");
        }
        this.visitOverClause(Collections.emptyList(), this.getSortSpecificationsRowNumbering(selectClause, queryPart));
    }

    protected List<SortSpecification> getSortSpecificationsRowNumbering(SelectClause selectClause, QueryPart queryPart) {
        List<SortSpecification> sortSpecifications = queryPart.getSortSpecifications();
        if (selectClause.isDistinct()) {
            ArrayList<SqlSelection> sqlSelections = new ArrayList<SqlSelection>(selectClause.getSqlSelections());
            int specificationsSize = sortSpecifications.size();
            block0: for (int i = sqlSelections.size() - 1; i != 0; --i) {
                Expression selectionExpression = ((SqlSelection)sqlSelections.get(i)).getExpression();
                for (int j = 0; j < specificationsSize; ++j) {
                    Expression expression = this.resolveAliasedExpression(sqlSelections, sortSpecifications.get(j).getSortExpression());
                    if (!expression.equals(selectionExpression)) continue;
                    sqlSelections.remove(i);
                    continue block0;
                }
            }
            int sqlSelectionsSize = sqlSelections.size();
            if (sqlSelectionsSize == 0) {
                return sortSpecifications;
            }
            ArrayList<SortSpecification> sortSpecificationsRowNumbering = new ArrayList<SortSpecification>(sqlSelectionsSize + specificationsSize);
            sortSpecificationsRowNumbering.addAll(sortSpecifications);
            for (int i = 0; i < sqlSelectionsSize; ++i) {
                sortSpecifications.add(new SortSpecification(new SqlSelectionExpression((SqlSelection)sqlSelections.get(i)), null, SortOrder.ASCENDING, NullPrecedence.NONE));
            }
            return sortSpecificationsRowNumbering;
        }
        return sortSpecifications;
    }

    @Override
    public void visitSqlSelection(SqlSelection sqlSelection) {
        Expression expression = sqlSelection.getExpression();
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            if (literal.getLiteralValue() == null) {
                this.renderNullCast(literal);
            } else {
                this.renderLiteral(literal, this.dialect.requiresCastingOfParametersInSelectClause());
            }
        } else if (expression instanceof NullnessLiteral) {
            this.renderNullCast(expression);
        } else {
            expression.accept(this);
        }
    }

    protected void renderNullCast(Expression expression) {
        ArrayList<SqlAstNode> arguments = new ArrayList<SqlAstNode>(2);
        arguments.add(expression);
        arguments.add(new CastTarget((BasicValuedMapping)expression.getExpressionType()));
        this.castFunction().render(this, arguments, this);
    }

    protected void renderLiteral(Literal literal, boolean castParameter) {
        assert (literal.getExpressionType().getJdbcTypeCount() == 1);
        JdbcMapping jdbcMapping = literal.getJdbcMapping();
        JdbcLiteralFormatter<Object> literalFormatter = jdbcMapping.getSqlTypeDescriptor().getJdbcLiteralFormatter(jdbcMapping.getJavaTypeDescriptor());
        if (literalFormatter == null) {
            this.parameterBinders.add(literal);
            LiteralAsParameter jdbcParameter = new LiteralAsParameter(literal);
            if (castParameter) {
                ArrayList<SqlAstNode> arguments = new ArrayList<SqlAstNode>(2);
                arguments.add(jdbcParameter);
                arguments.add(new CastTarget((BasicValuedMapping)((Object)jdbcMapping)));
                this.castFunction().render(this, arguments, this);
            } else {
                this.appendSql("?");
            }
        } else {
            this.appendSql(literalFormatter.toJdbcLiteral(literal.getLiteralValue(), this.dialect, this.getWrapperOptions()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitFromClause(FromClause fromClause) {
        if (fromClause == null || fromClause.getRoots().isEmpty()) {
            if (!this.getDialect().supportsSelectQueryWithoutFromClause()) {
                this.appendSql(" ");
                this.appendSql(this.getDialect().getFromDual());
            }
        } else {
            this.appendSql(" from ");
            try {
                this.clauseStack.push(Clause.FROM);
                String separator = "";
                for (TableGroup root : fromClause.getRoots()) {
                    this.appendSql(separator);
                    this.renderTableGroup(root);
                    separator = ", ";
                }
            }
            finally {
                this.clauseStack.pop();
            }
        }
    }

    protected void renderTableGroup(TableGroup tableGroup) {
        this.renderTableReference(tableGroup.getPrimaryTableReference());
        this.renderTableReferenceJoins(tableGroup);
        this.processTableGroupJoins(tableGroup);
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof AbstractEntityPersister) {
            String[] querySpaces = (String[])((AbstractEntityPersister)modelPart).getQuerySpaces();
            for (int i = 0; i < querySpaces.length; ++i) {
                this.registerAffectedTable(querySpaces[i]);
            }
        }
    }

    protected void renderTableGroup(TableGroup tableGroup, Predicate predicate) {
        this.renderTableReference(tableGroup.getPrimaryTableReference());
        this.appendSql(" on ");
        predicate.accept(this);
        this.renderTableReferenceJoins(tableGroup);
        this.processTableGroupJoins(tableGroup);
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof AbstractEntityPersister) {
            String[] querySpaces = (String[])((AbstractEntityPersister)modelPart).getQuerySpaces();
            for (int i = 0; i < querySpaces.length; ++i) {
                this.registerAffectedTable(querySpaces[i]);
            }
        }
    }

    protected void renderTableReference(TableReference tableReference) {
        this.appendSql(tableReference.getTableExpression());
        this.registerAffectedTable(tableReference);
        Clause currentClause = this.clauseStack.getCurrent();
        switch (currentClause) {
            case DELETE: 
            case UPDATE: {
                return;
            }
        }
        String identificationVariable = tableReference.getIdentificationVariable();
        if (identificationVariable != null) {
            this.appendSql(this.getDialect().getTableAliasSeparator());
            this.appendSql(identificationVariable);
        }
    }

    protected void registerAffectedTable(TableReference tableReference) {
        this.registerAffectedTable(tableReference.getTableExpression());
    }

    protected void registerAffectedTable(String tableExpression) {
        this.affectedTableNames.add(tableExpression);
    }

    protected void renderTableReferenceJoins(TableGroup tableGroup) {
        List<TableReferenceJoin> joins = tableGroup.getTableReferenceJoins();
        if (joins == null || joins.isEmpty()) {
            return;
        }
        for (TableReferenceJoin tableJoin : joins) {
            this.appendSql(" ");
            this.appendSql(tableJoin.getJoinType().getText());
            this.appendSql(" join ");
            this.renderTableReference(tableJoin.getJoinedTableReference());
            if (tableJoin.getJoinPredicate() == null || tableJoin.getJoinPredicate().isEmpty()) continue;
            this.appendSql(" on ");
            tableJoin.getJoinPredicate().accept(this);
        }
    }

    protected void processTableGroupJoins(TableGroup source) {
        source.visitTableGroupJoins(this::processTableGroupJoin);
    }

    protected void processTableGroupJoin(TableGroupJoin tableGroupJoin) {
        TableGroup joinedGroup = tableGroupJoin.getJoinedGroup();
        if (joinedGroup instanceof VirtualTableGroup) {
            this.processTableGroupJoins(tableGroupJoin.getJoinedGroup());
        } else {
            this.appendSql(" ");
            SqlAstJoinType joinType = tableGroupJoin.getJoinType();
            if (joinType == SqlAstJoinType.INNER && !joinedGroup.getTableReferenceJoins().isEmpty()) {
                joinType = SqlAstJoinType.LEFT;
            }
            this.appendSql(joinType.getText());
            this.appendSql(" join ");
            if (tableGroupJoin.getPredicate() != null && !tableGroupJoin.getPredicate().isEmpty()) {
                this.renderTableGroup(joinedGroup, tableGroupJoin.getPredicate());
            } else {
                this.renderTableGroup(joinedGroup);
            }
        }
    }

    @Override
    public void visitTableGroup(TableGroup tableGroup) {
        this.appendSql(tableGroup.getPrimaryTableReference().getIdentificationVariable());
        this.appendSql('.');
        ModelPartContainer modelPart = tableGroup.getModelPart();
        if (modelPart instanceof Loadable) {
            this.appendSql(((Loadable)tableGroup.getModelPart()).getIdentifierColumnNames()[0]);
        } else if (modelPart instanceof PluralAttributeMapping) {
            CollectionPart elementDescriptor = ((PluralAttributeMapping)modelPart).getElementDescriptor();
            if (elementDescriptor instanceof BasicValuedCollectionPart) {
                String mappedColumnExpression = ((BasicValuedCollectionPart)elementDescriptor).getSelectionExpression();
                this.appendSql(mappedColumnExpression);
            }
        } else {
            throw new NotYetImplementedFor6Exception(this.getClass());
        }
    }

    @Override
    public void visitTableGroupJoin(TableGroupJoin tableGroupJoin) {
        this.appendSql(tableGroupJoin.getJoinedGroup().getPrimaryTableReference().getIdentificationVariable());
        this.appendSql('.');
        this.appendSql(((Loadable)tableGroupJoin.getJoinedGroup().getModelPart()).getIdentifierColumnNames()[0]);
    }

    @Override
    public void visitTableReference(TableReference tableReference) {
    }

    @Override
    public void visitTableReferenceJoin(TableReferenceJoin tableReferenceJoin) {
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        if (this.dmlTargetTableAlias != null && this.dmlTargetTableAlias.equals(columnReference.getQualifier())) {
            this.appendSql(columnReference.getColumnExpression());
        } else {
            this.appendSql(columnReference.getExpressionText());
        }
    }

    @Override
    public void visitExtractUnit(ExtractUnit extractUnit) {
        this.appendSql(this.getDialect().translateExtractField(extractUnit.getUnit()));
    }

    @Override
    public void visitDurationUnit(DurationUnit unit) {
        this.appendSql(this.getDialect().translateDurationField(unit.getUnit()));
    }

    @Override
    public void visitFormat(Format format) {
        String dialectFormat = this.getDialect().translateDatetimeFormat(format.getFormat());
        this.appendSql("'");
        this.appendSql(dialectFormat);
        this.appendSql("'");
    }

    @Override
    public void visitStar(Star star) {
        this.appendSql("*");
    }

    @Override
    public void visitTrimSpecification(TrimSpecification trimSpecification) {
        this.appendSql(" ");
        this.appendSql(trimSpecification.getSpecification().toSqlText());
        this.appendSql(" ");
    }

    @Override
    public void visitCastTarget(CastTarget castTarget) {
        this.appendSql(this.getDialect().getCastTypeName(castTarget.getExpressionType(), castTarget.getLength(), castTarget.getPrecision(), castTarget.getScale()));
    }

    @Override
    public void visitDistinct(Distinct distinct) {
        this.appendSql("distinct ");
        distinct.getExpression().accept(this);
    }

    @Override
    public void visitParameter(JdbcParameter jdbcParameter) {
        if (this.inlineParameters) {
            this.renderExpressionAsLiteral(jdbcParameter, this.jdbcParameterBindings);
        } else {
            this.appendSql("?");
            this.parameterBinders.add(jdbcParameter.getParameterBinder());
            this.jdbcParameters.addParameter(jdbcParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(SqlAstNode sqlAstNode, SqlAstNodeRenderingMode renderingMode) {
        switch (renderingMode) {
            case NO_PLAIN_PARAMETER: {
                if (sqlAstNode instanceof SqmParameterInterpretation) {
                    sqlAstNode = ((SqmParameterInterpretation)sqlAstNode).getResolvedExpression();
                }
                if (sqlAstNode instanceof JdbcParameter) {
                    SqmFunctionDescriptor sqmFunctionDescriptor;
                    JdbcParameter jdbcParameter = (JdbcParameter)sqlAstNode;
                    JdbcMapping jdbcMapping = jdbcParameter.getExpressionType().getJdbcMappings().get(0);
                    if (jdbcMapping.getSqlTypeDescriptor().isNumber()) {
                        this.appendSql('(');
                        sqlAstNode.accept(this);
                        this.appendSql("+0)");
                        break;
                    }
                    if (jdbcMapping.getSqlTypeDescriptor().isString() && (sqmFunctionDescriptor = this.getSessionFactory().getQueryEngine().getSqmFunctionRegistry().findFunctionDescriptor("concat")) instanceof AbstractSqmSelfRenderingFunctionDescriptor) {
                        ArrayList<SqlAstNode> list = new ArrayList<SqlAstNode>(2);
                        list.add(sqlAstNode);
                        list.add(new QueryLiteral<String>("", StringType.INSTANCE));
                        ((AbstractSqmSelfRenderingFunctionDescriptor)sqmFunctionDescriptor).render(this, list, this);
                        break;
                    }
                    ArrayList<SqlAstNode> arguments = new ArrayList<SqlAstNode>(2);
                    arguments.add(jdbcParameter);
                    arguments.add(new CastTarget((BasicValuedMapping)((Object)jdbcMapping)));
                    this.castFunction().render(this, arguments, this);
                    break;
                }
                sqlAstNode.accept(this);
                break;
            }
            case INLINE_PARAMETERS: {
                boolean inlineParameters = this.inlineParameters;
                this.inlineParameters = true;
                try {
                    sqlAstNode.accept(this);
                    break;
                }
                finally {
                    this.inlineParameters = inlineParameters;
                }
            }
            default: {
                sqlAstNode.accept(this);
            }
        }
    }

    @Override
    public void visitTuple(SqlTuple tuple) {
        boolean isCurrentWhereClause;
        boolean bl = isCurrentWhereClause = this.clauseStack.getCurrent() == Clause.WHERE;
        if (isCurrentWhereClause) {
            this.appendSql("(");
        }
        this.renderCommaSeparated(tuple.getExpressions());
        if (isCurrentWhereClause) {
            this.appendSql(")");
        }
    }

    private void renderCommaSeparated(Iterable<? extends Expression> expressions) {
        String separator = "";
        for (Expression expression : expressions) {
            this.appendSql(separator);
            expression.accept(this);
            separator = ", ";
        }
    }

    @Override
    public void visitCollate(Collate collate) {
        collate.getExpression().accept(this);
        this.appendSql(" collate ");
        this.appendSql(collate.getCollation());
    }

    @Override
    public void visitSqlSelectionExpression(SqlSelectionExpression expression) {
        boolean useSelectionPosition = this.dialect.supportsOrdinalSelectItemReference();
        if (useSelectionPosition) {
            this.appendSql(Integer.toString(expression.getSelection().getJdbcResultSetIndex()));
        } else {
            expression.getSelection().getExpression().accept(this);
        }
    }

    @Override
    public void visitEntityTypeLiteral(EntityTypeLiteral expression) {
        throw new NotYetImplementedFor6Exception("Mapping model subclass support not yet implemented");
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql("(");
        arithmeticExpression.getLeftHandOperand().accept(this);
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        arithmeticExpression.getRightHandOperand().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitDuration(Duration duration) {
        duration.getMagnitude().accept(this);
        this.appendSql(duration.getUnit().conversionFactor(TemporalUnit.NANOSECOND, this.getDialect()));
    }

    @Override
    public void visitConversion(Conversion conversion) {
        conversion.getDuration().getMagnitude().accept(this);
        this.appendSql(conversion.getDuration().getUnit().conversionFactor(conversion.getUnit(), this.getDialect()));
    }

    @Override
    public void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression) {
        this.dialect.getCaseExpressionWalker().visitCaseSearchedExpression(caseSearchedExpression, this.sqlBuffer, this);
    }

    @Override
    public void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression) {
        this.appendSql("case");
        caseSimpleExpression.getFixture().accept(this);
        for (CaseSimpleExpression.WhenFragment whenFragment : caseSimpleExpression.getWhenFragments()) {
            this.appendSql(" when ");
            whenFragment.getCheckValue().accept(this);
            this.appendSql(" then ");
            whenFragment.getResult().accept(this);
        }
        this.appendSql(" else ");
        caseSimpleExpression.getOtherwise().accept(this);
        this.appendSql(" end");
    }

    @Override
    public void visitAny(Any any) {
        this.appendSql("some ");
        any.getSubquery().accept(this);
    }

    @Override
    public void visitEvery(Every every) {
        this.appendSql("all ");
        every.getSubquery().accept(this);
    }

    @Override
    public void visitSummarization(Summarization every) {
    }

    @Override
    public void visitJdbcLiteral(JdbcLiteral jdbcLiteral) {
        this.visitLiteral(jdbcLiteral);
    }

    @Override
    public void visitQueryLiteral(QueryLiteral queryLiteral) {
        this.visitLiteral(queryLiteral);
    }

    @Override
    public void visitNullnessLiteral(NullnessLiteral nullnessLiteral) {
        this.appendSql("null");
    }

    private void visitLiteral(Literal literal) {
        if (literal.getLiteralValue() == null) {
            this.appendSql("null");
        } else {
            this.renderLiteral(literal, false);
        }
    }

    protected void renderAsLiteral(JdbcParameter jdbcParameter, Object literalValue) {
        if (literalValue == null) {
            this.appendSql("null");
        } else {
            assert (jdbcParameter.getExpressionType().getJdbcTypeCount() == 1);
            JdbcMapping jdbcMapping = jdbcParameter.getExpressionType().getJdbcMappings().get(0);
            JdbcLiteralFormatter<Object> literalFormatter = jdbcMapping.getSqlTypeDescriptor().getJdbcLiteralFormatter(jdbcMapping.getJavaTypeDescriptor());
            if (literalFormatter == null) {
                throw new IllegalArgumentException("Can't render parameter as literal, no literal formatter found");
            }
            this.appendSql(literalFormatter.toJdbcLiteral(literalValue, this.dialect, this.getWrapperOptions()));
        }
    }

    @Override
    public void visitUnaryOperationExpression(UnaryOperation unaryOperationExpression) {
        if (unaryOperationExpression.getOperator() == UnaryArithmeticOperator.UNARY_PLUS) {
            this.appendSql(UnaryArithmeticOperator.UNARY_PLUS.getOperatorChar());
        } else {
            this.appendSql(UnaryArithmeticOperator.UNARY_MINUS.getOperatorChar());
        }
        unaryOperationExpression.getOperand().accept(this);
    }

    @Override
    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
        selfRenderingPredicate.getSelfRenderingExpression().renderToSql(this, this, this.getSessionFactory());
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        expression.renderToSql(this, this, this.getSessionFactory());
    }

    @Override
    public void visitBetweenPredicate(BetweenPredicate betweenPredicate) {
        betweenPredicate.getExpression().accept(this);
        if (betweenPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" between ");
        betweenPredicate.getLowerBound().accept(this);
        this.appendSql(" and ");
        betweenPredicate.getUpperBound().accept(this);
    }

    @Override
    public void visitFilterPredicate(FilterPredicate filterPredicate) {
        assert (StringHelper.isNotEmpty(filterPredicate.getFilterFragment()));
        this.appendSql(filterPredicate.getFilterFragment());
        for (FilterJdbcParameter filterJdbcParameter : filterPredicate.getFilterJdbcParameters()) {
            this.parameterBinders.add(filterJdbcParameter.getBinder());
            this.jdbcParameters.addParameter(filterJdbcParameter.getParameter());
            this.filterJdbcParameters.add(filterJdbcParameter);
        }
    }

    @Override
    public void visitGroupedPredicate(GroupedPredicate groupedPredicate) {
        if (groupedPredicate.isEmpty()) {
            return;
        }
        this.appendSql("(");
        groupedPredicate.getSubPredicate().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitInListPredicate(InListPredicate inListPredicate) {
        if (inListPredicate.getListExpressions().isEmpty()) {
            this.appendSql("false");
            return;
        }
        SqlTuple lhsTuple = this.getTuple(inListPredicate.getTestExpression());
        if (lhsTuple != null) {
            if (lhsTuple.getExpressions().size() == 1) {
                lhsTuple.getExpressions().get(0).accept(this);
                if (inListPredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" in (");
                String separator = "";
                for (Expression expression : inListPredicate.getListExpressions()) {
                    this.appendSql(separator);
                    this.getTuple(expression).getExpressions().get(0).accept(this);
                    separator = ", ";
                }
                this.appendSql(")");
            } else if (!this.dialect.supportsRowValueConstructorSyntaxInInList()) {
                ComparisonOperator comparisonOperator;
                ComparisonOperator comparisonOperator2 = comparisonOperator = inListPredicate.isNegated() ? ComparisonOperator.NOT_EQUAL : ComparisonOperator.EQUAL;
                if (this.dialect.supportsRowValueConstructorSyntaxInInSubquery() && this.dialect.supportsUnionAll()) {
                    inListPredicate.getTestExpression().accept(this);
                    if (inListPredicate.isNegated()) {
                        this.appendSql(" not");
                    }
                    this.appendSql(" in (");
                    String separator = "";
                    for (Expression expression : inListPredicate.getListExpressions()) {
                        this.appendSql(separator);
                        this.renderExpressionsAsSubquery(this.getTuple(expression).getExpressions());
                        separator = " union all ";
                    }
                    this.appendSql(")");
                } else {
                    String separator = "";
                    for (Expression expression : inListPredicate.getListExpressions()) {
                        this.appendSql(separator);
                        this.emulateTupleComparison(lhsTuple.getExpressions(), this.getTuple(expression).getExpressions(), comparisonOperator, true);
                        separator = " or ";
                    }
                }
            } else {
                inListPredicate.getTestExpression().accept(this);
                if (inListPredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" in (");
                this.renderCommaSeparated(inListPredicate.getListExpressions());
                this.appendSql(")");
            }
        } else {
            inListPredicate.getTestExpression().accept(this);
            if (inListPredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" in (");
            this.renderCommaSeparated(inListPredicate.getListExpressions());
            this.appendSql(")");
        }
    }

    protected final SqlTuple getTuple(Expression expression) {
        if (expression instanceof SqlTuple) {
            return (SqlTuple)expression;
        }
        if (expression instanceof SqmParameterInterpretation) {
            Expression resolvedExpression = ((SqmParameterInterpretation)expression).getResolvedExpression();
            if (resolvedExpression instanceof SqlTuple) {
                return (SqlTuple)resolvedExpression;
            }
        } else {
            if (expression instanceof EmbeddableValuedPathInterpretation) {
                return ((EmbeddableValuedPathInterpretation)expression).getSqlExpression();
            }
            if (expression instanceof NonAggregatedCompositeValuedPathInterpretation) {
                return ((NonAggregatedCompositeValuedPathInterpretation)expression).getSqlExpression();
            }
        }
        return null;
    }

    @Override
    public void visitInSubQueryPredicate(InSubQueryPredicate inSubQueryPredicate) {
        SqlTuple lhsTuple = this.getTuple(inSubQueryPredicate.getTestExpression());
        if (lhsTuple != null) {
            if (lhsTuple.getExpressions().size() == 1) {
                lhsTuple.getExpressions().get(0).accept(this);
                if (inSubQueryPredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" in ");
                inSubQueryPredicate.getSubQuery().accept(this);
            } else if (!this.dialect.supportsRowValueConstructorSyntaxInInSubquery()) {
                this.emulateTupleSubQueryPredicate(inSubQueryPredicate, inSubQueryPredicate.isNegated(), inSubQueryPredicate.getSubQuery(), lhsTuple, ComparisonOperator.EQUAL);
            } else {
                inSubQueryPredicate.getTestExpression().accept(this);
                if (inSubQueryPredicate.isNegated()) {
                    this.appendSql(" not");
                }
                this.appendSql(" in ");
                inSubQueryPredicate.getSubQuery().accept(this);
            }
        } else {
            inSubQueryPredicate.getTestExpression().accept(this);
            if (inSubQueryPredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" in ");
            inSubQueryPredicate.getSubQuery().accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void emulateTupleSubQueryPredicate(Predicate predicate, boolean negated, QueryPart queryPart, SqlTuple lhsTuple, ComparisonOperator tupleComparisonOperator) {
        if (queryPart instanceof QuerySpec && queryPart.getFetchClauseExpression() == null && queryPart.getOffsetClauseExpression() == null) {
            subQuery = (QuerySpec)queryPart;
            if (negated) {
                this.appendSql("not ");
            }
            queryPartForRowNumbering = this.queryPartForRowNumbering;
            needsSelectAliases = this.needsSelectAliases;
            try {
                this.queryPartForRowNumbering = null;
                this.needsSelectAliases = false;
                this.queryPartStack.push(subQuery);
                this.appendSql("exists (select 1");
                this.visitFromClause(subQuery.getFromClause());
                if (!subQuery.getGroupByClauseExpressions().isEmpty() || subQuery.getHavingClauseRestrictions() != null) {
                    this.visitWhereClause(subQuery);
                    this.visitGroupByClause(subQuery, false);
                    this.appendSql(" having ");
                    this.clauseStack.push(Clause.HAVING);
                    try {
                        this.renderSelectTupleComparison(subQuery.getSelectClause().getSqlSelections(), lhsTuple, tupleComparisonOperator);
                        havingClauseRestrictions = subQuery.getHavingClauseRestrictions();
                        if (havingClauseRestrictions == null) ** GOTO lbl44
                        this.appendSql(" and (");
                        havingClauseRestrictions.accept(this);
                        this.appendSql(')');
                    }
                    finally {
                        this.clauseStack.pop();
                    }
                } else {
                    this.appendSql(" where ");
                    this.clauseStack.push(Clause.WHERE);
                    try {
                        this.renderSelectTupleComparison(subQuery.getSelectClause().getSqlSelections(), lhsTuple, tupleComparisonOperator);
                        whereClauseRestrictions = subQuery.getWhereClauseRestrictions();
                        if (whereClauseRestrictions != null) {
                            this.appendSql(" and (");
                            whereClauseRestrictions.accept(this);
                            this.appendSql(')');
                        }
                    }
                    finally {
                        this.clauseStack.pop();
                    }
                }
                this.appendSql(")");
            }
            finally {
                this.queryPartStack.pop();
                this.queryPartForRowNumbering = queryPartForRowNumbering;
                this.needsSelectAliases = needsSelectAliases;
            }
        }
        throw new IllegalArgumentException("Can't emulate in predicate with tuples and limit/offset or set operations: " + predicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void emulateQuantifiedTupleSubQueryPredicate(Predicate predicate, QueryPart queryPart, SqlTuple lhsTuple, ComparisonOperator tupleComparisonOperator) {
        if (queryPart instanceof QuerySpec && queryPart.getFetchClauseExpression() == null && queryPart.getOffsetClauseExpression() == null) {
            QuerySpec subQuery = (QuerySpec)queryPart;
            lhsTuple.accept(this);
            this.appendSql(" ");
            this.appendSql(tupleComparisonOperator.sqlText());
            this.appendSql(" ");
            QueryPart queryPartForRowNumbering = this.queryPartForRowNumbering;
            boolean needsSelectAliases = this.needsSelectAliases;
            try {
                this.queryPartForRowNumbering = null;
                this.needsSelectAliases = false;
                this.queryPartStack.push(subQuery);
                this.appendSql("(");
                this.visitSelectClause(subQuery.getSelectClause());
                this.visitFromClause(subQuery.getFromClause());
                this.visitWhereClause(subQuery);
                this.visitGroupByClause(subQuery, this.dialect.supportsSelectAliasInGroupByClause());
                this.visitHavingClause(subQuery);
                this.appendSql(" order by ");
                List<SqlSelection> sqlSelections = subQuery.getSelectClause().getSqlSelections();
                String order = tupleComparisonOperator == ComparisonOperator.LESS_THAN || tupleComparisonOperator == ComparisonOperator.LESS_THAN_OR_EQUAL ? "" : " desc";
                this.appendSql("1");
                this.appendSql(order);
                for (int i = 1; i < sqlSelections.size(); ++i) {
                    this.appendSql(", ");
                    this.appendSql(Integer.toString(i + 1));
                    this.appendSql(order);
                }
                this.renderFetch(ONE_LITERAL, null, FetchClauseType.ROWS_ONLY);
                this.appendSql(")");
            }
            finally {
                this.queryPartStack.pop();
                this.queryPartForRowNumbering = queryPartForRowNumbering;
                this.needsSelectAliases = needsSelectAliases;
            }
        } else {
            throw new IllegalArgumentException("Can't emulate in predicate with tuples and limit/offset or set operations: " + predicate);
        }
    }

    @Override
    public void visitExistsPredicate(ExistsPredicate existsPredicate) {
        this.appendSql("exists ");
        existsPredicate.getExpression().accept(this);
    }

    @Override
    public void visitJunction(Junction junction) {
        if (junction.isEmpty()) {
            return;
        }
        String separator = "";
        for (Predicate predicate : junction.getPredicates()) {
            this.appendSql(separator);
            predicate.accept(this);
            if (separator != "") continue;
            separator = junction.getNature() == Junction.Nature.CONJUNCTION ? " and " : " or ";
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        likePredicate.getMatchExpression().accept(this);
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" like ");
        likePredicate.getPattern().accept(this);
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept(this);
        }
    }

    @Override
    public void visitNegatedPredicate(NegatedPredicate negatedPredicate) {
        if (negatedPredicate.isEmpty()) {
            return;
        }
        this.appendSql("not (");
        negatedPredicate.getPredicate().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
        Expression expression = nullnessPredicate.getExpression();
        String predicateValue = nullnessPredicate.isNegated() ? " is not null" : " is null";
        SqlTuple tuple = this.getTuple(expression);
        if (tuple != null) {
            String separator = "";
            for (Expression expression2 : tuple.getExpressions()) {
                this.appendSql(separator);
                expression2.accept(this);
                this.appendSql(predicateValue);
                separator = " and ";
            }
        } else {
            expression.accept(this);
            this.appendSql(predicateValue);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitRelationalPredicate(ComparisonPredicate comparisonPredicate) {
        SqlTuple lhsTuple = this.getTuple(comparisonPredicate.getLeftHandExpression());
        if (lhsTuple != null) {
            boolean all;
            QueryPart subquery;
            Expression rhsExpression = comparisonPredicate.getRightHandExpression();
            if (rhsExpression instanceof QueryPart) {
                subquery = (QueryPart)rhsExpression;
                all = true;
            } else if (rhsExpression instanceof Every) {
                subquery = ((Every)rhsExpression).getSubquery();
                all = true;
            } else if (rhsExpression instanceof Any) {
                subquery = ((Any)rhsExpression).getSubquery();
                all = false;
            } else {
                subquery = null;
                all = false;
            }
            ComparisonOperator operator = comparisonPredicate.getOperator();
            if (lhsTuple.getExpressions().size() == 1) {
                lhsTuple.getExpressions().get(0).accept(this);
                this.appendSql(" ");
                this.appendSql(operator.sqlText());
                this.appendSql(" ");
                if (subquery == null) {
                    this.getTuple(comparisonPredicate.getRightHandExpression()).getExpressions().get(0).accept(this);
                    return;
                } else {
                    rhsExpression.accept(this);
                }
                return;
            } else if (subquery != null && !this.dialect.supportsRowValueConstructorSyntaxInQuantifiedPredicates()) {
                if (all && operator != ComparisonOperator.EQUAL && operator != ComparisonOperator.NOT_EQUAL && this.dialect.supportsRowValueConstructorSyntax()) {
                    this.emulateQuantifiedTupleSubQueryPredicate(comparisonPredicate, subquery, lhsTuple, operator);
                    return;
                } else {
                    this.emulateTupleSubQueryPredicate(comparisonPredicate, all, subquery, lhsTuple, all ? operator.negated() : operator);
                }
                return;
            } else if (!this.dialect.supportsRowValueConstructorSyntax()) {
                SqlTuple rhsTuple = this.getTuple(rhsExpression);
                assert (rhsTuple != null);
                if ((operator == ComparisonOperator.EQUAL || operator == ComparisonOperator.NOT_EQUAL) && this.dialect.supportsRowValueConstructorSyntaxInInSubquery()) {
                    comparisonPredicate.getLeftHandExpression().accept(this);
                    if (operator == ComparisonOperator.NOT_EQUAL) {
                        this.appendSql(" not");
                    }
                    this.appendSql(" in (");
                    this.renderExpressionsAsSubquery(rhsTuple.getExpressions());
                    this.appendSql(")");
                    return;
                } else {
                    this.emulateTupleComparison(lhsTuple.getExpressions(), rhsTuple.getExpressions(), operator, true);
                }
                return;
            } else {
                comparisonPredicate.getLeftHandExpression().accept(this);
                this.appendSql(" ");
                this.appendSql(operator.sqlText());
                this.appendSql(" ");
                rhsExpression.accept(this);
            }
            return;
        } else {
            SqlTuple rhsTuple = this.getTuple(comparisonPredicate.getRightHandExpression());
            if (rhsTuple != null) {
                Expression lhsExpression = comparisonPredicate.getLeftHandExpression();
                if (!(lhsExpression instanceof QueryGroup)) throw new IllegalStateException("Unsupported tuple comparison combination. LHS is neither a tuple nor a tuple subquery but RHS is a tuple: " + comparisonPredicate);
                QueryGroup subquery = (QueryGroup)lhsExpression;
                if (rhsTuple.getExpressions().size() == 1) {
                    lhsExpression.accept(this);
                    this.appendSql(" ");
                    this.appendSql(comparisonPredicate.getOperator().sqlText());
                    this.appendSql(" ");
                    rhsTuple.getExpressions().get(0).accept(this);
                    return;
                } else if (this.dialect.supportsRowValueConstructorSyntax()) {
                    lhsExpression.accept(this);
                    this.appendSql(" ");
                    this.appendSql(comparisonPredicate.getOperator().sqlText());
                    this.appendSql(" ");
                    comparisonPredicate.getRightHandExpression().accept(this);
                    return;
                } else {
                    this.emulateTupleSubQueryPredicate(comparisonPredicate, false, subquery, rhsTuple, comparisonPredicate.getOperator().invert());
                }
                return;
            } else {
                comparisonPredicate.getLeftHandExpression().accept(this);
                this.appendSql(" ");
                this.appendSql(comparisonPredicate.getOperator().sqlText());
                this.appendSql(" ");
                comparisonPredicate.getRightHandExpression().accept(this);
            }
        }
    }

    private static class OffsetReceivingParameterBinder
    implements JdbcParameterBinder {
        private final JdbcParameter fetchParameter;
        private final int staticOffset;
        private Number dynamicOffset;

        public OffsetReceivingParameterBinder(JdbcParameter fetchParameter, int staticOffset) {
            this.fetchParameter = fetchParameter;
            this.staticOffset = staticOffset;
        }

        @Override
        public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
            JdbcParameterBinding binding = jdbcParameterBindings.getBinding(this.fetchParameter);
            if (binding == null) {
                throw new ExecutionException("JDBC parameter value not bound - " + this.fetchParameter);
            }
            Number bindValue = (Number)binding.getBindValue();
            int offsetValue = this.dynamicOffset.intValue() + this.staticOffset;
            this.dynamicOffset = null;
            this.fetchParameter.getExpressionType().getJdbcMappings().get(0).getJdbcValueBinder().bind(statement, Integer.valueOf(bindValue.intValue() + offsetValue), startPosition, (WrapperOptions)executionContext.getSession());
        }
    }

    private static class LazySessionWrapperOptions
    extends AbstractDelegatingWrapperOptions {
        private final SessionFactoryImplementor sessionFactory;
        private SessionImplementor session;

        public LazySessionWrapperOptions(SessionFactoryImplementor sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public void cleanup() {
            if (this.session != null) {
                this.session.close();
                this.session = null;
            }
        }

        @Override
        protected SessionImplementor delegate() {
            if (this.session == null) {
                this.session = (SessionImplementor)this.sessionFactory.openTemporarySession();
            }
            return this.session;
        }

        @Override
        public SharedSessionContractImplementor getSession() {
            return this.delegate();
        }

        @Override
        public boolean useStreamForLobBinding() {
            return this.sessionFactory.getFastSessionServices().useStreamForLobBinding();
        }

        @Override
        public SqlTypeDescriptor remapSqlTypeDescriptor(SqlTypeDescriptor sqlTypeDescriptor) {
            return this.sessionFactory.getFastSessionServices().remapSqlTypeDescriptor(sqlTypeDescriptor);
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.sessionFactory.getSessionFactoryOptions().getJdbcTimeZone();
        }
    }
}

