/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;

public abstract class AbstractLiteral<T>
implements JdbcParameterBinder,
Expression,
DomainResultProducer<T> {
    private final Object value;
    private final BasicValuedMapping type;
    private final Clause clause;

    public AbstractLiteral(Object value, BasicValuedMapping type, Clause clause) {
        this.value = value;
        this.type = type;
        this.clause = clause;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isInSelect() {
        return this.clause == Clause.SELECT;
    }

    @Override
    public BasicValuedMapping getExpressionType() {
        return this.type;
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(this, this.type.getMappedType().getMappedJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.type.getMappedType().getMappedJavaTypeDescriptor());
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        ((BasicType)this.getExpressionType()).getJdbcValueBinder().bind(statement, this.getValue(), startPosition, (WrapperOptions)executionContext.getSession());
    }
}

