/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.type.descriptor.WrapperOptions;

public class JdbcLiteral<T>
implements Literal,
MappingModelExpressable<T>,
DomainResultProducer<T> {
    private final T literalValue;
    private final JdbcMapping jdbcMapping;

    public JdbcLiteral(T literalValue, JdbcMapping jdbcMapping) {
        this.literalValue = literalValue;
        this.jdbcMapping = jdbcMapping;
    }

    @Override
    public Object getLiteralValue() {
        return this.literalValue;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitJdbcLiteral(this);
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        this.jdbcMapping.getJdbcValueBinder().bind(statement, this.literalValue, startPosition, (WrapperOptions)executionContext.getSession());
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this;
    }

    @Override
    public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return Collections.singletonList(this.jdbcMapping);
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        action.accept(offset, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return value;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        valuesConsumer.consume(offset, value, this.jdbcMapping);
        return this.getJdbcTypeCount();
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(this, this.jdbcMapping.getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.jdbcMapping.getJavaTypeDescriptor());
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        SqlExpressionResolver sqlExpressionResolver = sqlAstCreationState.getSqlExpressionResolver();
        sqlExpressionResolver.resolveSqlSelection(this, this.jdbcMapping.getJavaTypeDescriptor(), sqlAstCreationState.getCreationContext().getDomainModel().getTypeConfiguration());
    }
}

