/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.tree.from.ColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public abstract class AbstractColumnReferenceQualifier
implements ColumnReferenceQualifier {
    protected abstract TableReference getPrimaryTableReference();

    protected abstract List<TableReferenceJoin> getTableReferenceJoins();

    protected abstract SessionFactoryImplementor getSessionFactory();

    @Override
    public TableReference resolveTableReference(String tableExpression, Supplier<TableReference> creator) {
        TableReference existing = this.getTableReferenceInternal(tableExpression);
        if (existing != null) {
            return existing;
        }
        return creator.get();
    }

    @Override
    public TableReference resolveTableReference(String tableExpression) {
        assert (tableExpression != null);
        TableReference tableReference = this.getTableReferenceInternal(tableExpression);
        if (tableReference == null) {
            throw new IllegalStateException("Could not resolve binding for table `" + tableExpression + "`");
        }
        return tableReference;
    }

    @Override
    public TableReference getTableReference(String tableExpression) {
        return this.getTableReferenceInternal(tableExpression);
    }

    protected TableReference getTableReferenceInternal(String tableExpression) {
        if (this.getPrimaryTableReference().getTableReference(tableExpression) != null) {
            return this.getPrimaryTableReference();
        }
        for (TableReferenceJoin tableJoin : this.getTableReferenceJoins()) {
            if (tableJoin.getJoinedTableReference().getTableReference(tableExpression) == null) continue;
            return tableJoin.getJoinedTableReference();
        }
        return null;
    }
}

