/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;

public class CorrelatedTableGroup
extends AbstractTableGroup {
    private final TableGroup correlatedTableGroup;
    private final QuerySpec querySpec;
    private final Consumer<Predicate> joinPredicateConsumer;

    public CorrelatedTableGroup(TableGroup correlatedTableGroup, SqlAliasBase sqlAliasBase, QuerySpec querySpec, Consumer<Predicate> joinPredicateConsumer, SessionFactoryImplementor sessionFactory) {
        super(correlatedTableGroup.getNavigablePath(), (TableGroupProducer)correlatedTableGroup.getExpressionType(), LockMode.NONE, sqlAliasBase, sessionFactory);
        this.correlatedTableGroup = correlatedTableGroup;
        this.querySpec = querySpec;
        this.joinPredicateConsumer = joinPredicateConsumer;
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.getTableGroupJoins().contains(join)) {
            return;
        }
        assert (join.getJoinType() == SqlAstJoinType.INNER);
        this.querySpec.getFromClause().addRoot(join.getJoinedGroup());
        this.joinPredicateConsumer.accept(join.getPredicate());
        super.addTableGroupJoin(join);
    }

    @Override
    protected TableReference getTableReferenceInternal(String tableExpression) {
        TableReference primaryTableReference = this.correlatedTableGroup.getPrimaryTableReference();
        if (tableExpression.equals(primaryTableReference.getTableExpression())) {
            return primaryTableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            TableReference groupTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference();
            if (groupTableReference.getTableReference(tableExpression) == null) continue;
            return groupTableReference;
        }
        for (TableReferenceJoin tableReferenceJoin : this.correlatedTableGroup.getTableReferenceJoins()) {
            if (!tableExpression.equals(tableReferenceJoin.getJoinedTableReference().getTableExpression())) continue;
            return tableReferenceJoin.getJoinedTableReference();
        }
        return null;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        nameCollector.accept(this.getPrimaryTableReference().getTableExpression());
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.correlatedTableGroup.getPrimaryTableReference();
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }
}

