/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.insert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.AbstractMutationStatement;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.insert.Values;
import org.hibernate.sql.ast.tree.select.QueryPart;

public class InsertStatement
extends AbstractMutationStatement {
    private List<ColumnReference> targetColumnReferences;
    private QueryPart sourceSelectStatement;
    private List<Values> valuesList = new ArrayList<Values>();

    public InsertStatement(TableReference targetTable) {
        super(targetTable);
    }

    public InsertStatement(boolean withRecursive, Map<String, CteStatement> cteStatements, TableReference targetTable, List<ColumnReference> returningColumns) {
        super(cteStatements, targetTable, returningColumns);
        this.setWithRecursive(withRecursive);
    }

    public List<ColumnReference> getTargetColumnReferences() {
        return this.targetColumnReferences == null ? Collections.emptyList() : this.targetColumnReferences;
    }

    public void addTargetColumnReferences(ColumnReference ... references) {
        if (this.targetColumnReferences == null) {
            this.targetColumnReferences = new ArrayList<ColumnReference>();
        }
        Collections.addAll(this.targetColumnReferences, references);
    }

    public void addTargetColumnReferences(List<ColumnReference> references) {
        if (this.targetColumnReferences == null) {
            this.targetColumnReferences = new ArrayList<ColumnReference>();
        }
        this.targetColumnReferences.addAll(references);
    }

    public QueryPart getSourceSelectStatement() {
        return this.sourceSelectStatement;
    }

    public void setSourceSelectStatement(QueryPart sourceSelectStatement) {
        this.sourceSelectStatement = sourceSelectStatement;
    }

    public List<Values> getValuesList() {
        return this.valuesList;
    }

    public void setValuesList(List<Values> valuesList) {
        this.valuesList = valuesList;
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitInsertStatement(this);
    }
}

