/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.select;

import java.util.List;
import org.hibernate.SetOperator;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;

public class QueryGroup
extends QueryPart {
    private final SetOperator setOperator;
    private final List<QueryPart> queryParts;

    public QueryGroup(boolean isRoot, SetOperator setOperator, List<QueryPart> queryParts) {
        super(isRoot);
        this.setOperator = setOperator;
        this.queryParts = queryParts;
    }

    @Override
    public QuerySpec getFirstQuerySpec() {
        return this.queryParts.get(0).getFirstQuerySpec();
    }

    @Override
    public QuerySpec getLastQuerySpec() {
        return this.queryParts.get(this.queryParts.size() - 1).getLastQuerySpec();
    }

    public SetOperator getSetOperator() {
        return this.setOperator;
    }

    public List<QueryPart> getQueryParts() {
        return this.queryParts;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitQueryGroup(this);
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this.queryParts.get(0).getExpressionType();
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        this.queryParts.get(0).applySqlSelections(creationState);
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.queryParts.get(0).createDomainResult(resultVariable, creationState);
    }
}

