/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.select;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.FetchClauseType;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public abstract class QueryPart
implements SqlAstNode,
Expression,
DomainResultProducer {
    private final boolean isRoot;
    private List<SortSpecification> sortSpecifications;
    private Expression offsetClauseExpression;
    private Expression fetchClauseExpression;
    private FetchClauseType fetchClauseType = FetchClauseType.ROWS_ONLY;

    public QueryPart(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public abstract QuerySpec getFirstQuerySpec();

    public abstract QuerySpec getLastQuerySpec();

    public boolean isRoot() {
        return this.isRoot;
    }

    public boolean hasSortSpecifications() {
        return this.sortSpecifications != null && !this.sortSpecifications.isEmpty();
    }

    public List<SortSpecification> getSortSpecifications() {
        return this.sortSpecifications;
    }

    void visitSortSpecifications(Consumer<SortSpecification> consumer) {
        if (this.sortSpecifications != null) {
            this.sortSpecifications.forEach(consumer);
        }
    }

    public void addSortSpecification(SortSpecification specification) {
        if (this.sortSpecifications == null) {
            this.sortSpecifications = new ArrayList<SortSpecification>();
        }
        this.sortSpecifications.add(specification);
    }

    public boolean hasOffsetOrFetchClause() {
        return this.offsetClauseExpression != null || this.fetchClauseExpression != null;
    }

    public Expression getOffsetClauseExpression() {
        return this.offsetClauseExpression;
    }

    public void setOffsetClauseExpression(Expression offsetClauseExpression) {
        this.offsetClauseExpression = offsetClauseExpression;
    }

    public Expression getFetchClauseExpression() {
        return this.fetchClauseExpression;
    }

    public void setFetchClauseExpression(Expression fetchClauseExpression, FetchClauseType fetchClauseType) {
        if (fetchClauseExpression == null) {
            this.fetchClauseExpression = null;
            this.fetchClauseType = null;
        } else {
            if (fetchClauseType == null) {
                throw new IllegalArgumentException("Fetch clause may not be null!");
            }
            this.fetchClauseExpression = fetchClauseExpression;
            this.fetchClauseType = fetchClauseType;
        }
    }

    public FetchClauseType getFetchClauseType() {
        return this.fetchClauseType;
    }
}

