/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import java.util.Collections;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.CollectionResultGraphNode;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionAssembler;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class CollectionDomainResult
implements DomainResult,
CollectionResultGraphNode,
FetchParent {
    private final NavigablePath loadingPath;
    private final PluralAttributeMapping loadingAttribute;
    private final String resultVariable;
    private final DomainResult fkResult;
    private final CollectionInitializerProducer initializerProducer;

    public CollectionDomainResult(NavigablePath loadingPath, PluralAttributeMapping loadingAttribute, String resultVariable, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.loadingPath = loadingPath;
        this.loadingAttribute = loadingAttribute;
        this.resultVariable = resultVariable;
        this.fkResult = loadingAttribute.getKeyDescriptor().createDomainResult(loadingPath, tableGroup, creationState);
        CollectionSemantics collectionSemantics = loadingAttribute.getCollectionDescriptor().getCollectionSemantics();
        this.initializerProducer = collectionSemantics.createInitializerProducer(loadingPath, loadingAttribute, this, true, null, LockMode.READ, creationState);
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return true;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.loadingAttribute.getJavaTypeDescriptor();
    }

    public DomainResultAssembler createResultAssembler(AssemblerCreationState creationState) {
        CollectionInitializer initializer = (CollectionInitializer)creationState.resolveInitializer(this.getNavigablePath(), this.getReferencedModePart(), () -> {
            DomainResultAssembler fkAssembler = this.fkResult.createResultAssembler(creationState);
            return this.initializerProducer.produceInitializer(this.loadingPath, this.loadingAttribute, null, LockMode.READ, fkAssembler, fkAssembler, creationState);
        });
        return new EagerCollectionAssembler(this.loadingAttribute, initializer);
    }

    @Override
    public FetchableContainer getReferencedMappingContainer() {
        return this.loadingAttribute;
    }

    @Override
    public FetchableContainer getReferencedMappingType() {
        return this.getReferencedMappingContainer();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.loadingPath;
    }

    @Override
    public List<Fetch> getFetches() {
        return Collections.emptyList();
    }

    @Override
    public Fetch findFetch(Fetchable fetchable) {
        return null;
    }
}

